/*
 * Decompiled with CFR 0.152.
 */
package ch.cyberduck.core.cryptomator.features;

import ch.cyberduck.core.Path;
import ch.cyberduck.core.Session;
import ch.cyberduck.core.exception.BackgroundException;
import ch.cyberduck.core.features.Redundancy;
import ch.cyberduck.core.features.Vault;
import java.util.Set;

public class CryptoRedundancyFeature
implements Redundancy {
    private final Session<?> session;
    private final Redundancy delegate;
    private final Vault vault;

    public CryptoRedundancyFeature(Session<?> session, Redundancy delegate, Vault vault) {
        this.session = session;
        this.delegate = delegate;
        this.vault = vault;
    }

    public String getDefault() {
        return this.delegate.getDefault();
    }

    public Set<String> getClasses() {
        return this.delegate.getClasses();
    }

    public void setClass(Path file, String redundancy) throws BackgroundException {
        this.delegate.setClass(this.vault.encrypt(this.session, file), redundancy);
    }

    public String getClass(Path file) throws BackgroundException {
        return this.delegate.getClass(this.vault.encrypt(this.session, file));
    }

    public String toString() {
        StringBuilder sb = new StringBuilder("CryptoRedundancyFeature{");
        sb.append("delegate=").append(this.delegate);
        sb.append('}');
        return sb.toString();
    }
}

