/*
 * Decompiled with CFR 0.152.
 */
package org.nuxeo.onedrive.client;

import com.eclipsesource.json.JsonObject;
import com.eclipsesource.json.JsonValue;
import org.nuxeo.onedrive.client.types.Drive;
import org.nuxeo.onedrive.client.types.DriveItem;

public class CopyOperation {
    private final JsonObject jsonObject = new JsonObject();

    public void rename(String newName) {
        this.jsonObject.add("name", newName);
    }

    public void copy(DriveItem newParent) {
        JsonObject parentReference = new JsonObject();
        Drive rootDrive = newParent.getDrive();
        if (null != rootDrive) {
            parentReference.add("driveId", rootDrive.getId());
            parentReference.add("id", newParent.getId());
        } else if (DriveItem.ItemIdentifierType.Path == newParent.getItemIdentifierType()) {
            parentReference.add("path", newParent.getPath());
        }
        this.jsonObject.add("parentReference", (JsonValue)parentReference);
    }

    JsonObject build() {
        return this.jsonObject;
    }
}

