/*
 * Decompiled with CFR 0.152.
 */
package ch.cyberduck.cli;

import ch.cyberduck.cli.DownloadTransferItemFinder;
import ch.cyberduck.cli.TerminalAction;
import ch.cyberduck.cli.TransferItemFinder;
import ch.cyberduck.cli.UploadTransferItemFinder;
import ch.cyberduck.core.LocalFactory;
import ch.cyberduck.core.Path;
import ch.cyberduck.core.local.WorkdirPrefixer;
import ch.cyberduck.core.transfer.TransferItem;
import java.util.Collections;
import java.util.Set;
import org.apache.commons.cli.CommandLine;

public class SingleTransferItemFinder
implements TransferItemFinder {
    private final WorkdirPrefixer prefixer = new WorkdirPrefixer();

    @Override
    public Set<TransferItem> find(CommandLine input, TerminalAction action, Path remote) {
        if (input.getOptionValues(action.name()).length == 2) {
            switch (action) {
                case download: {
                    return new DownloadTransferItemFinder().find(input, action, remote);
                }
                case upload: 
                case synchronize: {
                    return new UploadTransferItemFinder().find(input, action, remote);
                }
            }
        } else {
            switch (action) {
                case upload: 
                case synchronize: {
                    return Collections.emptySet();
                }
            }
        }
        return Collections.singleton(new TransferItem(remote, LocalFactory.get(this.prefixer.normalize(remote.getName()))));
    }
}

