/*
 * Decompiled with CFR 0.152.
 */
package ch.cyberduck.core.storegate;

import ch.cyberduck.core.ConnectionCallback;
import ch.cyberduck.core.DisabledListProgressListener;
import ch.cyberduck.core.ListProgressListener;
import ch.cyberduck.core.Path;
import ch.cyberduck.core.exception.BackgroundException;
import ch.cyberduck.core.features.Copy;
import ch.cyberduck.core.storegate.StoregateAttributesFinderFeature;
import ch.cyberduck.core.storegate.StoregateExceptionMappingService;
import ch.cyberduck.core.storegate.StoregateIdProvider;
import ch.cyberduck.core.storegate.StoregateSession;
import ch.cyberduck.core.storegate.io.swagger.client.ApiClient;
import ch.cyberduck.core.storegate.io.swagger.client.ApiException;
import ch.cyberduck.core.storegate.io.swagger.client.api.FilesApi;
import ch.cyberduck.core.storegate.io.swagger.client.model.CopyFileRequest;
import ch.cyberduck.core.storegate.io.swagger.client.model.File;
import ch.cyberduck.core.transfer.TransferStatus;

public class StoregateCopyFeature
implements Copy {
    private final StoregateSession session;
    private final StoregateIdProvider fileid;

    public StoregateCopyFeature(StoregateSession session, StoregateIdProvider fileid) {
        this.session = session;
        this.fileid = fileid;
    }

    public Path copy(Path source, Path target, TransferStatus status, ConnectionCallback callback) throws BackgroundException {
        try {
            CopyFileRequest copy = new CopyFileRequest().name(target.getName()).parentID(this.fileid.getFileid(target.getParent(), (ListProgressListener)new DisabledListProgressListener())).mode(1);
            File file = new FilesApi((ApiClient)this.session.getClient()).filesCopy(this.fileid.getFileid(source, (ListProgressListener)new DisabledListProgressListener()), copy);
            return new Path(target.getParent(), target.getName(), target.getType(), new StoregateAttributesFinderFeature(this.session, this.fileid).toAttributes(file));
        }
        catch (ApiException e) {
            throw new StoregateExceptionMappingService().map("Cannot copy {0}", e, source);
        }
    }

    public boolean isSupported(Path source, Path target) {
        return true;
    }

    public boolean isRecursive(Path source, Path target) {
        return true;
    }
}

