/*
 * Decompiled with CFR 0.152.
 */
package org.perf4j.commonslog;

import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.perf4j.LoggingStopWatch;

public class CommonsLogStopWatch
extends LoggingStopWatch {
    public static final int TRACE_LEVEL = 5000;
    public static final int DEBUG_LEVEL = 10000;
    public static final int INFO_LEVEL = 20000;
    public static final int WARN_LEVEL = 30000;
    public static final int ERROR_LEVEL = 40000;
    public static final int FATAL_LEVEL = 50000;
    private Log logger;
    private int normalPriority;
    private int exceptionPriority;

    public CommonsLogStopWatch() {
        this("", null, LogFactory.getLog((String)"org.perf4j.TimingLogger"), 20000, 30000);
    }

    public CommonsLogStopWatch(Log logger) {
        this("", null, logger, 20000, 30000);
    }

    public CommonsLogStopWatch(Log logger, int normalPriority) {
        this("", null, logger, normalPriority, 30000);
    }

    public CommonsLogStopWatch(Log logger, int normalPriority, int exceptionPriority) {
        this("", null, logger, normalPriority, exceptionPriority);
    }

    public CommonsLogStopWatch(String tag) {
        this(tag, null, LogFactory.getLog((String)"org.perf4j.TimingLogger"), 20000, 30000);
    }

    public CommonsLogStopWatch(String tag, Log logger) {
        this(tag, null, logger, 20000, 30000);
    }

    public CommonsLogStopWatch(String tag, Log logger, int normalPriority) {
        this(tag, null, logger, normalPriority, 30000);
    }

    public CommonsLogStopWatch(String tag, Log logger, int normalPriority, int exceptionPriority) {
        this(tag, null, logger, normalPriority, exceptionPriority);
    }

    public CommonsLogStopWatch(String tag, String message) {
        this(tag, message, LogFactory.getLog((String)"org.perf4j.TimingLogger"), 20000, 30000);
    }

    public CommonsLogStopWatch(String tag, String message, Log logger) {
        this(tag, message, logger, 20000, 30000);
    }

    public CommonsLogStopWatch(String tag, String message, Log logger, int normalPriority) {
        this(tag, message, logger, normalPriority, 30000);
    }

    public CommonsLogStopWatch(String tag, String message, Log logger, int normalPriority, int exceptionPriority) {
        this(System.currentTimeMillis(), -1L, tag, message, logger, normalPriority, exceptionPriority);
    }

    public CommonsLogStopWatch(long startTime, long elapsedTime, String tag, String message, Log logger, int normalPriority, int exceptionPriority) {
        super(startTime, elapsedTime, tag, message);
        this.logger = logger;
        this.normalPriority = normalPriority;
        this.exceptionPriority = exceptionPriority;
    }

    public Log getLogger() {
        return this.logger;
    }

    public void setLogger(Log logger) {
        this.logger = logger;
    }

    public int getNormalPriority() {
        return this.normalPriority;
    }

    public void setNormalPriority(int normalPriority) {
        this.normalPriority = normalPriority;
    }

    public int getExceptionPriority() {
        return this.exceptionPriority;
    }

    public void setExceptionPriority(int exceptionPriority) {
        this.exceptionPriority = exceptionPriority;
    }

    public boolean isLogging() {
        return this.isLogging(this.normalPriority);
    }

    protected void log(String stopWatchAsString, Throwable exception) {
        this.log(stopWatchAsString, exception, exception == null ? this.normalPriority : this.exceptionPriority);
    }

    protected boolean isLogging(int atLevel) {
        switch (atLevel) {
            case 5000: {
                return this.logger.isTraceEnabled();
            }
            case 10000: {
                return this.logger.isDebugEnabled();
            }
            case 20000: {
                return this.logger.isInfoEnabled();
            }
            case 30000: {
                return this.logger.isWarnEnabled();
            }
            case 40000: {
                return this.logger.isErrorEnabled();
            }
            case 50000: {
                return this.logger.isFatalEnabled();
            }
        }
        return this.isLogging(this.closestKnownLevel(atLevel));
    }

    protected void log(String stopWatchAsString, Throwable exception, int atLevel) {
        switch (atLevel) {
            case 5000: {
                this.logger.trace((Object)stopWatchAsString, exception);
                break;
            }
            case 10000: {
                this.logger.debug((Object)stopWatchAsString, exception);
                break;
            }
            case 20000: {
                this.logger.info((Object)stopWatchAsString, exception);
                break;
            }
            case 30000: {
                this.logger.warn((Object)stopWatchAsString, exception);
                break;
            }
            case 40000: {
                this.logger.error((Object)stopWatchAsString, exception);
                break;
            }
            case 50000: {
                this.logger.fatal((Object)stopWatchAsString, exception);
                break;
            }
            default: {
                this.log(stopWatchAsString, exception, this.closestKnownLevel(atLevel));
            }
        }
    }

    private int closestKnownLevel(int level) {
        if (level <= 5000) {
            return 5000;
        }
        if (level <= 10000) {
            return 10000;
        }
        if (level <= 20000) {
            return 20000;
        }
        if (level <= 30000) {
            return 30000;
        }
        if (level <= 40000) {
            return 40000;
        }
        return 50000;
    }

    public static int mapLevelName(String levelName) {
        if ("TRACE".equals(levelName = levelName.toUpperCase())) {
            return 5000;
        }
        if ("DEBUG".equals(levelName)) {
            return 10000;
        }
        if ("INFO".equals(levelName)) {
            return 20000;
        }
        if ("WARN".equals(levelName)) {
            return 30000;
        }
        if ("ERROR".equals(levelName)) {
            return 40000;
        }
        if ("FATAL".equals(levelName)) {
            return 50000;
        }
        return 20000;
    }

    public CommonsLogStopWatch clone() {
        return (CommonsLogStopWatch)super.clone();
    }
}

