/*
 * Decompiled with CFR 0.152.
 */
package ch.cyberduck.core.onedrive.features;

import ch.cyberduck.core.AttributedList;
import ch.cyberduck.core.Cache;
import ch.cyberduck.core.ListProgressListener;
import ch.cyberduck.core.ListService;
import ch.cyberduck.core.Path;
import ch.cyberduck.core.PathCache;
import ch.cyberduck.core.Referenceable;
import ch.cyberduck.core.SimplePathPredicate;
import ch.cyberduck.core.exception.BackgroundException;
import ch.cyberduck.core.exception.NotfoundException;
import ch.cyberduck.core.features.IdProvider;
import ch.cyberduck.core.onedrive.GraphSession;
import java.util.function.Predicate;
import org.apache.commons.lang3.StringUtils;

public class GraphFileIdProvider
implements IdProvider {
    private final GraphSession session;
    private Cache<Path> cache = PathCache.empty();

    public GraphFileIdProvider(GraphSession session) {
        this.session = session;
    }

    public String getFileid(Path file, ListProgressListener listener) throws BackgroundException {
        AttributedList list;
        Path found;
        if (StringUtils.isNotBlank((CharSequence)file.attributes().getFileId())) {
            return file.attributes().getFileId();
        }
        if (this.cache.isCached((Referenceable)file.getParent()) && null != (found = (Path)(list = this.cache.get((Referenceable)file.getParent())).find((Predicate)new SimplePathPredicate(file))) && StringUtils.isNotBlank((CharSequence)file.attributes().getFileId())) {
            return this.set(file, file.attributes().getFileId());
        }
        list = this.session._getFeature(ListService.class).list(file.getParent(), listener);
        found = (Path)list.find(path -> file.getAbsolute().equals(path.getAbsolute()));
        if (null == found) {
            throw new NotfoundException(file.getAbsolute());
        }
        return this.set(file, found.attributes().getFileId());
    }

    protected String set(Path file, String id) {
        file.attributes().setFileId(id);
        return id;
    }

    public IdProvider withCache(Cache<Path> cache) {
        this.cache = cache;
        return this;
    }
}

