/*
 * Decompiled with CFR 0.152.
 */
package ch.cyberduck.core.onedrive.features.sharepoint;

import ch.cyberduck.core.AbstractPath;
import ch.cyberduck.core.Path;
import ch.cyberduck.core.PathAttributes;
import ch.cyberduck.core.onedrive.AbstractListService;
import ch.cyberduck.core.onedrive.SharepointSession;
import java.util.EnumSet;
import java.util.Iterator;
import org.apache.log4j.Logger;
import org.nuxeo.onedrive.client.Groups;
import org.nuxeo.onedrive.client.OneDriveAPI;
import org.nuxeo.onedrive.client.types.GroupItem;
import org.nuxeo.onedrive.client.types.User;

public class GroupListService
extends AbstractListService<GroupItem.Metadata> {
    private static final Logger log = Logger.getLogger(GroupListService.class);
    private final SharepointSession session;

    public GroupListService(SharepointSession session) {
        this.session = session;
    }

    @Override
    protected Iterator<GroupItem.Metadata> getIterator(Path directory) {
        return Groups.getMemberOfGroups((User)User.getCurrent((OneDriveAPI)((OneDriveAPI)this.session.getClient())));
    }

    @Override
    protected Path toPath(GroupItem.Metadata metadata, Path directory) {
        PathAttributes attributes = new PathAttributes();
        attributes.setFileId(metadata.getId());
        return new Path(directory, metadata.getDisplayName(), EnumSet.of(AbstractPath.Type.volume, AbstractPath.Type.directory, AbstractPath.Type.placeholder), attributes);
    }
}

