/*
 * Decompiled with CFR 0.152.
 */
package ch.cyberduck.core;

import ch.cyberduck.core.Permission;
import org.apache.commons.lang3.CharUtils;
import org.apache.commons.lang3.StringUtils;

public class PermissionOverwrite {
    public final Action user;
    public final Action group;
    public final Action other;

    public PermissionOverwrite() {
        this.user = new Action(null, null, null);
        this.group = new Action(null, null, null);
        this.other = new Action(null, null, null);
    }

    public PermissionOverwrite(Action user, Action group, Action other) {
        this.user = user;
        this.group = group;
        this.other = other;
    }

    public String getMode() {
        StringBuilder builder = new StringBuilder(3);
        builder.append(this.user.mode());
        builder.append(this.group.mode());
        builder.append(this.other.mode());
        return builder.toString();
    }

    public PermissionOverwrite fromOctal(String input) {
        if (StringUtils.isBlank((CharSequence)input)) {
            return null;
        }
        if (StringUtils.length((CharSequence)input) != 3) {
            return null;
        }
        if (!StringUtils.isNumeric((CharSequence)input)) {
            return null;
        }
        this.user.parse(input.charAt(0));
        this.group.parse(input.charAt(1));
        this.other.parse(input.charAt(2));
        return this;
    }

    public Permission resolve(Permission original) {
        return new Permission(this.user.resolve(original.getUser()), this.group.resolve(original.getGroup()), this.other.resolve(original.getOther()), original.isSticky(), original.isSetuid(), original.isSetgid());
    }

    public String toString() {
        StringBuilder symbolic = new StringBuilder();
        symbolic.append(this.user);
        symbolic.append(this.group);
        symbolic.append(this.other);
        return symbolic.toString();
    }

    public static final class Action {
        private final char MULTIPLE_VALUES = (char)8226;
        public Boolean read;
        public Boolean write;
        public Boolean execute;

        public Action(Boolean read, Boolean write, Boolean execute) {
            this.read = read;
            this.write = write;
            this.execute = execute;
        }

        private static Permission.Action solve(Permission.Action base, Permission.Action permission, boolean value) {
            return value ? base.or(permission) : base.and(permission.not());
        }

        public char mode() {
            int intermediate = 8226;
            int value = 0;
            if (this.read == null) {
                return '\u2022';
            }
            value += this.read != false ? 4 : 0;
            if (this.write == null) {
                return '\u2022';
            }
            value += this.write != false ? 2 : 0;
            if (this.execute == null) {
                return '\u2022';
            }
            return Character.forDigit(value += this.execute != false ? 1 : 0, 8);
        }

        public void parse(char c) {
            if (CharUtils.isAsciiNumeric((char)c)) {
                int intValue = CharUtils.toIntValue((char)c);
                this.read = (intValue & 4) > 0;
                this.write = (intValue & 2) > 0;
                this.execute = (intValue & 1) > 0;
            } else if (c == '\u2022') {
                this.execute = null;
                this.write = null;
                this.read = null;
            }
        }

        public Permission.Action resolve(Permission.Action original) {
            Permission.Action result = Permission.Action.none;
            result = Action.solve(result, Permission.Action.read, this.read == null ? original.implies(Permission.Action.read) : this.read.booleanValue());
            result = Action.solve(result, Permission.Action.write, this.write == null ? original.implies(Permission.Action.write) : this.write.booleanValue());
            result = Action.solve(result, Permission.Action.execute, this.execute == null ? original.implies(Permission.Action.execute) : this.execute.booleanValue());
            return result;
        }

        public String toString() {
            StringBuilder symbolic = new StringBuilder();
            symbolic.append((char)(this.read != null ? (this.read.booleanValue() ? 114 : 45) : 8226));
            symbolic.append((char)(this.write != null ? (this.write.booleanValue() ? 119 : 45) : 8226));
            symbolic.append((char)(this.execute != null ? (this.execute.booleanValue() ? 120 : 45) : 8226));
            return symbolic.toString();
        }
    }
}

