/*
 * Decompiled with CFR 0.152.
 */
package ch.cyberduck.core.date;

import ch.cyberduck.core.LocaleFactory;
import ch.cyberduck.core.date.PeriodFormatter;
import java.math.BigDecimal;
import java.text.MessageFormat;

public class RemainingPeriodFormatter
implements PeriodFormatter {
    @Override
    public String format(long remaining) {
        StringBuilder b = new StringBuilder();
        if (remaining < 0L) {
            return LocaleFactory.localizedString("Unknown");
        }
        if (remaining > 7200L) {
            b.append(MessageFormat.format(LocaleFactory.localizedString("{0} hours remaining", "Status"), new BigDecimal(remaining).divide(new BigDecimal(3600), 1, 1).toString()));
        } else if (remaining > 120L) {
            b.append(MessageFormat.format(LocaleFactory.localizedString("{0} minutes remaining", "Status"), String.valueOf((int)(remaining / 60L))));
        } else {
            b.append(MessageFormat.format(LocaleFactory.localizedString("{0} seconds remaining", "Status"), String.valueOf((int)remaining)));
        }
        return b.toString();
    }
}

