/*
 * Decompiled with CFR 0.152.
 */
package ch.cyberduck.core.local;

import ch.cyberduck.core.preferences.Preferences;
import ch.cyberduck.core.preferences.PreferencesFactory;
import org.apache.commons.lang3.StringUtils;
import org.apache.log4j.Logger;

public class TildeExpander {
    private static final Logger log = Logger.getLogger(TildeExpander.class);
    private final Preferences preferences = PreferencesFactory.get();

    public String abbreviate(String name) {
        if (StringUtils.startsWith((CharSequence)name, (CharSequence)this.preferences.getProperty("local.user.home"))) {
            return "~" + StringUtils.removeStart((String)name, (String)this.preferences.getProperty("local.user.home"));
        }
        return name;
    }

    public String expand(String name) {
        if (name.startsWith("~")) {
            String expanded = this.preferences.getProperty("local.user.home") + StringUtils.substring((String)name, (int)1);
            if (log.isDebugEnabled() && !StringUtils.equals((CharSequence)expanded, (CharSequence)name)) {
                log.debug((Object)String.format("Expanded %s to %s", name, expanded));
            }
            return expanded;
        }
        return name;
    }
}

