/*
 * Decompiled with CFR 0.152.
 */
package ch.cyberduck.core.ssl;

import ch.cyberduck.core.ssl.X509KeyManager;
import java.net.Socket;
import java.security.Principal;
import java.security.cert.Certificate;
import java.security.cert.X509Certificate;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import javax.net.ssl.X509ExtendedKeyManager;
import javax.security.auth.x500.X500Principal;
import org.apache.log4j.Logger;

public abstract class AbstractX509KeyManager
extends X509ExtendedKeyManager
implements X509KeyManager {
    private static final Logger log = Logger.getLogger(AbstractX509KeyManager.class);

    protected boolean matches(Certificate c, String[] keyTypes, Principal[] issuers) {
        if (!(c instanceof X509Certificate)) {
            log.warn((Object)String.format("Certificate %s is not of type X509", c));
            return false;
        }
        if (!Arrays.asList(keyTypes).contains(c.getPublicKey().getAlgorithm())) {
            log.warn((Object)String.format("Key type %s does not match any of %s", c.getPublicKey().getAlgorithm(), Arrays.toString(keyTypes)));
            return false;
        }
        if (null == issuers || Arrays.asList(issuers).isEmpty()) {
            return true;
        }
        X500Principal issuer = ((X509Certificate)c).getIssuerX500Principal();
        if (!Arrays.asList(issuers).contains(issuer)) {
            log.warn((Object)String.format("Issuer %s does not match", issuer));
            return false;
        }
        return true;
    }

    @Override
    public List<String> list() {
        return Collections.emptyList();
    }

    @Override
    public String chooseServerAlias(String s, Principal[] principals, Socket socket) {
        return null;
    }

    @Override
    public String[] getServerAliases(String s, Principal[] principals) {
        return null;
    }
}

