/*
 * Decompiled with CFR 0.152.
 */
package ch.cyberduck.core.synchronization;

import ch.cyberduck.core.Local;
import ch.cyberduck.core.Path;
import ch.cyberduck.core.exception.BackgroundException;
import ch.cyberduck.core.synchronization.ComparePathFilter;
import ch.cyberduck.core.synchronization.Comparison;
import ch.cyberduck.core.synchronization.ComparisonServiceFilter;
import ch.cyberduck.core.transfer.TransferItem;
import java.util.Collections;
import java.util.Map;
import org.apache.log4j.Logger;

public class CachingComparisonServiceFilter
implements ComparePathFilter {
    private static final Logger log = Logger.getLogger(CachingComparisonServiceFilter.class);
    private Map<TransferItem, Comparison> cache = Collections.emptyMap();
    private final ComparisonServiceFilter delegate;

    public CachingComparisonServiceFilter(ComparisonServiceFilter delegate) {
        this.delegate = delegate;
    }

    @Override
    public Comparison compare(Path file, Local local) throws BackgroundException {
        if (!this.cache.containsKey(new TransferItem(file, local))) {
            if (log.isDebugEnabled()) {
                log.debug((Object)String.format("Compare file %s", file));
            }
            this.cache.put(new TransferItem(file, local), this.delegate.compare(file, local));
        }
        Comparison comparison = this.cache.get(new TransferItem(file, local));
        if (log.isDebugEnabled()) {
            log.debug((Object)String.format("Return comparison %s for file %s", new Object[]{comparison, file}));
        }
        return comparison;
    }

    public Comparison get(TransferItem item) {
        if (this.cache.containsKey(item)) {
            return this.cache.get(item);
        }
        return Comparison.unknown;
    }

    public void reset() {
        this.cache.clear();
    }

    public CachingComparisonServiceFilter withCache(Map<TransferItem, Comparison> cache) {
        this.cache = cache;
        return this;
    }
}

