/*
 * Decompiled with CFR 0.152.
 */
package ch.cyberduck.core.worker;

import ch.cyberduck.core.ListService;
import ch.cyberduck.core.LocaleFactory;
import ch.cyberduck.core.Path;
import ch.cyberduck.core.ProgressListener;
import ch.cyberduck.core.Session;
import ch.cyberduck.core.exception.BackgroundException;
import ch.cyberduck.core.exception.ConnectionCanceledException;
import ch.cyberduck.core.worker.Worker;
import ch.cyberduck.core.worker.WorkerListProgressListener;
import java.text.MessageFormat;
import java.util.List;
import java.util.Objects;

public abstract class CalculateSizeWorker
extends Worker<Long> {
    private final List<Path> files;
    private final ProgressListener listener;
    private Long total = 0L;

    public CalculateSizeWorker(List<Path> files, ProgressListener listener) {
        this.files = files;
        this.listener = listener;
    }

    @Override
    public Long run(Session<?> session) throws BackgroundException {
        for (Path next : this.files) {
            next.attributes().setSize(this.calculateSize(session, next));
        }
        return this.total;
    }

    private long calculateSize(Session<?> session, Path p) throws BackgroundException {
        long size = 0L;
        if (this.isCanceled()) {
            throw new ConnectionCanceledException();
        }
        this.listener.message(MessageFormat.format(LocaleFactory.localizedString("Getting size of {0}", "Status"), p.getName()));
        if (p.isDirectory()) {
            for (Path next : session.getFeature(ListService.class).list(p, new WorkerListProgressListener(this, this.listener))) {
                size += this.calculateSize(session, next);
            }
        } else if (p.isFile()) {
            this.total = this.total + (size += p.attributes().getSize());
            this.update(this.total);
        }
        return size;
    }

    protected abstract void update(long var1);

    @Override
    public String getActivity() {
        return MessageFormat.format(LocaleFactory.localizedString("Getting size of {0}", "Status"), this.toString(this.files));
    }

    @Override
    public Long initialize() {
        return this.total;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        CalculateSizeWorker that = (CalculateSizeWorker)o;
        return Objects.equals(this.files, that.files);
    }

    public int hashCode() {
        return this.files != null ? this.files.hashCode() : 0;
    }

    @Override
    public String toString() {
        StringBuilder sb = new StringBuilder("CalculateSizeWorker{");
        sb.append("files=").append(this.files);
        sb.append('}');
        return sb.toString();
    }
}

