/*
 * Decompiled with CFR 0.152.
 */
package ch.cyberduck.core;

import ch.cyberduck.binding.foundation.FoundationKitFunctions;
import ch.cyberduck.core.DefaultHostPasswordStore;
import ch.cyberduck.core.PasswordStore;
import ch.cyberduck.core.Scheme;
import ch.cyberduck.core.exception.LocalAccessDeniedException;
import ch.cyberduck.core.keychain.SecKeychainItemRef;
import ch.cyberduck.core.keychain.SecurityFunctions;
import com.sun.jna.platform.mac.CoreFoundation;
import com.sun.jna.ptr.IntByReference;
import com.sun.jna.ptr.PointerByReference;
import java.nio.charset.StandardCharsets;
import org.apache.log4j.Logger;

public final class KeychainPasswordStore
extends DefaultHostPasswordStore
implements PasswordStore {
    private static final Logger log = Logger.getLogger(KeychainPasswordStore.class);
    private static final Object lock = new Object();

    public String getPassword(Scheme scheme, int port, String serviceName, String accountName) throws LocalAccessDeniedException {
        Object object = lock;
        synchronized (object) {
            IntByReference passwordLength = new IntByReference();
            PointerByReference passwordRef = new PointerByReference();
            int err = SecurityFunctions.library.SecKeychainFindInternetPassword(null, serviceName.getBytes(StandardCharsets.UTF_8).length, serviceName.getBytes(StandardCharsets.UTF_8), 0, null, accountName.getBytes(StandardCharsets.UTF_8).length, accountName.getBytes(StandardCharsets.UTF_8), 0, null, port, KeychainPasswordStore.toSecProtocolType(scheme), 1953261156, passwordLength, passwordRef, null);
            if (0 == err) {
                return new String(passwordRef.getValue().getByteArray(0L, passwordLength.getValue()), StandardCharsets.UTF_8);
            }
            if (-25300 == err) {
                return null;
            }
            throw new LocalAccessDeniedException(String.format("Failure reading credentials for %s from Keychain", serviceName));
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void addPassword(Scheme scheme, int port, String serviceName, String accountName, String password) throws LocalAccessDeniedException {
        Object object = lock;
        synchronized (object) {
            int err = SecurityFunctions.library.SecKeychainAddInternetPassword(null, serviceName.getBytes(StandardCharsets.UTF_8).length, serviceName.getBytes(StandardCharsets.UTF_8), 0, null, accountName.getBytes(StandardCharsets.UTF_8).length, accountName.getBytes(StandardCharsets.UTF_8), 0, null, port, KeychainPasswordStore.toSecProtocolType(scheme), 1953261156, password.getBytes(StandardCharsets.UTF_8).length, password.getBytes(StandardCharsets.UTF_8), null);
            if (-25299 == err) {
                PointerByReference itemRef = new PointerByReference();
                err = SecurityFunctions.library.SecKeychainFindInternetPassword(null, serviceName.getBytes(StandardCharsets.UTF_8).length, serviceName.getBytes(StandardCharsets.UTF_8), 0, null, accountName.getBytes(StandardCharsets.UTF_8).length, accountName.getBytes(StandardCharsets.UTF_8), 0, null, port, KeychainPasswordStore.toSecProtocolType(scheme), 1953261156, null, null, itemRef);
                if (0 != err) {
                    throw new LocalAccessDeniedException(String.format("Failure saving credentials for %s in Keychain", serviceName));
                }
                err = SecurityFunctions.library.SecKeychainItemModifyContent(new SecKeychainItemRef(itemRef.getValue()), null, password.getBytes(StandardCharsets.UTF_8).length, password.getBytes(StandardCharsets.UTF_8));
                if (0 != err) {
                    throw new LocalAccessDeniedException(String.format("Failure saving credentials for %s in Keychain", serviceName));
                }
                FoundationKitFunctions.library.CFRelease((CoreFoundation.CFTypeRef)new SecKeychainItemRef(itemRef.getValue()));
            }
            if (0 != err) {
                throw new LocalAccessDeniedException(String.format("Failure saving credentials for %s in Keychain", serviceName));
            }
        }
    }

    public void deletePassword(Scheme scheme, int port, String serviceName, String accountName) throws LocalAccessDeniedException {
        Object object = lock;
        synchronized (object) {
            PointerByReference itemRef = new PointerByReference();
            int err = SecurityFunctions.library.SecKeychainFindInternetPassword(null, serviceName.getBytes(StandardCharsets.UTF_8).length, serviceName.getBytes(StandardCharsets.UTF_8), 0, null, accountName.getBytes(StandardCharsets.UTF_8).length, accountName.getBytes(StandardCharsets.UTF_8), 0, null, port, KeychainPasswordStore.toSecProtocolType(scheme), 1953261156, null, null, itemRef);
            if (0 == err) {
                if (0 != SecurityFunctions.library.SecKeychainItemDelete(itemRef.getValue())) {
                    throw new LocalAccessDeniedException(String.format("Failure deleting credentials for %s in Keychain", serviceName));
                }
                return;
            }
            if (-25300 == err) {
                return;
            }
            throw new LocalAccessDeniedException(String.format("Failure deleting credentials for %s in Keychain", serviceName));
        }
    }

    public String getPassword(String serviceName, String accountName) throws LocalAccessDeniedException {
        Object object = lock;
        synchronized (object) {
            IntByReference passwordLength = new IntByReference();
            PointerByReference passwordRef = new PointerByReference();
            int err = SecurityFunctions.library.SecKeychainFindGenericPassword(null, serviceName.getBytes(StandardCharsets.UTF_8).length, serviceName.getBytes(StandardCharsets.UTF_8), accountName.getBytes(StandardCharsets.UTF_8).length, accountName.getBytes(StandardCharsets.UTF_8), passwordLength, passwordRef, null);
            if (0 == err) {
                return new String(passwordRef.getValue().getByteArray(0L, passwordLength.getValue()), StandardCharsets.UTF_8);
            }
            if (-25300 == err) {
                return null;
            }
            throw new LocalAccessDeniedException(String.format("Failure reading credentials for %s from Keychain", serviceName));
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void addPassword(String serviceName, String accountName, String password) throws LocalAccessDeniedException {
        Object object = lock;
        synchronized (object) {
            int err = SecurityFunctions.library.SecKeychainAddGenericPassword(null, serviceName.getBytes(StandardCharsets.UTF_8).length, serviceName.getBytes(StandardCharsets.UTF_8), accountName.getBytes(StandardCharsets.UTF_8).length, accountName.getBytes(StandardCharsets.UTF_8), password.getBytes(StandardCharsets.UTF_8).length, password.getBytes(StandardCharsets.UTF_8), null);
            if (-25299 == err) {
                PointerByReference itemRef = new PointerByReference();
                err = SecurityFunctions.library.SecKeychainFindGenericPassword(null, serviceName.getBytes(StandardCharsets.UTF_8).length, serviceName.getBytes(StandardCharsets.UTF_8), accountName.getBytes(StandardCharsets.UTF_8).length, accountName.getBytes(StandardCharsets.UTF_8), null, null, itemRef);
                if (0 != err) {
                    throw new LocalAccessDeniedException(String.format("Failure saving credentials for %s in Keychain", serviceName));
                }
                err = SecurityFunctions.library.SecKeychainItemModifyContent(new SecKeychainItemRef(itemRef.getValue()), null, password.getBytes(StandardCharsets.UTF_8).length, password.getBytes(StandardCharsets.UTF_8));
                if (0 != err) {
                    throw new LocalAccessDeniedException(String.format("Failure saving credentials for %s in Keychain", serviceName));
                }
                FoundationKitFunctions.library.CFRelease((CoreFoundation.CFTypeRef)new SecKeychainItemRef(itemRef.getValue()));
            }
            if (0 != err) {
                throw new LocalAccessDeniedException(String.format("Failure saving credentials for %s in Keychain", serviceName));
            }
        }
    }

    public void deletePassword(String serviceName, String accountName) throws LocalAccessDeniedException {
        Object object = lock;
        synchronized (object) {
            PointerByReference itemRef = new PointerByReference();
            int err = SecurityFunctions.library.SecKeychainFindGenericPassword(null, serviceName.getBytes(StandardCharsets.UTF_8).length, serviceName.getBytes(StandardCharsets.UTF_8), accountName.getBytes(StandardCharsets.UTF_8).length, accountName.getBytes(StandardCharsets.UTF_8), null, null, itemRef);
            if (0 == err) {
                if (0 != SecurityFunctions.library.SecKeychainItemDelete(itemRef.getValue())) {
                    throw new LocalAccessDeniedException(String.format("Failure deleting credentials for %s in Keychain", serviceName));
                }
                return;
            }
            if (-25300 == err) {
                return;
            }
            throw new LocalAccessDeniedException(String.format("Failure deleting credentials for %s in Keychain", serviceName));
        }
    }

    private static int toSecProtocolType(Scheme scheme) {
        switch (scheme) {
            case ftp: {
                return 1718906912;
            }
            case ftps: {
                return 1718906995;
            }
            case sftp: {
                return 1936943136;
            }
            case http: {
                return 1752462448;
            }
            case https: {
                return 1752461427;
            }
        }
        return 0;
    }
}

