/*
 * Decompiled with CFR 0.152.
 */
package ch.cyberduck.core.diagnostics;

import ch.cyberduck.binding.Proxy;
import ch.cyberduck.binding.foundation.NSNotification;
import ch.cyberduck.binding.foundation.NSNotificationCenter;
import ch.cyberduck.core.Host;
import ch.cyberduck.core.diagnostics.CDReachabilityMonitor;
import ch.cyberduck.core.diagnostics.Reachability;
import ch.cyberduck.core.idna.PunycodeConverter;
import org.apache.log4j.Logger;
import org.rococoa.Foundation;

public final class SystemConfigurationReachability
implements Reachability {
    private static final Logger log = Logger.getLogger(SystemConfigurationReachability.class);
    private final NSNotificationCenter notificationCenter = NSNotificationCenter.defaultCenter();

    public Reachability.Monitor monitor(Host bookmark, final Reachability.Callback callback) {
        final String url = this.toURL(bookmark);
        return new Reachability.Monitor(){
            private final CDReachabilityMonitor monitor;
            private final NotificationFilterCallback listener;
            {
                this.monitor = CDReachabilityMonitor.monitorForUrl(url);
                this.listener = new NotificationFilterCallback(callback);
            }

            public Reachability.Monitor start() {
                SystemConfigurationReachability.this.notificationCenter.addObserver(this.listener.id(), Foundation.selector((String)"notify:"), "kNetworkReachabilityChangedNotification", this.monitor.id());
                this.monitor.startReachabilityMonitor();
                return this;
            }

            public Reachability.Monitor stop() {
                this.monitor.stopReachabilityMonitor();
                SystemConfigurationReachability.this.notificationCenter.removeObserver(this.listener.id());
                return this;
            }
        };
    }

    public boolean isReachable(Host bookmark) {
        CDReachabilityMonitor monitor = CDReachabilityMonitor.monitorForUrl(this.toURL(bookmark));
        return monitor.isReachable();
    }

    public void diagnose(Host bookmark) {
        CDReachabilityMonitor monitor = CDReachabilityMonitor.monitorForUrl(this.toURL(bookmark));
        monitor.diagnoseInteractively();
    }

    private String toURL(Host host) {
        StringBuilder url = new StringBuilder(host.getProtocol().getScheme().toString());
        url.append("://");
        url.append(new PunycodeConverter().convert(host.getHostname()));
        url.append(":").append(host.getPort());
        return url.toString();
    }

    private final class NotificationFilterCallback
    extends Proxy {
        private final Reachability.Callback proxy;

        public NotificationFilterCallback(Reachability.Callback proxy) {
            this.proxy = proxy;
        }

        public void notify(NSNotification notification) {
            if (log.isDebugEnabled()) {
                log.debug((Object)String.format("Received notification %s", notification));
            }
            this.proxy.change();
        }
    }
}

