/*
 * Decompiled with CFR 0.152.
 */
package com.spectralogic.ds3client.commands.parsers;

import com.spectralogic.ds3client.commands.parsers.interfaces.AbstractResponseParser;
import com.spectralogic.ds3client.commands.parsers.utils.ResponseParserUtils;
import com.spectralogic.ds3client.commands.spectrads3.notifications.GetSystemFailureNotificationRegistrationSpectraS3Response;
import com.spectralogic.ds3client.models.SystemFailureNotificationRegistration;
import com.spectralogic.ds3client.networking.WebResponse;
import com.spectralogic.ds3client.serializer.XmlOutput;
import java.io.IOException;
import java.io.InputStream;

public class GetSystemFailureNotificationRegistrationSpectraS3ResponseParser
extends AbstractResponseParser<GetSystemFailureNotificationRegistrationSpectraS3Response> {
    private final int[] expectedStatusCodes = new int[]{200};

    @Override
    public GetSystemFailureNotificationRegistrationSpectraS3Response parseXmlResponse(WebResponse response) throws IOException {
        int statusCode = response.getStatusCode();
        if (ResponseParserUtils.validateStatusCode(statusCode, this.expectedStatusCodes)) {
            switch (statusCode) {
                case 200: {
                    try (InputStream inputStream = response.getResponseStream();){
                        SystemFailureNotificationRegistration result = XmlOutput.fromXml(inputStream, SystemFailureNotificationRegistration.class);
                        GetSystemFailureNotificationRegistrationSpectraS3Response getSystemFailureNotificationRegistrationSpectraS3Response = new GetSystemFailureNotificationRegistrationSpectraS3Response(result, this.getChecksum(), this.getChecksumType());
                        return getSystemFailureNotificationRegistrationSpectraS3Response;
                    }
                }
            }
            assert (false) : "validateStatusCode should have made it impossible to reach this line";
        }
        throw ResponseParserUtils.createFailedRequest(response, this.expectedStatusCodes);
    }
}

