/*
 * Decompiled with CFR 0.152.
 */
package com.spectralogic.ds3client.commands.spectrads3;

import com.spectralogic.ds3client.commands.interfaces.AbstractRequest;
import com.spectralogic.ds3client.networking.HttpVerb;

public class VerifyAzureTargetSpectraS3Request
extends AbstractRequest {
    private final String azureTarget;
    private boolean fullDetails;

    public VerifyAzureTargetSpectraS3Request(String azureTarget) {
        this.azureTarget = azureTarget;
        this.getQueryParams().put("operation", "verify");
    }

    public VerifyAzureTargetSpectraS3Request withFullDetails(boolean fullDetails) {
        this.fullDetails = fullDetails;
        if (this.fullDetails) {
            this.getQueryParams().put("full_details", null);
        } else {
            this.getQueryParams().remove("full_details");
        }
        return this;
    }

    @Override
    public HttpVerb getVerb() {
        return HttpVerb.PUT;
    }

    @Override
    public String getPath() {
        return "/_rest_/azure_target/" + this.azureTarget;
    }

    public String getAzureTarget() {
        return this.azureTarget;
    }

    public boolean getFullDetails() {
        return this.fullDetails;
    }
}

