/*
 * Decompiled with CFR 0.152.
 */
package ch.cyberduck.core.sds.io.swagger.client.model;

import ch.cyberduck.core.sds.io.swagger.client.model.AuditUserPermission;
import ch.cyberduck.core.sds.io.swagger.client.model.UserInfo;
import com.fasterxml.jackson.annotation.JsonProperty;
import io.swagger.v3.oas.annotations.media.Schema;
import java.util.ArrayList;
import java.util.List;
import java.util.Objects;
import org.joda.time.DateTime;

@Schema(description="Audit node report")
public class AuditNodeResponse {
    @JsonProperty(value="nodeId")
    private Long nodeId = null;
    @JsonProperty(value="nodeName")
    private String nodeName = null;
    @JsonProperty(value="nodeParentPath")
    private String nodeParentPath = null;
    @JsonProperty(value="nodeCntChildren")
    private Integer nodeCntChildren = null;
    @JsonProperty(value="auditUserPermissionList")
    private List<AuditUserPermission> auditUserPermissionList = new ArrayList<AuditUserPermission>();
    @JsonProperty(value="nodeParentId")
    private Long nodeParentId = null;
    @JsonProperty(value="nodeSize")
    private Long nodeSize = null;
    @JsonProperty(value="nodeRecycleBinRetentionPeriod")
    private Integer nodeRecycleBinRetentionPeriod = null;
    @JsonProperty(value="nodeQuota")
    private Long nodeQuota = null;
    @JsonProperty(value="nodeIsEncrypted")
    private Boolean nodeIsEncrypted = null;
    @JsonProperty(value="nodeHasActivitiesLog")
    private Boolean nodeHasActivitiesLog = true;
    @JsonProperty(value="nodeCreatedAt")
    private DateTime nodeCreatedAt = null;
    @JsonProperty(value="nodeCreatedBy")
    private UserInfo nodeCreatedBy = null;
    @JsonProperty(value="nodeUpdatedAt")
    private DateTime nodeUpdatedAt = null;
    @JsonProperty(value="nodeUpdatedBy")
    private UserInfo nodeUpdatedBy = null;
    @JsonProperty(value="nodeHasRecycleBin")
    private Boolean nodeHasRecycleBin = null;

    public AuditNodeResponse nodeId(Long nodeId) {
        this.nodeId = nodeId;
        return this;
    }

    @Schema(required=true, description="Node ID")
    public Long getNodeId() {
        return this.nodeId;
    }

    public void setNodeId(Long nodeId) {
        this.nodeId = nodeId;
    }

    public AuditNodeResponse nodeName(String nodeName) {
        this.nodeName = nodeName;
        return this;
    }

    @Schema(required=true, description="Node name")
    public String getNodeName() {
        return this.nodeName;
    }

    public void setNodeName(String nodeName) {
        this.nodeName = nodeName;
    }

    public AuditNodeResponse nodeParentPath(String nodeParentPath) {
        this.nodeParentPath = nodeParentPath;
        return this;
    }

    @Schema(required=true, description="Parent node path  `/` if node is a root node (room)")
    public String getNodeParentPath() {
        return this.nodeParentPath;
    }

    public void setNodeParentPath(String nodeParentPath) {
        this.nodeParentPath = nodeParentPath;
    }

    public AuditNodeResponse nodeCntChildren(Integer nodeCntChildren) {
        this.nodeCntChildren = nodeCntChildren;
        return this;
    }

    @Schema(required=true, description="Number of direct children  (no recursion; for rooms / folders only)")
    public Integer getNodeCntChildren() {
        return this.nodeCntChildren;
    }

    public void setNodeCntChildren(Integer nodeCntChildren) {
        this.nodeCntChildren = nodeCntChildren;
    }

    public AuditNodeResponse auditUserPermissionList(List<AuditUserPermission> auditUserPermissionList) {
        this.auditUserPermissionList = auditUserPermissionList;
        return this;
    }

    public AuditNodeResponse addAuditUserPermissionListItem(AuditUserPermission auditUserPermissionListItem) {
        this.auditUserPermissionList.add(auditUserPermissionListItem);
        return this;
    }

    @Schema(required=true, description="List of assigned users with permissions")
    public List<AuditUserPermission> getAuditUserPermissionList() {
        return this.auditUserPermissionList;
    }

    public void setAuditUserPermissionList(List<AuditUserPermission> auditUserPermissionList) {
        this.auditUserPermissionList = auditUserPermissionList;
    }

    public AuditNodeResponse nodeParentId(Long nodeParentId) {
        this.nodeParentId = nodeParentId;
        return this;
    }

    @Schema(description="Parent node ID (room or folder)")
    public Long getNodeParentId() {
        return this.nodeParentId;
    }

    public void setNodeParentId(Long nodeParentId) {
        this.nodeParentId = nodeParentId;
    }

    public AuditNodeResponse nodeSize(Long nodeSize) {
        this.nodeSize = nodeSize;
        return this;
    }

    @Schema(description="Node size in byte")
    public Long getNodeSize() {
        return this.nodeSize;
    }

    public void setNodeSize(Long nodeSize) {
        this.nodeSize = nodeSize;
    }

    public AuditNodeResponse nodeRecycleBinRetentionPeriod(Integer nodeRecycleBinRetentionPeriod) {
        this.nodeRecycleBinRetentionPeriod = nodeRecycleBinRetentionPeriod;
        return this;
    }

    @Schema(description="Retention period for deleted nodes in days")
    public Integer getNodeRecycleBinRetentionPeriod() {
        return this.nodeRecycleBinRetentionPeriod;
    }

    public void setNodeRecycleBinRetentionPeriod(Integer nodeRecycleBinRetentionPeriod) {
        this.nodeRecycleBinRetentionPeriod = nodeRecycleBinRetentionPeriod;
    }

    public AuditNodeResponse nodeQuota(Long nodeQuota) {
        this.nodeQuota = nodeQuota;
        return this;
    }

    @Schema(description="Quota in byte")
    public Long getNodeQuota() {
        return this.nodeQuota;
    }

    public void setNodeQuota(Long nodeQuota) {
        this.nodeQuota = nodeQuota;
    }

    public AuditNodeResponse nodeIsEncrypted(Boolean nodeIsEncrypted) {
        this.nodeIsEncrypted = nodeIsEncrypted;
        return this;
    }

    @Schema(description="Encryption state")
    public Boolean isNodeIsEncrypted() {
        return this.nodeIsEncrypted;
    }

    public void setNodeIsEncrypted(Boolean nodeIsEncrypted) {
        this.nodeIsEncrypted = nodeIsEncrypted;
    }

    public AuditNodeResponse nodeHasActivitiesLog(Boolean nodeHasActivitiesLog) {
        this.nodeHasActivitiesLog = nodeHasActivitiesLog;
        return this;
    }

    @Schema(description="Is activities log active (for rooms only)")
    public Boolean isNodeHasActivitiesLog() {
        return this.nodeHasActivitiesLog;
    }

    public void setNodeHasActivitiesLog(Boolean nodeHasActivitiesLog) {
        this.nodeHasActivitiesLog = nodeHasActivitiesLog;
    }

    public AuditNodeResponse nodeCreatedAt(DateTime nodeCreatedAt) {
        this.nodeCreatedAt = nodeCreatedAt;
        return this;
    }

    @Schema(description="Creation date")
    public DateTime getNodeCreatedAt() {
        return this.nodeCreatedAt;
    }

    public void setNodeCreatedAt(DateTime nodeCreatedAt) {
        this.nodeCreatedAt = nodeCreatedAt;
    }

    public AuditNodeResponse nodeCreatedBy(UserInfo nodeCreatedBy) {
        this.nodeCreatedBy = nodeCreatedBy;
        return this;
    }

    @Schema(description="")
    public UserInfo getNodeCreatedBy() {
        return this.nodeCreatedBy;
    }

    public void setNodeCreatedBy(UserInfo nodeCreatedBy) {
        this.nodeCreatedBy = nodeCreatedBy;
    }

    public AuditNodeResponse nodeUpdatedAt(DateTime nodeUpdatedAt) {
        this.nodeUpdatedAt = nodeUpdatedAt;
        return this;
    }

    @Schema(description="Modification date")
    public DateTime getNodeUpdatedAt() {
        return this.nodeUpdatedAt;
    }

    public void setNodeUpdatedAt(DateTime nodeUpdatedAt) {
        this.nodeUpdatedAt = nodeUpdatedAt;
    }

    public AuditNodeResponse nodeUpdatedBy(UserInfo nodeUpdatedBy) {
        this.nodeUpdatedBy = nodeUpdatedBy;
        return this;
    }

    @Schema(description="")
    public UserInfo getNodeUpdatedBy() {
        return this.nodeUpdatedBy;
    }

    public void setNodeUpdatedBy(UserInfo nodeUpdatedBy) {
        this.nodeUpdatedBy = nodeUpdatedBy;
    }

    public AuditNodeResponse nodeHasRecycleBin(Boolean nodeHasRecycleBin) {
        this.nodeHasRecycleBin = nodeHasRecycleBin;
        return this;
    }

    @Schema(description="&#128679; Deprecated since v4.10.0  Is recycle bin active (for rooms only)  Recycle bin is always on (disabling is not possible).")
    public Boolean isNodeHasRecycleBin() {
        return this.nodeHasRecycleBin;
    }

    public void setNodeHasRecycleBin(Boolean nodeHasRecycleBin) {
        this.nodeHasRecycleBin = nodeHasRecycleBin;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        AuditNodeResponse auditNodeResponse = (AuditNodeResponse)o;
        return Objects.equals(this.nodeId, auditNodeResponse.nodeId) && Objects.equals(this.nodeName, auditNodeResponse.nodeName) && Objects.equals(this.nodeParentPath, auditNodeResponse.nodeParentPath) && Objects.equals(this.nodeCntChildren, auditNodeResponse.nodeCntChildren) && Objects.equals(this.auditUserPermissionList, auditNodeResponse.auditUserPermissionList) && Objects.equals(this.nodeParentId, auditNodeResponse.nodeParentId) && Objects.equals(this.nodeSize, auditNodeResponse.nodeSize) && Objects.equals(this.nodeRecycleBinRetentionPeriod, auditNodeResponse.nodeRecycleBinRetentionPeriod) && Objects.equals(this.nodeQuota, auditNodeResponse.nodeQuota) && Objects.equals(this.nodeIsEncrypted, auditNodeResponse.nodeIsEncrypted) && Objects.equals(this.nodeHasActivitiesLog, auditNodeResponse.nodeHasActivitiesLog) && Objects.equals(this.nodeCreatedAt, auditNodeResponse.nodeCreatedAt) && Objects.equals(this.nodeCreatedBy, auditNodeResponse.nodeCreatedBy) && Objects.equals(this.nodeUpdatedAt, auditNodeResponse.nodeUpdatedAt) && Objects.equals(this.nodeUpdatedBy, auditNodeResponse.nodeUpdatedBy) && Objects.equals(this.nodeHasRecycleBin, auditNodeResponse.nodeHasRecycleBin);
    }

    public int hashCode() {
        return Objects.hash(this.nodeId, this.nodeName, this.nodeParentPath, this.nodeCntChildren, this.auditUserPermissionList, this.nodeParentId, this.nodeSize, this.nodeRecycleBinRetentionPeriod, this.nodeQuota, this.nodeIsEncrypted, this.nodeHasActivitiesLog, this.nodeCreatedAt, this.nodeCreatedBy, this.nodeUpdatedAt, this.nodeUpdatedBy, this.nodeHasRecycleBin);
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("class AuditNodeResponse {\n");
        sb.append("    nodeId: ").append(this.toIndentedString(this.nodeId)).append("\n");
        sb.append("    nodeName: ").append(this.toIndentedString(this.nodeName)).append("\n");
        sb.append("    nodeParentPath: ").append(this.toIndentedString(this.nodeParentPath)).append("\n");
        sb.append("    nodeCntChildren: ").append(this.toIndentedString(this.nodeCntChildren)).append("\n");
        sb.append("    auditUserPermissionList: ").append(this.toIndentedString(this.auditUserPermissionList)).append("\n");
        sb.append("    nodeParentId: ").append(this.toIndentedString(this.nodeParentId)).append("\n");
        sb.append("    nodeSize: ").append(this.toIndentedString(this.nodeSize)).append("\n");
        sb.append("    nodeRecycleBinRetentionPeriod: ").append(this.toIndentedString(this.nodeRecycleBinRetentionPeriod)).append("\n");
        sb.append("    nodeQuota: ").append(this.toIndentedString(this.nodeQuota)).append("\n");
        sb.append("    nodeIsEncrypted: ").append(this.toIndentedString(this.nodeIsEncrypted)).append("\n");
        sb.append("    nodeHasActivitiesLog: ").append(this.toIndentedString(this.nodeHasActivitiesLog)).append("\n");
        sb.append("    nodeCreatedAt: ").append(this.toIndentedString(this.nodeCreatedAt)).append("\n");
        sb.append("    nodeCreatedBy: ").append(this.toIndentedString(this.nodeCreatedBy)).append("\n");
        sb.append("    nodeUpdatedAt: ").append(this.toIndentedString(this.nodeUpdatedAt)).append("\n");
        sb.append("    nodeUpdatedBy: ").append(this.toIndentedString(this.nodeUpdatedBy)).append("\n");
        sb.append("    nodeHasRecycleBin: ").append(this.toIndentedString(this.nodeHasRecycleBin)).append("\n");
        sb.append("}");
        return sb.toString();
    }

    private String toIndentedString(Object o) {
        if (o == null) {
            return "null";
        }
        return o.toString().replace("\n", "\n    ");
    }
}

