/*
 * Decompiled with CFR 0.152.
 */
package ch.cyberduck.core.sds.io.swagger.client.model;

import ch.cyberduck.core.sds.io.swagger.client.model.NodePermissions;
import ch.cyberduck.core.sds.io.swagger.client.model.UserInfo;
import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.annotation.JsonValue;
import io.swagger.v3.oas.annotations.media.Schema;
import java.util.ArrayList;
import java.util.List;
import java.util.Objects;
import org.joda.time.DateTime;

@Schema(description="Room information")
public class RoomData {
    @JsonProperty(value="type")
    private TypeEnum type = null;
    @JsonProperty(value="id")
    private Long id = null;
    @JsonProperty(value="isGranted")
    private Boolean isGranted = null;
    @JsonProperty(value="name")
    private String name = null;
    @JsonProperty(value="isEncrypted")
    private Boolean isEncrypted = null;
    @JsonProperty(value="recycleBinRetentionPeriod")
    private Integer recycleBinRetentionPeriod = null;
    @JsonProperty(value="parentId")
    private Long parentId = null;
    @JsonProperty(value="size")
    private Long size = null;
    @JsonProperty(value="permissions")
    private NodePermissions permissions = null;
    @JsonProperty(value="createdAt")
    private DateTime createdAt = null;
    @JsonProperty(value="createdBy")
    private UserInfo createdBy = null;
    @JsonProperty(value="updatedAt")
    private DateTime updatedAt = null;
    @JsonProperty(value="updatedBy")
    private UserInfo updatedBy = null;
    @JsonProperty(value="quota")
    private Long quota = null;
    @JsonProperty(value="cntDownloadShares")
    private Integer cntDownloadShares = null;
    @JsonProperty(value="cntUploadShares")
    private Integer cntUploadShares = null;
    @JsonProperty(value="isFavorite")
    private Boolean isFavorite = null;
    @JsonProperty(value="hasRecycleBin")
    private Boolean hasRecycleBin = null;
    @JsonProperty(value="children")
    private List<RoomData> children = null;
    @JsonProperty(value="cntAdmins")
    private Integer cntAdmins = null;
    @JsonProperty(value="cntUsers")
    private Integer cntUsers = null;

    public RoomData type(TypeEnum type) {
        this.type = type;
        return this;
    }

    @Schema(description="Node type")
    public TypeEnum getType() {
        return this.type;
    }

    public void setType(TypeEnum type) {
        this.type = type;
    }

    public RoomData id(Long id) {
        this.id = id;
        return this;
    }

    @Schema(required=true, description="Room ID")
    public Long getId() {
        return this.id;
    }

    public void setId(Long id) {
        this.id = id;
    }

    public RoomData isGranted(Boolean isGranted) {
        this.isGranted = isGranted;
        return this;
    }

    @Schema(required=true, description="Is user granted room permissions")
    public Boolean isIsGranted() {
        return this.isGranted;
    }

    public void setIsGranted(Boolean isGranted) {
        this.isGranted = isGranted;
    }

    public RoomData name(String name) {
        this.name = name;
        return this;
    }

    @Schema(required=true, description="Name")
    public String getName() {
        return this.name;
    }

    public void setName(String name) {
        this.name = name;
    }

    public RoomData isEncrypted(Boolean isEncrypted) {
        this.isEncrypted = isEncrypted;
        return this;
    }

    @Schema(required=true, description="Encryption state")
    public Boolean isIsEncrypted() {
        return this.isEncrypted;
    }

    public void setIsEncrypted(Boolean isEncrypted) {
        this.isEncrypted = isEncrypted;
    }

    public RoomData recycleBinRetentionPeriod(Integer recycleBinRetentionPeriod) {
        this.recycleBinRetentionPeriod = recycleBinRetentionPeriod;
        return this;
    }

    @Schema(required=true, description="Retention period for deleted nodes in days")
    public Integer getRecycleBinRetentionPeriod() {
        return this.recycleBinRetentionPeriod;
    }

    public void setRecycleBinRetentionPeriod(Integer recycleBinRetentionPeriod) {
        this.recycleBinRetentionPeriod = recycleBinRetentionPeriod;
    }

    public RoomData parentId(Long parentId) {
        this.parentId = parentId;
        return this;
    }

    @Schema(description="Parent node ID (room or folder)")
    public Long getParentId() {
        return this.parentId;
    }

    public void setParentId(Long parentId) {
        this.parentId = parentId;
    }

    public RoomData size(Long size) {
        this.size = size;
        return this;
    }

    @Schema(description="Room size")
    public Long getSize() {
        return this.size;
    }

    public void setSize(Long size) {
        this.size = size;
    }

    public RoomData permissions(NodePermissions permissions) {
        this.permissions = permissions;
        return this;
    }

    @Schema(description="")
    public NodePermissions getPermissions() {
        return this.permissions;
    }

    public void setPermissions(NodePermissions permissions) {
        this.permissions = permissions;
    }

    public RoomData createdAt(DateTime createdAt) {
        this.createdAt = createdAt;
        return this;
    }

    @Schema(description="Expiration date")
    public DateTime getCreatedAt() {
        return this.createdAt;
    }

    public void setCreatedAt(DateTime createdAt) {
        this.createdAt = createdAt;
    }

    public RoomData createdBy(UserInfo createdBy) {
        this.createdBy = createdBy;
        return this;
    }

    @Schema(description="")
    public UserInfo getCreatedBy() {
        return this.createdBy;
    }

    public void setCreatedBy(UserInfo createdBy) {
        this.createdBy = createdBy;
    }

    public RoomData updatedAt(DateTime updatedAt) {
        this.updatedAt = updatedAt;
        return this;
    }

    @Schema(description="Modification date")
    public DateTime getUpdatedAt() {
        return this.updatedAt;
    }

    public void setUpdatedAt(DateTime updatedAt) {
        this.updatedAt = updatedAt;
    }

    public RoomData updatedBy(UserInfo updatedBy) {
        this.updatedBy = updatedBy;
        return this;
    }

    @Schema(description="")
    public UserInfo getUpdatedBy() {
        return this.updatedBy;
    }

    public void setUpdatedBy(UserInfo updatedBy) {
        this.updatedBy = updatedBy;
    }

    public RoomData quota(Long quota) {
        this.quota = quota;
        return this;
    }

    @Schema(description="Quota in byte")
    public Long getQuota() {
        return this.quota;
    }

    public void setQuota(Long quota) {
        this.quota = quota;
    }

    public RoomData cntDownloadShares(Integer cntDownloadShares) {
        this.cntDownloadShares = cntDownloadShares;
        return this;
    }

    @Schema(description="Returns the number of Download Shares of this node.")
    public Integer getCntDownloadShares() {
        return this.cntDownloadShares;
    }

    public void setCntDownloadShares(Integer cntDownloadShares) {
        this.cntDownloadShares = cntDownloadShares;
    }

    public RoomData cntUploadShares(Integer cntUploadShares) {
        this.cntUploadShares = cntUploadShares;
        return this;
    }

    @Schema(description="Returns the number of Upload Shares of this node.")
    public Integer getCntUploadShares() {
        return this.cntUploadShares;
    }

    public void setCntUploadShares(Integer cntUploadShares) {
        this.cntUploadShares = cntUploadShares;
    }

    public RoomData isFavorite(Boolean isFavorite) {
        this.isFavorite = isFavorite;
        return this;
    }

    @Schema(description="Node is marked as favorite (for rooms / folders only)")
    public Boolean isIsFavorite() {
        return this.isFavorite;
    }

    public void setIsFavorite(Boolean isFavorite) {
        this.isFavorite = isFavorite;
    }

    public RoomData hasRecycleBin(Boolean hasRecycleBin) {
        this.hasRecycleBin = hasRecycleBin;
        return this;
    }

    @Schema(required=true, description="&#128679; Deprecated since v4.10.0  Is recycle bin active (for rooms only)  Recycle bin is always on (disabling is not possible).")
    public Boolean isHasRecycleBin() {
        return this.hasRecycleBin;
    }

    public void setHasRecycleBin(Boolean hasRecycleBin) {
        this.hasRecycleBin = hasRecycleBin;
    }

    public RoomData children(List<RoomData> children) {
        this.children = children;
        return this;
    }

    public RoomData addChildrenItem(RoomData childrenItem) {
        if (this.children == null) {
            this.children = new ArrayList<RoomData>();
        }
        this.children.add(childrenItem);
        return this;
    }

    @Schema(description="&#128679; Deprecated since v4.10.0  List of rooms, where this room is a parent (if exist)")
    public List<RoomData> getChildren() {
        return this.children;
    }

    public void setChildren(List<RoomData> children) {
        this.children = children;
    }

    public RoomData cntAdmins(Integer cntAdmins) {
        this.cntAdmins = cntAdmins;
        return this;
    }

    @Schema(description="&#128679; Deprecated since v4.2.0  Number of admins (for rooms only)")
    public Integer getCntAdmins() {
        return this.cntAdmins;
    }

    public void setCntAdmins(Integer cntAdmins) {
        this.cntAdmins = cntAdmins;
    }

    public RoomData cntUsers(Integer cntUsers) {
        this.cntUsers = cntUsers;
        return this;
    }

    @Schema(description="&#128679; Deprecated since v4.2.0  Number of users (for rooms only)")
    public Integer getCntUsers() {
        return this.cntUsers;
    }

    public void setCntUsers(Integer cntUsers) {
        this.cntUsers = cntUsers;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        RoomData roomData = (RoomData)o;
        return Objects.equals((Object)this.type, (Object)roomData.type) && Objects.equals(this.id, roomData.id) && Objects.equals(this.isGranted, roomData.isGranted) && Objects.equals(this.name, roomData.name) && Objects.equals(this.isEncrypted, roomData.isEncrypted) && Objects.equals(this.recycleBinRetentionPeriod, roomData.recycleBinRetentionPeriod) && Objects.equals(this.parentId, roomData.parentId) && Objects.equals(this.size, roomData.size) && Objects.equals(this.permissions, roomData.permissions) && Objects.equals(this.createdAt, roomData.createdAt) && Objects.equals(this.createdBy, roomData.createdBy) && Objects.equals(this.updatedAt, roomData.updatedAt) && Objects.equals(this.updatedBy, roomData.updatedBy) && Objects.equals(this.quota, roomData.quota) && Objects.equals(this.cntDownloadShares, roomData.cntDownloadShares) && Objects.equals(this.cntUploadShares, roomData.cntUploadShares) && Objects.equals(this.isFavorite, roomData.isFavorite) && Objects.equals(this.hasRecycleBin, roomData.hasRecycleBin) && Objects.equals(this.children, roomData.children) && Objects.equals(this.cntAdmins, roomData.cntAdmins) && Objects.equals(this.cntUsers, roomData.cntUsers);
    }

    public int hashCode() {
        return Objects.hash(new Object[]{this.type, this.id, this.isGranted, this.name, this.isEncrypted, this.recycleBinRetentionPeriod, this.parentId, this.size, this.permissions, this.createdAt, this.createdBy, this.updatedAt, this.updatedBy, this.quota, this.cntDownloadShares, this.cntUploadShares, this.isFavorite, this.hasRecycleBin, this.children, this.cntAdmins, this.cntUsers});
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("class RoomData {\n");
        sb.append("    type: ").append(this.toIndentedString((Object)this.type)).append("\n");
        sb.append("    id: ").append(this.toIndentedString(this.id)).append("\n");
        sb.append("    isGranted: ").append(this.toIndentedString(this.isGranted)).append("\n");
        sb.append("    name: ").append(this.toIndentedString(this.name)).append("\n");
        sb.append("    isEncrypted: ").append(this.toIndentedString(this.isEncrypted)).append("\n");
        sb.append("    recycleBinRetentionPeriod: ").append(this.toIndentedString(this.recycleBinRetentionPeriod)).append("\n");
        sb.append("    parentId: ").append(this.toIndentedString(this.parentId)).append("\n");
        sb.append("    size: ").append(this.toIndentedString(this.size)).append("\n");
        sb.append("    permissions: ").append(this.toIndentedString(this.permissions)).append("\n");
        sb.append("    createdAt: ").append(this.toIndentedString(this.createdAt)).append("\n");
        sb.append("    createdBy: ").append(this.toIndentedString(this.createdBy)).append("\n");
        sb.append("    updatedAt: ").append(this.toIndentedString(this.updatedAt)).append("\n");
        sb.append("    updatedBy: ").append(this.toIndentedString(this.updatedBy)).append("\n");
        sb.append("    quota: ").append(this.toIndentedString(this.quota)).append("\n");
        sb.append("    cntDownloadShares: ").append(this.toIndentedString(this.cntDownloadShares)).append("\n");
        sb.append("    cntUploadShares: ").append(this.toIndentedString(this.cntUploadShares)).append("\n");
        sb.append("    isFavorite: ").append(this.toIndentedString(this.isFavorite)).append("\n");
        sb.append("    hasRecycleBin: ").append(this.toIndentedString(this.hasRecycleBin)).append("\n");
        sb.append("    children: ").append(this.toIndentedString(this.children)).append("\n");
        sb.append("    cntAdmins: ").append(this.toIndentedString(this.cntAdmins)).append("\n");
        sb.append("    cntUsers: ").append(this.toIndentedString(this.cntUsers)).append("\n");
        sb.append("}");
        return sb.toString();
    }

    private String toIndentedString(Object o) {
        if (o == null) {
            return "null";
        }
        return o.toString().replace("\n", "\n    ");
    }

    public static enum TypeEnum {
        ROOM("room");

        private String value;

        private TypeEnum(String value) {
            this.value = value;
        }

        @JsonValue
        public String getValue() {
            return this.value;
        }

        public String toString() {
            return String.valueOf(this.value);
        }

        @JsonCreator
        public static TypeEnum fromValue(String text) {
            for (TypeEnum b : TypeEnum.values()) {
                if (!String.valueOf(b.value).equals(text)) continue;
                return b;
            }
            return null;
        }
    }
}

