/*
 * Decompiled with CFR 0.152.
 */
package ch.cyberduck.core.sds.io.swagger.client.model;

import ch.cyberduck.core.sds.io.swagger.client.model.CharacterRules;
import ch.cyberduck.core.sds.io.swagger.client.model.UserInfo;
import com.fasterxml.jackson.annotation.JsonProperty;
import io.swagger.v3.oas.annotations.media.Schema;
import java.util.Objects;
import org.joda.time.DateTime;

@Schema(description="Shares password policies")
public class SharesPasswordPolicies {
    @JsonProperty(value="characterRules")
    private CharacterRules characterRules = null;
    @JsonProperty(value="minLength")
    private Integer minLength = null;
    @JsonProperty(value="rejectDictionaryWords")
    private Boolean rejectDictionaryWords = null;
    @JsonProperty(value="rejectUserInfo")
    private Boolean rejectUserInfo = null;
    @JsonProperty(value="rejectKeyboardPatterns")
    private Boolean rejectKeyboardPatterns = null;
    @JsonProperty(value="updatedAt")
    private DateTime updatedAt = null;
    @JsonProperty(value="updatedBy")
    private UserInfo updatedBy = null;

    public SharesPasswordPolicies characterRules(CharacterRules characterRules) {
        this.characterRules = characterRules;
        return this;
    }

    @Schema(description="")
    public CharacterRules getCharacterRules() {
        return this.characterRules;
    }

    public void setCharacterRules(CharacterRules characterRules) {
        this.characterRules = characterRules;
    }

    public SharesPasswordPolicies minLength(Integer minLength) {
        this.minLength = minLength;
        return this;
    }

    @Schema(description="Minimum number of characters a password must contain")
    public Integer getMinLength() {
        return this.minLength;
    }

    public void setMinLength(Integer minLength) {
        this.minLength = minLength;
    }

    public SharesPasswordPolicies rejectDictionaryWords(Boolean rejectDictionaryWords) {
        this.rejectDictionaryWords = rejectDictionaryWords;
        return this;
    }

    @Schema(description="Determines whether a password must NOT contain word(s) from a dictionary")
    public Boolean isRejectDictionaryWords() {
        return this.rejectDictionaryWords;
    }

    public void setRejectDictionaryWords(Boolean rejectDictionaryWords) {
        this.rejectDictionaryWords = rejectDictionaryWords;
    }

    public SharesPasswordPolicies rejectUserInfo(Boolean rejectUserInfo) {
        this.rejectUserInfo = rejectUserInfo;
        return this;
    }

    @Schema(description="Determines whether a password must NOT contain user info (first name, last name, email, user name)")
    public Boolean isRejectUserInfo() {
        return this.rejectUserInfo;
    }

    public void setRejectUserInfo(Boolean rejectUserInfo) {
        this.rejectUserInfo = rejectUserInfo;
    }

    public SharesPasswordPolicies rejectKeyboardPatterns(Boolean rejectKeyboardPatterns) {
        this.rejectKeyboardPatterns = rejectKeyboardPatterns;
        return this;
    }

    @Schema(description="Determines whether a password must NOT contain keyboard patterns (e.g. `qwertz`, `asdf`)  (min. 4 character pattern)")
    public Boolean isRejectKeyboardPatterns() {
        return this.rejectKeyboardPatterns;
    }

    public void setRejectKeyboardPatterns(Boolean rejectKeyboardPatterns) {
        this.rejectKeyboardPatterns = rejectKeyboardPatterns;
    }

    public SharesPasswordPolicies updatedAt(DateTime updatedAt) {
        this.updatedAt = updatedAt;
        return this;
    }

    @Schema(description="Modification date")
    public DateTime getUpdatedAt() {
        return this.updatedAt;
    }

    public void setUpdatedAt(DateTime updatedAt) {
        this.updatedAt = updatedAt;
    }

    public SharesPasswordPolicies updatedBy(UserInfo updatedBy) {
        this.updatedBy = updatedBy;
        return this;
    }

    @Schema(description="")
    public UserInfo getUpdatedBy() {
        return this.updatedBy;
    }

    public void setUpdatedBy(UserInfo updatedBy) {
        this.updatedBy = updatedBy;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        SharesPasswordPolicies sharesPasswordPolicies = (SharesPasswordPolicies)o;
        return Objects.equals(this.characterRules, sharesPasswordPolicies.characterRules) && Objects.equals(this.minLength, sharesPasswordPolicies.minLength) && Objects.equals(this.rejectDictionaryWords, sharesPasswordPolicies.rejectDictionaryWords) && Objects.equals(this.rejectUserInfo, sharesPasswordPolicies.rejectUserInfo) && Objects.equals(this.rejectKeyboardPatterns, sharesPasswordPolicies.rejectKeyboardPatterns) && Objects.equals(this.updatedAt, sharesPasswordPolicies.updatedAt) && Objects.equals(this.updatedBy, sharesPasswordPolicies.updatedBy);
    }

    public int hashCode() {
        return Objects.hash(this.characterRules, this.minLength, this.rejectDictionaryWords, this.rejectUserInfo, this.rejectKeyboardPatterns, this.updatedAt, this.updatedBy);
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("class SharesPasswordPolicies {\n");
        sb.append("    characterRules: ").append(this.toIndentedString(this.characterRules)).append("\n");
        sb.append("    minLength: ").append(this.toIndentedString(this.minLength)).append("\n");
        sb.append("    rejectDictionaryWords: ").append(this.toIndentedString(this.rejectDictionaryWords)).append("\n");
        sb.append("    rejectUserInfo: ").append(this.toIndentedString(this.rejectUserInfo)).append("\n");
        sb.append("    rejectKeyboardPatterns: ").append(this.toIndentedString(this.rejectKeyboardPatterns)).append("\n");
        sb.append("    updatedAt: ").append(this.toIndentedString(this.updatedAt)).append("\n");
        sb.append("    updatedBy: ").append(this.toIndentedString(this.updatedBy)).append("\n");
        sb.append("}");
        return sb.toString();
    }

    private String toIndentedString(Object o) {
        if (o == null) {
            return "null";
        }
        return o.toString().replace("\n", "\n    ");
    }
}

