/*
 * Decompiled with CFR 0.152.
 */
package ch.cyberduck.core.sds.io.swagger.client.model;

import ch.cyberduck.core.sds.io.swagger.client.model.AuthMethod;
import com.fasterxml.jackson.annotation.JsonProperty;
import io.swagger.v3.oas.annotations.media.Schema;
import java.util.ArrayList;
import java.util.List;
import java.util.Objects;

@Schema(description="System information (default language and authentication methods)")
public class SystemInfo {
    @JsonProperty(value="languageDefault")
    private String languageDefault = null;
    @JsonProperty(value="hideLoginInputFields")
    private Boolean hideLoginInputFields = null;
    @JsonProperty(value="s3Hosts")
    private List<String> s3Hosts = new ArrayList<String>();
    @JsonProperty(value="s3EnforceDirectUpload")
    private Boolean s3EnforceDirectUpload = null;
    @JsonProperty(value="useS3Storage")
    private Boolean useS3Storage = null;
    @JsonProperty(value="authMethods")
    private List<AuthMethod> authMethods = new ArrayList<AuthMethod>();

    public SystemInfo languageDefault(String languageDefault) {
        this.languageDefault = languageDefault;
        return this;
    }

    @Schema(required=true, description="System default language  cf. [RFC 5646](https://tools.ietf.org/html/rfc5646)")
    public String getLanguageDefault() {
        return this.languageDefault;
    }

    public void setLanguageDefault(String languageDefault) {
        this.languageDefault = languageDefault;
    }

    public SystemInfo hideLoginInputFields(Boolean hideLoginInputFields) {
        this.hideLoginInputFields = hideLoginInputFields;
        return this;
    }

    @Schema(required=true, description="&#128640; Since v4.13.0  Defines if login fields should be hidden")
    public Boolean isHideLoginInputFields() {
        return this.hideLoginInputFields;
    }

    public void setHideLoginInputFields(Boolean hideLoginInputFields) {
        this.hideLoginInputFields = hideLoginInputFields;
    }

    public SystemInfo s3Hosts(List<String> s3Hosts) {
        this.s3Hosts = s3Hosts;
        return this;
    }

    public SystemInfo addS3HostsItem(String s3HostsItem) {
        this.s3Hosts.add(s3HostsItem);
        return this;
    }

    @Schema(required=true, description="&#128640; Since v4.14.0  List of S3 Hosts for CSP header")
    public List<String> getS3Hosts() {
        return this.s3Hosts;
    }

    public void setS3Hosts(List<String> s3Hosts) {
        this.s3Hosts = s3Hosts;
    }

    public SystemInfo s3EnforceDirectUpload(Boolean s3EnforceDirectUpload) {
        this.s3EnforceDirectUpload = s3EnforceDirectUpload;
        return this;
    }

    @Schema(required=true, description="&#128640; Since v4.15.0  Determines whether S3 direct upload is enforced or not")
    public Boolean isS3EnforceDirectUpload() {
        return this.s3EnforceDirectUpload;
    }

    public void setS3EnforceDirectUpload(Boolean s3EnforceDirectUpload) {
        this.s3EnforceDirectUpload = s3EnforceDirectUpload;
    }

    public SystemInfo useS3Storage(Boolean useS3Storage) {
        this.useS3Storage = useS3Storage;
        return this;
    }

    @Schema(required=true, description="&#128640; Since v4.21.0  Defines if S3 is used as storage backend")
    public Boolean isUseS3Storage() {
        return this.useS3Storage;
    }

    public void setUseS3Storage(Boolean useS3Storage) {
        this.useS3Storage = useS3Storage;
    }

    public SystemInfo authMethods(List<AuthMethod> authMethods) {
        this.authMethods = authMethods;
        return this;
    }

    public SystemInfo addAuthMethodsItem(AuthMethod authMethodsItem) {
        this.authMethods.add(authMethodsItem);
        return this;
    }

    @Schema(required=true, description="&#128679; Deprecated since v4.13.0  Authentication methods:  * `sql`  * `active_directory`  * `radius`  * `openid`  use `authData` instead")
    public List<AuthMethod> getAuthMethods() {
        return this.authMethods;
    }

    public void setAuthMethods(List<AuthMethod> authMethods) {
        this.authMethods = authMethods;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        SystemInfo systemInfo = (SystemInfo)o;
        return Objects.equals(this.languageDefault, systemInfo.languageDefault) && Objects.equals(this.hideLoginInputFields, systemInfo.hideLoginInputFields) && Objects.equals(this.s3Hosts, systemInfo.s3Hosts) && Objects.equals(this.s3EnforceDirectUpload, systemInfo.s3EnforceDirectUpload) && Objects.equals(this.useS3Storage, systemInfo.useS3Storage) && Objects.equals(this.authMethods, systemInfo.authMethods);
    }

    public int hashCode() {
        return Objects.hash(this.languageDefault, this.hideLoginInputFields, this.s3Hosts, this.s3EnforceDirectUpload, this.useS3Storage, this.authMethods);
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("class SystemInfo {\n");
        sb.append("    languageDefault: ").append(this.toIndentedString(this.languageDefault)).append("\n");
        sb.append("    hideLoginInputFields: ").append(this.toIndentedString(this.hideLoginInputFields)).append("\n");
        sb.append("    s3Hosts: ").append(this.toIndentedString(this.s3Hosts)).append("\n");
        sb.append("    s3EnforceDirectUpload: ").append(this.toIndentedString(this.s3EnforceDirectUpload)).append("\n");
        sb.append("    useS3Storage: ").append(this.toIndentedString(this.useS3Storage)).append("\n");
        sb.append("    authMethods: ").append(this.toIndentedString(this.authMethods)).append("\n");
        sb.append("}");
        return sb.toString();
    }

    private String toIndentedString(Object o) {
        if (o == null) {
            return "null";
        }
        return o.toString().replace("\n", "\n    ");
    }
}

