/*
 * Decompiled with CFR 0.152.
 */
package ch.cyberduck.core.sds.io.swagger.client.model;

import ch.cyberduck.core.sds.io.swagger.client.model.UserInfo;
import com.fasterxml.jackson.annotation.JsonProperty;
import io.swagger.v3.oas.annotations.media.Schema;
import java.util.Objects;
import org.joda.time.DateTime;

@Schema(description="Upload Share information")
public class UploadShare {
    @JsonProperty(value="id")
    private Long id = null;
    @JsonProperty(value="name")
    private String name = null;
    @JsonProperty(value="targetId")
    private Long targetId = null;
    @JsonProperty(value="isProtected")
    private Boolean isProtected = null;
    @JsonProperty(value="accessKey")
    private String accessKey = null;
    @JsonProperty(value="createdAt")
    private DateTime createdAt = null;
    @JsonProperty(value="createdBy")
    private UserInfo createdBy = null;
    @JsonProperty(value="updatedAt")
    private DateTime updatedAt = null;
    @JsonProperty(value="updatedBy")
    private UserInfo updatedBy = null;
    @JsonProperty(value="expireAt")
    private DateTime expireAt = null;
    @JsonProperty(value="targetPath")
    private String targetPath = null;
    @JsonProperty(value="isEncrypted")
    private Boolean isEncrypted = null;
    @JsonProperty(value="notes")
    private String notes = null;
    @JsonProperty(value="internalNotes")
    private String internalNotes = null;
    @JsonProperty(value="filesExpiryPeriod")
    private Integer filesExpiryPeriod = null;
    @JsonProperty(value="cntFiles")
    private Integer cntFiles = null;
    @JsonProperty(value="cntUploads")
    private Integer cntUploads = null;
    @JsonProperty(value="showUploadedFiles")
    private Boolean showUploadedFiles = null;
    @JsonProperty(value="dataUrl")
    private String dataUrl = null;
    @JsonProperty(value="maxSlots")
    private Integer maxSlots = null;
    @JsonProperty(value="maxSize")
    private Long maxSize = null;
    @JsonProperty(value="targetType")
    private String targetType = null;
    @JsonProperty(value="showCreatorName")
    private Boolean showCreatorName = null;
    @JsonProperty(value="showCreatorUsername")
    private Boolean showCreatorUsername = null;
    @JsonProperty(value="notifyCreator")
    private Boolean notifyCreator = null;
    @JsonProperty(value="recipients")
    private String recipients = null;
    @JsonProperty(value="smsRecipients")
    private String smsRecipients = null;

    public UploadShare id(Long id) {
        this.id = id;
        return this;
    }

    @Schema(required=true, description="Share ID")
    public Long getId() {
        return this.id;
    }

    public void setId(Long id) {
        this.id = id;
    }

    public UploadShare name(String name) {
        this.name = name;
        return this;
    }

    @Schema(required=true, description="Alias name")
    public String getName() {
        return this.name;
    }

    public void setName(String name) {
        this.name = name;
    }

    public UploadShare targetId(Long targetId) {
        this.targetId = targetId;
        return this;
    }

    @Schema(required=true, description="Target room or folder ID")
    public Long getTargetId() {
        return this.targetId;
    }

    public void setTargetId(Long targetId) {
        this.targetId = targetId;
    }

    public UploadShare isProtected(Boolean isProtected) {
        this.isProtected = isProtected;
        return this;
    }

    @Schema(required=true, description="Is share protected by password")
    public Boolean isIsProtected() {
        return this.isProtected;
    }

    public void setIsProtected(Boolean isProtected) {
        this.isProtected = isProtected;
    }

    public UploadShare accessKey(String accessKey) {
        this.accessKey = accessKey;
        return this;
    }

    @Schema(required=true, description="Share access key to generate secure link")
    public String getAccessKey() {
        return this.accessKey;
    }

    public void setAccessKey(String accessKey) {
        this.accessKey = accessKey;
    }

    public UploadShare createdAt(DateTime createdAt) {
        this.createdAt = createdAt;
        return this;
    }

    @Schema(required=true, description="Creation date")
    public DateTime getCreatedAt() {
        return this.createdAt;
    }

    public void setCreatedAt(DateTime createdAt) {
        this.createdAt = createdAt;
    }

    public UploadShare createdBy(UserInfo createdBy) {
        this.createdBy = createdBy;
        return this;
    }

    @Schema(required=true, description="")
    public UserInfo getCreatedBy() {
        return this.createdBy;
    }

    public void setCreatedBy(UserInfo createdBy) {
        this.createdBy = createdBy;
    }

    public UploadShare updatedAt(DateTime updatedAt) {
        this.updatedAt = updatedAt;
        return this;
    }

    @Schema(description="Modification date")
    public DateTime getUpdatedAt() {
        return this.updatedAt;
    }

    public void setUpdatedAt(DateTime updatedAt) {
        this.updatedAt = updatedAt;
    }

    public UploadShare updatedBy(UserInfo updatedBy) {
        this.updatedBy = updatedBy;
        return this;
    }

    @Schema(description="")
    public UserInfo getUpdatedBy() {
        return this.updatedBy;
    }

    public void setUpdatedBy(UserInfo updatedBy) {
        this.updatedBy = updatedBy;
    }

    public UploadShare expireAt(DateTime expireAt) {
        this.expireAt = expireAt;
        return this;
    }

    @Schema(description="Expiration date")
    public DateTime getExpireAt() {
        return this.expireAt;
    }

    public void setExpireAt(DateTime expireAt) {
        this.expireAt = expireAt;
    }

    public UploadShare targetPath(String targetPath) {
        this.targetPath = targetPath;
        return this;
    }

    @Schema(description="Path to shared upload node")
    public String getTargetPath() {
        return this.targetPath;
    }

    public void setTargetPath(String targetPath) {
        this.targetPath = targetPath;
    }

    public UploadShare isEncrypted(Boolean isEncrypted) {
        this.isEncrypted = isEncrypted;
        return this;
    }

    @Schema(description="Encryption state")
    public Boolean isIsEncrypted() {
        return this.isEncrypted;
    }

    public void setIsEncrypted(Boolean isEncrypted) {
        this.isEncrypted = isEncrypted;
    }

    public UploadShare notes(String notes) {
        this.notes = notes;
        return this;
    }

    @Schema(description="User notes")
    public String getNotes() {
        return this.notes;
    }

    public void setNotes(String notes) {
        this.notes = notes;
    }

    public UploadShare internalNotes(String internalNotes) {
        this.internalNotes = internalNotes;
        return this;
    }

    @Schema(description="&#128640; Since v4.11.0  Internal notes")
    public String getInternalNotes() {
        return this.internalNotes;
    }

    public void setInternalNotes(String internalNotes) {
        this.internalNotes = internalNotes;
    }

    public UploadShare filesExpiryPeriod(Integer filesExpiryPeriod) {
        this.filesExpiryPeriod = filesExpiryPeriod;
        return this;
    }

    @Schema(description="Number of days after which uploaded files expire")
    public Integer getFilesExpiryPeriod() {
        return this.filesExpiryPeriod;
    }

    public void setFilesExpiryPeriod(Integer filesExpiryPeriod) {
        this.filesExpiryPeriod = filesExpiryPeriod;
    }

    public UploadShare cntFiles(Integer cntFiles) {
        this.cntFiles = cntFiles;
        return this;
    }

    @Schema(description="Total amount of existing files uploaded with this share.")
    public Integer getCntFiles() {
        return this.cntFiles;
    }

    public void setCntFiles(Integer cntFiles) {
        this.cntFiles = cntFiles;
    }

    public UploadShare cntUploads(Integer cntUploads) {
        this.cntUploads = cntUploads;
        return this;
    }

    @Schema(description="Total amount of uploads conducted with this share.")
    public Integer getCntUploads() {
        return this.cntUploads;
    }

    public void setCntUploads(Integer cntUploads) {
        this.cntUploads = cntUploads;
    }

    public UploadShare showUploadedFiles(Boolean showUploadedFiles) {
        this.showUploadedFiles = showUploadedFiles;
        return this;
    }

    @Schema(description="Allow display of already uploaded files")
    public Boolean isShowUploadedFiles() {
        return this.showUploadedFiles;
    }

    public void setShowUploadedFiles(Boolean showUploadedFiles) {
        this.showUploadedFiles = showUploadedFiles;
    }

    public UploadShare dataUrl(String dataUrl) {
        this.dataUrl = dataUrl;
        return this;
    }

    @Schema(description="Upload Share URL")
    public String getDataUrl() {
        return this.dataUrl;
    }

    public void setDataUrl(String dataUrl) {
        this.dataUrl = dataUrl;
    }

    public UploadShare maxSlots(Integer maxSlots) {
        this.maxSlots = maxSlots;
        return this;
    }

    @Schema(description="Maximal amount of files to upload")
    public Integer getMaxSlots() {
        return this.maxSlots;
    }

    public void setMaxSlots(Integer maxSlots) {
        this.maxSlots = maxSlots;
    }

    public UploadShare maxSize(Long maxSize) {
        this.maxSize = maxSize;
        return this;
    }

    @Schema(description="Maximal total size of uploaded files (in bytes)")
    public Long getMaxSize() {
        return this.maxSize;
    }

    public void setMaxSize(Long maxSize) {
        this.maxSize = maxSize;
    }

    public UploadShare targetType(String targetType) {
        this.targetType = targetType;
        return this;
    }

    @Schema(description="Node type")
    public String getTargetType() {
        return this.targetType;
    }

    public void setTargetType(String targetType) {
        this.targetType = targetType;
    }

    public UploadShare showCreatorName(Boolean showCreatorName) {
        this.showCreatorName = showCreatorName;
        return this;
    }

    @Schema(description="&#128640; Since v4.11.0  Show creator first and last name.")
    public Boolean isShowCreatorName() {
        return this.showCreatorName;
    }

    public void setShowCreatorName(Boolean showCreatorName) {
        this.showCreatorName = showCreatorName;
    }

    public UploadShare showCreatorUsername(Boolean showCreatorUsername) {
        this.showCreatorUsername = showCreatorUsername;
        return this;
    }

    @Schema(description="&#128640; Since v4.11.0  Show creator email address.")
    public Boolean isShowCreatorUsername() {
        return this.showCreatorUsername;
    }

    public void setShowCreatorUsername(Boolean showCreatorUsername) {
        this.showCreatorUsername = showCreatorUsername;
    }

    public UploadShare notifyCreator(Boolean notifyCreator) {
        this.notifyCreator = notifyCreator;
        return this;
    }

    @Schema(required=true, description="&#128679; Deprecated since v4.20.0  Notify creator on every upload.")
    public Boolean isNotifyCreator() {
        return this.notifyCreator;
    }

    public void setNotifyCreator(Boolean notifyCreator) {
        this.notifyCreator = notifyCreator;
    }

    public UploadShare recipients(String recipients) {
        this.recipients = recipients;
        return this;
    }

    @Schema(description="&#128679; Deprecated since v4.11.0  CSV string of recipient email addresses")
    public String getRecipients() {
        return this.recipients;
    }

    public void setRecipients(String recipients) {
        this.recipients = recipients;
    }

    public UploadShare smsRecipients(String smsRecipients) {
        this.smsRecipients = smsRecipients;
        return this;
    }

    @Schema(description="&#128679; Deprecated since v4.11.0  CSV string of recipient MSISDNs")
    public String getSmsRecipients() {
        return this.smsRecipients;
    }

    public void setSmsRecipients(String smsRecipients) {
        this.smsRecipients = smsRecipients;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        UploadShare uploadShare = (UploadShare)o;
        return Objects.equals(this.id, uploadShare.id) && Objects.equals(this.name, uploadShare.name) && Objects.equals(this.targetId, uploadShare.targetId) && Objects.equals(this.isProtected, uploadShare.isProtected) && Objects.equals(this.accessKey, uploadShare.accessKey) && Objects.equals(this.createdAt, uploadShare.createdAt) && Objects.equals(this.createdBy, uploadShare.createdBy) && Objects.equals(this.updatedAt, uploadShare.updatedAt) && Objects.equals(this.updatedBy, uploadShare.updatedBy) && Objects.equals(this.expireAt, uploadShare.expireAt) && Objects.equals(this.targetPath, uploadShare.targetPath) && Objects.equals(this.isEncrypted, uploadShare.isEncrypted) && Objects.equals(this.notes, uploadShare.notes) && Objects.equals(this.internalNotes, uploadShare.internalNotes) && Objects.equals(this.filesExpiryPeriod, uploadShare.filesExpiryPeriod) && Objects.equals(this.cntFiles, uploadShare.cntFiles) && Objects.equals(this.cntUploads, uploadShare.cntUploads) && Objects.equals(this.showUploadedFiles, uploadShare.showUploadedFiles) && Objects.equals(this.dataUrl, uploadShare.dataUrl) && Objects.equals(this.maxSlots, uploadShare.maxSlots) && Objects.equals(this.maxSize, uploadShare.maxSize) && Objects.equals(this.targetType, uploadShare.targetType) && Objects.equals(this.showCreatorName, uploadShare.showCreatorName) && Objects.equals(this.showCreatorUsername, uploadShare.showCreatorUsername) && Objects.equals(this.notifyCreator, uploadShare.notifyCreator) && Objects.equals(this.recipients, uploadShare.recipients) && Objects.equals(this.smsRecipients, uploadShare.smsRecipients);
    }

    public int hashCode() {
        return Objects.hash(this.id, this.name, this.targetId, this.isProtected, this.accessKey, this.createdAt, this.createdBy, this.updatedAt, this.updatedBy, this.expireAt, this.targetPath, this.isEncrypted, this.notes, this.internalNotes, this.filesExpiryPeriod, this.cntFiles, this.cntUploads, this.showUploadedFiles, this.dataUrl, this.maxSlots, this.maxSize, this.targetType, this.showCreatorName, this.showCreatorUsername, this.notifyCreator, this.recipients, this.smsRecipients);
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("class UploadShare {\n");
        sb.append("    id: ").append(this.toIndentedString(this.id)).append("\n");
        sb.append("    name: ").append(this.toIndentedString(this.name)).append("\n");
        sb.append("    targetId: ").append(this.toIndentedString(this.targetId)).append("\n");
        sb.append("    isProtected: ").append(this.toIndentedString(this.isProtected)).append("\n");
        sb.append("    accessKey: ").append(this.toIndentedString(this.accessKey)).append("\n");
        sb.append("    createdAt: ").append(this.toIndentedString(this.createdAt)).append("\n");
        sb.append("    createdBy: ").append(this.toIndentedString(this.createdBy)).append("\n");
        sb.append("    updatedAt: ").append(this.toIndentedString(this.updatedAt)).append("\n");
        sb.append("    updatedBy: ").append(this.toIndentedString(this.updatedBy)).append("\n");
        sb.append("    expireAt: ").append(this.toIndentedString(this.expireAt)).append("\n");
        sb.append("    targetPath: ").append(this.toIndentedString(this.targetPath)).append("\n");
        sb.append("    isEncrypted: ").append(this.toIndentedString(this.isEncrypted)).append("\n");
        sb.append("    notes: ").append(this.toIndentedString(this.notes)).append("\n");
        sb.append("    internalNotes: ").append(this.toIndentedString(this.internalNotes)).append("\n");
        sb.append("    filesExpiryPeriod: ").append(this.toIndentedString(this.filesExpiryPeriod)).append("\n");
        sb.append("    cntFiles: ").append(this.toIndentedString(this.cntFiles)).append("\n");
        sb.append("    cntUploads: ").append(this.toIndentedString(this.cntUploads)).append("\n");
        sb.append("    showUploadedFiles: ").append(this.toIndentedString(this.showUploadedFiles)).append("\n");
        sb.append("    dataUrl: ").append(this.toIndentedString(this.dataUrl)).append("\n");
        sb.append("    maxSlots: ").append(this.toIndentedString(this.maxSlots)).append("\n");
        sb.append("    maxSize: ").append(this.toIndentedString(this.maxSize)).append("\n");
        sb.append("    targetType: ").append(this.toIndentedString(this.targetType)).append("\n");
        sb.append("    showCreatorName: ").append(this.toIndentedString(this.showCreatorName)).append("\n");
        sb.append("    showCreatorUsername: ").append(this.toIndentedString(this.showCreatorUsername)).append("\n");
        sb.append("    notifyCreator: ").append(this.toIndentedString(this.notifyCreator)).append("\n");
        sb.append("    recipients: ").append(this.toIndentedString(this.recipients)).append("\n");
        sb.append("    smsRecipients: ").append(this.toIndentedString(this.smsRecipients)).append("\n");
        sb.append("}");
        return sb.toString();
    }

    private String toIndentedString(Object o) {
        if (o == null) {
            return "null";
        }
        return o.toString().replace("\n", "\n    ");
    }
}

