/*
 * Decompiled with CFR 0.152.
 */
package ch.cyberduck.core.googlestorage;

import ch.cyberduck.core.DefaultIOExceptionMappingService;
import ch.cyberduck.core.exception.BackgroundException;
import ch.cyberduck.core.exception.RetriableAccessDeniedException;
import ch.cyberduck.core.http.DefaultHttpResponseExceptionMappingService;
import com.google.api.client.googleapis.json.GoogleJsonError;
import com.google.api.client.googleapis.json.GoogleJsonResponseException;
import java.io.IOException;
import java.time.Duration;
import java.util.Optional;
import org.apache.http.client.HttpResponseException;

public class GoogleStorageExceptionMappingService
extends DefaultIOExceptionMappingService {
    public BackgroundException map(IOException failure) {
        GoogleJsonResponseException error;
        GoogleJsonError details;
        StringBuilder buffer = new StringBuilder();
        if (failure instanceof GoogleJsonResponseException && (details = (error = (GoogleJsonResponseException)failure).getDetails()) != null) {
            this.append(buffer, error.getDetails().getMessage());
            Optional optionalInfo = details.getErrors().stream().findFirst();
            if (optionalInfo.isPresent()) {
                GoogleJsonError.ErrorInfo info = (GoogleJsonError.ErrorInfo)optionalInfo.get();
                this.append(buffer, "domain: " + info.getDomain());
                this.append(buffer, "reason: " + info.getReason());
                if ("usageLimits".equals(info.getDomain()) && details.getCode() == 403) {
                    return new RetriableAccessDeniedException(buffer.toString(), Duration.ofSeconds(5L), (Throwable)failure);
                }
            }
        }
        if (failure instanceof com.google.api.client.http.HttpResponseException) {
            com.google.api.client.http.HttpResponseException response = (com.google.api.client.http.HttpResponseException)failure;
            this.append(buffer, response.getStatusMessage());
            return new DefaultHttpResponseExceptionMappingService().map(new HttpResponseException(response.getStatusCode(), buffer.toString()));
        }
        return super.map(failure);
    }
}

