/*
 * Decompiled with CFR 0.152.
 */
package ch.cyberduck.core.googlestorage;

import ch.cyberduck.core.ConnectionCallback;
import ch.cyberduck.core.PasswordCallback;
import ch.cyberduck.core.Path;
import ch.cyberduck.core.PathContainerService;
import ch.cyberduck.core.exception.BackgroundException;
import ch.cyberduck.core.features.Delete;
import ch.cyberduck.core.features.Move;
import ch.cyberduck.core.googlestorage.GoogleStorageCopyFeature;
import ch.cyberduck.core.googlestorage.GoogleStorageDeleteFeature;
import ch.cyberduck.core.googlestorage.GoogleStoragePathContainerService;
import ch.cyberduck.core.googlestorage.GoogleStorageSession;
import ch.cyberduck.core.transfer.TransferStatus;
import java.util.Collections;

public class GoogleStorageMoveFeature
implements Move {
    private final PathContainerService containerService = new GoogleStoragePathContainerService();
    private final GoogleStorageSession session;
    private Delete delete;

    public GoogleStorageMoveFeature(GoogleStorageSession session) {
        this.session = session;
        this.delete = new GoogleStorageDeleteFeature(session);
    }

    public Path move(Path source, Path target, TransferStatus status, Delete.Callback callback, ConnectionCallback connectionCallback) throws BackgroundException {
        Path copy = new GoogleStorageCopyFeature(this.session).copy(source, target, status, connectionCallback);
        this.delete.delete(Collections.singletonMap(source, status), (PasswordCallback)connectionCallback, callback);
        return copy;
    }

    public boolean isSupported(Path source, Path target) {
        return !this.containerService.isContainer(source);
    }
}

