/*
 * Decompiled with CFR 0.152.
 */
package ch.cyberduck.core.nio;

import ch.cyberduck.core.AbstractPath;
import ch.cyberduck.core.LocalFactory;
import ch.cyberduck.core.Path;
import ch.cyberduck.core.exception.BackgroundException;
import ch.cyberduck.core.nio.LocalSession;
import ch.cyberduck.core.shared.DefaultHomeFinderService;
import java.util.EnumSet;
import org.apache.commons.lang3.StringUtils;

public class LocalHomeFinderFeature
extends DefaultHomeFinderService {
    public LocalHomeFinderFeature(LocalSession session) {
        super(session.getHost());
    }

    public Path find() throws BackgroundException {
        Path directory = super.find();
        if (directory == this.DEFAULT_HOME) {
            String home = LocalFactory.get().getAbsolute();
            return this.toPath(home);
        }
        return directory;
    }

    protected Path toPath(String home) {
        return new Path(StringUtils.replace((String)home, (String)"\\", (String)"/"), EnumSet.of(AbstractPath.Type.directory));
    }
}

