/*
 * Decompiled with CFR 0.152.
 */
package ch.cyberduck.core.nio;

import ch.cyberduck.core.ConnectionCallback;
import ch.cyberduck.core.DisabledPasswordCallback;
import ch.cyberduck.core.PasswordCallback;
import ch.cyberduck.core.Path;
import ch.cyberduck.core.exception.BackgroundException;
import ch.cyberduck.core.exception.NotfoundException;
import ch.cyberduck.core.features.Delete;
import ch.cyberduck.core.features.Move;
import ch.cyberduck.core.nio.LocalAttributesFinderFeature;
import ch.cyberduck.core.nio.LocalDeleteFeature;
import ch.cyberduck.core.nio.LocalExceptionMappingService;
import ch.cyberduck.core.nio.LocalFindFeature;
import ch.cyberduck.core.nio.LocalSession;
import ch.cyberduck.core.transfer.TransferStatus;
import java.nio.file.NoSuchFileException;
import java.util.Collections;

public class LocalMoveFeature
implements Move {
    private final LocalSession session;

    public LocalMoveFeature(LocalSession session) {
        this.session = session;
    }

    public Path move(Path file, Path renamed, TransferStatus status, Delete.Callback callback, ConnectionCallback connectionCallback) throws BackgroundException {
        if (!new LocalFindFeature(this.session).find(file)) {
            throw new NotfoundException(file.getAbsolute());
        }
        if (status.isExists()) {
            new LocalDeleteFeature(this.session).delete(Collections.singletonMap(renamed, status), (PasswordCallback)new DisabledPasswordCallback(), callback);
        }
        if (!this.session.toPath(file).toFile().renameTo(this.session.toPath(renamed).toFile())) {
            throw new LocalExceptionMappingService().map("Cannot rename {0}", new NoSuchFileException(file.getName()), file);
        }
        return new Path(renamed.getParent(), renamed.getName(), renamed.getType(), new LocalAttributesFinderFeature(this.session).find(renamed));
    }

    public boolean isRecursive(Path source, Path target) {
        return true;
    }
}

