/*
 * Decompiled with CFR 0.152.
 */
package ch.cyberduck.core.openstack;

import ch.cyberduck.core.AttributedList;
import ch.cyberduck.core.ListProgressListener;
import ch.cyberduck.core.ListService;
import ch.cyberduck.core.Path;
import ch.cyberduck.core.exception.BackgroundException;
import ch.cyberduck.core.openstack.SwiftContainerListService;
import ch.cyberduck.core.openstack.SwiftLocationFeature;
import ch.cyberduck.core.openstack.SwiftObjectListService;
import ch.cyberduck.core.openstack.SwiftRegionService;
import ch.cyberduck.core.openstack.SwiftSession;

public class SwiftListService
implements ListService {
    private final SwiftSession session;
    private final SwiftRegionService regionService;

    public SwiftListService(SwiftSession session, SwiftRegionService regionService) {
        this.session = session;
        this.regionService = regionService;
    }

    public AttributedList<Path> list(Path directory, ListProgressListener listener) throws BackgroundException {
        if (directory.isRoot()) {
            return new SwiftContainerListService(this.session, new SwiftLocationFeature.SwiftRegion(this.session.getHost().getRegion())).list(directory, listener);
        }
        return new SwiftObjectListService(this.session, this.regionService).list(directory, listener);
    }
}

