/*
 * Decompiled with CFR 0.152.
 */
package com.joyent.manta.client.crypto;

import com.joyent.manta.client.crypto.AbstractAesCipherDetails;
import com.joyent.manta.client.crypto.AesCipherDetailsFactory;
import com.joyent.manta.client.crypto.ByteRangeConversion;
import com.joyent.manta.client.crypto.SupportedCipherDetails;
import java.security.spec.AlgorithmParameterSpec;
import javax.crypto.Cipher;
import javax.crypto.spec.GCMParameterSpec;
import org.apache.commons.lang3.Validate;

public final class AesGcmCipherDetails
extends AbstractAesCipherDetails {
    private static final long MAX_AES_GCM_BLOCKS = 0xFFFFFFFEL;
    private static final long MAX_PLAIN_TEXT_SIZE_BYTES = 0xFFFFFFFE0L;
    public static final SupportedCipherDetails INSTANCE_128_BIT = AesCipherDetailsFactory.buildWith(AesCipherDetailsFactory.CipherMode.GCM, 128);
    public static final SupportedCipherDetails INSTANCE_192_BIT = AesCipherDetailsFactory.buildWith(AesCipherDetailsFactory.CipherMode.GCM, 192);
    public static final SupportedCipherDetails INSTANCE_256_BIT = AesCipherDetailsFactory.buildWith(AesCipherDetailsFactory.CipherMode.GCM, 256);

    protected AesGcmCipherDetails(int keyLengthBits) {
        super(keyLengthBits, "AES/GCM/NoPadding", 16);
    }

    @Override
    public long getMaximumPlaintextSizeInBytes() {
        return 0xFFFFFFFE0L;
    }

    @Override
    public AlgorithmParameterSpec getEncryptionParameterSpec(byte[] iv) {
        Validate.notNull((Object)iv, (String)"Initialization vector must not be null", (Object[])new Object[0]);
        Validate.isTrue((iv.length == this.getIVLengthInBytes() ? 1 : 0) != 0, (String)"Initialization vector has the wrong byte count [%d] expected [%d] bytes", (Object[])new Object[]{iv.length, this.getIVLengthInBytes()});
        int tagSizeInBits = this.getAuthenticationTagOrHmacLengthInBytes() << 3;
        return new GCMParameterSpec(tagSizeInBits, iv);
    }

    @Override
    public long ciphertextSize(long plaintextSize) {
        Validate.inclusiveBetween((long)0L, (long)Long.MAX_VALUE, (long)plaintextSize);
        return plaintextSize + (long)this.getAuthenticationTagOrHmacLengthInBytes();
    }

    @Override
    public long plaintextSize(long ciphertextSize) {
        Validate.inclusiveBetween((long)0L, (long)Long.MAX_VALUE, (long)ciphertextSize);
        return ciphertextSize - (long)this.getAuthenticationTagOrHmacLengthInBytes();
    }

    @Override
    public boolean plaintextSizeCalculationIsAnEstimate() {
        return false;
    }

    @Override
    public ByteRangeConversion translateByteRange(long startInclusive, long endInclusive) {
        throw new UnsupportedOperationException("Not implemented yet");
    }

    @Override
    public long updateCipherToPosition(Cipher cipher, long position) {
        throw new UnsupportedOperationException("Not implemented yet");
    }

    @Override
    public boolean supportsRandomAccess() {
        return false;
    }
}

