/*
 * Decompiled with CFR 0.152.
 */
package com.joyent.manta.client.crypto;

import com.joyent.manta.client.crypto.EncryptionContext;
import com.joyent.manta.client.crypto.SupportedCipherDetails;
import com.joyent.manta.util.HmacOutputStream;
import java.io.OutputStream;
import javax.crypto.Cipher;
import org.apache.commons.io.output.CloseShieldOutputStream;
import org.apache.commons.lang3.Validate;
import org.bouncycastle.crypto.CipherParameters;
import org.bouncycastle.crypto.macs.HMac;
import org.bouncycastle.crypto.params.KeyParameter;
import org.bouncycastle.jcajce.io.CipherOutputStream;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public final class EncryptingEntityHelper {
    private static final Logger LOGGER = LoggerFactory.getLogger(EncryptingEntityHelper.class);

    private EncryptingEntityHelper() {
    }

    public static OutputStream makeCipherOutputForStream(OutputStream httpOut, EncryptionContext encryptionContext) {
        HMac hmac;
        if (encryptionContext.getCipherDetails().isAEADCipher()) {
            hmac = null;
        } else {
            hmac = encryptionContext.getCipherDetails().getAuthenticationHmac();
            Validate.notNull((Object)encryptionContext.getSecretKey(), (String)"Secret key must not be null", (Object[])new Object[0]);
            hmac.init((CipherParameters)new KeyParameter(encryptionContext.getSecretKey().getEncoded()));
            byte[] iv = encryptionContext.getCipher().getIV();
            hmac.update(iv, 0, iv.length);
        }
        return EncryptingEntityHelper.makeCipherOutputForStream(httpOut, encryptionContext.getCipherDetails(), encryptionContext.getCipher(), hmac);
    }

    public static OutputStream makeCipherOutputForStream(OutputStream httpOut, EncryptionContext encryptionContext, HMac hmac) {
        return EncryptingEntityHelper.makeCipherOutputForStream(httpOut, encryptionContext.getCipherDetails(), encryptionContext.getCipher(), hmac);
    }

    public static OutputStream makeCipherOutputForStream(OutputStream httpOut, SupportedCipherDetails cipherDetails, Cipher cipher, HMac hmac) {
        CloseShieldOutputStream noCloseOut = new CloseShieldOutputStream(httpOut);
        CipherOutputStream cipherOut = new CipherOutputStream((OutputStream)noCloseOut, cipher);
        Validate.notNull((Object)cipherDetails, (String)"Cipher details must not be null", (Object[])new Object[0]);
        Validate.notNull((Object)cipher, (String)"Cipher must not be null", (Object[])new Object[0]);
        Object out = cipherDetails.isAEADCipher() ? cipherOut : new HmacOutputStream(hmac, (OutputStream)cipherOut);
        if (LOGGER.isTraceEnabled()) {
            LOGGER.trace("Creating new OutputStream for multipart [{}]", out.getClass());
        }
        return out;
    }
}

