/*
 * Decompiled with CFR 0.152.
 */
package ch.cyberduck.core.b2;

import ch.cyberduck.core.AbstractPath;
import ch.cyberduck.core.Acl;
import ch.cyberduck.core.ConnectionCallback;
import ch.cyberduck.core.DefaultIOExceptionMappingService;
import ch.cyberduck.core.DisabledConnectionCallback;
import ch.cyberduck.core.Path;
import ch.cyberduck.core.PathAttributes;
import ch.cyberduck.core.PathContainerService;
import ch.cyberduck.core.b2.B2AttributesFinderFeature;
import ch.cyberduck.core.b2.B2ExceptionMappingService;
import ch.cyberduck.core.b2.B2FileidProvider;
import ch.cyberduck.core.b2.B2PathContainerService;
import ch.cyberduck.core.b2.B2Session;
import ch.cyberduck.core.b2.B2WriteFeature;
import ch.cyberduck.core.exception.BackgroundException;
import ch.cyberduck.core.features.Directory;
import ch.cyberduck.core.features.Write;
import ch.cyberduck.core.io.DefaultStreamCloser;
import ch.cyberduck.core.io.StatusOutputStream;
import ch.cyberduck.core.preferences.PreferencesFactory;
import ch.cyberduck.core.transfer.TransferStatus;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.util.EnumSet;
import org.apache.commons.io.input.NullInputStream;
import org.apache.commons.lang3.StringUtils;
import synapticloop.b2.B2ApiClient;
import synapticloop.b2.BucketType;
import synapticloop.b2.exception.B2ApiException;
import synapticloop.b2.response.B2BucketResponse;
import synapticloop.b2.response.B2FileResponse;
import synapticloop.b2.response.BaseB2Response;

public class B2DirectoryFeature
implements Directory<BaseB2Response> {
    private final PathContainerService containerService = new B2PathContainerService();
    private final B2Session session;
    private final B2FileidProvider fileid;
    private Write<BaseB2Response> writer;

    public B2DirectoryFeature(B2Session session, B2FileidProvider fileid) {
        this(session, fileid, new B2WriteFeature(session, fileid));
    }

    public B2DirectoryFeature(B2Session session, B2FileidProvider fileid, B2WriteFeature writer) {
        this.session = session;
        this.fileid = fileid;
        this.writer = writer;
    }

    public Path mkdir(Path folder, String region, TransferStatus status) throws BackgroundException {
        try {
            if (this.containerService.isContainer(folder)) {
                B2BucketResponse response = ((B2ApiClient)this.session.getClient()).createBucket(this.containerService.getContainer(folder).getName(), null == region ? BucketType.valueOf((String)PreferencesFactory.get().getProperty("b2.bucket.acl.default")) : BucketType.valueOf((String)region));
                switch (response.getBucketType()) {
                    case allPublic: {
                        folder.attributes().setAcl(new Acl((Acl.User)new Acl.GroupUser("AllUsers", false), new Acl.Role[]{new Acl.Role("READ")}));
                    }
                }
                return new Path(folder.getParent(), folder.getName(), folder.getType(), new PathAttributes(folder.attributes()));
            }
            status.setChecksum(this.writer.checksum(folder, status).compute((InputStream)new NullInputStream(0L), status));
            status.setMime("application/octet-stream");
            StatusOutputStream out = this.writer.write(folder, status, (ConnectionCallback)new DisabledConnectionCallback());
            new DefaultStreamCloser().close((OutputStream)out);
            EnumSet<AbstractPath.Type> type = EnumSet.copyOf(folder.getType());
            type.add(AbstractPath.Type.placeholder);
            return new Path(folder.getParent(), folder.getName(), type, new B2AttributesFinderFeature(this.session, this.fileid).toAttributes((B2FileResponse)out.getStatus()));
        }
        catch (B2ApiException e) {
            throw new B2ExceptionMappingService().map("Cannot create folder {0}", e, folder);
        }
        catch (IOException e) {
            throw new DefaultIOExceptionMappingService().map(e);
        }
    }

    public boolean isSupported(Path workdir, String name) {
        if (workdir.isRoot() && StringUtils.isNotBlank((CharSequence)name)) {
            if (StringUtils.startsWith((CharSequence)name, (CharSequence)"b2-")) {
                return false;
            }
            if (StringUtils.length((CharSequence)name) > 50) {
                return false;
            }
            if (StringUtils.length((CharSequence)name) < 6) {
                return false;
            }
            return StringUtils.isAlphanumeric((CharSequence)StringUtils.removeAll((String)name, (String)"-"));
        }
        return true;
    }

    public B2DirectoryFeature withWriter(Write<BaseB2Response> writer) {
        this.writer = writer;
        return this;
    }
}

