/*
 * Decompiled with CFR 0.152.
 */
package ch.cyberduck.core.b2;

import ch.cyberduck.core.ConnectionCallback;
import ch.cyberduck.core.PasswordCallback;
import ch.cyberduck.core.Path;
import ch.cyberduck.core.PathContainerService;
import ch.cyberduck.core.b2.B2DeleteFeature;
import ch.cyberduck.core.b2.B2FileidProvider;
import ch.cyberduck.core.b2.B2PathContainerService;
import ch.cyberduck.core.b2.B2Session;
import ch.cyberduck.core.b2.B2ThresholdCopyFeature;
import ch.cyberduck.core.exception.BackgroundException;
import ch.cyberduck.core.features.Delete;
import ch.cyberduck.core.features.Move;
import ch.cyberduck.core.transfer.TransferStatus;
import java.util.Collections;

public class B2MoveFeature
implements Move {
    private final PathContainerService containerService = new B2PathContainerService();
    private final B2Session session;
    private final B2FileidProvider fileid;
    private final B2ThresholdCopyFeature proxy;

    public B2MoveFeature(B2Session session, B2FileidProvider fileid) {
        this.session = session;
        this.fileid = fileid;
        this.proxy = new B2ThresholdCopyFeature(session, fileid);
    }

    public Path move(Path source, Path target, TransferStatus status, Delete.Callback delete, ConnectionCallback callback) throws BackgroundException {
        Path copy = this.proxy.copy(source, target, status.length(source.attributes().getSize()), callback);
        new B2DeleteFeature(this.session, this.fileid).delete(Collections.singletonList(new Path(source)), (PasswordCallback)callback, delete);
        return copy;
    }

    public boolean isSupported(Path source, Path target) {
        if (!this.containerService.isContainer(source)) {
            return this.proxy.isSupported(source, target);
        }
        return false;
    }

    public boolean isRecursive(Path source, Path target) {
        return this.proxy.isRecursive(source, target);
    }
}

