//go:build go1.18
// +build go1.18

// Copyright (c) Microsoft Corporation. All rights reserved.
// Licensed under the MIT License. See License.txt in the project root for license information.
// Code generated by Microsoft (R) AutoRest Code Generator. DO NOT EDIT.
// Changes may cause incorrect behavior and will be lost if the code is regenerated.

package azopenai

import (
	"time"
)

// AudioTranscription - Result information for an operation that transcribed spoken audio into written text.
type AudioTranscription struct {
	// REQUIRED; The transcribed text for the provided audio data.
	Text *string

	// The total duration of the audio processed to produce accompanying transcription information.
	Duration *float32

	// The spoken language that was detected in the transcribed audio data. This is expressed as a two-letter ISO-639-1 language
	// code like 'en' or 'fr'.
	Language *string

	// A collection of information about the timing, probabilities, and other detail of each processed audio segment.
	Segments []AudioTranscriptionSegment

	// The label that describes which operation type generated the accompanying response data.
	Task *AudioTaskLabel

	// A collection of information about the timing of each processed word.
	Words []AudioTranscriptionWord
}

// AudioTranscriptionOptions - The configuration information for an audio transcription request.
type AudioTranscriptionOptions struct {
	// REQUIRED; The audio data to transcribe. This must be the binary content of a file in one of the supported media formats:
	// flac, mp3, mp4, mpeg, mpga, m4a, ogg, wav, webm.
	File []byte

	// The optional filename or descriptive identifier to associate with with the audio data.
	Filename *string

	// The primary spoken language of the audio data to be transcribed, supplied as a two-letter ISO-639-1 language code such
	// as 'en' or 'fr'. Providing this known input language is optional but may improve
	// the accuracy and/or latency of transcription.
	Language *string

	// The model to use for this transcription request.
	DeploymentName *string

	// An optional hint to guide the model's style or continue from a prior audio segment. The written language of the prompt
	// should match the primary spoken language of the audio data.
	Prompt *string

	// The requested format of the transcription response data, which will influence the content and detail of the result.
	ResponseFormat *AudioTranscriptionFormat

	// The sampling temperature, between 0 and 1. Higher values like 0.8 will make the output more random, while lower values
	// like 0.2 will make it more focused and deterministic. If set to 0, the model will
	// use log probability to automatically increase the temperature until certain thresholds are hit.
	Temperature *float32

	// The timestamp granularities to populate for this transcription.response_format must be set verbose_json to use timestamp
	// granularities. Either or both of these options are supported: word, or segment.
	// Note: There is no additional latency for segment timestamps, but generating word timestamps incurs additional latency.
	TimestampGranularities []AudioTranscriptionTimestampGranularity
}

// AudioTranscriptionSegment - Extended information about a single segment of transcribed audio data. Segments generally represent
// roughly 5-10 seconds of speech. Segment boundaries typically occur between words but not necessarily
// sentences.
type AudioTranscriptionSegment struct {
	// REQUIRED; The average log probability associated with this audio segment.
	AvgLogProb *float32

	// REQUIRED; The compression ratio of this audio segment.
	CompressionRatio *float32

	// REQUIRED; The time at which this segment ended relative to the beginning of the transcribed audio.
	End *float32

	// REQUIRED; The 0-based index of this segment within a transcription.
	ID *int32

	// REQUIRED; The probability of no speech detection within this audio segment.
	NoSpeechProb *float32

	// REQUIRED; The seek position associated with the processing of this audio segment. Seek positions are expressed as hundredths
	// of seconds. The model may process several segments from a single seek position, so
	// while the seek position will never represent a later time than the segment's start, the segment's start may represent a
	// significantly later time than the segment's associated seek position.
	Seek *int32

	// REQUIRED; The time at which this segment started relative to the beginning of the transcribed audio.
	Start *float32

	// REQUIRED; The temperature score associated with this audio segment.
	Temperature *float32

	// REQUIRED; The transcribed text that was part of this audio segment.
	Text *string

	// REQUIRED; The token IDs matching the transcribed text in this audio segment.
	Tokens []int32
}

// AudioTranscriptionWord - Extended information about a single transcribed word, as provided on responses when the 'word'
// timestamp granularity is provided.
type AudioTranscriptionWord struct {
	// REQUIRED; The end time of the word relative to the beginning of the audio, expressed in seconds.
	End *float32

	// REQUIRED; The start time of the word relative to the beginning of the audio, expressed in seconds.
	Start *float32

	// REQUIRED; The textual content of the word.
	Word *string
}

// AudioTranslation - Result information for an operation that translated spoken audio into written text.
type AudioTranslation struct {
	// REQUIRED; The translated text for the provided audio data.
	Text *string

	// The total duration of the audio processed to produce accompanying translation information.
	Duration *float32

	// The spoken language that was detected in the translated audio data. This is expressed as a two-letter ISO-639-1 language
	// code like 'en' or 'fr'.
	Language *string

	// A collection of information about the timing, probabilities, and other detail of each processed audio segment.
	Segments []AudioTranslationSegment

	// The label that describes which operation type generated the accompanying response data.
	Task *AudioTaskLabel
}

// AudioTranslationOptions - The configuration information for an audio translation request.
type AudioTranslationOptions struct {
	// REQUIRED; The audio data to translate. This must be the binary content of a file in one of the supported media formats:
	// flac, mp3, mp4, mpeg, mpga, m4a, ogg, wav, webm.
	File []byte

	// The optional filename or descriptive identifier to associate with with the audio data.
	Filename *string

	// The model to use for this translation request.
	DeploymentName *string

	// An optional hint to guide the model's style or continue from a prior audio segment. The written language of the prompt
	// should match the primary spoken language of the audio data.
	Prompt *string

	// The requested format of the translation response data, which will influence the content and detail of the result.
	ResponseFormat *AudioTranslationFormat

	// The sampling temperature, between 0 and 1. Higher values like 0.8 will make the output more random, while lower values
	// like 0.2 will make it more focused and deterministic. If set to 0, the model will
	// use log probability to automatically increase the temperature until certain thresholds are hit.
	Temperature *float32
}

// AudioTranslationSegment - Extended information about a single segment of translated audio data. Segments generally represent
// roughly 5-10 seconds of speech. Segment boundaries typically occur between words but not necessarily
// sentences.
type AudioTranslationSegment struct {
	// REQUIRED; The average log probability associated with this audio segment.
	AvgLogProb *float32

	// REQUIRED; The compression ratio of this audio segment.
	CompressionRatio *float32

	// REQUIRED; The time at which this segment ended relative to the beginning of the translated audio.
	End *float32

	// REQUIRED; The 0-based index of this segment within a translation.
	ID *int32

	// REQUIRED; The probability of no speech detection within this audio segment.
	NoSpeechProb *float32

	// REQUIRED; The seek position associated with the processing of this audio segment. Seek positions are expressed as hundredths
	// of seconds. The model may process several segments from a single seek position, so
	// while the seek position will never represent a later time than the segment's start, the segment's start may represent a
	// significantly later time than the segment's associated seek position.
	Seek *int32

	// REQUIRED; The time at which this segment started relative to the beginning of the translated audio.
	Start *float32

	// REQUIRED; The temperature score associated with this audio segment.
	Temperature *float32

	// REQUIRED; The translated text that was part of this audio segment.
	Text *string

	// REQUIRED; The token IDs matching the translated text in this audio segment.
	Tokens []int32
}

// AzureChatEnhancementConfiguration - A representation of the available Azure OpenAI enhancement configurations.
type AzureChatEnhancementConfiguration struct {
	// A representation of the available options for the Azure OpenAI grounding enhancement.
	Grounding *AzureChatGroundingEnhancementConfiguration

	// A representation of the available options for the Azure OpenAI optical character recognition (OCR) enhancement.
	Ocr *AzureChatOCREnhancementConfiguration
}

// AzureChatEnhancements - Represents the output results of Azure enhancements to chat completions, as configured via the
// matching input provided in the request.
type AzureChatEnhancements struct {
	// The grounding enhancement that returns the bounding box of the objects detected in the image.
	Grounding *AzureGroundingEnhancement
}

// AzureChatExtensionConfiguration - A representation of configuration data for a single Azure OpenAI chat extension. This
// will be used by a chat completions request that should use Azure OpenAI chat extensions to augment the response
// behavior. The use of this configuration is compatible only with Azure OpenAI.
type AzureChatExtensionConfiguration struct {
	// REQUIRED; The label for the type of an Azure chat extension. This typically corresponds to a matching Azure resource. Azure
	// chat extensions are only compatible with Azure OpenAI.
	configType *AzureChatExtensionType
}

// GetAzureChatExtensionConfiguration implements the AzureChatExtensionConfigurationClassification interface for type AzureChatExtensionConfiguration.
func (a *AzureChatExtensionConfiguration) GetAzureChatExtensionConfiguration() *AzureChatExtensionConfiguration {
	return a
}

// AzureChatExtensionDataSourceResponseCitation - A single instance of additional context information available when Azure
// OpenAI chat extensions are involved in the generation of a corresponding chat completions response. This context information
// is
// only populated when using an Azure OpenAI request configured to use a matching extension.
type AzureChatExtensionDataSourceResponseCitation struct {
	// REQUIRED; The content of the citation.
	Content *string

	// The chunk ID of the citation.
	ChunkID *string

	// The file path of the citation.
	Filepath *string

	// The title of the citation.
	Title *string

	// The URL of the citation.
	URL *string
}

// AzureChatExtensionsMessageContext - A representation of the additional context information available when Azure OpenAI
// chat extensions are involved in the generation of a corresponding chat completions response. This context information
// is only populated when using an Azure OpenAI request configured to use a matching extension.
type AzureChatExtensionsMessageContext struct {
	// The contextual information associated with the Azure chat extensions used for a chat completions request. These messages
	// describe the data source retrievals, plugin invocations, and other intermediate
	// steps taken in the course of generating a chat completions response that was augmented by capabilities from Azure OpenAI
	// chat extensions.
	Citations []AzureChatExtensionDataSourceResponseCitation

	// The detected intent from the chat history, used to pass to the next turn to carry over the context.
	Intent *string
}

// AzureChatGroundingEnhancementConfiguration - A representation of the available options for the Azure OpenAI grounding enhancement.
type AzureChatGroundingEnhancementConfiguration struct {
	// REQUIRED; Specifies whether the enhancement is enabled.
	Enabled *bool
}

// AzureChatOCREnhancementConfiguration - A representation of the available options for the Azure OpenAI optical character
// recognition (OCR) enhancement.
type AzureChatOCREnhancementConfiguration struct {
	// REQUIRED; Specifies whether the enhancement is enabled.
	Enabled *bool
}

// AzureCosmosDBChatExtensionConfiguration - A specific representation of configurable options for Azure Cosmos DB when using
// it as an Azure OpenAI chat extension.
type AzureCosmosDBChatExtensionConfiguration struct {
	// REQUIRED; The label for the type of an Azure chat extension. This typically corresponds to a matching Azure resource. Azure
	// chat extensions are only compatible with Azure OpenAI.
	configType *AzureChatExtensionType

	// REQUIRED; The parameters to use when configuring Azure OpenAI CosmosDB chat extensions.
	Parameters *AzureCosmosDBChatExtensionParameters
}

// GetAzureChatExtensionConfiguration implements the AzureChatExtensionConfigurationClassification interface for type AzureCosmosDBChatExtensionConfiguration.
func (a *AzureCosmosDBChatExtensionConfiguration) GetAzureChatExtensionConfiguration() *AzureChatExtensionConfiguration {
	return &AzureChatExtensionConfiguration{
		configType: a.configType,
	}
}

// AzureCosmosDBChatExtensionParameters - Parameters to use when configuring Azure OpenAI On Your Data chat extensions when
// using Azure Cosmos DB for MongoDB vCore. The supported authentication type is ConnectionString.
type AzureCosmosDBChatExtensionParameters struct {
	// REQUIRED; The name of the Azure Cosmos DB resource container.
	ContainerName *string

	// REQUIRED; The MongoDB vCore database name to use with Azure Cosmos DB.
	DatabaseName *string

	// REQUIRED; The embedding dependency for vector search.
	EmbeddingDependency OnYourDataVectorizationSourceClassification

	// REQUIRED; Customized field mapping behavior to use when interacting with the search index.
	FieldsMapping *AzureCosmosDBFieldMappingOptions

	// REQUIRED; The MongoDB vCore index name to use with Azure Cosmos DB.
	IndexName *string

	// The authentication method to use when accessing the defined data source. Each data source type supports a specific set
	// of available authentication methods; please see the documentation of the data
	// source for supported mechanisms. If not otherwise provided, On Your Data will attempt to use System Managed Identity (default
	// credential) authentication.
	Authentication OnYourDataAuthenticationOptionsClassification

	// Whether queries should be restricted to use of indexed data.
	InScope *bool

	// Give the model instructions about how it should behave and any context it should reference when generating a response.
	// You can describe the assistant's personality and tell it how to format responses.
	// There's a 100 token limit for it, and it counts against the overall token limit.
	RoleInformation *string

	// The configured strictness of the search relevance filtering. The higher of strictness, the higher of the precision but
	// lower recall of the answer.
	Strictness *int32

	// The configured top number of documents to feature for the configured query.
	TopNDocuments *int32
}

// AzureCosmosDBFieldMappingOptions - Optional settings to control how fields are processed when using a configured Azure
// Cosmos DB resource.
type AzureCosmosDBFieldMappingOptions struct {
	// REQUIRED; The names of index fields that should be treated as content.
	ContentFields []string

	// REQUIRED; The names of fields that represent vector data.
	VectorFields []string

	// The separator pattern that content fields should use.
	ContentFieldsSeparator *string

	// The name of the index field to use as a filepath.
	FilepathField *string

	// The name of the index field to use as a title.
	TitleField *string

	// The name of the index field to use as a URL.
	URLField *string
}

// AzureGroundingEnhancement - The grounding enhancement that returns the bounding box of the objects detected in the image.
type AzureGroundingEnhancement struct {
	// REQUIRED; The lines of text detected by the grounding enhancement.
	Lines []AzureGroundingEnhancementLine
}

// AzureGroundingEnhancementCoordinatePoint - A representation of a single polygon point as used by the Azure grounding enhancement.
type AzureGroundingEnhancementCoordinatePoint struct {
	// REQUIRED; The x-coordinate (horizontal axis) of the point.
	X *float32

	// REQUIRED; The y-coordinate (vertical axis) of the point.
	Y *float32
}

// AzureGroundingEnhancementLine - A content line object consisting of an adjacent sequence of content elements, such as words
// and selection marks.
type AzureGroundingEnhancementLine struct {
	// REQUIRED; An array of spans that represent detected objects and its bounding box information.
	Spans []AzureGroundingEnhancementLineSpan

	// REQUIRED; The text within the line.
	Text *string
}

// AzureGroundingEnhancementLineSpan - A span object that represents a detected object and its bounding box information.
type AzureGroundingEnhancementLineSpan struct {
	// REQUIRED; The length of the span in characters, measured in Unicode codepoints.
	Length *int32

	// REQUIRED; The character offset within the text where the span begins. This offset is defined as the position of the first
	// character of the span, counting from the start of the text as Unicode codepoints.
	Offset *int32

	// REQUIRED; An array of objects representing points in the polygon that encloses the detected object.
	Polygon []AzureGroundingEnhancementCoordinatePoint

	// REQUIRED; The text content of the span that represents the detected object.
	Text *string
}

// AzureMachineLearningIndexChatExtensionConfiguration - A specific representation of configurable options for Azure Machine
// Learning vector index when using it as an Azure OpenAI chat extension.
type AzureMachineLearningIndexChatExtensionConfiguration struct {
	// REQUIRED; The label for the type of an Azure chat extension. This typically corresponds to a matching Azure resource. Azure
	// chat extensions are only compatible with Azure OpenAI.
	configType *AzureChatExtensionType

	// REQUIRED; The parameters for the Azure Machine Learning vector index chat extension.
	Parameters *AzureMachineLearningIndexChatExtensionParameters
}

// GetAzureChatExtensionConfiguration implements the AzureChatExtensionConfigurationClassification interface for type AzureMachineLearningIndexChatExtensionConfiguration.
func (a *AzureMachineLearningIndexChatExtensionConfiguration) GetAzureChatExtensionConfiguration() *AzureChatExtensionConfiguration {
	return &AzureChatExtensionConfiguration{
		configType: a.configType,
	}
}

// AzureMachineLearningIndexChatExtensionParameters - Parameters for the Azure Machine Learning vector index chat extension.
// The supported authentication types are AccessToken, SystemAssignedManagedIdentity and UserAssignedManagedIdentity.
type AzureMachineLearningIndexChatExtensionParameters struct {
	// REQUIRED; The Azure Machine Learning vector index name.
	Name *string

	// REQUIRED; The resource ID of the Azure Machine Learning project.
	ProjectResourceID *string

	// REQUIRED; The version of the Azure Machine Learning vector index.
	Version *string

	// The authentication method to use when accessing the defined data source. Each data source type supports a specific set
	// of available authentication methods; please see the documentation of the data
	// source for supported mechanisms. If not otherwise provided, On Your Data will attempt to use System Managed Identity (default
	// credential) authentication.
	Authentication OnYourDataAuthenticationOptionsClassification

	// Search filter. Only supported if the Azure Machine Learning vector index is of type AzureSearch.
	Filter *string

	// Whether queries should be restricted to use of indexed data.
	InScope *bool

	// Give the model instructions about how it should behave and any context it should reference when generating a response.
	// You can describe the assistant's personality and tell it how to format responses.
	// There's a 100 token limit for it, and it counts against the overall token limit.
	RoleInformation *string

	// The configured strictness of the search relevance filtering. The higher of strictness, the higher of the precision but
	// lower recall of the answer.
	Strictness *int32

	// The configured top number of documents to feature for the configured query.
	TopNDocuments *int32
}

// AzureSearchChatExtensionConfiguration - A specific representation of configurable options for Azure Search when using it
// as an Azure OpenAI chat extension.
type AzureSearchChatExtensionConfiguration struct {
	// REQUIRED; The label for the type of an Azure chat extension. This typically corresponds to a matching Azure resource. Azure
	// chat extensions are only compatible with Azure OpenAI.
	configType *AzureChatExtensionType

	// REQUIRED; The parameters to use when configuring Azure Search.
	Parameters *AzureSearchChatExtensionParameters
}

// GetAzureChatExtensionConfiguration implements the AzureChatExtensionConfigurationClassification interface for type AzureSearchChatExtensionConfiguration.
func (a *AzureSearchChatExtensionConfiguration) GetAzureChatExtensionConfiguration() *AzureChatExtensionConfiguration {
	return &AzureChatExtensionConfiguration{
		configType: a.configType,
	}
}

// AzureSearchChatExtensionParameters - Parameters for Azure Cognitive Search when used as an Azure OpenAI chat extension.
// The supported authentication types are APIKey, SystemAssignedManagedIdentity and UserAssignedManagedIdentity.
type AzureSearchChatExtensionParameters struct {
	// REQUIRED; The absolute endpoint path for the Azure Cognitive Search resource to use.
	Endpoint *string

	// REQUIRED; The name of the index to use as available in the referenced Azure Cognitive Search resource.
	IndexName *string

	// The authentication method to use when accessing the defined data source. Each data source type supports a specific set
	// of available authentication methods; please see the documentation of the data
	// source for supported mechanisms. If not otherwise provided, On Your Data will attempt to use System Managed Identity (default
	// credential) authentication.
	Authentication OnYourDataAuthenticationOptionsClassification

	// The embedding dependency for vector search.
	EmbeddingDependency OnYourDataVectorizationSourceClassification

	// Customized field mapping behavior to use when interacting with the search index.
	FieldsMapping *AzureSearchIndexFieldMappingOptions

	// Search filter.
	Filter *string

	// Whether queries should be restricted to use of indexed data.
	InScope *bool

	// The query type to use with Azure Cognitive Search.
	QueryType *AzureSearchQueryType

	// Give the model instructions about how it should behave and any context it should reference when generating a response.
	// You can describe the assistant's personality and tell it how to format responses.
	// There's a 100 token limit for it, and it counts against the overall token limit.
	RoleInformation *string

	// The additional semantic configuration for the query.
	SemanticConfiguration *string

	// The configured strictness of the search relevance filtering. The higher of strictness, the higher of the precision but
	// lower recall of the answer.
	Strictness *int32

	// The configured top number of documents to feature for the configured query.
	TopNDocuments *int32
}

// AzureSearchIndexFieldMappingOptions - Optional settings to control how fields are processed when using a configured Azure
// Search resource.
type AzureSearchIndexFieldMappingOptions struct {
	// The names of index fields that should be treated as content.
	ContentFields []string

	// The separator pattern that content fields should use.
	ContentFieldsSeparator *string

	// The name of the index field to use as a filepath.
	FilepathField *string

	// The names of fields that represent image vector data.
	ImageVectorFields []string

	// The name of the index field to use as a title.
	TitleField *string

	// The name of the index field to use as a URL.
	URLField *string

	// The names of fields that represent vector data.
	VectorFields []string
}

// ChatChoice - The representation of a single prompt completion as part of an overall chat completions request. Generally,
// n choices are generated per provided prompt with a default value of 1. Token limits and
// other settings may limit the number of choices generated.
type ChatChoice struct {
	// REQUIRED; The reason that this chat completions choice completed its generated.
	FinishReason *CompletionsFinishReason

	// REQUIRED; The ordered index associated with this chat completions choice.
	Index *int32

	// REQUIRED; The log probability information for this choice, as enabled via the 'logprobs' request option.
	LogProbs *ChatChoiceLogProbs

	// Information about the content filtering category (hate, sexual, violence, selfharm), if it has been detected, as well as
	// the severity level (verylow, low, medium, high-scale that determines the
	// intensity and risk level of harmful content) and if it has been filtered or not.
	ContentFilterResults *ContentFilterResultsForChoice

	// The delta message content for a streaming response.
	Delta *ChatResponseMessage

	// Represents the output results of Azure OpenAI enhancements to chat completions, as configured via the matching input provided
	// in the request. This supplementary information is only available when
	// using Azure OpenAI and only when the request is configured to use enhancements.
	Enhancements *AzureChatEnhancements

	// The reason the model stopped generating tokens, together with any applicable details. This structured representation replaces
	// 'finish_reason' for some models.
	FinishDetails ChatFinishDetailsClassification

	// The chat message for a given chat completions prompt.
	Message *ChatResponseMessage
}

// ChatChoiceLogProbabilityInfo - Log probability information for a choice, as requested via 'logprobs' and 'top_logprobs'.
type ChatChoiceLogProbabilityInfo struct {
	// REQUIRED; The list of log probability information entries for the choice's message content tokens, as requested via the
	// 'logprobs' option.
	Content []ChatTokenLogProbabilityResult
}

// ChatChoiceLogProbs - The log probability information for this choice, as enabled via the 'logprobs' request option.
type ChatChoiceLogProbs struct {
	// REQUIRED; The list of log probability information entries for the choice's message content tokens, as requested via the
	// 'logprobs' option.
	Content []ChatTokenLogProbabilityResult
}

// ChatCompletionRequestMessageContentPart - represents either an image URL or text content for a prompt
type ChatCompletionRequestMessageContentPart struct {
	// REQUIRED; The type of the content part.
	partType *ChatCompletionRequestMessageContentPartType
}

// GetChatCompletionRequestMessageContentPart implements the ChatCompletionRequestMessageContentPartClassification interface
// for type ChatCompletionRequestMessageContentPart.
func (c *ChatCompletionRequestMessageContentPart) GetChatCompletionRequestMessageContentPart() *ChatCompletionRequestMessageContentPart {
	return c
}

// ChatCompletionRequestMessageContentPartImage - represents an image URL, to be used as part of a prompt
type ChatCompletionRequestMessageContentPartImage struct {
	// REQUIRED; The type of the content part.
	partType *ChatCompletionRequestMessageContentPartType

	// REQUIRED; contains the URL and level of detail for an image prompt
	ImageURL *ChatCompletionRequestMessageContentPartImageURL
}

// GetChatCompletionRequestMessageContentPart implements the ChatCompletionRequestMessageContentPartClassification interface
// for type ChatCompletionRequestMessageContentPartImage.
func (c *ChatCompletionRequestMessageContentPartImage) GetChatCompletionRequestMessageContentPart() *ChatCompletionRequestMessageContentPart {
	return &ChatCompletionRequestMessageContentPart{
		partType: c.partType,
	}
}

// ChatCompletionRequestMessageContentPartImageURL - contains the URL and level of detail for an image prompt
type ChatCompletionRequestMessageContentPartImageURL struct {
	// REQUIRED; Either a URL of the image or the base64 encoded image data.
	URL *string

	// Specifies the detail level of the image. Learn more in the Vision guide [/docs/guides/vision/low-or-high-fidelity-image-understanding].
	Detail *ChatCompletionRequestMessageContentPartImageURLDetail
}

// ChatCompletionRequestMessageContentPartText - represents text content, to be used as part of a prompt
type ChatCompletionRequestMessageContentPartText struct {
	// REQUIRED; The type of the content part.
	partType *ChatCompletionRequestMessageContentPartType

	// REQUIRED; The text content.
	Text *string
}

// GetChatCompletionRequestMessageContentPart implements the ChatCompletionRequestMessageContentPartClassification interface
// for type ChatCompletionRequestMessageContentPartText.
func (c *ChatCompletionRequestMessageContentPartText) GetChatCompletionRequestMessageContentPart() *ChatCompletionRequestMessageContentPart {
	return &ChatCompletionRequestMessageContentPart{
		partType: c.partType,
	}
}

// ChatCompletions - Representation of the response data from a chat completions request. Completions support a wide variety
// of tasks and generate text that continues from or "completes" provided prompt data.
type ChatCompletions struct {
	// REQUIRED; The collection of completions choices associated with this completions response. Generally, n choices are generated
	// per provided prompt with a default value of 1. Token limits and other settings may
	// limit the number of choices generated.
	Choices []ChatChoice

	// REQUIRED; The first timestamp associated with generation activity for this completions response, represented as seconds
	// since the beginning of the Unix epoch of 00:00 on 1 Jan 1970.
	Created *time.Time

	// REQUIRED; A unique identifier associated with this chat completions response.
	ID *string

	// REQUIRED; Usage information for tokens processed and generated as part of this completions operation.
	// NOTE: This field is not available when using [Client.GetChatCompletionsStream].
	Usage *CompletionsUsage

	// The model name used for this completions request.
	Model *string

	// Content filtering results for zero or more prompts in the request. In a streaming request, results for different prompts
	// may arrive at different times or in different orders.
	PromptFilterResults []ContentFilterResultsForPrompt

	// Can be used in conjunction with the seed request parameter to understand when backend changes have been made that might
	// impact determinism.
	SystemFingerprint *string
}

// ChatCompletionsFunctionToolCall - A tool call to a function tool, issued by the model in evaluation of a configured function
// tool, that represents a function invocation needed for a subsequent chat completions request to resolve.
type ChatCompletionsFunctionToolCall struct {
	// REQUIRED; The details of the function invocation requested by the tool call.
	Function *FunctionCall

	// REQUIRED; The ID of the tool call.
	ID *string

	// REQUIRED; The object type.
	Type *string
}

// GetChatCompletionsToolCall implements the ChatCompletionsToolCallClassification interface for type ChatCompletionsFunctionToolCall.
func (c *ChatCompletionsFunctionToolCall) GetChatCompletionsToolCall() *ChatCompletionsToolCall {
	return &ChatCompletionsToolCall{
		ID:   c.ID,
		Type: c.Type,
	}
}

// ChatCompletionsFunctionToolDefinition - The definition information for a chat completions function tool that can call a
// function in response to a tool call.
type ChatCompletionsFunctionToolDefinition struct {
	// REQUIRED; The function definition details for the function tool.
	Function *FunctionDefinition

	// REQUIRED; The object type.
	Type *string
}

// GetChatCompletionsToolDefinition implements the ChatCompletionsToolDefinitionClassification interface for type ChatCompletionsFunctionToolDefinition.
func (c *ChatCompletionsFunctionToolDefinition) GetChatCompletionsToolDefinition() *ChatCompletionsToolDefinition {
	return &ChatCompletionsToolDefinition{
		Type: c.Type,
	}
}

// ChatCompletionsFunctionToolSelection - A tool selection of a specific, named function tool that will limit chat completions
// to using the named function.
type ChatCompletionsFunctionToolSelection struct {
	// REQUIRED; The name of the function that should be called.
	Name *string
}

// ChatCompletionsJSONResponseFormat - A response format for Chat Completions that restricts responses to emitting valid JSON
// objects.
type ChatCompletionsJSONResponseFormat struct {
	// REQUIRED; The discriminated type for the response format.
	respType *string
}

// GetChatCompletionsResponseFormat implements the ChatCompletionsResponseFormatClassification interface for type ChatCompletionsJSONResponseFormat.
func (c *ChatCompletionsJSONResponseFormat) GetChatCompletionsResponseFormat() *ChatCompletionsResponseFormat {
	return &ChatCompletionsResponseFormat{
		respType: c.respType,
	}
}

// ChatCompletionsNamedFunctionToolSelection - A tool selection of a specific, named function tool that will limit chat completions
// to using the named function.
type ChatCompletionsNamedFunctionToolSelection struct {
	// REQUIRED; The function that should be called.
	Function *ChatCompletionsFunctionToolSelection

	// REQUIRED; The object type.
	Type *string
}

// GetChatCompletionsNamedToolSelection implements the ChatCompletionsNamedToolSelectionClassification interface for type
// ChatCompletionsNamedFunctionToolSelection.
func (c *ChatCompletionsNamedFunctionToolSelection) GetChatCompletionsNamedToolSelection() *ChatCompletionsNamedToolSelection {
	return &ChatCompletionsNamedToolSelection{
		Type: c.Type,
	}
}

// ChatCompletionsNamedToolSelection - An abstract representation of an explicit, named tool selection to use for a chat completions
// request.
type ChatCompletionsNamedToolSelection struct {
	// REQUIRED; The object type.
	Type *string
}

// GetChatCompletionsNamedToolSelection implements the ChatCompletionsNamedToolSelectionClassification interface for type
// ChatCompletionsNamedToolSelection.
func (c *ChatCompletionsNamedToolSelection) GetChatCompletionsNamedToolSelection() *ChatCompletionsNamedToolSelection {
	return c
}

// ChatCompletionsOptions - The configuration information for a chat completions request. Completions support a wide variety
// of tasks and generate text that continues from or "completes" provided prompt data.
type ChatCompletionsOptions struct {
	// REQUIRED; The collection of context messages associated with this chat completions request. Typical usage begins with a
	// chat message for the System role that provides instructions for the behavior of the
	// assistant, followed by alternating messages between the User and Assistant roles.
	Messages []ChatRequestMessageClassification

	// The configuration entries for Azure OpenAI chat extensions that use them. This additional specification is only compatible
	// with Azure OpenAI.
	AzureExtensionsOptions []AzureChatExtensionConfigurationClassification

	// If provided, the configuration options for available Azure OpenAI chat enhancements.
	Enhancements *AzureChatEnhancementConfiguration

	// A value that influences the probability of generated tokens appearing based on their cumulative frequency in generated
	// text. Positive values will make tokens less likely to appear as their frequency
	// increases and decrease the likelihood of the model repeating the same statements verbatim.
	FrequencyPenalty *float32

	// Controls how the model responds to function calls. "none" means the model does not call a function, and responds to the
	// end-user. "auto" means the model can pick between an end-user or calling a
	// function. Specifying a particular function via {"name": "my_function"} forces the model to call that function. "none" is
	// the default when no functions are present. "auto" is the default if functions
	// are present.
	FunctionCall *ChatCompletionsOptionsFunctionCall

	// A list of functions the model may generate JSON inputs for.
	Functions []FunctionDefinition

	// A map between GPT token IDs and bias scores that influences the probability of specific tokens appearing in a completions
	// response. Token IDs are computed via external tokenizer tools, while bias
	// scores reside in the range of -100 to 100 with minimum and maximum values corresponding to a full ban or exclusive selection
	// of a token, respectively. The exact behavior of a given bias score varies
	// by model.
	LogitBias map[string]*int32

	// Whether to return log probabilities of the output tokens or not. If true, returns the log probabilities of each output
	// token returned in the content of message. This option is currently not available
	// on the gpt-4-vision-preview model.
	LogProbs *bool

	// The maximum number of tokens to generate.
	MaxTokens *int32

	// The model name to provide as part of this completions request. Not applicable to Azure OpenAI, where deployment information
	// should be included in the Azure resource URI that's connected to.
	DeploymentName *string

	// The number of chat completions choices that should be generated for a chat completions response. Because this setting can
	// generate many completions, it may quickly consume your token quota. Use
	// carefully and ensure reasonable settings for max_tokens and stop.
	N *int32

	// A value that influences the probability of generated tokens appearing based on their existing presence in generated text.
	// Positive values will make tokens less likely to appear when they already exist
	// and increase the model's likelihood to output new topics.
	PresencePenalty *float32

	// An object specifying the format that the model must output. Used to enable JSON mode.
	ResponseFormat ChatCompletionsResponseFormatClassification

	// If specified, the system will make a best effort to sample deterministically such that repeated requests with the same
	// seed and parameters should return the same result. Determinism is not guaranteed,
	// and you should refer to the system_fingerprint response parameter to monitor changes in the backend."
	Seed *int64

	// A collection of textual sequences that will end completions generation.
	Stop []string

	// The sampling temperature to use that controls the apparent creativity of generated completions. Higher values will make
	// output more random while lower values will make results more focused and
	// deterministic. It is not recommended to modify temperature and top_p for the same completions request as the interaction
	// of these two settings is difficult to predict.
	Temperature *float32

	// If specified, the model will configure which of the provided tools it can use for the chat completions response.
	ToolChoice *ChatCompletionsToolChoice

	// The available tool definitions that the chat completions request can use, including caller-defined functions.
	Tools []ChatCompletionsToolDefinitionClassification

	// An integer between 0 and 5 specifying the number of most likely tokens to return at each token position, each with an associated
	// log probability. logprobs must be set to true if this parameter is
	// used.
	TopLogProbs *int32

	// An alternative to sampling with temperature called nucleus sampling. This value causes the model to consider the results
	// of tokens with the provided probability mass. As an example, a value of 0.15
	// will cause only the tokens comprising the top 15% of probability mass to be considered. It is not recommended to modify
	// temperature and top_p for the same completions request as the interaction of
	// these two settings is difficult to predict.
	TopP *float32

	// An identifier for the caller or end user of the operation. This may be used for tracking or rate-limiting purposes.
	User *string
}

// ChatCompletionsResponseFormat - An abstract representation of a response format configuration usable by Chat Completions.
// Can be used to enable JSON mode.
type ChatCompletionsResponseFormat struct {
	// REQUIRED; The discriminated type for the response format.
	respType *string
}

// GetChatCompletionsResponseFormat implements the ChatCompletionsResponseFormatClassification interface for type ChatCompletionsResponseFormat.
func (c *ChatCompletionsResponseFormat) GetChatCompletionsResponseFormat() *ChatCompletionsResponseFormat {
	return c
}

// ChatCompletionsTextResponseFormat - The standard Chat Completions response format that can freely generate text and is
// not guaranteed to produce response content that adheres to a specific schema.
type ChatCompletionsTextResponseFormat struct {
	// REQUIRED; The discriminated type for the response format.
	respType *string
}

// GetChatCompletionsResponseFormat implements the ChatCompletionsResponseFormatClassification interface for type ChatCompletionsTextResponseFormat.
func (c *ChatCompletionsTextResponseFormat) GetChatCompletionsResponseFormat() *ChatCompletionsResponseFormat {
	return &ChatCompletionsResponseFormat{
		respType: c.respType,
	}
}

// ChatCompletionsToolCall - An abstract representation of a tool call that must be resolved in a subsequent request to perform
// the requested chat completion.
type ChatCompletionsToolCall struct {
	// REQUIRED; The ID of the tool call.
	ID *string

	// REQUIRED; The object type.
	Type *string
}

// GetChatCompletionsToolCall implements the ChatCompletionsToolCallClassification interface for type ChatCompletionsToolCall.
func (c *ChatCompletionsToolCall) GetChatCompletionsToolCall() *ChatCompletionsToolCall { return c }

// ChatCompletionsToolDefinition - An abstract representation of a tool that can be used by the model to improve a chat completions
// response.
type ChatCompletionsToolDefinition struct {
	// REQUIRED; The object type.
	Type *string
}

// GetChatCompletionsToolDefinition implements the ChatCompletionsToolDefinitionClassification interface for type ChatCompletionsToolDefinition.
func (c *ChatCompletionsToolDefinition) GetChatCompletionsToolDefinition() *ChatCompletionsToolDefinition {
	return c
}

// ChatFinishDetails - An abstract representation of structured information about why a chat completions response terminated.
type ChatFinishDetails struct {
	// REQUIRED; The object type.
	Type *string
}

// GetChatFinishDetails implements the ChatFinishDetailsClassification interface for type ChatFinishDetails.
func (c *ChatFinishDetails) GetChatFinishDetails() *ChatFinishDetails { return c }

// ChatMessageContentItem - An abstract representation of a structured content item within a chat message.
type ChatMessageContentItem struct {
	// REQUIRED; The discriminated object type.
	Type *string
}

// GetChatMessageContentItem implements the ChatMessageContentItemClassification interface for type ChatMessageContentItem.
func (c *ChatMessageContentItem) GetChatMessageContentItem() *ChatMessageContentItem { return c }

// ChatMessageImageContentItem - A structured chat content item containing an image reference.
type ChatMessageImageContentItem struct {
	// REQUIRED; An internet location, which must be accessible to the model,from which the image may be retrieved.
	ImageURL *ChatMessageImageURL

	// REQUIRED; The discriminated object type.
	Type *string
}

// GetChatMessageContentItem implements the ChatMessageContentItemClassification interface for type ChatMessageImageContentItem.
func (c *ChatMessageImageContentItem) GetChatMessageContentItem() *ChatMessageContentItem {
	return &ChatMessageContentItem{
		Type: c.Type,
	}
}

// ChatMessageImageURL - An internet location from which the model may retrieve an image.
type ChatMessageImageURL struct {
	// REQUIRED; The URL of the image.
	URL *string

	// The evaluation quality setting to use, which controls relative prioritization of speed, token consumption, and accuracy.
	Detail *ChatMessageImageDetailLevel
}

// ChatMessageTextContentItem - A structured chat content item containing plain text.
type ChatMessageTextContentItem struct {
	// REQUIRED; The content of the message.
	Text *string

	// REQUIRED; The discriminated object type.
	Type *string
}

// GetChatMessageContentItem implements the ChatMessageContentItemClassification interface for type ChatMessageTextContentItem.
func (c *ChatMessageTextContentItem) GetChatMessageContentItem() *ChatMessageContentItem {
	return &ChatMessageContentItem{
		Type: c.Type,
	}
}

// ChatRequestAssistantMessage - A request chat message representing response or action from the assistant.
type ChatRequestAssistantMessage struct {
	// REQUIRED; The content of the message.
	Content *string

	// REQUIRED; The chat role associated with this message.
	role *ChatRole

	// The function call that must be resolved and have its output appended to subsequent input messages for the chat completions
	// request to resolve as configured.
	FunctionCall *FunctionCall

	// An optional name for the participant.
	Name *string

	// The tool calls that must be resolved and have their outputs appended to subsequent input messages for the chat completions
	// request to resolve as configured.
	ToolCalls []ChatCompletionsToolCallClassification
}

// GetChatRequestMessage implements the ChatRequestMessageClassification interface for type ChatRequestAssistantMessage.
func (c *ChatRequestAssistantMessage) GetChatRequestMessage() *ChatRequestMessage {
	return &ChatRequestMessage{
		role: c.role,
	}
}

// ChatRequestFunctionMessage - A request chat message representing requested output from a configured function.
type ChatRequestFunctionMessage struct {
	// REQUIRED; The output of the function as requested by the function call.
	Content *string

	// REQUIRED; The chat role associated with this message.
	role *ChatRole

	// REQUIRED; The name of the function that was called to produce output.
	Name *string
}

// GetChatRequestMessage implements the ChatRequestMessageClassification interface for type ChatRequestFunctionMessage.
func (c *ChatRequestFunctionMessage) GetChatRequestMessage() *ChatRequestMessage {
	return &ChatRequestMessage{
		role: c.role,
	}
}

// ChatRequestMessage - An abstract representation of a chat message as provided in a request.
type ChatRequestMessage struct {
	// REQUIRED; The chat role associated with this message.
	role *ChatRole
}

// GetChatRequestMessage implements the ChatRequestMessageClassification interface for type ChatRequestMessage.
func (c *ChatRequestMessage) GetChatRequestMessage() *ChatRequestMessage { return c }

// ChatRequestSystemMessage - A request chat message containing system instructions that influence how the model will generate
// a chat completions response.
type ChatRequestSystemMessage struct {
	// REQUIRED; The contents of the system message.
	Content *string

	// REQUIRED; The chat role associated with this message.
	role *ChatRole

	// An optional name for the participant.
	Name *string
}

// GetChatRequestMessage implements the ChatRequestMessageClassification interface for type ChatRequestSystemMessage.
func (c *ChatRequestSystemMessage) GetChatRequestMessage() *ChatRequestMessage {
	return &ChatRequestMessage{
		role: c.role,
	}
}

// ChatRequestToolMessage - A request chat message representing requested output from a configured tool.
type ChatRequestToolMessage struct {
	// REQUIRED; The content of the message.
	Content *string

	// REQUIRED; The chat role associated with this message.
	role *ChatRole

	// REQUIRED; The ID of the tool call resolved by the provided content.
	ToolCallID *string
}

// GetChatRequestMessage implements the ChatRequestMessageClassification interface for type ChatRequestToolMessage.
func (c *ChatRequestToolMessage) GetChatRequestMessage() *ChatRequestMessage {
	return &ChatRequestMessage{
		role: c.role,
	}
}

// ChatRequestUserMessage - A request chat message representing user input to the assistant.
type ChatRequestUserMessage struct {
	// REQUIRED; The contents of the user message, with available input types varying by selected model.
	Content ChatRequestUserMessageContent

	// REQUIRED; The chat role associated with this message.
	role *ChatRole

	// An optional name for the participant.
	Name *string
}

// GetChatRequestMessage implements the ChatRequestMessageClassification interface for type ChatRequestUserMessage.
func (c *ChatRequestUserMessage) GetChatRequestMessage() *ChatRequestMessage {
	return &ChatRequestMessage{
		role: c.role,
	}
}

// ChatResponseMessage - A representation of a chat message as received in a response.
type ChatResponseMessage struct {
	// REQUIRED; The content of the message.
	Content *string

	// REQUIRED; The chat role associated with the message.
	Role *ChatRole

	// If Azure OpenAI chat extensions are configured, this array represents the incremental steps performed by those extensions
	// while processing the chat completions request.
	Context *AzureChatExtensionsMessageContext

	// The function call that must be resolved and have its output appended to subsequent input messages for the chat completions
	// request to resolve as configured.
	FunctionCall *FunctionCall

	// The tool calls that must be resolved and have their outputs appended to subsequent input messages for the chat completions
	// request to resolve as configured.
	ToolCalls []ChatCompletionsToolCallClassification
}

// ChatTokenLogProbabilityInfo - A representation of the log probability information for a single message content token.
type ChatTokenLogProbabilityInfo struct {
	// REQUIRED; A list of integers representing the UTF-8 bytes representation of the token. Useful in instances where characters
	// are represented by multiple tokens and their byte representations must be combined to
	// generate the correct text representation. Can be null if there is no bytes representation for the token.
	Bytes []int32

	// REQUIRED; The log probability of the message content token.
	Logprob *float32

	// REQUIRED; The message content token.
	Token *string
}

// ChatTokenLogProbabilityResult - A representation of the log probability information for a single content token, including
// a list of most likely tokens if 'top_logprobs' were requested.
type ChatTokenLogProbabilityResult struct {
	// REQUIRED; A list of integers representing the UTF-8 bytes representation of the token. Useful in instances where characters
	// are represented by multiple tokens and their byte representations must be combined to
	// generate the correct text representation. Can be null if there is no bytes representation for the token.
	Bytes []int32

	// REQUIRED; The log probability of the message content token.
	Logprob *float32

	// REQUIRED; The message content token.
	Token *string

	// REQUIRED; The list of most likely tokens and their log probability information, as requested via 'top_logprobs'.
	TopLogProbs []ChatTokenLogProbabilityInfo
}

// Choice - The representation of a single prompt completion as part of an overall completions request. Generally, n choices
// are generated per provided prompt with a default value of 1. Token limits and other
// settings may limit the number of choices generated.
type Choice struct {
	// REQUIRED; Reason for finishing
	FinishReason *CompletionsFinishReason

	// REQUIRED; The ordered index associated with this completions choice.
	Index *int32

	// REQUIRED; The log probabilities model for tokens associated with this completions choice.
	LogProbs *ChoiceLogProbs

	// REQUIRED; The generated text for a given completions prompt.
	Text *string

	// Information about the content filtering category (hate, sexual, violence, selfharm), if it has been detected, as well as
	// the severity level (verylow, low, medium, high-scale that determines the
	// intensity and risk level of harmful content) and if it has been filtered or not.
	ContentFilterResults *ContentFilterResultsForChoice
}

// ChoiceLogProbs - The log probabilities model for tokens associated with this completions choice.
type ChoiceLogProbs struct {
	// REQUIRED; The text offsets associated with tokens in this completions data.
	TextOffset []int32

	// REQUIRED; A collection of log probability values for the tokens in this completions data.
	TokenLogProbs []float32

	// REQUIRED; The textual forms of tokens evaluated in this probability model.
	Tokens []string

	// REQUIRED; A mapping of tokens to maximum log probability values in this completions data.
	TopLogProbs []map[string]*float32
}

// Completions - Representation of the response data from a completions request. Completions support a wide variety of tasks
// and generate text that continues from or "completes" provided prompt data.
type Completions struct {
	// REQUIRED; The collection of completions choices associated with this completions response. Generally, n choices are generated
	// per provided prompt with a default value of 1. Token limits and other settings may
	// limit the number of choices generated.
	Choices []Choice

	// REQUIRED; The first timestamp associated with generation activity for this completions response, represented as seconds
	// since the beginning of the Unix epoch of 00:00 on 1 Jan 1970.
	Created *time.Time

	// REQUIRED; A unique identifier associated with this completions response.
	ID *string

	// REQUIRED; Usage information for tokens processed and generated as part of this completions operation.
	Usage *CompletionsUsage

	// Content filtering results for zero or more prompts in the request. In a streaming request, results for different prompts
	// may arrive at different times or in different orders.
	PromptFilterResults []ContentFilterResultsForPrompt
}

// CompletionsLogProbabilityModel - Representation of a log probabilities model for a completions generation.
type CompletionsLogProbabilityModel struct {
	// REQUIRED; The text offsets associated with tokens in this completions data.
	TextOffset []int32

	// REQUIRED; A collection of log probability values for the tokens in this completions data.
	TokenLogProbs []float32

	// REQUIRED; The textual forms of tokens evaluated in this probability model.
	Tokens []string

	// REQUIRED; A mapping of tokens to maximum log probability values in this completions data.
	TopLogProbs []map[string]*float32
}

// CompletionsOptions - The configuration information for a completions request. Completions support a wide variety of tasks
// and generate text that continues from or "completes" provided prompt data.
type CompletionsOptions struct {
	// REQUIRED; The prompts to generate completions from.
	Prompt []string

	// A value that controls how many completions will be internally generated prior to response formulation. When used together
	// with n, bestof controls the number of candidate completions and must be
	// greater than n. Because this setting can generate many completions, it may quickly consume your token quota. Use carefully
	// and ensure reasonable settings for maxtokens and stop.
	BestOf *int32

	// A value specifying whether completions responses should include input prompts as prefixes to their generated output.
	Echo *bool

	// A value that influences the probability of generated tokens appearing based on their cumulative frequency in generated
	// text. Positive values will make tokens less likely to appear as their frequency
	// increases and decrease the likelihood of the model repeating the same statements verbatim.
	FrequencyPenalty *float32

	// A map between GPT token IDs and bias scores that influences the probability of specific tokens appearing in a completions
	// response. Token IDs are computed via external tokenizer tools, while bias
	// scores reside in the range of -100 to 100 with minimum and maximum values corresponding to a full ban or exclusive selection
	// of a token, respectively. The exact behavior of a given bias score varies
	// by model.
	LogitBias map[string]*int32

	// A value that controls the emission of log probabilities for the provided number of most likely tokens within a completions
	// response.
	LogProbs *int32

	// The maximum number of tokens to generate.
	MaxTokens *int32

	// The model name to provide as part of this completions request. Not applicable to Azure OpenAI, where deployment information
	// should be included in the Azure resource URI that's connected to.
	DeploymentName *string

	// The number of completions choices that should be generated per provided prompt as part of an overall completions response.
	// Because this setting can generate many completions, it may quickly consume
	// your token quota. Use carefully and ensure reasonable settings for max_tokens and stop.
	N *int32

	// A value that influences the probability of generated tokens appearing based on their existing presence in generated text.
	// Positive values will make tokens less likely to appear when they already exist
	// and increase the model's likelihood to output new topics.
	PresencePenalty *float32

	// A collection of textual sequences that will end completions generation.
	Stop []string

	// The suffix that comes after a completion of inserted text
	Suffix *string

	// The sampling temperature to use that controls the apparent creativity of generated completions. Higher values will make
	// output more random while lower values will make results more focused and
	// deterministic. It is not recommended to modify temperature and top_p for the same completions request as the interaction
	// of these two settings is difficult to predict.
	Temperature *float32

	// An alternative to sampling with temperature called nucleus sampling. This value causes the model to consider the results
	// of tokens with the provided probability mass. As an example, a value of 0.15
	// will cause only the tokens comprising the top 15% of probability mass to be considered. It is not recommended to modify
	// temperature and top_p for the same completions request as the interaction of
	// these two settings is difficult to predict.
	TopP *float32

	// An identifier for the caller or end user of the operation. This may be used for tracking or rate-limiting purposes.
	User *string
}

// CompletionsUsage - Representation of the token counts processed for a completions request. Counts consider all tokens across
// prompts, choices, choice alternates, best_of generations, and other consumers.
type CompletionsUsage struct {
	// REQUIRED; The number of tokens generated across all completions emissions.
	CompletionTokens *int32

	// REQUIRED; The number of tokens in the provided prompts for the completions request.
	PromptTokens *int32

	// REQUIRED; The total number of tokens processed for the completions request and response.
	TotalTokens *int32
}

// ContentFilterBlocklistIDResult - Represents the outcome of an evaluation against a custom blocklist as performed by content
// filtering.
type ContentFilterBlocklistIDResult struct {
	// REQUIRED; A value indicating whether or not the content has been filtered.
	Filtered *bool

	// REQUIRED; The ID of the custom blocklist evaluated.
	ID *string
}

// ContentFilterCitedDetectionResult - Represents the outcome of a detection operation against protected resources as performed
// by content filtering.
type ContentFilterCitedDetectionResult struct {
	// REQUIRED; A value indicating whether detection occurred, irrespective of severity or whether the content was filtered.
	Detected *bool

	// REQUIRED; A value indicating whether or not the content has been filtered.
	Filtered *bool

	// REQUIRED; The license description associated with the detection.
	License *string

	// The internet location associated with the detection.
	URL *string
}

// ContentFilterDetailedResults - Represents a structured collection of result details for content filtering.
type ContentFilterDetailedResults struct {
	// REQUIRED; The collection of detailed blocklist result information.
	Details []ContentFilterBlocklistIDResult

	// REQUIRED; A value indicating whether or not the content has been filtered.
	Filtered *bool
}

// ContentFilterDetectionResult - Represents the outcome of a detection operation performed by content filtering.
type ContentFilterDetectionResult struct {
	// REQUIRED; A value indicating whether detection occurred, irrespective of severity or whether the content was filtered.
	Detected *bool

	// REQUIRED; A value indicating whether or not the content has been filtered.
	Filtered *bool
}

// ContentFilterResult - Information about filtered content severity level and if it has been filtered or not.
type ContentFilterResult struct {
	// REQUIRED; A value indicating whether or not the content has been filtered.
	Filtered *bool

	// REQUIRED; Ratings for the intensity and risk level of filtered content.
	Severity *ContentFilterSeverity
}

// ContentFilterResultDetailsForPrompt - Information about content filtering evaluated against input data to Azure OpenAI.
type ContentFilterResultDetailsForPrompt struct {
	// Describes detection results against configured custom blocklists.
	CustomBlocklists *ContentFilterDetailedResults

	// Describes an error returned if the content filtering system is down or otherwise unable to complete the operation in time.
	Error *Error

	// Describes language attacks or uses that include pejorative or discriminatory language with reference to a person or identity
	// group on the basis of certain differentiating attributes of these groups
	// including but not limited to race, ethnicity, nationality, gender identity and expression, sexual orientation, religion,
	// immigration status, ability status, personal appearance, and body size.
	Hate *ContentFilterResult

	// Whether an indirect attack was detected in the prompt.
	IndirectAttack *ContentFilterDetectionResult

	// Whether a jailbreak attempt was detected in the prompt.
	Jailbreak *ContentFilterDetectionResult

	// Describes whether profanity was detected.
	Profanity *ContentFilterDetectionResult

	// Describes language related to physical actions intended to purposely hurt, injure, or damage one’s body, or kill oneself.
	SelfHarm *ContentFilterResult

	// Describes language related to anatomical organs and genitals, romantic relationships, acts portrayed in erotic or affectionate
	// terms, physical sexual acts, including those portrayed as an assault or a
	// forced sexual violent act against one’s will, prostitution, pornography, and abuse.
	Sexual *ContentFilterResult

	// Describes language related to physical actions intended to hurt, injure, damage, or kill someone or something; describes
	// weapons, etc.
	Violence *ContentFilterResult
}

// ContentFilterResultsForChoice - Information about content filtering evaluated against generated model output.
type ContentFilterResultsForChoice struct {
	// Describes detection results against configured custom blocklists.
	CustomBlocklists *ContentFilterDetailedResults

	// Describes an error returned if the content filtering system is down or otherwise unable to complete the operation in time.
	Error *Error

	// Describes language attacks or uses that include pejorative or discriminatory language with reference to a person or identity
	// group on the basis of certain differentiating attributes of these groups
	// including but not limited to race, ethnicity, nationality, gender identity and expression, sexual orientation, religion,
	// immigration status, ability status, personal appearance, and body size.
	Hate *ContentFilterResult

	// Describes whether profanity was detected.
	Profanity *ContentFilterDetectionResult

	// Information about detection of protected code material.
	ProtectedMaterialCode *ContentFilterCitedDetectionResult

	// Information about detection of protected text material.
	ProtectedMaterialText *ContentFilterDetectionResult

	// Describes language related to physical actions intended to purposely hurt, injure, or damage one’s body, or kill oneself.
	SelfHarm *ContentFilterResult

	// Describes language related to anatomical organs and genitals, romantic relationships, acts portrayed in erotic or affectionate
	// terms, physical sexual acts, including those portrayed as an assault or a
	// forced sexual violent act against one’s will, prostitution, pornography, and abuse.
	Sexual *ContentFilterResult

	// Describes language related to physical actions intended to hurt, injure, damage, or kill someone or something; describes
	// weapons, etc.
	Violence *ContentFilterResult
}

// ContentFilterResultsForPrompt - Content filtering results for a single prompt in the request.
type ContentFilterResultsForPrompt struct {
	// REQUIRED; Content filtering results for this prompt
	ContentFilterResults *ContentFilterResultDetailsForPrompt

	// REQUIRED; The index of this prompt in the set of prompt results
	PromptIndex *int32
}

// ElasticsearchChatExtensionConfiguration - A specific representation of configurable options for Elasticsearch when using
// it as an Azure OpenAI chat extension.
type ElasticsearchChatExtensionConfiguration struct {
	// REQUIRED; The label for the type of an Azure chat extension. This typically corresponds to a matching Azure resource. Azure
	// chat extensions are only compatible with Azure OpenAI.
	configType *AzureChatExtensionType

	// REQUIRED; The parameters to use when configuring Elasticsearch®.
	Parameters *ElasticsearchChatExtensionParameters
}

// GetAzureChatExtensionConfiguration implements the AzureChatExtensionConfigurationClassification interface for type ElasticsearchChatExtensionConfiguration.
func (e *ElasticsearchChatExtensionConfiguration) GetAzureChatExtensionConfiguration() *AzureChatExtensionConfiguration {
	return &AzureChatExtensionConfiguration{
		configType: e.configType,
	}
}

// ElasticsearchChatExtensionParameters - Parameters to use when configuring Elasticsearch® as an Azure OpenAI chat extension.
// The supported authentication types are KeyAndKeyId and EncodedAPIKey.
type ElasticsearchChatExtensionParameters struct {
	// REQUIRED; The endpoint of Elasticsearch®.
	Endpoint *string

	// REQUIRED; The index name of Elasticsearch®.
	IndexName *string

	// The authentication method to use when accessing the defined data source. Each data source type supports a specific set
	// of available authentication methods; please see the documentation of the data
	// source for supported mechanisms. If not otherwise provided, On Your Data will attempt to use System Managed Identity (default
	// credential) authentication.
	Authentication OnYourDataAuthenticationOptionsClassification

	// The embedding dependency for vector search.
	EmbeddingDependency OnYourDataVectorizationSourceClassification

	// The index field mapping options of Elasticsearch®.
	FieldsMapping *ElasticsearchIndexFieldMappingOptions

	// Whether queries should be restricted to use of indexed data.
	InScope *bool

	// The query type of Elasticsearch®.
	QueryType *ElasticsearchQueryType

	// Give the model instructions about how it should behave and any context it should reference when generating a response.
	// You can describe the assistant's personality and tell it how to format responses.
	// There's a 100 token limit for it, and it counts against the overall token limit.
	RoleInformation *string

	// The configured strictness of the search relevance filtering. The higher of strictness, the higher of the precision but
	// lower recall of the answer.
	Strictness *int32

	// The configured top number of documents to feature for the configured query.
	TopNDocuments *int32
}

// ElasticsearchIndexFieldMappingOptions - Optional settings to control how fields are processed when using a configured Elasticsearch®
// resource.
type ElasticsearchIndexFieldMappingOptions struct {
	// The names of index fields that should be treated as content.
	ContentFields []string

	// The separator pattern that content fields should use.
	ContentFieldsSeparator *string

	// The name of the index field to use as a filepath.
	FilepathField *string

	// The name of the index field to use as a title.
	TitleField *string

	// The name of the index field to use as a URL.
	URLField *string

	// The names of fields that represent vector data.
	VectorFields []string
}

// Embeddings - Representation of the response data from an embeddings request. Embeddings measure the relatedness of text
// strings and are commonly used for search, clustering, recommendations, and other similar
// scenarios.
type Embeddings struct {
	// REQUIRED; Embedding values for the prompts submitted in the request.
	Data []EmbeddingItem

	// REQUIRED; Usage counts for tokens input using the embeddings API.
	Usage *EmbeddingsUsage
}

// EmbeddingsOptions - The configuration information for an embeddings request. Embeddings measure the relatedness of text
// strings and are commonly used for search, clustering, recommendations, and other similar scenarios.
type EmbeddingsOptions struct {
	// REQUIRED; Input texts to get embeddings for, encoded as a an array of strings. Each input must not exceed 2048 tokens in
	// length.
	// Unless you are embedding code, we suggest replacing newlines (\n) in your input with a single space, as we have observed
	// inferior results when newlines are present.
	Input []string

	// The number of dimensions the resulting output embeddings should have. Only supported in text-embedding-3 and later models.
	Dimensions *int32

	// The response encoding format to use for embedding data.
	// - If using EmbeddingEncodingFormatFloat (the default), the value will be a []float32, in [EmbeddingItem.Embedding]
	// - If using EmbeddingEncodingFormatBase64, the value will be a base-64 string in [EmbeddingItem.EmbeddingBase64]
	EncodingFormat *EmbeddingEncodingFormat

	// When using Azure OpenAI, specifies the input type to use for embedding search.
	InputType *string

	// The model name to provide as part of this embeddings request. Not applicable to Azure OpenAI, where deployment information
	// should be included in the Azure resource URI that's connected to.
	DeploymentName *string

	// An identifier for the caller or end user of the operation. This may be used for tracking or rate-limiting purposes.
	User *string
}

// EmbeddingsUsage - Measurement of the amount of tokens used in this request and response.
type EmbeddingsUsage struct {
	// REQUIRED; Number of tokens sent in the original request.
	PromptTokens *int32

	// REQUIRED; Total number of tokens transacted in this request/response.
	TotalTokens *int32
}

// Error - The error object.
type Error struct {
	// REQUIRED; One of a server-defined set of error codes.
	Code *string

	// REQUIRED; A human-readable representation of the error.
	message *string
}

// FunctionCall - The name and arguments of a function that should be called, as generated by the model.
type FunctionCall struct {
	// REQUIRED; The arguments to call the function with, as generated by the model in JSON format. Note that the model does not
	// always generate valid JSON, and may hallucinate parameters not defined by your function
	// schema. Validate the arguments in your code before calling your function.
	Arguments *string

	// REQUIRED; The name of the function to call.
	Name *string
}

// FunctionDefinition - The definition of a caller-specified function that chat completions may invoke in response to matching
// user input.
type FunctionDefinition struct {
	// REQUIRED; The name of the function to be called.
	Name *string

	// A description of what the function does. The model will use this description when selecting the function and interpreting
	// its parameters.
	Description *string

	// The parameters the function accepts, described as a JSON Schema object.
	Parameters any
}

// FunctionName - A structure that specifies the exact name of a specific, request-provided function to use when processing
// a chat completions operation.
type FunctionName struct {
	// REQUIRED; The name of the function to call.
	Name *string
}

// ImageGenerationContentFilterResults - Describes the content filtering result for the image generation request.
type ImageGenerationContentFilterResults struct {
	// Describes language attacks or uses that include pejorative or discriminatory language with reference to a person or identity
	// group on the basis of certain differentiating attributes of these groups
	// including but not limited to race, ethnicity, nationality, gender identity and expression, sexual orientation, religion,
	// immigration status, ability status, personal appearance, and body size.
	Hate *ContentFilterResult

	// Describes language related to physical actions intended to purposely hurt, injure, or damage one’s body, or kill oneself.
	SelfHarm *ContentFilterResult

	// Describes language related to anatomical organs and genitals, romantic relationships, acts portrayed in erotic or affectionate
	// terms, physical sexual acts, including those portrayed as an assault or a
	// forced sexual violent act against one’s will, prostitution, pornography, and abuse.
	Sexual *ContentFilterResult

	// Describes language related to physical actions intended to hurt, injure, damage, or kill someone or something; describes
	// weapons, etc.
	Violence *ContentFilterResult
}

// ImageGenerationData - A representation of a single generated image, provided as either base64-encoded data or as a URL
// from which the image may be retrieved.
type ImageGenerationData struct {
	// The complete data for an image, represented as a base64-encoded string.
	Base64Data *string

	// Information about the content filtering results.
	ContentFilterResults *ImageGenerationContentFilterResults

	// Information about the content filtering category (hate, sexual, violence, selfharm), if it has been detected, as well as
	// the severity level (verylow, low, medium, high-scale that determines the
	// intensity and risk level of harmful content) and if it has been filtered or not. Information about jailbreak content and
	// profanity, if it has been detected, and if it has been filtered or not. And
	// information about customer block list, if it has been filtered and its id.
	PromptFilterResults *ImageGenerationPromptFilterResults

	// The final prompt used by the model to generate the image. Only provided with dall-3-models and only when revisions were
	// made to the prompt.
	RevisedPrompt *string

	// The URL that provides temporary access to download the generated image.
	URL *string
}

// ImageGenerationOptions - Represents the request data used to generate images.
type ImageGenerationOptions struct {
	// REQUIRED; A description of the desired images.
	Prompt *string

	// The model name or Azure OpenAI model deployment name to use for image generation. If not specified, dall-e-2 will be inferred
	// as a default.
	DeploymentName *string

	// The number of images to generate. Dall-e-2 models support values between 1 and 10. Dall-e-3 models only support a value
	// of 1.
	N *int32

	// The desired image generation quality level to use. Only configurable with dall-e-3 models.
	Quality *ImageGenerationQuality

	// The format in which image generation response items should be presented.
	ResponseFormat *ImageGenerationResponseFormat

	// The desired dimensions for generated images. Dall-e-2 models support 256x256, 512x512, or 1024x1024. Dall-e-3 models support
	// 1024x1024, 1792x1024, or 1024x1792.
	Size *ImageSize

	// The desired image generation style to use. Only configurable with dall-e-3 models.
	Style *ImageGenerationStyle

	// A unique identifier representing your end-user, which can help to monitor and detect abuse.
	User *string
}

// ImageGenerationPromptFilterResults - Describes the content filtering results for the prompt of a image generation request.
type ImageGenerationPromptFilterResults struct {
	// Describes language attacks or uses that include pejorative or discriminatory language with reference to a person or identity
	// group on the basis of certain differentiating attributes of these groups
	// including but not limited to race, ethnicity, nationality, gender identity and expression, sexual orientation, religion,
	// immigration status, ability status, personal appearance, and body size.
	Hate *ContentFilterResult

	// Whether a jailbreak attempt was detected in the prompt.
	Jailbreak *ContentFilterDetectionResult

	// Describes whether profanity was detected.
	Profanity *ContentFilterDetectionResult

	// Describes language related to physical actions intended to purposely hurt, injure, or damage one’s body, or kill oneself.
	SelfHarm *ContentFilterResult

	// Describes language related to anatomical organs and genitals, romantic relationships, acts portrayed in erotic or affectionate
	// terms, physical sexual acts, including those portrayed as an assault or a
	// forced sexual violent act against one’s will, prostitution, pornography, and abuse.
	Sexual *ContentFilterResult

	// Describes language related to physical actions intended to hurt, injure, damage, or kill someone or something; describes
	// weapons, etc.
	Violence *ContentFilterResult
}

// ImageGenerations - The result of a successful image generation operation.
type ImageGenerations struct {
	// REQUIRED; A timestamp representing when this operation was started. Expressed in seconds since the Unix epoch of 1970-01-01T00:00:00+0000.
	Created *time.Time

	// REQUIRED; The images generated by the operation.
	Data []ImageGenerationData
}

// MaxTokensFinishDetails - A structured representation of a stop reason that signifies a token limit was reached before the
// model could naturally complete.
type MaxTokensFinishDetails struct {
	// REQUIRED; The object type.
	Type *string
}

// GetChatFinishDetails implements the ChatFinishDetailsClassification interface for type MaxTokensFinishDetails.
func (m *MaxTokensFinishDetails) GetChatFinishDetails() *ChatFinishDetails {
	return &ChatFinishDetails{
		Type: m.Type,
	}
}

// OnYourDataAPIKeyAuthenticationOptions - The authentication options for Azure OpenAI On Your Data when using an API key.
type OnYourDataAPIKeyAuthenticationOptions struct {
	// REQUIRED; The authentication type.
	configType *OnYourDataAuthenticationType

	// REQUIRED; The API key to use for authentication.
	Key *string
}

// GetOnYourDataAuthenticationOptions implements the OnYourDataAuthenticationOptionsClassification interface for type OnYourDataAPIKeyAuthenticationOptions.
func (o *OnYourDataAPIKeyAuthenticationOptions) GetOnYourDataAuthenticationOptions() *OnYourDataAuthenticationOptions {
	return &OnYourDataAuthenticationOptions{
		configType: o.configType,
	}
}

// OnYourDataAccessTokenAuthenticationOptions - The authentication options for Azure OpenAI On Your Data when using access
// token.
type OnYourDataAccessTokenAuthenticationOptions struct {
	// REQUIRED; The access token to use for authentication.
	AccessToken *string

	// REQUIRED; The authentication type.
	configType *OnYourDataAuthenticationType
}

// GetOnYourDataAuthenticationOptions implements the OnYourDataAuthenticationOptionsClassification interface for type OnYourDataAccessTokenAuthenticationOptions.
func (o *OnYourDataAccessTokenAuthenticationOptions) GetOnYourDataAuthenticationOptions() *OnYourDataAuthenticationOptions {
	return &OnYourDataAuthenticationOptions{
		configType: o.configType,
	}
}

// OnYourDataAuthenticationOptions - The authentication options for Azure OpenAI On Your Data.
type OnYourDataAuthenticationOptions struct {
	// REQUIRED; The authentication type.
	configType *OnYourDataAuthenticationType
}

// GetOnYourDataAuthenticationOptions implements the OnYourDataAuthenticationOptionsClassification interface for type OnYourDataAuthenticationOptions.
func (o *OnYourDataAuthenticationOptions) GetOnYourDataAuthenticationOptions() *OnYourDataAuthenticationOptions {
	return o
}

// OnYourDataConnectionStringAuthenticationOptions - The authentication options for Azure OpenAI On Your Data when using a
// connection string.
type OnYourDataConnectionStringAuthenticationOptions struct {
	// REQUIRED; The connection string to use for authentication.
	ConnectionString *string

	// REQUIRED; The authentication type.
	configType *OnYourDataAuthenticationType
}

// GetOnYourDataAuthenticationOptions implements the OnYourDataAuthenticationOptionsClassification interface for type OnYourDataConnectionStringAuthenticationOptions.
func (o *OnYourDataConnectionStringAuthenticationOptions) GetOnYourDataAuthenticationOptions() *OnYourDataAuthenticationOptions {
	return &OnYourDataAuthenticationOptions{
		configType: o.configType,
	}
}

// OnYourDataDeploymentNameVectorizationSource - The details of a a vectorization source, used by Azure OpenAI On Your Data
// when applying vector search, that is based on an internal embeddings model deployment name in the same Azure OpenAI resource.
type OnYourDataDeploymentNameVectorizationSource struct {
	// REQUIRED; The embedding model deployment name within the same Azure OpenAI resource. This enables you to use vector search
	// without Azure OpenAI api-key and without Azure OpenAI public network access.
	DeploymentName *string

	// REQUIRED; The type of vectorization source to use.
	Type *OnYourDataVectorizationSourceType
}

// GetOnYourDataVectorizationSource implements the OnYourDataVectorizationSourceClassification interface for type OnYourDataDeploymentNameVectorizationSource.
func (o *OnYourDataDeploymentNameVectorizationSource) GetOnYourDataVectorizationSource() *OnYourDataVectorizationSource {
	return &OnYourDataVectorizationSource{
		Type: o.Type,
	}
}

// OnYourDataEncodedAPIKeyAuthenticationOptions - The authentication options for Azure OpenAI On Your Data when using an Elasticsearch
// encoded API key.
type OnYourDataEncodedAPIKeyAuthenticationOptions struct {
	// REQUIRED; The encoded API key to use for authentication.
	EncodedAPIKey *string

	// REQUIRED; The authentication type.
	configType *OnYourDataAuthenticationType
}

// GetOnYourDataAuthenticationOptions implements the OnYourDataAuthenticationOptionsClassification interface for type OnYourDataEncodedAPIKeyAuthenticationOptions.
func (o *OnYourDataEncodedAPIKeyAuthenticationOptions) GetOnYourDataAuthenticationOptions() *OnYourDataAuthenticationOptions {
	return &OnYourDataAuthenticationOptions{
		configType: o.configType,
	}
}

// OnYourDataEndpointVectorizationSource - The details of a a vectorization source, used by Azure OpenAI On Your Data when
// applying vector search, that is based on a public Azure OpenAI endpoint call for embeddings.
type OnYourDataEndpointVectorizationSource struct {
	// REQUIRED; Specifies the authentication options to use when retrieving embeddings from the specified endpoint.
	Authentication OnYourDataAuthenticationOptionsClassification

	// REQUIRED; Specifies the resource endpoint URL from which embeddings should be retrieved. It should be in the format of
	// https://YOURRESOURCENAME.openai.azure.com/openai/deployments/YOURDEPLOYMENTNAME/embeddings.
	// The api-version query parameter is not allowed.
	Endpoint *string

	// REQUIRED; The type of vectorization source to use.
	Type *OnYourDataVectorizationSourceType
}

// GetOnYourDataVectorizationSource implements the OnYourDataVectorizationSourceClassification interface for type OnYourDataEndpointVectorizationSource.
func (o *OnYourDataEndpointVectorizationSource) GetOnYourDataVectorizationSource() *OnYourDataVectorizationSource {
	return &OnYourDataVectorizationSource{
		Type: o.Type,
	}
}

// OnYourDataKeyAndKeyIDAuthenticationOptions - The authentication options for Azure OpenAI On Your Data when using an Elasticsearch
// key and key ID pair.
type OnYourDataKeyAndKeyIDAuthenticationOptions struct {
	// REQUIRED; The authentication type.
	configType *OnYourDataAuthenticationType

	// REQUIRED; The key to use for authentication.
	Key *string

	// REQUIRED; The key ID to use for authentication.
	KeyID *string
}

// GetOnYourDataAuthenticationOptions implements the OnYourDataAuthenticationOptionsClassification interface for type OnYourDataKeyAndKeyIDAuthenticationOptions.
func (o *OnYourDataKeyAndKeyIDAuthenticationOptions) GetOnYourDataAuthenticationOptions() *OnYourDataAuthenticationOptions {
	return &OnYourDataAuthenticationOptions{
		configType: o.configType,
	}
}

// OnYourDataModelIDVectorizationSource - The details of a a vectorization source, used by Azure OpenAI On Your Data when
// applying vector search, that is based on a search service model ID. Currently only supported by Elasticsearch®.
type OnYourDataModelIDVectorizationSource struct {
	// REQUIRED; The embedding model ID build inside the search service. Currently only supported by Elasticsearch®.
	ModelID *string

	// REQUIRED; The type of vectorization source to use.
	Type *OnYourDataVectorizationSourceType
}

// GetOnYourDataVectorizationSource implements the OnYourDataVectorizationSourceClassification interface for type OnYourDataModelIDVectorizationSource.
func (o *OnYourDataModelIDVectorizationSource) GetOnYourDataVectorizationSource() *OnYourDataVectorizationSource {
	return &OnYourDataVectorizationSource{
		Type: o.Type,
	}
}

// OnYourDataSystemAssignedManagedIdentityAuthenticationOptions - The authentication options for Azure OpenAI On Your Data
// when using a system-assigned managed identity.
type OnYourDataSystemAssignedManagedIdentityAuthenticationOptions struct {
	// REQUIRED; The authentication type.
	configType *OnYourDataAuthenticationType
}

// GetOnYourDataAuthenticationOptions implements the OnYourDataAuthenticationOptionsClassification interface for type OnYourDataSystemAssignedManagedIdentityAuthenticationOptions.
func (o *OnYourDataSystemAssignedManagedIdentityAuthenticationOptions) GetOnYourDataAuthenticationOptions() *OnYourDataAuthenticationOptions {
	return &OnYourDataAuthenticationOptions{
		configType: o.configType,
	}
}

// OnYourDataUserAssignedManagedIdentityAuthenticationOptions - The authentication options for Azure OpenAI On Your Data when
// using a user-assigned managed identity.
type OnYourDataUserAssignedManagedIdentityAuthenticationOptions struct {
	// REQUIRED; The authentication type.
	configType *OnYourDataAuthenticationType

	// REQUIRED; The resource ID of the user-assigned managed identity to use for authentication.
	ManagedIdentityResourceID *string
}

// GetOnYourDataAuthenticationOptions implements the OnYourDataAuthenticationOptionsClassification interface for type OnYourDataUserAssignedManagedIdentityAuthenticationOptions.
func (o *OnYourDataUserAssignedManagedIdentityAuthenticationOptions) GetOnYourDataAuthenticationOptions() *OnYourDataAuthenticationOptions {
	return &OnYourDataAuthenticationOptions{
		configType: o.configType,
	}
}

// OnYourDataVectorizationSource - An abstract representation of a vectorization source for Azure OpenAI On Your Data with
// vector search.
type OnYourDataVectorizationSource struct {
	// REQUIRED; The type of vectorization source to use.
	Type *OnYourDataVectorizationSourceType
}

// GetOnYourDataVectorizationSource implements the OnYourDataVectorizationSourceClassification interface for type OnYourDataVectorizationSource.
func (o *OnYourDataVectorizationSource) GetOnYourDataVectorizationSource() *OnYourDataVectorizationSource {
	return o
}

// PineconeChatExtensionConfiguration - A specific representation of configurable options for Pinecone when using it as an
// Azure OpenAI chat extension.
type PineconeChatExtensionConfiguration struct {
	// REQUIRED; The label for the type of an Azure chat extension. This typically corresponds to a matching Azure resource. Azure
	// chat extensions are only compatible with Azure OpenAI.
	configType *AzureChatExtensionType

	// REQUIRED; The parameters to use when configuring Azure OpenAI chat extensions.
	Parameters *PineconeChatExtensionParameters
}

// GetAzureChatExtensionConfiguration implements the AzureChatExtensionConfigurationClassification interface for type PineconeChatExtensionConfiguration.
func (p *PineconeChatExtensionConfiguration) GetAzureChatExtensionConfiguration() *AzureChatExtensionConfiguration {
	return &AzureChatExtensionConfiguration{
		configType: p.configType,
	}
}

// PineconeChatExtensionParameters - Parameters for configuring Azure OpenAI Pinecone chat extensions. The supported authentication
// type is APIKey.
type PineconeChatExtensionParameters struct {
	// REQUIRED; The embedding dependency for vector search.
	EmbeddingDependency OnYourDataVectorizationSourceClassification

	// REQUIRED; The environment name of Pinecone.
	Environment *string

	// REQUIRED; Customized field mapping behavior to use when interacting with the search index.
	FieldsMapping *PineconeFieldMappingOptions

	// REQUIRED; The name of the Pinecone database index.
	IndexName *string

	// The authentication method to use when accessing the defined data source. Each data source type supports a specific set
	// of available authentication methods; please see the documentation of the data
	// source for supported mechanisms. If not otherwise provided, On Your Data will attempt to use System Managed Identity (default
	// credential) authentication.
	Authentication OnYourDataAuthenticationOptionsClassification

	// Whether queries should be restricted to use of indexed data.
	InScope *bool

	// Give the model instructions about how it should behave and any context it should reference when generating a response.
	// You can describe the assistant's personality and tell it how to format responses.
	// There's a 100 token limit for it, and it counts against the overall token limit.
	RoleInformation *string

	// The configured strictness of the search relevance filtering. The higher of strictness, the higher of the precision but
	// lower recall of the answer.
	Strictness *int32

	// The configured top number of documents to feature for the configured query.
	TopNDocuments *int32
}

// PineconeFieldMappingOptions - Optional settings to control how fields are processed when using a configured Pinecone resource.
type PineconeFieldMappingOptions struct {
	// REQUIRED; The names of index fields that should be treated as content.
	ContentFields []string

	// The separator pattern that content fields should use.
	ContentFieldsSeparator *string

	// The name of the index field to use as a filepath.
	FilepathField *string

	// The name of the index field to use as a title.
	TitleField *string

	// The name of the index field to use as a URL.
	URLField *string
}

// SpeechGenerationOptions - A representation of the request options that control the behavior of a text-to-speech operation.
type SpeechGenerationOptions struct {
	// REQUIRED; The text to generate audio for. The maximum length is 4096 characters.
	Input *string

	// REQUIRED; The voice to use for text-to-speech.
	Voice *SpeechVoice

	// The model to use for this text-to-speech request.
	DeploymentName *string

	// The audio output format for the spoken text. By default, the MP3 format will be used.
	ResponseFormat *SpeechGenerationResponseFormat

	// The speed of speech for generated audio. Values are valid in the range from 0.25 to 4.0, with 1.0 the default and higher
	// values corresponding to faster speech.
	Speed *float32
}

// SpeechGenerationResponse - A representation of a response for a text-to-speech operation.
type SpeechGenerationResponse struct {
	// REQUIRED; The generated audio, generated in the requested audio output format.
	Audio []byte
}

// StopFinishDetails - A structured representation of a stop reason that signifies natural termination by the model.
type StopFinishDetails struct {
	// REQUIRED; The token sequence that the model terminated with.
	Stop *string

	// REQUIRED; The object type.
	Type *string
}

// GetChatFinishDetails implements the ChatFinishDetailsClassification interface for type StopFinishDetails.
func (s *StopFinishDetails) GetChatFinishDetails() *ChatFinishDetails {
	return &ChatFinishDetails{
		Type: s.Type,
	}
}
