//go:build go1.18
// +build go1.18

// Copyright (c) Microsoft Corporation. All rights reserved.
// Licensed under the MIT License. See License.txt in the project root for license information.
// Code generated by Microsoft (R) AutoRest Code Generator. DO NOT EDIT.
// Changes may cause incorrect behavior and will be lost if the code is regenerated.

package azopenai

import (
	"encoding/json"
	"fmt"
	"reflect"

	"github.com/Azure/azure-sdk-for-go/sdk/azcore"
	"github.com/Azure/azure-sdk-for-go/sdk/azcore/runtime"
)

// MarshalJSON implements the json.Marshaller interface for type AudioTranscription.
func (a AudioTranscription) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]any)
	populate(objectMap, "duration", a.Duration)
	populate(objectMap, "language", a.Language)
	populate(objectMap, "segments", a.Segments)
	populate(objectMap, "task", a.Task)
	populate(objectMap, "text", a.Text)
	populate(objectMap, "words", a.Words)
	return json.Marshal(objectMap)
}

// UnmarshalJSON implements the json.Unmarshaller interface for type AudioTranscription.
func (a *AudioTranscription) UnmarshalJSON(data []byte) error {
	var rawMsg map[string]json.RawMessage
	if err := json.Unmarshal(data, &rawMsg); err != nil {
		return fmt.Errorf("unmarshalling type %T: %v", a, err)
	}
	for key, val := range rawMsg {
		var err error
		switch key {
		case "duration":
			err = unpopulate(val, "Duration", &a.Duration)
			delete(rawMsg, key)
		case "language":
			err = unpopulate(val, "Language", &a.Language)
			delete(rawMsg, key)
		case "segments":
			err = unpopulate(val, "Segments", &a.Segments)
			delete(rawMsg, key)
		case "task":
			err = unpopulate(val, "Task", &a.Task)
			delete(rawMsg, key)
		case "text":
			err = unpopulate(val, "Text", &a.Text)
			delete(rawMsg, key)
		case "words":
			err = unpopulate(val, "Words", &a.Words)
			delete(rawMsg, key)
		}
		if err != nil {
			return fmt.Errorf("unmarshalling type %T: %v", a, err)
		}
	}
	return nil
}

// MarshalJSON implements the json.Marshaller interface for type AudioTranscriptionOptions.
func (a AudioTranscriptionOptions) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]any)
	populateByteArray(objectMap, "file", a.File, func() any {
		return runtime.EncodeByteArray(a.File, runtime.Base64StdFormat)
	})
	populate(objectMap, "filename", a.Filename)
	populate(objectMap, "language", a.Language)
	populate(objectMap, "model", a.DeploymentName)
	populate(objectMap, "prompt", a.Prompt)
	populate(objectMap, "response_format", a.ResponseFormat)
	populate(objectMap, "temperature", a.Temperature)
	populate(objectMap, "timestamp_granularities", a.TimestampGranularities)
	return json.Marshal(objectMap)
}

// UnmarshalJSON implements the json.Unmarshaller interface for type AudioTranscriptionOptions.
func (a *AudioTranscriptionOptions) UnmarshalJSON(data []byte) error {
	var rawMsg map[string]json.RawMessage
	if err := json.Unmarshal(data, &rawMsg); err != nil {
		return fmt.Errorf("unmarshalling type %T: %v", a, err)
	}
	for key, val := range rawMsg {
		var err error
		switch key {
		case "file":
			if val != nil && string(val) != "null" {
				err = runtime.DecodeByteArray(string(val), &a.File, runtime.Base64StdFormat)
			}
			delete(rawMsg, key)
		case "filename":
			err = unpopulate(val, "Filename", &a.Filename)
			delete(rawMsg, key)
		case "language":
			err = unpopulate(val, "Language", &a.Language)
			delete(rawMsg, key)
		case "model":
			err = unpopulate(val, "Model", &a.DeploymentName)
			delete(rawMsg, key)
		case "prompt":
			err = unpopulate(val, "Prompt", &a.Prompt)
			delete(rawMsg, key)
		case "response_format":
			err = unpopulate(val, "ResponseFormat", &a.ResponseFormat)
			delete(rawMsg, key)
		case "temperature":
			err = unpopulate(val, "Temperature", &a.Temperature)
			delete(rawMsg, key)
		case "timestamp_granularities":
			err = unpopulate(val, "TimestampGranularities", &a.TimestampGranularities)
			delete(rawMsg, key)
		}
		if err != nil {
			return fmt.Errorf("unmarshalling type %T: %v", a, err)
		}
	}
	return nil
}

// MarshalJSON implements the json.Marshaller interface for type AudioTranscriptionSegment.
func (a AudioTranscriptionSegment) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]any)
	populate(objectMap, "avg_logprob", a.AvgLogProb)
	populate(objectMap, "compression_ratio", a.CompressionRatio)
	populate(objectMap, "end", a.End)
	populate(objectMap, "id", a.ID)
	populate(objectMap, "no_speech_prob", a.NoSpeechProb)
	populate(objectMap, "seek", a.Seek)
	populate(objectMap, "start", a.Start)
	populate(objectMap, "temperature", a.Temperature)
	populate(objectMap, "text", a.Text)
	populate(objectMap, "tokens", a.Tokens)
	return json.Marshal(objectMap)
}

// UnmarshalJSON implements the json.Unmarshaller interface for type AudioTranscriptionSegment.
func (a *AudioTranscriptionSegment) UnmarshalJSON(data []byte) error {
	var rawMsg map[string]json.RawMessage
	if err := json.Unmarshal(data, &rawMsg); err != nil {
		return fmt.Errorf("unmarshalling type %T: %v", a, err)
	}
	for key, val := range rawMsg {
		var err error
		switch key {
		case "avg_logprob":
			err = unpopulate(val, "AvgLogprob", &a.AvgLogProb)
			delete(rawMsg, key)
		case "compression_ratio":
			err = unpopulate(val, "CompressionRatio", &a.CompressionRatio)
			delete(rawMsg, key)
		case "end":
			err = unpopulate(val, "End", &a.End)
			delete(rawMsg, key)
		case "id":
			err = unpopulate(val, "ID", &a.ID)
			delete(rawMsg, key)
		case "no_speech_prob":
			err = unpopulate(val, "NoSpeechProb", &a.NoSpeechProb)
			delete(rawMsg, key)
		case "seek":
			err = unpopulate(val, "Seek", &a.Seek)
			delete(rawMsg, key)
		case "start":
			err = unpopulate(val, "Start", &a.Start)
			delete(rawMsg, key)
		case "temperature":
			err = unpopulate(val, "Temperature", &a.Temperature)
			delete(rawMsg, key)
		case "text":
			err = unpopulate(val, "Text", &a.Text)
			delete(rawMsg, key)
		case "tokens":
			err = unpopulate(val, "Tokens", &a.Tokens)
			delete(rawMsg, key)
		}
		if err != nil {
			return fmt.Errorf("unmarshalling type %T: %v", a, err)
		}
	}
	return nil
}

// MarshalJSON implements the json.Marshaller interface for type AudioTranscriptionWord.
func (a AudioTranscriptionWord) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]any)
	populate(objectMap, "end", a.End)
	populate(objectMap, "start", a.Start)
	populate(objectMap, "word", a.Word)
	return json.Marshal(objectMap)
}

// UnmarshalJSON implements the json.Unmarshaller interface for type AudioTranscriptionWord.
func (a *AudioTranscriptionWord) UnmarshalJSON(data []byte) error {
	var rawMsg map[string]json.RawMessage
	if err := json.Unmarshal(data, &rawMsg); err != nil {
		return fmt.Errorf("unmarshalling type %T: %v", a, err)
	}
	for key, val := range rawMsg {
		var err error
		switch key {
		case "end":
			err = unpopulate(val, "End", &a.End)
			delete(rawMsg, key)
		case "start":
			err = unpopulate(val, "Start", &a.Start)
			delete(rawMsg, key)
		case "word":
			err = unpopulate(val, "Word", &a.Word)
			delete(rawMsg, key)
		}
		if err != nil {
			return fmt.Errorf("unmarshalling type %T: %v", a, err)
		}
	}
	return nil
}

// MarshalJSON implements the json.Marshaller interface for type AudioTranslation.
func (a AudioTranslation) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]any)
	populate(objectMap, "duration", a.Duration)
	populate(objectMap, "language", a.Language)
	populate(objectMap, "segments", a.Segments)
	populate(objectMap, "task", a.Task)
	populate(objectMap, "text", a.Text)
	return json.Marshal(objectMap)
}

// UnmarshalJSON implements the json.Unmarshaller interface for type AudioTranslation.
func (a *AudioTranslation) UnmarshalJSON(data []byte) error {
	var rawMsg map[string]json.RawMessage
	if err := json.Unmarshal(data, &rawMsg); err != nil {
		return fmt.Errorf("unmarshalling type %T: %v", a, err)
	}
	for key, val := range rawMsg {
		var err error
		switch key {
		case "duration":
			err = unpopulate(val, "Duration", &a.Duration)
			delete(rawMsg, key)
		case "language":
			err = unpopulate(val, "Language", &a.Language)
			delete(rawMsg, key)
		case "segments":
			err = unpopulate(val, "Segments", &a.Segments)
			delete(rawMsg, key)
		case "task":
			err = unpopulate(val, "Task", &a.Task)
			delete(rawMsg, key)
		case "text":
			err = unpopulate(val, "Text", &a.Text)
			delete(rawMsg, key)
		}
		if err != nil {
			return fmt.Errorf("unmarshalling type %T: %v", a, err)
		}
	}
	return nil
}

// MarshalJSON implements the json.Marshaller interface for type AudioTranslationOptions.
func (a AudioTranslationOptions) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]any)
	populateByteArray(objectMap, "file", a.File, func() any {
		return runtime.EncodeByteArray(a.File, runtime.Base64StdFormat)
	})
	populate(objectMap, "filename", a.Filename)
	populate(objectMap, "model", a.DeploymentName)
	populate(objectMap, "prompt", a.Prompt)
	populate(objectMap, "response_format", a.ResponseFormat)
	populate(objectMap, "temperature", a.Temperature)
	return json.Marshal(objectMap)
}

// UnmarshalJSON implements the json.Unmarshaller interface for type AudioTranslationOptions.
func (a *AudioTranslationOptions) UnmarshalJSON(data []byte) error {
	var rawMsg map[string]json.RawMessage
	if err := json.Unmarshal(data, &rawMsg); err != nil {
		return fmt.Errorf("unmarshalling type %T: %v", a, err)
	}
	for key, val := range rawMsg {
		var err error
		switch key {
		case "file":
			if val != nil && string(val) != "null" {
				err = runtime.DecodeByteArray(string(val), &a.File, runtime.Base64StdFormat)
			}
			delete(rawMsg, key)
		case "filename":
			err = unpopulate(val, "Filename", &a.Filename)
			delete(rawMsg, key)
		case "model":
			err = unpopulate(val, "Model", &a.DeploymentName)
			delete(rawMsg, key)
		case "prompt":
			err = unpopulate(val, "Prompt", &a.Prompt)
			delete(rawMsg, key)
		case "response_format":
			err = unpopulate(val, "ResponseFormat", &a.ResponseFormat)
			delete(rawMsg, key)
		case "temperature":
			err = unpopulate(val, "Temperature", &a.Temperature)
			delete(rawMsg, key)
		}
		if err != nil {
			return fmt.Errorf("unmarshalling type %T: %v", a, err)
		}
	}
	return nil
}

// MarshalJSON implements the json.Marshaller interface for type AudioTranslationSegment.
func (a AudioTranslationSegment) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]any)
	populate(objectMap, "avg_logprob", a.AvgLogProb)
	populate(objectMap, "compression_ratio", a.CompressionRatio)
	populate(objectMap, "end", a.End)
	populate(objectMap, "id", a.ID)
	populate(objectMap, "no_speech_prob", a.NoSpeechProb)
	populate(objectMap, "seek", a.Seek)
	populate(objectMap, "start", a.Start)
	populate(objectMap, "temperature", a.Temperature)
	populate(objectMap, "text", a.Text)
	populate(objectMap, "tokens", a.Tokens)
	return json.Marshal(objectMap)
}

// UnmarshalJSON implements the json.Unmarshaller interface for type AudioTranslationSegment.
func (a *AudioTranslationSegment) UnmarshalJSON(data []byte) error {
	var rawMsg map[string]json.RawMessage
	if err := json.Unmarshal(data, &rawMsg); err != nil {
		return fmt.Errorf("unmarshalling type %T: %v", a, err)
	}
	for key, val := range rawMsg {
		var err error
		switch key {
		case "avg_logprob":
			err = unpopulate(val, "AvgLogprob", &a.AvgLogProb)
			delete(rawMsg, key)
		case "compression_ratio":
			err = unpopulate(val, "CompressionRatio", &a.CompressionRatio)
			delete(rawMsg, key)
		case "end":
			err = unpopulate(val, "End", &a.End)
			delete(rawMsg, key)
		case "id":
			err = unpopulate(val, "ID", &a.ID)
			delete(rawMsg, key)
		case "no_speech_prob":
			err = unpopulate(val, "NoSpeechProb", &a.NoSpeechProb)
			delete(rawMsg, key)
		case "seek":
			err = unpopulate(val, "Seek", &a.Seek)
			delete(rawMsg, key)
		case "start":
			err = unpopulate(val, "Start", &a.Start)
			delete(rawMsg, key)
		case "temperature":
			err = unpopulate(val, "Temperature", &a.Temperature)
			delete(rawMsg, key)
		case "text":
			err = unpopulate(val, "Text", &a.Text)
			delete(rawMsg, key)
		case "tokens":
			err = unpopulate(val, "Tokens", &a.Tokens)
			delete(rawMsg, key)
		}
		if err != nil {
			return fmt.Errorf("unmarshalling type %T: %v", a, err)
		}
	}
	return nil
}

// MarshalJSON implements the json.Marshaller interface for type AzureChatEnhancementConfiguration.
func (a AzureChatEnhancementConfiguration) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]any)
	populate(objectMap, "grounding", a.Grounding)
	populate(objectMap, "ocr", a.Ocr)
	return json.Marshal(objectMap)
}

// UnmarshalJSON implements the json.Unmarshaller interface for type AzureChatEnhancementConfiguration.
func (a *AzureChatEnhancementConfiguration) UnmarshalJSON(data []byte) error {
	var rawMsg map[string]json.RawMessage
	if err := json.Unmarshal(data, &rawMsg); err != nil {
		return fmt.Errorf("unmarshalling type %T: %v", a, err)
	}
	for key, val := range rawMsg {
		var err error
		switch key {
		case "grounding":
			err = unpopulate(val, "Grounding", &a.Grounding)
			delete(rawMsg, key)
		case "ocr":
			err = unpopulate(val, "Ocr", &a.Ocr)
			delete(rawMsg, key)
		}
		if err != nil {
			return fmt.Errorf("unmarshalling type %T: %v", a, err)
		}
	}
	return nil
}

// MarshalJSON implements the json.Marshaller interface for type AzureChatEnhancements.
func (a AzureChatEnhancements) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]any)
	populate(objectMap, "grounding", a.Grounding)
	return json.Marshal(objectMap)
}

// UnmarshalJSON implements the json.Unmarshaller interface for type AzureChatEnhancements.
func (a *AzureChatEnhancements) UnmarshalJSON(data []byte) error {
	var rawMsg map[string]json.RawMessage
	if err := json.Unmarshal(data, &rawMsg); err != nil {
		return fmt.Errorf("unmarshalling type %T: %v", a, err)
	}
	for key, val := range rawMsg {
		var err error
		switch key {
		case "grounding":
			err = unpopulate(val, "Grounding", &a.Grounding)
			delete(rawMsg, key)
		}
		if err != nil {
			return fmt.Errorf("unmarshalling type %T: %v", a, err)
		}
	}
	return nil
}

// MarshalJSON implements the json.Marshaller interface for type AzureChatExtensionConfiguration.
func (a AzureChatExtensionConfiguration) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]any)
	objectMap["type"] = a.configType
	return json.Marshal(objectMap)
}

// UnmarshalJSON implements the json.Unmarshaller interface for type AzureChatExtensionConfiguration.
func (a *AzureChatExtensionConfiguration) UnmarshalJSON(data []byte) error {
	var rawMsg map[string]json.RawMessage
	if err := json.Unmarshal(data, &rawMsg); err != nil {
		return fmt.Errorf("unmarshalling type %T: %v", a, err)
	}
	for key, val := range rawMsg {
		var err error
		switch key {
		case "type":
			err = unpopulate(val, "configType", &a.configType)
			delete(rawMsg, key)
		}
		if err != nil {
			return fmt.Errorf("unmarshalling type %T: %v", a, err)
		}
	}
	return nil
}

// MarshalJSON implements the json.Marshaller interface for type AzureChatExtensionDataSourceResponseCitation.
func (a AzureChatExtensionDataSourceResponseCitation) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]any)
	populate(objectMap, "chunk_id", a.ChunkID)
	populate(objectMap, "content", a.Content)
	populate(objectMap, "filepath", a.Filepath)
	populate(objectMap, "title", a.Title)
	populate(objectMap, "url", a.URL)
	return json.Marshal(objectMap)
}

// UnmarshalJSON implements the json.Unmarshaller interface for type AzureChatExtensionDataSourceResponseCitation.
func (a *AzureChatExtensionDataSourceResponseCitation) UnmarshalJSON(data []byte) error {
	var rawMsg map[string]json.RawMessage
	if err := json.Unmarshal(data, &rawMsg); err != nil {
		return fmt.Errorf("unmarshalling type %T: %v", a, err)
	}
	for key, val := range rawMsg {
		var err error
		switch key {
		case "chunk_id":
			err = unpopulate(val, "ChunkID", &a.ChunkID)
			delete(rawMsg, key)
		case "content":
			err = unpopulate(val, "Content", &a.Content)
			delete(rawMsg, key)
		case "filepath":
			err = unpopulate(val, "Filepath", &a.Filepath)
			delete(rawMsg, key)
		case "title":
			err = unpopulate(val, "Title", &a.Title)
			delete(rawMsg, key)
		case "url":
			err = unpopulate(val, "URL", &a.URL)
			delete(rawMsg, key)
		}
		if err != nil {
			return fmt.Errorf("unmarshalling type %T: %v", a, err)
		}
	}
	return nil
}

// MarshalJSON implements the json.Marshaller interface for type AzureChatExtensionsMessageContext.
func (a AzureChatExtensionsMessageContext) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]any)
	populate(objectMap, "citations", a.Citations)
	populate(objectMap, "intent", a.Intent)
	return json.Marshal(objectMap)
}

// UnmarshalJSON implements the json.Unmarshaller interface for type AzureChatExtensionsMessageContext.
func (a *AzureChatExtensionsMessageContext) UnmarshalJSON(data []byte) error {
	var rawMsg map[string]json.RawMessage
	if err := json.Unmarshal(data, &rawMsg); err != nil {
		return fmt.Errorf("unmarshalling type %T: %v", a, err)
	}
	for key, val := range rawMsg {
		var err error
		switch key {
		case "citations":
			err = unpopulate(val, "Citations", &a.Citations)
			delete(rawMsg, key)
		case "intent":
			err = unpopulate(val, "Intent", &a.Intent)
			delete(rawMsg, key)
		}
		if err != nil {
			return fmt.Errorf("unmarshalling type %T: %v", a, err)
		}
	}
	return nil
}

// MarshalJSON implements the json.Marshaller interface for type AzureChatGroundingEnhancementConfiguration.
func (a AzureChatGroundingEnhancementConfiguration) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]any)
	populate(objectMap, "enabled", a.Enabled)
	return json.Marshal(objectMap)
}

// UnmarshalJSON implements the json.Unmarshaller interface for type AzureChatGroundingEnhancementConfiguration.
func (a *AzureChatGroundingEnhancementConfiguration) UnmarshalJSON(data []byte) error {
	var rawMsg map[string]json.RawMessage
	if err := json.Unmarshal(data, &rawMsg); err != nil {
		return fmt.Errorf("unmarshalling type %T: %v", a, err)
	}
	for key, val := range rawMsg {
		var err error
		switch key {
		case "enabled":
			err = unpopulate(val, "Enabled", &a.Enabled)
			delete(rawMsg, key)
		}
		if err != nil {
			return fmt.Errorf("unmarshalling type %T: %v", a, err)
		}
	}
	return nil
}

// MarshalJSON implements the json.Marshaller interface for type AzureChatOCREnhancementConfiguration.
func (a AzureChatOCREnhancementConfiguration) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]any)
	populate(objectMap, "enabled", a.Enabled)
	return json.Marshal(objectMap)
}

// UnmarshalJSON implements the json.Unmarshaller interface for type AzureChatOCREnhancementConfiguration.
func (a *AzureChatOCREnhancementConfiguration) UnmarshalJSON(data []byte) error {
	var rawMsg map[string]json.RawMessage
	if err := json.Unmarshal(data, &rawMsg); err != nil {
		return fmt.Errorf("unmarshalling type %T: %v", a, err)
	}
	for key, val := range rawMsg {
		var err error
		switch key {
		case "enabled":
			err = unpopulate(val, "Enabled", &a.Enabled)
			delete(rawMsg, key)
		}
		if err != nil {
			return fmt.Errorf("unmarshalling type %T: %v", a, err)
		}
	}
	return nil
}

// MarshalJSON implements the json.Marshaller interface for type AzureCosmosDBChatExtensionConfiguration.
func (a AzureCosmosDBChatExtensionConfiguration) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]any)
	objectMap["type"] = AzureChatExtensionTypeAzureCosmosDB
	populate(objectMap, "parameters", a.Parameters)
	return json.Marshal(objectMap)
}

// UnmarshalJSON implements the json.Unmarshaller interface for type AzureCosmosDBChatExtensionConfiguration.
func (a *AzureCosmosDBChatExtensionConfiguration) UnmarshalJSON(data []byte) error {
	var rawMsg map[string]json.RawMessage
	if err := json.Unmarshal(data, &rawMsg); err != nil {
		return fmt.Errorf("unmarshalling type %T: %v", a, err)
	}
	for key, val := range rawMsg {
		var err error
		switch key {
		case "type":
			err = unpopulate(val, "configType", &a.configType)
			delete(rawMsg, key)
		case "parameters":
			err = unpopulate(val, "Parameters", &a.Parameters)
			delete(rawMsg, key)
		}
		if err != nil {
			return fmt.Errorf("unmarshalling type %T: %v", a, err)
		}
	}
	return nil
}

// MarshalJSON implements the json.Marshaller interface for type AzureCosmosDBChatExtensionParameters.
func (a AzureCosmosDBChatExtensionParameters) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]any)
	populate(objectMap, "authentication", a.Authentication)
	populate(objectMap, "container_name", a.ContainerName)
	populate(objectMap, "database_name", a.DatabaseName)
	populate(objectMap, "embedding_dependency", a.EmbeddingDependency)
	populate(objectMap, "fields_mapping", a.FieldsMapping)
	populate(objectMap, "in_scope", a.InScope)
	populate(objectMap, "index_name", a.IndexName)
	populate(objectMap, "role_information", a.RoleInformation)
	populate(objectMap, "strictness", a.Strictness)
	populate(objectMap, "top_n_documents", a.TopNDocuments)
	return json.Marshal(objectMap)
}

// UnmarshalJSON implements the json.Unmarshaller interface for type AzureCosmosDBChatExtensionParameters.
func (a *AzureCosmosDBChatExtensionParameters) UnmarshalJSON(data []byte) error {
	var rawMsg map[string]json.RawMessage
	if err := json.Unmarshal(data, &rawMsg); err != nil {
		return fmt.Errorf("unmarshalling type %T: %v", a, err)
	}
	for key, val := range rawMsg {
		var err error
		switch key {
		case "authentication":
			a.Authentication, err = unmarshalOnYourDataAuthenticationOptionsClassification(val)
			delete(rawMsg, key)
		case "container_name":
			err = unpopulate(val, "ContainerName", &a.ContainerName)
			delete(rawMsg, key)
		case "database_name":
			err = unpopulate(val, "DatabaseName", &a.DatabaseName)
			delete(rawMsg, key)
		case "embedding_dependency":
			a.EmbeddingDependency, err = unmarshalOnYourDataVectorizationSourceClassification(val)
			delete(rawMsg, key)
		case "fields_mapping":
			err = unpopulate(val, "FieldsMapping", &a.FieldsMapping)
			delete(rawMsg, key)
		case "in_scope":
			err = unpopulate(val, "InScope", &a.InScope)
			delete(rawMsg, key)
		case "index_name":
			err = unpopulate(val, "IndexName", &a.IndexName)
			delete(rawMsg, key)
		case "role_information":
			err = unpopulate(val, "RoleInformation", &a.RoleInformation)
			delete(rawMsg, key)
		case "strictness":
			err = unpopulate(val, "Strictness", &a.Strictness)
			delete(rawMsg, key)
		case "top_n_documents":
			err = unpopulate(val, "TopNDocuments", &a.TopNDocuments)
			delete(rawMsg, key)
		}
		if err != nil {
			return fmt.Errorf("unmarshalling type %T: %v", a, err)
		}
	}
	return nil
}

// MarshalJSON implements the json.Marshaller interface for type AzureCosmosDBFieldMappingOptions.
func (a AzureCosmosDBFieldMappingOptions) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]any)
	populate(objectMap, "content_fields", a.ContentFields)
	populate(objectMap, "content_fields_separator", a.ContentFieldsSeparator)
	populate(objectMap, "filepath_field", a.FilepathField)
	populate(objectMap, "title_field", a.TitleField)
	populate(objectMap, "url_field", a.URLField)
	populate(objectMap, "vector_fields", a.VectorFields)
	return json.Marshal(objectMap)
}

// UnmarshalJSON implements the json.Unmarshaller interface for type AzureCosmosDBFieldMappingOptions.
func (a *AzureCosmosDBFieldMappingOptions) UnmarshalJSON(data []byte) error {
	var rawMsg map[string]json.RawMessage
	if err := json.Unmarshal(data, &rawMsg); err != nil {
		return fmt.Errorf("unmarshalling type %T: %v", a, err)
	}
	for key, val := range rawMsg {
		var err error
		switch key {
		case "content_fields":
			err = unpopulate(val, "ContentFields", &a.ContentFields)
			delete(rawMsg, key)
		case "content_fields_separator":
			err = unpopulate(val, "ContentFieldsSeparator", &a.ContentFieldsSeparator)
			delete(rawMsg, key)
		case "filepath_field":
			err = unpopulate(val, "FilepathField", &a.FilepathField)
			delete(rawMsg, key)
		case "title_field":
			err = unpopulate(val, "TitleField", &a.TitleField)
			delete(rawMsg, key)
		case "url_field":
			err = unpopulate(val, "URLField", &a.URLField)
			delete(rawMsg, key)
		case "vector_fields":
			err = unpopulate(val, "VectorFields", &a.VectorFields)
			delete(rawMsg, key)
		}
		if err != nil {
			return fmt.Errorf("unmarshalling type %T: %v", a, err)
		}
	}
	return nil
}

// MarshalJSON implements the json.Marshaller interface for type AzureGroundingEnhancement.
func (a AzureGroundingEnhancement) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]any)
	populate(objectMap, "lines", a.Lines)
	return json.Marshal(objectMap)
}

// UnmarshalJSON implements the json.Unmarshaller interface for type AzureGroundingEnhancement.
func (a *AzureGroundingEnhancement) UnmarshalJSON(data []byte) error {
	var rawMsg map[string]json.RawMessage
	if err := json.Unmarshal(data, &rawMsg); err != nil {
		return fmt.Errorf("unmarshalling type %T: %v", a, err)
	}
	for key, val := range rawMsg {
		var err error
		switch key {
		case "lines":
			err = unpopulate(val, "Lines", &a.Lines)
			delete(rawMsg, key)
		}
		if err != nil {
			return fmt.Errorf("unmarshalling type %T: %v", a, err)
		}
	}
	return nil
}

// MarshalJSON implements the json.Marshaller interface for type AzureGroundingEnhancementCoordinatePoint.
func (a AzureGroundingEnhancementCoordinatePoint) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]any)
	populate(objectMap, "x", a.X)
	populate(objectMap, "y", a.Y)
	return json.Marshal(objectMap)
}

// UnmarshalJSON implements the json.Unmarshaller interface for type AzureGroundingEnhancementCoordinatePoint.
func (a *AzureGroundingEnhancementCoordinatePoint) UnmarshalJSON(data []byte) error {
	var rawMsg map[string]json.RawMessage
	if err := json.Unmarshal(data, &rawMsg); err != nil {
		return fmt.Errorf("unmarshalling type %T: %v", a, err)
	}
	for key, val := range rawMsg {
		var err error
		switch key {
		case "x":
			err = unpopulate(val, "X", &a.X)
			delete(rawMsg, key)
		case "y":
			err = unpopulate(val, "Y", &a.Y)
			delete(rawMsg, key)
		}
		if err != nil {
			return fmt.Errorf("unmarshalling type %T: %v", a, err)
		}
	}
	return nil
}

// MarshalJSON implements the json.Marshaller interface for type AzureGroundingEnhancementLine.
func (a AzureGroundingEnhancementLine) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]any)
	populate(objectMap, "spans", a.Spans)
	populate(objectMap, "text", a.Text)
	return json.Marshal(objectMap)
}

// UnmarshalJSON implements the json.Unmarshaller interface for type AzureGroundingEnhancementLine.
func (a *AzureGroundingEnhancementLine) UnmarshalJSON(data []byte) error {
	var rawMsg map[string]json.RawMessage
	if err := json.Unmarshal(data, &rawMsg); err != nil {
		return fmt.Errorf("unmarshalling type %T: %v", a, err)
	}
	for key, val := range rawMsg {
		var err error
		switch key {
		case "spans":
			err = unpopulate(val, "Spans", &a.Spans)
			delete(rawMsg, key)
		case "text":
			err = unpopulate(val, "Text", &a.Text)
			delete(rawMsg, key)
		}
		if err != nil {
			return fmt.Errorf("unmarshalling type %T: %v", a, err)
		}
	}
	return nil
}

// MarshalJSON implements the json.Marshaller interface for type AzureGroundingEnhancementLineSpan.
func (a AzureGroundingEnhancementLineSpan) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]any)
	populate(objectMap, "length", a.Length)
	populate(objectMap, "offset", a.Offset)
	populate(objectMap, "polygon", a.Polygon)
	populate(objectMap, "text", a.Text)
	return json.Marshal(objectMap)
}

// UnmarshalJSON implements the json.Unmarshaller interface for type AzureGroundingEnhancementLineSpan.
func (a *AzureGroundingEnhancementLineSpan) UnmarshalJSON(data []byte) error {
	var rawMsg map[string]json.RawMessage
	if err := json.Unmarshal(data, &rawMsg); err != nil {
		return fmt.Errorf("unmarshalling type %T: %v", a, err)
	}
	for key, val := range rawMsg {
		var err error
		switch key {
		case "length":
			err = unpopulate(val, "Length", &a.Length)
			delete(rawMsg, key)
		case "offset":
			err = unpopulate(val, "Offset", &a.Offset)
			delete(rawMsg, key)
		case "polygon":
			err = unpopulate(val, "Polygon", &a.Polygon)
			delete(rawMsg, key)
		case "text":
			err = unpopulate(val, "Text", &a.Text)
			delete(rawMsg, key)
		}
		if err != nil {
			return fmt.Errorf("unmarshalling type %T: %v", a, err)
		}
	}
	return nil
}

// MarshalJSON implements the json.Marshaller interface for type AzureMachineLearningIndexChatExtensionConfiguration.
func (a AzureMachineLearningIndexChatExtensionConfiguration) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]any)
	objectMap["type"] = AzureChatExtensionTypeAzureMachineLearningIndex
	populate(objectMap, "parameters", a.Parameters)
	return json.Marshal(objectMap)
}

// UnmarshalJSON implements the json.Unmarshaller interface for type AzureMachineLearningIndexChatExtensionConfiguration.
func (a *AzureMachineLearningIndexChatExtensionConfiguration) UnmarshalJSON(data []byte) error {
	var rawMsg map[string]json.RawMessage
	if err := json.Unmarshal(data, &rawMsg); err != nil {
		return fmt.Errorf("unmarshalling type %T: %v", a, err)
	}
	for key, val := range rawMsg {
		var err error
		switch key {
		case "type":
			err = unpopulate(val, "configType", &a.configType)
			delete(rawMsg, key)
		case "parameters":
			err = unpopulate(val, "Parameters", &a.Parameters)
			delete(rawMsg, key)
		}
		if err != nil {
			return fmt.Errorf("unmarshalling type %T: %v", a, err)
		}
	}
	return nil
}

// MarshalJSON implements the json.Marshaller interface for type AzureMachineLearningIndexChatExtensionParameters.
func (a AzureMachineLearningIndexChatExtensionParameters) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]any)
	populate(objectMap, "authentication", a.Authentication)
	populate(objectMap, "filter", a.Filter)
	populate(objectMap, "in_scope", a.InScope)
	populate(objectMap, "name", a.Name)
	populate(objectMap, "project_resource_id", a.ProjectResourceID)
	populate(objectMap, "role_information", a.RoleInformation)
	populate(objectMap, "strictness", a.Strictness)
	populate(objectMap, "top_n_documents", a.TopNDocuments)
	populate(objectMap, "version", a.Version)
	return json.Marshal(objectMap)
}

// UnmarshalJSON implements the json.Unmarshaller interface for type AzureMachineLearningIndexChatExtensionParameters.
func (a *AzureMachineLearningIndexChatExtensionParameters) UnmarshalJSON(data []byte) error {
	var rawMsg map[string]json.RawMessage
	if err := json.Unmarshal(data, &rawMsg); err != nil {
		return fmt.Errorf("unmarshalling type %T: %v", a, err)
	}
	for key, val := range rawMsg {
		var err error
		switch key {
		case "authentication":
			a.Authentication, err = unmarshalOnYourDataAuthenticationOptionsClassification(val)
			delete(rawMsg, key)
		case "filter":
			err = unpopulate(val, "Filter", &a.Filter)
			delete(rawMsg, key)
		case "in_scope":
			err = unpopulate(val, "InScope", &a.InScope)
			delete(rawMsg, key)
		case "name":
			err = unpopulate(val, "Name", &a.Name)
			delete(rawMsg, key)
		case "project_resource_id":
			err = unpopulate(val, "ProjectResourceID", &a.ProjectResourceID)
			delete(rawMsg, key)
		case "role_information":
			err = unpopulate(val, "RoleInformation", &a.RoleInformation)
			delete(rawMsg, key)
		case "strictness":
			err = unpopulate(val, "Strictness", &a.Strictness)
			delete(rawMsg, key)
		case "top_n_documents":
			err = unpopulate(val, "TopNDocuments", &a.TopNDocuments)
			delete(rawMsg, key)
		case "version":
			err = unpopulate(val, "Version", &a.Version)
			delete(rawMsg, key)
		}
		if err != nil {
			return fmt.Errorf("unmarshalling type %T: %v", a, err)
		}
	}
	return nil
}

// MarshalJSON implements the json.Marshaller interface for type AzureSearchChatExtensionConfiguration.
func (a AzureSearchChatExtensionConfiguration) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]any)
	objectMap["type"] = AzureChatExtensionTypeAzureSearch
	populate(objectMap, "parameters", a.Parameters)
	return json.Marshal(objectMap)
}

// UnmarshalJSON implements the json.Unmarshaller interface for type AzureSearchChatExtensionConfiguration.
func (a *AzureSearchChatExtensionConfiguration) UnmarshalJSON(data []byte) error {
	var rawMsg map[string]json.RawMessage
	if err := json.Unmarshal(data, &rawMsg); err != nil {
		return fmt.Errorf("unmarshalling type %T: %v", a, err)
	}
	for key, val := range rawMsg {
		var err error
		switch key {
		case "type":
			err = unpopulate(val, "configType", &a.configType)
			delete(rawMsg, key)
		case "parameters":
			err = unpopulate(val, "Parameters", &a.Parameters)
			delete(rawMsg, key)
		}
		if err != nil {
			return fmt.Errorf("unmarshalling type %T: %v", a, err)
		}
	}
	return nil
}

// MarshalJSON implements the json.Marshaller interface for type AzureSearchChatExtensionParameters.
func (a AzureSearchChatExtensionParameters) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]any)
	populate(objectMap, "authentication", a.Authentication)
	populate(objectMap, "embedding_dependency", a.EmbeddingDependency)
	populate(objectMap, "endpoint", a.Endpoint)
	populate(objectMap, "fields_mapping", a.FieldsMapping)
	populate(objectMap, "filter", a.Filter)
	populate(objectMap, "in_scope", a.InScope)
	populate(objectMap, "index_name", a.IndexName)
	populate(objectMap, "query_type", a.QueryType)
	populate(objectMap, "role_information", a.RoleInformation)
	populate(objectMap, "semantic_configuration", a.SemanticConfiguration)
	populate(objectMap, "strictness", a.Strictness)
	populate(objectMap, "top_n_documents", a.TopNDocuments)
	return json.Marshal(objectMap)
}

// UnmarshalJSON implements the json.Unmarshaller interface for type AzureSearchChatExtensionParameters.
func (a *AzureSearchChatExtensionParameters) UnmarshalJSON(data []byte) error {
	var rawMsg map[string]json.RawMessage
	if err := json.Unmarshal(data, &rawMsg); err != nil {
		return fmt.Errorf("unmarshalling type %T: %v", a, err)
	}
	for key, val := range rawMsg {
		var err error
		switch key {
		case "authentication":
			a.Authentication, err = unmarshalOnYourDataAuthenticationOptionsClassification(val)
			delete(rawMsg, key)
		case "embedding_dependency":
			a.EmbeddingDependency, err = unmarshalOnYourDataVectorizationSourceClassification(val)
			delete(rawMsg, key)
		case "endpoint":
			err = unpopulate(val, "Endpoint", &a.Endpoint)
			delete(rawMsg, key)
		case "fields_mapping":
			err = unpopulate(val, "FieldsMapping", &a.FieldsMapping)
			delete(rawMsg, key)
		case "filter":
			err = unpopulate(val, "Filter", &a.Filter)
			delete(rawMsg, key)
		case "in_scope":
			err = unpopulate(val, "InScope", &a.InScope)
			delete(rawMsg, key)
		case "index_name":
			err = unpopulate(val, "IndexName", &a.IndexName)
			delete(rawMsg, key)
		case "query_type":
			err = unpopulate(val, "QueryType", &a.QueryType)
			delete(rawMsg, key)
		case "role_information":
			err = unpopulate(val, "RoleInformation", &a.RoleInformation)
			delete(rawMsg, key)
		case "semantic_configuration":
			err = unpopulate(val, "SemanticConfiguration", &a.SemanticConfiguration)
			delete(rawMsg, key)
		case "strictness":
			err = unpopulate(val, "Strictness", &a.Strictness)
			delete(rawMsg, key)
		case "top_n_documents":
			err = unpopulate(val, "TopNDocuments", &a.TopNDocuments)
			delete(rawMsg, key)
		}
		if err != nil {
			return fmt.Errorf("unmarshalling type %T: %v", a, err)
		}
	}
	return nil
}

// MarshalJSON implements the json.Marshaller interface for type AzureSearchIndexFieldMappingOptions.
func (a AzureSearchIndexFieldMappingOptions) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]any)
	populate(objectMap, "content_fields", a.ContentFields)
	populate(objectMap, "content_fields_separator", a.ContentFieldsSeparator)
	populate(objectMap, "filepath_field", a.FilepathField)
	populate(objectMap, "image_vector_fields", a.ImageVectorFields)
	populate(objectMap, "title_field", a.TitleField)
	populate(objectMap, "url_field", a.URLField)
	populate(objectMap, "vector_fields", a.VectorFields)
	return json.Marshal(objectMap)
}

// UnmarshalJSON implements the json.Unmarshaller interface for type AzureSearchIndexFieldMappingOptions.
func (a *AzureSearchIndexFieldMappingOptions) UnmarshalJSON(data []byte) error {
	var rawMsg map[string]json.RawMessage
	if err := json.Unmarshal(data, &rawMsg); err != nil {
		return fmt.Errorf("unmarshalling type %T: %v", a, err)
	}
	for key, val := range rawMsg {
		var err error
		switch key {
		case "content_fields":
			err = unpopulate(val, "ContentFields", &a.ContentFields)
			delete(rawMsg, key)
		case "content_fields_separator":
			err = unpopulate(val, "ContentFieldsSeparator", &a.ContentFieldsSeparator)
			delete(rawMsg, key)
		case "filepath_field":
			err = unpopulate(val, "FilepathField", &a.FilepathField)
			delete(rawMsg, key)
		case "image_vector_fields":
			err = unpopulate(val, "ImageVectorFields", &a.ImageVectorFields)
			delete(rawMsg, key)
		case "title_field":
			err = unpopulate(val, "TitleField", &a.TitleField)
			delete(rawMsg, key)
		case "url_field":
			err = unpopulate(val, "URLField", &a.URLField)
			delete(rawMsg, key)
		case "vector_fields":
			err = unpopulate(val, "VectorFields", &a.VectorFields)
			delete(rawMsg, key)
		}
		if err != nil {
			return fmt.Errorf("unmarshalling type %T: %v", a, err)
		}
	}
	return nil
}

// MarshalJSON implements the json.Marshaller interface for type ChatChoice.
func (c ChatChoice) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]any)
	populate(objectMap, "content_filter_results", c.ContentFilterResults)
	populate(objectMap, "delta", c.Delta)
	populate(objectMap, "enhancements", c.Enhancements)
	populate(objectMap, "finish_details", c.FinishDetails)
	populate(objectMap, "finish_reason", c.FinishReason)
	populate(objectMap, "index", c.Index)
	populate(objectMap, "logprobs", c.LogProbs)
	populate(objectMap, "message", c.Message)
	return json.Marshal(objectMap)
}

// UnmarshalJSON implements the json.Unmarshaller interface for type ChatChoice.
func (c *ChatChoice) UnmarshalJSON(data []byte) error {
	var rawMsg map[string]json.RawMessage
	if err := json.Unmarshal(data, &rawMsg); err != nil {
		return fmt.Errorf("unmarshalling type %T: %v", c, err)
	}
	for key, val := range rawMsg {
		var err error
		switch key {
		case "content_filter_results":
			err = unpopulate(val, "ContentFilterResults", &c.ContentFilterResults)
			delete(rawMsg, key)
		case "delta":
			err = unpopulate(val, "Delta", &c.Delta)
			delete(rawMsg, key)
		case "enhancements":
			err = unpopulate(val, "Enhancements", &c.Enhancements)
			delete(rawMsg, key)
		case "finish_details":
			c.FinishDetails, err = unmarshalChatFinishDetailsClassification(val)
			delete(rawMsg, key)
		case "finish_reason":
			err = unpopulate(val, "FinishReason", &c.FinishReason)
			delete(rawMsg, key)
		case "index":
			err = unpopulate(val, "Index", &c.Index)
			delete(rawMsg, key)
		case "logprobs":
			err = unpopulate(val, "LogProbs", &c.LogProbs)
			delete(rawMsg, key)
		case "message":
			err = unpopulate(val, "Message", &c.Message)
			delete(rawMsg, key)
		}
		if err != nil {
			return fmt.Errorf("unmarshalling type %T: %v", c, err)
		}
	}
	return nil
}

// MarshalJSON implements the json.Marshaller interface for type ChatChoiceLogProbabilityInfo.
func (c ChatChoiceLogProbabilityInfo) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]any)
	populate(objectMap, "content", c.Content)
	return json.Marshal(objectMap)
}

// UnmarshalJSON implements the json.Unmarshaller interface for type ChatChoiceLogProbabilityInfo.
func (c *ChatChoiceLogProbabilityInfo) UnmarshalJSON(data []byte) error {
	var rawMsg map[string]json.RawMessage
	if err := json.Unmarshal(data, &rawMsg); err != nil {
		return fmt.Errorf("unmarshalling type %T: %v", c, err)
	}
	for key, val := range rawMsg {
		var err error
		switch key {
		case "content":
			err = unpopulate(val, "Content", &c.Content)
			delete(rawMsg, key)
		}
		if err != nil {
			return fmt.Errorf("unmarshalling type %T: %v", c, err)
		}
	}
	return nil
}

// MarshalJSON implements the json.Marshaller interface for type ChatChoiceLogProbs.
func (c ChatChoiceLogProbs) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]any)
	populate(objectMap, "content", c.Content)
	return json.Marshal(objectMap)
}

// UnmarshalJSON implements the json.Unmarshaller interface for type ChatChoiceLogProbs.
func (c *ChatChoiceLogProbs) UnmarshalJSON(data []byte) error {
	var rawMsg map[string]json.RawMessage
	if err := json.Unmarshal(data, &rawMsg); err != nil {
		return fmt.Errorf("unmarshalling type %T: %v", c, err)
	}
	for key, val := range rawMsg {
		var err error
		switch key {
		case "content":
			err = unpopulate(val, "Content", &c.Content)
			delete(rawMsg, key)
		}
		if err != nil {
			return fmt.Errorf("unmarshalling type %T: %v", c, err)
		}
	}
	return nil
}

// MarshalJSON implements the json.Marshaller interface for type ChatCompletionRequestMessageContentPart.
func (c ChatCompletionRequestMessageContentPart) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]any)
	objectMap["type"] = c.partType
	return json.Marshal(objectMap)
}

// UnmarshalJSON implements the json.Unmarshaller interface for type ChatCompletionRequestMessageContentPart.
func (c *ChatCompletionRequestMessageContentPart) UnmarshalJSON(data []byte) error {
	var rawMsg map[string]json.RawMessage
	if err := json.Unmarshal(data, &rawMsg); err != nil {
		return fmt.Errorf("unmarshalling type %T: %v", c, err)
	}
	for key, val := range rawMsg {
		var err error
		switch key {
		case "type":
			err = unpopulate(val, "partType", &c.partType)
			delete(rawMsg, key)
		}
		if err != nil {
			return fmt.Errorf("unmarshalling type %T: %v", c, err)
		}
	}
	return nil
}

// MarshalJSON implements the json.Marshaller interface for type ChatCompletionRequestMessageContentPartImage.
func (c ChatCompletionRequestMessageContentPartImage) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]any)
	objectMap["type"] = ChatCompletionRequestMessageContentPartTypeImageURL
	populate(objectMap, "image_url", c.ImageURL)
	return json.Marshal(objectMap)
}

// UnmarshalJSON implements the json.Unmarshaller interface for type ChatCompletionRequestMessageContentPartImage.
func (c *ChatCompletionRequestMessageContentPartImage) UnmarshalJSON(data []byte) error {
	var rawMsg map[string]json.RawMessage
	if err := json.Unmarshal(data, &rawMsg); err != nil {
		return fmt.Errorf("unmarshalling type %T: %v", c, err)
	}
	for key, val := range rawMsg {
		var err error
		switch key {
		case "type":
			err = unpopulate(val, "partType", &c.partType)
			delete(rawMsg, key)
		case "image_url":
			err = unpopulate(val, "ImageURL", &c.ImageURL)
			delete(rawMsg, key)
		}
		if err != nil {
			return fmt.Errorf("unmarshalling type %T: %v", c, err)
		}
	}
	return nil
}

// MarshalJSON implements the json.Marshaller interface for type ChatCompletionRequestMessageContentPartImageURL.
func (c ChatCompletionRequestMessageContentPartImageURL) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]any)
	populate(objectMap, "detail", c.Detail)
	populate(objectMap, "url", c.URL)
	return json.Marshal(objectMap)
}

// UnmarshalJSON implements the json.Unmarshaller interface for type ChatCompletionRequestMessageContentPartImageURL.
func (c *ChatCompletionRequestMessageContentPartImageURL) UnmarshalJSON(data []byte) error {
	var rawMsg map[string]json.RawMessage
	if err := json.Unmarshal(data, &rawMsg); err != nil {
		return fmt.Errorf("unmarshalling type %T: %v", c, err)
	}
	for key, val := range rawMsg {
		var err error
		switch key {
		case "detail":
			err = unpopulate(val, "Detail", &c.Detail)
			delete(rawMsg, key)
		case "url":
			err = unpopulate(val, "URL", &c.URL)
			delete(rawMsg, key)
		}
		if err != nil {
			return fmt.Errorf("unmarshalling type %T: %v", c, err)
		}
	}
	return nil
}

// MarshalJSON implements the json.Marshaller interface for type ChatCompletionRequestMessageContentPartText.
func (c ChatCompletionRequestMessageContentPartText) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]any)
	objectMap["type"] = ChatCompletionRequestMessageContentPartTypeText
	populate(objectMap, "text", c.Text)
	return json.Marshal(objectMap)
}

// UnmarshalJSON implements the json.Unmarshaller interface for type ChatCompletionRequestMessageContentPartText.
func (c *ChatCompletionRequestMessageContentPartText) UnmarshalJSON(data []byte) error {
	var rawMsg map[string]json.RawMessage
	if err := json.Unmarshal(data, &rawMsg); err != nil {
		return fmt.Errorf("unmarshalling type %T: %v", c, err)
	}
	for key, val := range rawMsg {
		var err error
		switch key {
		case "type":
			err = unpopulate(val, "partType", &c.partType)
			delete(rawMsg, key)
		case "text":
			err = unpopulate(val, "Text", &c.Text)
			delete(rawMsg, key)
		}
		if err != nil {
			return fmt.Errorf("unmarshalling type %T: %v", c, err)
		}
	}
	return nil
}

// MarshalJSON implements the json.Marshaller interface for type ChatCompletions.
func (c ChatCompletions) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]any)
	populate(objectMap, "choices", c.Choices)
	populateTimeUnix(objectMap, "created", c.Created)
	populate(objectMap, "id", c.ID)
	populate(objectMap, "model", c.Model)
	populate(objectMap, "prompt_filter_results", c.PromptFilterResults)
	populate(objectMap, "system_fingerprint", c.SystemFingerprint)
	populate(objectMap, "usage", c.Usage)
	return json.Marshal(objectMap)
}

// UnmarshalJSON implements the json.Unmarshaller interface for type ChatCompletions.
func (c *ChatCompletions) UnmarshalJSON(data []byte) error {
	var rawMsg map[string]json.RawMessage
	if err := json.Unmarshal(data, &rawMsg); err != nil {
		return fmt.Errorf("unmarshalling type %T: %v", c, err)
	}
	for key, val := range rawMsg {
		var err error
		switch key {
		case "choices":
			err = unpopulate(val, "Choices", &c.Choices)
			delete(rawMsg, key)
		case "created":
			err = unpopulateTimeUnix(val, "Created", &c.Created)
			delete(rawMsg, key)
		case "id":
			err = unpopulate(val, "ID", &c.ID)
			delete(rawMsg, key)
		case "model":
			err = unpopulate(val, "Model", &c.Model)
			delete(rawMsg, key)
		case "prompt_annotations":
			fallthrough
		case "prompt_filter_results":
			err = unpopulate(val, "PromptFilterResults", &c.PromptFilterResults)
			delete(rawMsg, key)
		case "system_fingerprint":
			err = unpopulate(val, "SystemFingerprint", &c.SystemFingerprint)
			delete(rawMsg, key)
		case "usage":
			err = unpopulate(val, "Usage", &c.Usage)
			delete(rawMsg, key)
		}
		if err != nil {
			return fmt.Errorf("unmarshalling type %T: %v", c, err)
		}
	}
	return nil
}

// MarshalJSON implements the json.Marshaller interface for type ChatCompletionsFunctionToolCall.
func (c ChatCompletionsFunctionToolCall) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]any)
	populate(objectMap, "function", c.Function)
	populate(objectMap, "id", c.ID)
	objectMap["type"] = "function"
	return json.Marshal(objectMap)
}

// UnmarshalJSON implements the json.Unmarshaller interface for type ChatCompletionsFunctionToolCall.
func (c *ChatCompletionsFunctionToolCall) UnmarshalJSON(data []byte) error {
	var rawMsg map[string]json.RawMessage
	if err := json.Unmarshal(data, &rawMsg); err != nil {
		return fmt.Errorf("unmarshalling type %T: %v", c, err)
	}
	for key, val := range rawMsg {
		var err error
		switch key {
		case "function":
			err = unpopulate(val, "Function", &c.Function)
			delete(rawMsg, key)
		case "id":
			err = unpopulate(val, "ID", &c.ID)
			delete(rawMsg, key)
		case "type":
			err = unpopulate(val, "Type", &c.Type)
			delete(rawMsg, key)
		}
		if err != nil {
			return fmt.Errorf("unmarshalling type %T: %v", c, err)
		}
	}
	return nil
}

// MarshalJSON implements the json.Marshaller interface for type ChatCompletionsFunctionToolDefinition.
func (c ChatCompletionsFunctionToolDefinition) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]any)
	populate(objectMap, "function", c.Function)
	objectMap["type"] = "function"
	return json.Marshal(objectMap)
}

// UnmarshalJSON implements the json.Unmarshaller interface for type ChatCompletionsFunctionToolDefinition.
func (c *ChatCompletionsFunctionToolDefinition) UnmarshalJSON(data []byte) error {
	var rawMsg map[string]json.RawMessage
	if err := json.Unmarshal(data, &rawMsg); err != nil {
		return fmt.Errorf("unmarshalling type %T: %v", c, err)
	}
	for key, val := range rawMsg {
		var err error
		switch key {
		case "function":
			err = unpopulate(val, "Function", &c.Function)
			delete(rawMsg, key)
		case "type":
			err = unpopulate(val, "Type", &c.Type)
			delete(rawMsg, key)
		}
		if err != nil {
			return fmt.Errorf("unmarshalling type %T: %v", c, err)
		}
	}
	return nil
}

// MarshalJSON implements the json.Marshaller interface for type ChatCompletionsFunctionToolSelection.
func (c ChatCompletionsFunctionToolSelection) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]any)
	populate(objectMap, "name", c.Name)
	return json.Marshal(objectMap)
}

// UnmarshalJSON implements the json.Unmarshaller interface for type ChatCompletionsFunctionToolSelection.
func (c *ChatCompletionsFunctionToolSelection) UnmarshalJSON(data []byte) error {
	var rawMsg map[string]json.RawMessage
	if err := json.Unmarshal(data, &rawMsg); err != nil {
		return fmt.Errorf("unmarshalling type %T: %v", c, err)
	}
	for key, val := range rawMsg {
		var err error
		switch key {
		case "name":
			err = unpopulate(val, "Name", &c.Name)
			delete(rawMsg, key)
		}
		if err != nil {
			return fmt.Errorf("unmarshalling type %T: %v", c, err)
		}
	}
	return nil
}

// MarshalJSON implements the json.Marshaller interface for type ChatCompletionsJSONResponseFormat.
func (c ChatCompletionsJSONResponseFormat) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]any)
	objectMap["type"] = "json_object"
	return json.Marshal(objectMap)
}

// UnmarshalJSON implements the json.Unmarshaller interface for type ChatCompletionsJSONResponseFormat.
func (c *ChatCompletionsJSONResponseFormat) UnmarshalJSON(data []byte) error {
	var rawMsg map[string]json.RawMessage
	if err := json.Unmarshal(data, &rawMsg); err != nil {
		return fmt.Errorf("unmarshalling type %T: %v", c, err)
	}
	for key, val := range rawMsg {
		var err error
		switch key {
		case "type":
			err = unpopulate(val, "respType", &c.respType)
			delete(rawMsg, key)
		}
		if err != nil {
			return fmt.Errorf("unmarshalling type %T: %v", c, err)
		}
	}
	return nil
}

// MarshalJSON implements the json.Marshaller interface for type ChatCompletionsNamedFunctionToolSelection.
func (c ChatCompletionsNamedFunctionToolSelection) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]any)
	populate(objectMap, "function", c.Function)
	objectMap["type"] = "function"
	return json.Marshal(objectMap)
}

// UnmarshalJSON implements the json.Unmarshaller interface for type ChatCompletionsNamedFunctionToolSelection.
func (c *ChatCompletionsNamedFunctionToolSelection) UnmarshalJSON(data []byte) error {
	var rawMsg map[string]json.RawMessage
	if err := json.Unmarshal(data, &rawMsg); err != nil {
		return fmt.Errorf("unmarshalling type %T: %v", c, err)
	}
	for key, val := range rawMsg {
		var err error
		switch key {
		case "function":
			err = unpopulate(val, "Function", &c.Function)
			delete(rawMsg, key)
		case "type":
			err = unpopulate(val, "Type", &c.Type)
			delete(rawMsg, key)
		}
		if err != nil {
			return fmt.Errorf("unmarshalling type %T: %v", c, err)
		}
	}
	return nil
}

// MarshalJSON implements the json.Marshaller interface for type ChatCompletionsNamedToolSelection.
func (c ChatCompletionsNamedToolSelection) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]any)
	objectMap["type"] = c.Type
	return json.Marshal(objectMap)
}

// UnmarshalJSON implements the json.Unmarshaller interface for type ChatCompletionsNamedToolSelection.
func (c *ChatCompletionsNamedToolSelection) UnmarshalJSON(data []byte) error {
	var rawMsg map[string]json.RawMessage
	if err := json.Unmarshal(data, &rawMsg); err != nil {
		return fmt.Errorf("unmarshalling type %T: %v", c, err)
	}
	for key, val := range rawMsg {
		var err error
		switch key {
		case "type":
			err = unpopulate(val, "Type", &c.Type)
			delete(rawMsg, key)
		}
		if err != nil {
			return fmt.Errorf("unmarshalling type %T: %v", c, err)
		}
	}
	return nil
}

// MarshalJSON implements the json.Marshaller interface for type ChatCompletionsOptions.
func (c ChatCompletionsOptions) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]any)
	populate(objectMap, "data_sources", c.AzureExtensionsOptions)
	populate(objectMap, "enhancements", c.Enhancements)
	populate(objectMap, "frequency_penalty", c.FrequencyPenalty)
	populate(objectMap, "function_call", c.FunctionCall)
	populate(objectMap, "functions", c.Functions)
	populate(objectMap, "logit_bias", c.LogitBias)
	populate(objectMap, "logprobs", c.LogProbs)
	populate(objectMap, "max_tokens", c.MaxTokens)
	populate(objectMap, "messages", c.Messages)
	populate(objectMap, "model", c.DeploymentName)
	populate(objectMap, "n", c.N)
	populate(objectMap, "presence_penalty", c.PresencePenalty)
	populate(objectMap, "response_format", c.ResponseFormat)
	populate(objectMap, "seed", c.Seed)
	populate(objectMap, "stop", c.Stop)
	populate(objectMap, "temperature", c.Temperature)
	populate(objectMap, "tool_choice", c.ToolChoice)
	populate(objectMap, "tools", c.Tools)
	populate(objectMap, "top_logprobs", c.TopLogProbs)
	populate(objectMap, "top_p", c.TopP)
	populate(objectMap, "user", c.User)
	return json.Marshal(objectMap)
}

// UnmarshalJSON implements the json.Unmarshaller interface for type ChatCompletionsOptions.
func (c *ChatCompletionsOptions) UnmarshalJSON(data []byte) error {
	var rawMsg map[string]json.RawMessage
	if err := json.Unmarshal(data, &rawMsg); err != nil {
		return fmt.Errorf("unmarshalling type %T: %v", c, err)
	}
	for key, val := range rawMsg {
		var err error
		switch key {
		case "data_sources":
			c.AzureExtensionsOptions, err = unmarshalAzureChatExtensionConfigurationClassificationArray(val)
			delete(rawMsg, key)
		case "enhancements":
			err = unpopulate(val, "Enhancements", &c.Enhancements)
			delete(rawMsg, key)
		case "frequency_penalty":
			err = unpopulate(val, "FrequencyPenalty", &c.FrequencyPenalty)
			delete(rawMsg, key)
		case "function_call":
			err = unpopulate(val, "FunctionCall", &c.FunctionCall)
			delete(rawMsg, key)
		case "functions":
			err = unpopulate(val, "Functions", &c.Functions)
			delete(rawMsg, key)
		case "logit_bias":
			err = unpopulate(val, "LogitBias", &c.LogitBias)
			delete(rawMsg, key)
		case "logprobs":
			err = unpopulate(val, "LogProbs", &c.LogProbs)
			delete(rawMsg, key)
		case "max_tokens":
			err = unpopulate(val, "MaxTokens", &c.MaxTokens)
			delete(rawMsg, key)
		case "messages":
			c.Messages, err = unmarshalChatRequestMessageClassificationArray(val)
			delete(rawMsg, key)
		case "model":
			err = unpopulate(val, "Model", &c.DeploymentName)
			delete(rawMsg, key)
		case "n":
			err = unpopulate(val, "N", &c.N)
			delete(rawMsg, key)
		case "presence_penalty":
			err = unpopulate(val, "PresencePenalty", &c.PresencePenalty)
			delete(rawMsg, key)
		case "response_format":
			c.ResponseFormat, err = unmarshalChatCompletionsResponseFormatClassification(val)
			delete(rawMsg, key)
		case "seed":
			err = unpopulate(val, "Seed", &c.Seed)
			delete(rawMsg, key)
		case "stop":
			err = unpopulate(val, "Stop", &c.Stop)
			delete(rawMsg, key)
		case "temperature":
			err = unpopulate(val, "Temperature", &c.Temperature)
			delete(rawMsg, key)
		case "tool_choice":
			err = unpopulate(val, "ToolChoice", &c.ToolChoice)
			delete(rawMsg, key)
		case "tools":
			c.Tools, err = unmarshalChatCompletionsToolDefinitionClassificationArray(val)
			delete(rawMsg, key)
		case "top_logprobs":
			err = unpopulate(val, "TopLogProbs", &c.TopLogProbs)
			delete(rawMsg, key)
		case "top_p":
			err = unpopulate(val, "TopP", &c.TopP)
			delete(rawMsg, key)
		case "user":
			err = unpopulate(val, "User", &c.User)
			delete(rawMsg, key)
		}
		if err != nil {
			return fmt.Errorf("unmarshalling type %T: %v", c, err)
		}
	}
	return nil
}

// MarshalJSON implements the json.Marshaller interface for type ChatCompletionsResponseFormat.
func (c ChatCompletionsResponseFormat) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]any)
	objectMap["type"] = c.respType
	return json.Marshal(objectMap)
}

// UnmarshalJSON implements the json.Unmarshaller interface for type ChatCompletionsResponseFormat.
func (c *ChatCompletionsResponseFormat) UnmarshalJSON(data []byte) error {
	var rawMsg map[string]json.RawMessage
	if err := json.Unmarshal(data, &rawMsg); err != nil {
		return fmt.Errorf("unmarshalling type %T: %v", c, err)
	}
	for key, val := range rawMsg {
		var err error
		switch key {
		case "type":
			err = unpopulate(val, "respType", &c.respType)
			delete(rawMsg, key)
		}
		if err != nil {
			return fmt.Errorf("unmarshalling type %T: %v", c, err)
		}
	}
	return nil
}

// MarshalJSON implements the json.Marshaller interface for type ChatCompletionsTextResponseFormat.
func (c ChatCompletionsTextResponseFormat) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]any)
	objectMap["type"] = "text"
	return json.Marshal(objectMap)
}

// UnmarshalJSON implements the json.Unmarshaller interface for type ChatCompletionsTextResponseFormat.
func (c *ChatCompletionsTextResponseFormat) UnmarshalJSON(data []byte) error {
	var rawMsg map[string]json.RawMessage
	if err := json.Unmarshal(data, &rawMsg); err != nil {
		return fmt.Errorf("unmarshalling type %T: %v", c, err)
	}
	for key, val := range rawMsg {
		var err error
		switch key {
		case "type":
			err = unpopulate(val, "respType", &c.respType)
			delete(rawMsg, key)
		}
		if err != nil {
			return fmt.Errorf("unmarshalling type %T: %v", c, err)
		}
	}
	return nil
}

// MarshalJSON implements the json.Marshaller interface for type ChatCompletionsToolCall.
func (c ChatCompletionsToolCall) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]any)
	populate(objectMap, "id", c.ID)
	objectMap["type"] = c.Type
	return json.Marshal(objectMap)
}

// UnmarshalJSON implements the json.Unmarshaller interface for type ChatCompletionsToolCall.
func (c *ChatCompletionsToolCall) UnmarshalJSON(data []byte) error {
	var rawMsg map[string]json.RawMessage
	if err := json.Unmarshal(data, &rawMsg); err != nil {
		return fmt.Errorf("unmarshalling type %T: %v", c, err)
	}
	for key, val := range rawMsg {
		var err error
		switch key {
		case "id":
			err = unpopulate(val, "ID", &c.ID)
			delete(rawMsg, key)
		case "type":
			err = unpopulate(val, "Type", &c.Type)
			delete(rawMsg, key)
		}
		if err != nil {
			return fmt.Errorf("unmarshalling type %T: %v", c, err)
		}
	}
	return nil
}

// MarshalJSON implements the json.Marshaller interface for type ChatCompletionsToolDefinition.
func (c ChatCompletionsToolDefinition) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]any)
	objectMap["type"] = c.Type
	return json.Marshal(objectMap)
}

// UnmarshalJSON implements the json.Unmarshaller interface for type ChatCompletionsToolDefinition.
func (c *ChatCompletionsToolDefinition) UnmarshalJSON(data []byte) error {
	var rawMsg map[string]json.RawMessage
	if err := json.Unmarshal(data, &rawMsg); err != nil {
		return fmt.Errorf("unmarshalling type %T: %v", c, err)
	}
	for key, val := range rawMsg {
		var err error
		switch key {
		case "type":
			err = unpopulate(val, "Type", &c.Type)
			delete(rawMsg, key)
		}
		if err != nil {
			return fmt.Errorf("unmarshalling type %T: %v", c, err)
		}
	}
	return nil
}

// MarshalJSON implements the json.Marshaller interface for type ChatFinishDetails.
func (c ChatFinishDetails) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]any)
	objectMap["type"] = c.Type
	return json.Marshal(objectMap)
}

// UnmarshalJSON implements the json.Unmarshaller interface for type ChatFinishDetails.
func (c *ChatFinishDetails) UnmarshalJSON(data []byte) error {
	var rawMsg map[string]json.RawMessage
	if err := json.Unmarshal(data, &rawMsg); err != nil {
		return fmt.Errorf("unmarshalling type %T: %v", c, err)
	}
	for key, val := range rawMsg {
		var err error
		switch key {
		case "type":
			err = unpopulate(val, "Type", &c.Type)
			delete(rawMsg, key)
		}
		if err != nil {
			return fmt.Errorf("unmarshalling type %T: %v", c, err)
		}
	}
	return nil
}

// MarshalJSON implements the json.Marshaller interface for type ChatMessageContentItem.
func (c ChatMessageContentItem) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]any)
	objectMap["type"] = c.Type
	return json.Marshal(objectMap)
}

// UnmarshalJSON implements the json.Unmarshaller interface for type ChatMessageContentItem.
func (c *ChatMessageContentItem) UnmarshalJSON(data []byte) error {
	var rawMsg map[string]json.RawMessage
	if err := json.Unmarshal(data, &rawMsg); err != nil {
		return fmt.Errorf("unmarshalling type %T: %v", c, err)
	}
	for key, val := range rawMsg {
		var err error
		switch key {
		case "type":
			err = unpopulate(val, "Type", &c.Type)
			delete(rawMsg, key)
		}
		if err != nil {
			return fmt.Errorf("unmarshalling type %T: %v", c, err)
		}
	}
	return nil
}

// MarshalJSON implements the json.Marshaller interface for type ChatMessageImageContentItem.
func (c ChatMessageImageContentItem) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]any)
	populate(objectMap, "image_url", c.ImageURL)
	objectMap["type"] = "image_url"
	return json.Marshal(objectMap)
}

// UnmarshalJSON implements the json.Unmarshaller interface for type ChatMessageImageContentItem.
func (c *ChatMessageImageContentItem) UnmarshalJSON(data []byte) error {
	var rawMsg map[string]json.RawMessage
	if err := json.Unmarshal(data, &rawMsg); err != nil {
		return fmt.Errorf("unmarshalling type %T: %v", c, err)
	}
	for key, val := range rawMsg {
		var err error
		switch key {
		case "image_url":
			err = unpopulate(val, "ImageURL", &c.ImageURL)
			delete(rawMsg, key)
		case "type":
			err = unpopulate(val, "Type", &c.Type)
			delete(rawMsg, key)
		}
		if err != nil {
			return fmt.Errorf("unmarshalling type %T: %v", c, err)
		}
	}
	return nil
}

// MarshalJSON implements the json.Marshaller interface for type ChatMessageImageURL.
func (c ChatMessageImageURL) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]any)
	populate(objectMap, "detail", c.Detail)
	populate(objectMap, "url", c.URL)
	return json.Marshal(objectMap)
}

// UnmarshalJSON implements the json.Unmarshaller interface for type ChatMessageImageURL.
func (c *ChatMessageImageURL) UnmarshalJSON(data []byte) error {
	var rawMsg map[string]json.RawMessage
	if err := json.Unmarshal(data, &rawMsg); err != nil {
		return fmt.Errorf("unmarshalling type %T: %v", c, err)
	}
	for key, val := range rawMsg {
		var err error
		switch key {
		case "detail":
			err = unpopulate(val, "Detail", &c.Detail)
			delete(rawMsg, key)
		case "url":
			err = unpopulate(val, "URL", &c.URL)
			delete(rawMsg, key)
		}
		if err != nil {
			return fmt.Errorf("unmarshalling type %T: %v", c, err)
		}
	}
	return nil
}

// MarshalJSON implements the json.Marshaller interface for type ChatMessageTextContentItem.
func (c ChatMessageTextContentItem) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]any)
	populate(objectMap, "text", c.Text)
	objectMap["type"] = "text"
	return json.Marshal(objectMap)
}

// UnmarshalJSON implements the json.Unmarshaller interface for type ChatMessageTextContentItem.
func (c *ChatMessageTextContentItem) UnmarshalJSON(data []byte) error {
	var rawMsg map[string]json.RawMessage
	if err := json.Unmarshal(data, &rawMsg); err != nil {
		return fmt.Errorf("unmarshalling type %T: %v", c, err)
	}
	for key, val := range rawMsg {
		var err error
		switch key {
		case "text":
			err = unpopulate(val, "Text", &c.Text)
			delete(rawMsg, key)
		case "type":
			err = unpopulate(val, "Type", &c.Type)
			delete(rawMsg, key)
		}
		if err != nil {
			return fmt.Errorf("unmarshalling type %T: %v", c, err)
		}
	}
	return nil
}

// MarshalJSON implements the json.Marshaller interface for type ChatRequestAssistantMessage.
func (c ChatRequestAssistantMessage) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]any)
	populate(objectMap, "content", c.Content)
	populate(objectMap, "function_call", c.FunctionCall)
	objectMap["role"] = ChatRoleAssistant
	populate(objectMap, "name", c.Name)
	populate(objectMap, "tool_calls", c.ToolCalls)
	return json.Marshal(objectMap)
}

// UnmarshalJSON implements the json.Unmarshaller interface for type ChatRequestAssistantMessage.
func (c *ChatRequestAssistantMessage) UnmarshalJSON(data []byte) error {
	var rawMsg map[string]json.RawMessage
	if err := json.Unmarshal(data, &rawMsg); err != nil {
		return fmt.Errorf("unmarshalling type %T: %v", c, err)
	}
	for key, val := range rawMsg {
		var err error
		switch key {
		case "content":
			err = unpopulate(val, "Content", &c.Content)
			delete(rawMsg, key)
		case "function_call":
			err = unpopulate(val, "FunctionCall", &c.FunctionCall)
			delete(rawMsg, key)
		case "role":
			err = unpopulate(val, "role", &c.role)
			delete(rawMsg, key)
		case "name":
			err = unpopulate(val, "Name", &c.Name)
			delete(rawMsg, key)
		case "tool_calls":
			c.ToolCalls, err = unmarshalChatCompletionsToolCallClassificationArray(val)
			delete(rawMsg, key)
		}
		if err != nil {
			return fmt.Errorf("unmarshalling type %T: %v", c, err)
		}
	}
	return nil
}

// MarshalJSON implements the json.Marshaller interface for type ChatRequestFunctionMessage.
func (c ChatRequestFunctionMessage) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]any)
	populate(objectMap, "content", c.Content)
	objectMap["role"] = ChatRoleFunction
	populate(objectMap, "name", c.Name)
	return json.Marshal(objectMap)
}

// UnmarshalJSON implements the json.Unmarshaller interface for type ChatRequestFunctionMessage.
func (c *ChatRequestFunctionMessage) UnmarshalJSON(data []byte) error {
	var rawMsg map[string]json.RawMessage
	if err := json.Unmarshal(data, &rawMsg); err != nil {
		return fmt.Errorf("unmarshalling type %T: %v", c, err)
	}
	for key, val := range rawMsg {
		var err error
		switch key {
		case "content":
			err = unpopulate(val, "Content", &c.Content)
			delete(rawMsg, key)
		case "role":
			err = unpopulate(val, "role", &c.role)
			delete(rawMsg, key)
		case "name":
			err = unpopulate(val, "Name", &c.Name)
			delete(rawMsg, key)
		}
		if err != nil {
			return fmt.Errorf("unmarshalling type %T: %v", c, err)
		}
	}
	return nil
}

// MarshalJSON implements the json.Marshaller interface for type ChatRequestMessage.
func (c ChatRequestMessage) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]any)
	objectMap["role"] = c.role
	return json.Marshal(objectMap)
}

// UnmarshalJSON implements the json.Unmarshaller interface for type ChatRequestMessage.
func (c *ChatRequestMessage) UnmarshalJSON(data []byte) error {
	var rawMsg map[string]json.RawMessage
	if err := json.Unmarshal(data, &rawMsg); err != nil {
		return fmt.Errorf("unmarshalling type %T: %v", c, err)
	}
	for key, val := range rawMsg {
		var err error
		switch key {
		case "role":
			err = unpopulate(val, "role", &c.role)
			delete(rawMsg, key)
		}
		if err != nil {
			return fmt.Errorf("unmarshalling type %T: %v", c, err)
		}
	}
	return nil
}

// MarshalJSON implements the json.Marshaller interface for type ChatRequestSystemMessage.
func (c ChatRequestSystemMessage) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]any)
	populate(objectMap, "content", c.Content)
	objectMap["role"] = ChatRoleSystem
	populate(objectMap, "name", c.Name)
	return json.Marshal(objectMap)
}

// UnmarshalJSON implements the json.Unmarshaller interface for type ChatRequestSystemMessage.
func (c *ChatRequestSystemMessage) UnmarshalJSON(data []byte) error {
	var rawMsg map[string]json.RawMessage
	if err := json.Unmarshal(data, &rawMsg); err != nil {
		return fmt.Errorf("unmarshalling type %T: %v", c, err)
	}
	for key, val := range rawMsg {
		var err error
		switch key {
		case "content":
			err = unpopulate(val, "Content", &c.Content)
			delete(rawMsg, key)
		case "role":
			err = unpopulate(val, "role", &c.role)
			delete(rawMsg, key)
		case "name":
			err = unpopulate(val, "Name", &c.Name)
			delete(rawMsg, key)
		}
		if err != nil {
			return fmt.Errorf("unmarshalling type %T: %v", c, err)
		}
	}
	return nil
}

// MarshalJSON implements the json.Marshaller interface for type ChatRequestToolMessage.
func (c ChatRequestToolMessage) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]any)
	populate(objectMap, "content", c.Content)
	objectMap["role"] = ChatRoleTool
	populate(objectMap, "tool_call_id", c.ToolCallID)
	return json.Marshal(objectMap)
}

// UnmarshalJSON implements the json.Unmarshaller interface for type ChatRequestToolMessage.
func (c *ChatRequestToolMessage) UnmarshalJSON(data []byte) error {
	var rawMsg map[string]json.RawMessage
	if err := json.Unmarshal(data, &rawMsg); err != nil {
		return fmt.Errorf("unmarshalling type %T: %v", c, err)
	}
	for key, val := range rawMsg {
		var err error
		switch key {
		case "content":
			err = unpopulate(val, "Content", &c.Content)
			delete(rawMsg, key)
		case "role":
			err = unpopulate(val, "role", &c.role)
			delete(rawMsg, key)
		case "tool_call_id":
			err = unpopulate(val, "ToolCallID", &c.ToolCallID)
			delete(rawMsg, key)
		}
		if err != nil {
			return fmt.Errorf("unmarshalling type %T: %v", c, err)
		}
	}
	return nil
}

// MarshalJSON implements the json.Marshaller interface for type ChatRequestUserMessage.
func (c ChatRequestUserMessage) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]any)
	populateAny(objectMap, "content", c.Content)
	objectMap["role"] = ChatRoleUser
	populate(objectMap, "name", c.Name)
	return json.Marshal(objectMap)
}

// UnmarshalJSON implements the json.Unmarshaller interface for type ChatRequestUserMessage.
func (c *ChatRequestUserMessage) UnmarshalJSON(data []byte) error {
	var rawMsg map[string]json.RawMessage
	if err := json.Unmarshal(data, &rawMsg); err != nil {
		return fmt.Errorf("unmarshalling type %T: %v", c, err)
	}
	for key, val := range rawMsg {
		var err error
		switch key {
		case "content":
			err = unpopulate(val, "Content", &c.Content)
			delete(rawMsg, key)
		case "role":
			err = unpopulate(val, "role", &c.role)
			delete(rawMsg, key)
		case "name":
			err = unpopulate(val, "Name", &c.Name)
			delete(rawMsg, key)
		}
		if err != nil {
			return fmt.Errorf("unmarshalling type %T: %v", c, err)
		}
	}
	return nil
}

// MarshalJSON implements the json.Marshaller interface for type ChatResponseMessage.
func (c ChatResponseMessage) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]any)
	populate(objectMap, "content", c.Content)
	populate(objectMap, "context", c.Context)
	populate(objectMap, "function_call", c.FunctionCall)
	populate(objectMap, "role", c.Role)
	populate(objectMap, "tool_calls", c.ToolCalls)
	return json.Marshal(objectMap)
}

// UnmarshalJSON implements the json.Unmarshaller interface for type ChatResponseMessage.
func (c *ChatResponseMessage) UnmarshalJSON(data []byte) error {
	var rawMsg map[string]json.RawMessage
	if err := json.Unmarshal(data, &rawMsg); err != nil {
		return fmt.Errorf("unmarshalling type %T: %v", c, err)
	}
	for key, val := range rawMsg {
		var err error
		switch key {
		case "content":
			err = unpopulate(val, "Content", &c.Content)
			delete(rawMsg, key)
		case "context":
			err = unpopulate(val, "Context", &c.Context)
			delete(rawMsg, key)
		case "function_call":
			err = unpopulate(val, "FunctionCall", &c.FunctionCall)
			delete(rawMsg, key)
		case "role":
			err = unpopulate(val, "Role", &c.Role)
			delete(rawMsg, key)
		case "tool_calls":
			c.ToolCalls, err = unmarshalChatCompletionsToolCallClassificationArray(val)
			delete(rawMsg, key)
		}
		if err != nil {
			return fmt.Errorf("unmarshalling type %T: %v", c, err)
		}
	}
	return nil
}

// MarshalJSON implements the json.Marshaller interface for type ChatTokenLogProbabilityInfo.
func (c ChatTokenLogProbabilityInfo) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]any)
	populate(objectMap, "bytes", c.Bytes)
	populate(objectMap, "logprob", c.Logprob)
	populate(objectMap, "token", c.Token)
	return json.Marshal(objectMap)
}

// UnmarshalJSON implements the json.Unmarshaller interface for type ChatTokenLogProbabilityInfo.
func (c *ChatTokenLogProbabilityInfo) UnmarshalJSON(data []byte) error {
	var rawMsg map[string]json.RawMessage
	if err := json.Unmarshal(data, &rawMsg); err != nil {
		return fmt.Errorf("unmarshalling type %T: %v", c, err)
	}
	for key, val := range rawMsg {
		var err error
		switch key {
		case "bytes":
			err = unpopulate(val, "Bytes", &c.Bytes)
			delete(rawMsg, key)
		case "logprob":
			err = unpopulate(val, "Logprob", &c.Logprob)
			delete(rawMsg, key)
		case "token":
			err = unpopulate(val, "Token", &c.Token)
			delete(rawMsg, key)
		}
		if err != nil {
			return fmt.Errorf("unmarshalling type %T: %v", c, err)
		}
	}
	return nil
}

// MarshalJSON implements the json.Marshaller interface for type ChatTokenLogProbabilityResult.
func (c ChatTokenLogProbabilityResult) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]any)
	populate(objectMap, "bytes", c.Bytes)
	populate(objectMap, "logprob", c.Logprob)
	populate(objectMap, "token", c.Token)
	populate(objectMap, "top_logprobs", c.TopLogProbs)
	return json.Marshal(objectMap)
}

// UnmarshalJSON implements the json.Unmarshaller interface for type ChatTokenLogProbabilityResult.
func (c *ChatTokenLogProbabilityResult) UnmarshalJSON(data []byte) error {
	var rawMsg map[string]json.RawMessage
	if err := json.Unmarshal(data, &rawMsg); err != nil {
		return fmt.Errorf("unmarshalling type %T: %v", c, err)
	}
	for key, val := range rawMsg {
		var err error
		switch key {
		case "bytes":
			err = unpopulate(val, "Bytes", &c.Bytes)
			delete(rawMsg, key)
		case "logprob":
			err = unpopulate(val, "Logprob", &c.Logprob)
			delete(rawMsg, key)
		case "token":
			err = unpopulate(val, "Token", &c.Token)
			delete(rawMsg, key)
		case "top_logprobs":
			err = unpopulate(val, "TopLogProbs", &c.TopLogProbs)
			delete(rawMsg, key)
		}
		if err != nil {
			return fmt.Errorf("unmarshalling type %T: %v", c, err)
		}
	}
	return nil
}

// MarshalJSON implements the json.Marshaller interface for type Choice.
func (c Choice) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]any)
	populate(objectMap, "content_filter_results", c.ContentFilterResults)
	populate(objectMap, "finish_reason", c.FinishReason)
	populate(objectMap, "index", c.Index)
	populate(objectMap, "logprobs", c.LogProbs)
	populate(objectMap, "text", c.Text)
	return json.Marshal(objectMap)
}

// UnmarshalJSON implements the json.Unmarshaller interface for type Choice.
func (c *Choice) UnmarshalJSON(data []byte) error {
	var rawMsg map[string]json.RawMessage
	if err := json.Unmarshal(data, &rawMsg); err != nil {
		return fmt.Errorf("unmarshalling type %T: %v", c, err)
	}
	for key, val := range rawMsg {
		var err error
		switch key {
		case "content_filter_results":
			err = unpopulate(val, "ContentFilterResults", &c.ContentFilterResults)
			delete(rawMsg, key)
		case "finish_reason":
			err = unpopulate(val, "FinishReason", &c.FinishReason)
			delete(rawMsg, key)
		case "index":
			err = unpopulate(val, "Index", &c.Index)
			delete(rawMsg, key)
		case "logprobs":
			err = unpopulate(val, "LogProbs", &c.LogProbs)
			delete(rawMsg, key)
		case "text":
			err = unpopulate(val, "Text", &c.Text)
			delete(rawMsg, key)
		}
		if err != nil {
			return fmt.Errorf("unmarshalling type %T: %v", c, err)
		}
	}
	return nil
}

// MarshalJSON implements the json.Marshaller interface for type ChoiceLogProbs.
func (c ChoiceLogProbs) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]any)
	populate(objectMap, "text_offset", c.TextOffset)
	populate(objectMap, "token_logprobs", c.TokenLogProbs)
	populate(objectMap, "tokens", c.Tokens)
	populate(objectMap, "top_logprobs", c.TopLogProbs)
	return json.Marshal(objectMap)
}

// UnmarshalJSON implements the json.Unmarshaller interface for type ChoiceLogProbs.
func (c *ChoiceLogProbs) UnmarshalJSON(data []byte) error {
	var rawMsg map[string]json.RawMessage
	if err := json.Unmarshal(data, &rawMsg); err != nil {
		return fmt.Errorf("unmarshalling type %T: %v", c, err)
	}
	for key, val := range rawMsg {
		var err error
		switch key {
		case "text_offset":
			err = unpopulate(val, "TextOffset", &c.TextOffset)
			delete(rawMsg, key)
		case "token_logprobs":
			err = unpopulate(val, "TokenLogProbs", &c.TokenLogProbs)
			delete(rawMsg, key)
		case "tokens":
			err = unpopulate(val, "Tokens", &c.Tokens)
			delete(rawMsg, key)
		case "top_logprobs":
			err = unpopulate(val, "TopLogProbs", &c.TopLogProbs)
			delete(rawMsg, key)
		}
		if err != nil {
			return fmt.Errorf("unmarshalling type %T: %v", c, err)
		}
	}
	return nil
}

// MarshalJSON implements the json.Marshaller interface for type Completions.
func (c Completions) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]any)
	populate(objectMap, "choices", c.Choices)
	populateTimeUnix(objectMap, "created", c.Created)
	populate(objectMap, "id", c.ID)
	populate(objectMap, "prompt_filter_results", c.PromptFilterResults)
	populate(objectMap, "usage", c.Usage)
	return json.Marshal(objectMap)
}

// UnmarshalJSON implements the json.Unmarshaller interface for type Completions.
func (c *Completions) UnmarshalJSON(data []byte) error {
	var rawMsg map[string]json.RawMessage
	if err := json.Unmarshal(data, &rawMsg); err != nil {
		return fmt.Errorf("unmarshalling type %T: %v", c, err)
	}
	for key, val := range rawMsg {
		var err error
		switch key {
		case "choices":
			err = unpopulate(val, "Choices", &c.Choices)
			delete(rawMsg, key)
		case "created":
			err = unpopulateTimeUnix(val, "Created", &c.Created)
			delete(rawMsg, key)
		case "id":
			err = unpopulate(val, "ID", &c.ID)
			delete(rawMsg, key)
		case "prompt_annotations":
			fallthrough
		case "prompt_filter_results":
			err = unpopulate(val, "PromptFilterResults", &c.PromptFilterResults)
			delete(rawMsg, key)
		case "usage":
			err = unpopulate(val, "Usage", &c.Usage)
			delete(rawMsg, key)
		}
		if err != nil {
			return fmt.Errorf("unmarshalling type %T: %v", c, err)
		}
	}
	return nil
}

// MarshalJSON implements the json.Marshaller interface for type CompletionsLogProbabilityModel.
func (c CompletionsLogProbabilityModel) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]any)
	populate(objectMap, "text_offset", c.TextOffset)
	populate(objectMap, "token_logprobs", c.TokenLogProbs)
	populate(objectMap, "tokens", c.Tokens)
	populate(objectMap, "top_logprobs", c.TopLogProbs)
	return json.Marshal(objectMap)
}

// UnmarshalJSON implements the json.Unmarshaller interface for type CompletionsLogProbabilityModel.
func (c *CompletionsLogProbabilityModel) UnmarshalJSON(data []byte) error {
	var rawMsg map[string]json.RawMessage
	if err := json.Unmarshal(data, &rawMsg); err != nil {
		return fmt.Errorf("unmarshalling type %T: %v", c, err)
	}
	for key, val := range rawMsg {
		var err error
		switch key {
		case "text_offset":
			err = unpopulate(val, "TextOffset", &c.TextOffset)
			delete(rawMsg, key)
		case "token_logprobs":
			err = unpopulate(val, "TokenLogProbs", &c.TokenLogProbs)
			delete(rawMsg, key)
		case "tokens":
			err = unpopulate(val, "Tokens", &c.Tokens)
			delete(rawMsg, key)
		case "top_logprobs":
			err = unpopulate(val, "TopLogProbs", &c.TopLogProbs)
			delete(rawMsg, key)
		}
		if err != nil {
			return fmt.Errorf("unmarshalling type %T: %v", c, err)
		}
	}
	return nil
}

// MarshalJSON implements the json.Marshaller interface for type CompletionsOptions.
func (c CompletionsOptions) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]any)
	populate(objectMap, "best_of", c.BestOf)
	populate(objectMap, "echo", c.Echo)
	populate(objectMap, "frequency_penalty", c.FrequencyPenalty)
	populate(objectMap, "logit_bias", c.LogitBias)
	populate(objectMap, "logprobs", c.LogProbs)
	populate(objectMap, "max_tokens", c.MaxTokens)
	populate(objectMap, "model", c.DeploymentName)
	populate(objectMap, "n", c.N)
	populate(objectMap, "presence_penalty", c.PresencePenalty)
	populate(objectMap, "prompt", c.Prompt)
	populate(objectMap, "stop", c.Stop)
	populate(objectMap, "suffix", c.Suffix)
	populate(objectMap, "temperature", c.Temperature)
	populate(objectMap, "top_p", c.TopP)
	populate(objectMap, "user", c.User)
	return json.Marshal(objectMap)
}

// UnmarshalJSON implements the json.Unmarshaller interface for type CompletionsOptions.
func (c *CompletionsOptions) UnmarshalJSON(data []byte) error {
	var rawMsg map[string]json.RawMessage
	if err := json.Unmarshal(data, &rawMsg); err != nil {
		return fmt.Errorf("unmarshalling type %T: %v", c, err)
	}
	for key, val := range rawMsg {
		var err error
		switch key {
		case "best_of":
			err = unpopulate(val, "BestOf", &c.BestOf)
			delete(rawMsg, key)
		case "echo":
			err = unpopulate(val, "Echo", &c.Echo)
			delete(rawMsg, key)
		case "frequency_penalty":
			err = unpopulate(val, "FrequencyPenalty", &c.FrequencyPenalty)
			delete(rawMsg, key)
		case "logit_bias":
			err = unpopulate(val, "LogitBias", &c.LogitBias)
			delete(rawMsg, key)
		case "logprobs":
			err = unpopulate(val, "LogProbs", &c.LogProbs)
			delete(rawMsg, key)
		case "max_tokens":
			err = unpopulate(val, "MaxTokens", &c.MaxTokens)
			delete(rawMsg, key)
		case "model":
			err = unpopulate(val, "Model", &c.DeploymentName)
			delete(rawMsg, key)
		case "n":
			err = unpopulate(val, "N", &c.N)
			delete(rawMsg, key)
		case "presence_penalty":
			err = unpopulate(val, "PresencePenalty", &c.PresencePenalty)
			delete(rawMsg, key)
		case "prompt":
			err = unpopulate(val, "Prompt", &c.Prompt)
			delete(rawMsg, key)
		case "stop":
			err = unpopulate(val, "Stop", &c.Stop)
			delete(rawMsg, key)
		case "suffix":
			err = unpopulate(val, "Suffix", &c.Suffix)
			delete(rawMsg, key)
		case "temperature":
			err = unpopulate(val, "Temperature", &c.Temperature)
			delete(rawMsg, key)
		case "top_p":
			err = unpopulate(val, "TopP", &c.TopP)
			delete(rawMsg, key)
		case "user":
			err = unpopulate(val, "User", &c.User)
			delete(rawMsg, key)
		}
		if err != nil {
			return fmt.Errorf("unmarshalling type %T: %v", c, err)
		}
	}
	return nil
}

// MarshalJSON implements the json.Marshaller interface for type CompletionsUsage.
func (c CompletionsUsage) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]any)
	populate(objectMap, "completion_tokens", c.CompletionTokens)
	populate(objectMap, "prompt_tokens", c.PromptTokens)
	populate(objectMap, "total_tokens", c.TotalTokens)
	return json.Marshal(objectMap)
}

// UnmarshalJSON implements the json.Unmarshaller interface for type CompletionsUsage.
func (c *CompletionsUsage) UnmarshalJSON(data []byte) error {
	var rawMsg map[string]json.RawMessage
	if err := json.Unmarshal(data, &rawMsg); err != nil {
		return fmt.Errorf("unmarshalling type %T: %v", c, err)
	}
	for key, val := range rawMsg {
		var err error
		switch key {
		case "completion_tokens":
			err = unpopulate(val, "CompletionTokens", &c.CompletionTokens)
			delete(rawMsg, key)
		case "prompt_tokens":
			err = unpopulate(val, "PromptTokens", &c.PromptTokens)
			delete(rawMsg, key)
		case "total_tokens":
			err = unpopulate(val, "TotalTokens", &c.TotalTokens)
			delete(rawMsg, key)
		}
		if err != nil {
			return fmt.Errorf("unmarshalling type %T: %v", c, err)
		}
	}
	return nil
}

// MarshalJSON implements the json.Marshaller interface for type ContentFilterBlocklistIDResult.
func (c ContentFilterBlocklistIDResult) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]any)
	populate(objectMap, "filtered", c.Filtered)
	populate(objectMap, "id", c.ID)
	return json.Marshal(objectMap)
}

// UnmarshalJSON implements the json.Unmarshaller interface for type ContentFilterBlocklistIDResult.
func (c *ContentFilterBlocklistIDResult) UnmarshalJSON(data []byte) error {
	var rawMsg map[string]json.RawMessage
	if err := json.Unmarshal(data, &rawMsg); err != nil {
		return fmt.Errorf("unmarshalling type %T: %v", c, err)
	}
	for key, val := range rawMsg {
		var err error
		switch key {
		case "filtered":
			err = unpopulate(val, "Filtered", &c.Filtered)
			delete(rawMsg, key)
		case "id":
			err = unpopulate(val, "ID", &c.ID)
			delete(rawMsg, key)
		}
		if err != nil {
			return fmt.Errorf("unmarshalling type %T: %v", c, err)
		}
	}
	return nil
}

// MarshalJSON implements the json.Marshaller interface for type ContentFilterCitedDetectionResult.
func (c ContentFilterCitedDetectionResult) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]any)
	populate(objectMap, "detected", c.Detected)
	populate(objectMap, "filtered", c.Filtered)
	populate(objectMap, "license", c.License)
	populate(objectMap, "URL", c.URL)
	return json.Marshal(objectMap)
}

// UnmarshalJSON implements the json.Unmarshaller interface for type ContentFilterCitedDetectionResult.
func (c *ContentFilterCitedDetectionResult) UnmarshalJSON(data []byte) error {
	var rawMsg map[string]json.RawMessage
	if err := json.Unmarshal(data, &rawMsg); err != nil {
		return fmt.Errorf("unmarshalling type %T: %v", c, err)
	}
	for key, val := range rawMsg {
		var err error
		switch key {
		case "detected":
			err = unpopulate(val, "Detected", &c.Detected)
			delete(rawMsg, key)
		case "filtered":
			err = unpopulate(val, "Filtered", &c.Filtered)
			delete(rawMsg, key)
		case "license":
			err = unpopulate(val, "License", &c.License)
			delete(rawMsg, key)
		case "URL":
			err = unpopulate(val, "URL", &c.URL)
			delete(rawMsg, key)
		}
		if err != nil {
			return fmt.Errorf("unmarshalling type %T: %v", c, err)
		}
	}
	return nil
}

// MarshalJSON implements the json.Marshaller interface for type ContentFilterDetailedResults.
func (c ContentFilterDetailedResults) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]any)
	populate(objectMap, "details", c.Details)
	populate(objectMap, "filtered", c.Filtered)
	return json.Marshal(objectMap)
}

// UnmarshalJSON implements the json.Unmarshaller interface for type ContentFilterDetailedResults.
func (c *ContentFilterDetailedResults) UnmarshalJSON(data []byte) error {
	var rawMsg map[string]json.RawMessage
	if err := json.Unmarshal(data, &rawMsg); err != nil {
		return fmt.Errorf("unmarshalling type %T: %v", c, err)
	}
	for key, val := range rawMsg {
		var err error
		switch key {
		case "details":
			err = unpopulate(val, "Details", &c.Details)
			delete(rawMsg, key)
		case "filtered":
			err = unpopulate(val, "Filtered", &c.Filtered)
			delete(rawMsg, key)
		}
		if err != nil {
			return fmt.Errorf("unmarshalling type %T: %v", c, err)
		}
	}
	return nil
}

// MarshalJSON implements the json.Marshaller interface for type ContentFilterDetectionResult.
func (c ContentFilterDetectionResult) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]any)
	populate(objectMap, "detected", c.Detected)
	populate(objectMap, "filtered", c.Filtered)
	return json.Marshal(objectMap)
}

// UnmarshalJSON implements the json.Unmarshaller interface for type ContentFilterDetectionResult.
func (c *ContentFilterDetectionResult) UnmarshalJSON(data []byte) error {
	var rawMsg map[string]json.RawMessage
	if err := json.Unmarshal(data, &rawMsg); err != nil {
		return fmt.Errorf("unmarshalling type %T: %v", c, err)
	}
	for key, val := range rawMsg {
		var err error
		switch key {
		case "detected":
			err = unpopulate(val, "Detected", &c.Detected)
			delete(rawMsg, key)
		case "filtered":
			err = unpopulate(val, "Filtered", &c.Filtered)
			delete(rawMsg, key)
		}
		if err != nil {
			return fmt.Errorf("unmarshalling type %T: %v", c, err)
		}
	}
	return nil
}

// MarshalJSON implements the json.Marshaller interface for type ContentFilterResult.
func (c ContentFilterResult) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]any)
	populate(objectMap, "filtered", c.Filtered)
	populate(objectMap, "severity", c.Severity)
	return json.Marshal(objectMap)
}

// UnmarshalJSON implements the json.Unmarshaller interface for type ContentFilterResult.
func (c *ContentFilterResult) UnmarshalJSON(data []byte) error {
	var rawMsg map[string]json.RawMessage
	if err := json.Unmarshal(data, &rawMsg); err != nil {
		return fmt.Errorf("unmarshalling type %T: %v", c, err)
	}
	for key, val := range rawMsg {
		var err error
		switch key {
		case "filtered":
			err = unpopulate(val, "Filtered", &c.Filtered)
			delete(rawMsg, key)
		case "severity":
			err = unpopulate(val, "Severity", &c.Severity)
			delete(rawMsg, key)
		}
		if err != nil {
			return fmt.Errorf("unmarshalling type %T: %v", c, err)
		}
	}
	return nil
}

// MarshalJSON implements the json.Marshaller interface for type ContentFilterResultDetailsForPrompt.
func (c ContentFilterResultDetailsForPrompt) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]any)
	populate(objectMap, "custom_blocklists", c.CustomBlocklists)
	populate(objectMap, "error", c.Error)
	populate(objectMap, "hate", c.Hate)
	populate(objectMap, "indirect_attack", c.IndirectAttack)
	populate(objectMap, "jailbreak", c.Jailbreak)
	populate(objectMap, "profanity", c.Profanity)
	populate(objectMap, "self_harm", c.SelfHarm)
	populate(objectMap, "sexual", c.Sexual)
	populate(objectMap, "violence", c.Violence)
	return json.Marshal(objectMap)
}

// UnmarshalJSON implements the json.Unmarshaller interface for type ContentFilterResultDetailsForPrompt.
func (c *ContentFilterResultDetailsForPrompt) UnmarshalJSON(data []byte) error {
	var rawMsg map[string]json.RawMessage
	if err := json.Unmarshal(data, &rawMsg); err != nil {
		return fmt.Errorf("unmarshalling type %T: %v", c, err)
	}
	for key, val := range rawMsg {
		var err error
		switch key {
		case "custom_blocklists":
			err = unpopulate(val, "CustomBlocklists", &c.CustomBlocklists)
			delete(rawMsg, key)
		case "error":
			err = unpopulate(val, "Error", &c.Error)
			delete(rawMsg, key)
		case "hate":
			err = unpopulate(val, "Hate", &c.Hate)
			delete(rawMsg, key)
		case "indirect_attack":
			err = unpopulate(val, "IndirectAttack", &c.IndirectAttack)
			delete(rawMsg, key)
		case "jailbreak":
			err = unpopulate(val, "Jailbreak", &c.Jailbreak)
			delete(rawMsg, key)
		case "profanity":
			err = unpopulate(val, "Profanity", &c.Profanity)
			delete(rawMsg, key)
		case "self_harm":
			err = unpopulate(val, "SelfHarm", &c.SelfHarm)
			delete(rawMsg, key)
		case "sexual":
			err = unpopulate(val, "Sexual", &c.Sexual)
			delete(rawMsg, key)
		case "violence":
			err = unpopulate(val, "Violence", &c.Violence)
			delete(rawMsg, key)
		}
		if err != nil {
			return fmt.Errorf("unmarshalling type %T: %v", c, err)
		}
	}
	return nil
}

// MarshalJSON implements the json.Marshaller interface for type ContentFilterResultsForChoice.
func (c ContentFilterResultsForChoice) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]any)
	populate(objectMap, "custom_blocklists", c.CustomBlocklists)
	populate(objectMap, "error", c.Error)
	populate(objectMap, "hate", c.Hate)
	populate(objectMap, "profanity", c.Profanity)
	populate(objectMap, "protected_material_code", c.ProtectedMaterialCode)
	populate(objectMap, "protected_material_text", c.ProtectedMaterialText)
	populate(objectMap, "self_harm", c.SelfHarm)
	populate(objectMap, "sexual", c.Sexual)
	populate(objectMap, "violence", c.Violence)
	return json.Marshal(objectMap)
}

// UnmarshalJSON implements the json.Unmarshaller interface for type ContentFilterResultsForChoice.
func (c *ContentFilterResultsForChoice) UnmarshalJSON(data []byte) error {
	var rawMsg map[string]json.RawMessage
	if err := json.Unmarshal(data, &rawMsg); err != nil {
		return fmt.Errorf("unmarshalling type %T: %v", c, err)
	}
	for key, val := range rawMsg {
		var err error
		switch key {
		case "custom_blocklists":
			err = unpopulate(val, "CustomBlocklists", &c.CustomBlocklists)
			delete(rawMsg, key)
		case "error":
			err = unpopulate(val, "Error", &c.Error)
			delete(rawMsg, key)
		case "hate":
			err = unpopulate(val, "Hate", &c.Hate)
			delete(rawMsg, key)
		case "profanity":
			err = unpopulate(val, "Profanity", &c.Profanity)
			delete(rawMsg, key)
		case "protected_material_code":
			err = unpopulate(val, "ProtectedMaterialCode", &c.ProtectedMaterialCode)
			delete(rawMsg, key)
		case "protected_material_text":
			err = unpopulate(val, "ProtectedMaterialText", &c.ProtectedMaterialText)
			delete(rawMsg, key)
		case "self_harm":
			err = unpopulate(val, "SelfHarm", &c.SelfHarm)
			delete(rawMsg, key)
		case "sexual":
			err = unpopulate(val, "Sexual", &c.Sexual)
			delete(rawMsg, key)
		case "violence":
			err = unpopulate(val, "Violence", &c.Violence)
			delete(rawMsg, key)
		}
		if err != nil {
			return fmt.Errorf("unmarshalling type %T: %v", c, err)
		}
	}
	return nil
}

// MarshalJSON implements the json.Marshaller interface for type ContentFilterResultsForPrompt.
func (c ContentFilterResultsForPrompt) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]any)
	populate(objectMap, "content_filter_results", c.ContentFilterResults)
	populate(objectMap, "prompt_index", c.PromptIndex)
	return json.Marshal(objectMap)
}

// UnmarshalJSON implements the json.Unmarshaller interface for type ContentFilterResultsForPrompt.
func (c *ContentFilterResultsForPrompt) UnmarshalJSON(data []byte) error {
	var rawMsg map[string]json.RawMessage
	if err := json.Unmarshal(data, &rawMsg); err != nil {
		return fmt.Errorf("unmarshalling type %T: %v", c, err)
	}
	for key, val := range rawMsg {
		var err error
		switch key {
		case "content_filter_results":
			err = unpopulate(val, "ContentFilterResults", &c.ContentFilterResults)
			delete(rawMsg, key)
		case "prompt_index":
			err = unpopulate(val, "PromptIndex", &c.PromptIndex)
			delete(rawMsg, key)
		}
		if err != nil {
			return fmt.Errorf("unmarshalling type %T: %v", c, err)
		}
	}
	return nil
}

// MarshalJSON implements the json.Marshaller interface for type ElasticsearchChatExtensionConfiguration.
func (e ElasticsearchChatExtensionConfiguration) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]any)
	objectMap["type"] = AzureChatExtensionTypeElasticsearch
	populate(objectMap, "parameters", e.Parameters)
	return json.Marshal(objectMap)
}

// UnmarshalJSON implements the json.Unmarshaller interface for type ElasticsearchChatExtensionConfiguration.
func (e *ElasticsearchChatExtensionConfiguration) UnmarshalJSON(data []byte) error {
	var rawMsg map[string]json.RawMessage
	if err := json.Unmarshal(data, &rawMsg); err != nil {
		return fmt.Errorf("unmarshalling type %T: %v", e, err)
	}
	for key, val := range rawMsg {
		var err error
		switch key {
		case "type":
			err = unpopulate(val, "configType", &e.configType)
			delete(rawMsg, key)
		case "parameters":
			err = unpopulate(val, "Parameters", &e.Parameters)
			delete(rawMsg, key)
		}
		if err != nil {
			return fmt.Errorf("unmarshalling type %T: %v", e, err)
		}
	}
	return nil
}

// MarshalJSON implements the json.Marshaller interface for type ElasticsearchChatExtensionParameters.
func (e ElasticsearchChatExtensionParameters) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]any)
	populate(objectMap, "authentication", e.Authentication)
	populate(objectMap, "embedding_dependency", e.EmbeddingDependency)
	populate(objectMap, "endpoint", e.Endpoint)
	populate(objectMap, "fields_mapping", e.FieldsMapping)
	populate(objectMap, "in_scope", e.InScope)
	populate(objectMap, "index_name", e.IndexName)
	populate(objectMap, "query_type", e.QueryType)
	populate(objectMap, "role_information", e.RoleInformation)
	populate(objectMap, "strictness", e.Strictness)
	populate(objectMap, "top_n_documents", e.TopNDocuments)
	return json.Marshal(objectMap)
}

// UnmarshalJSON implements the json.Unmarshaller interface for type ElasticsearchChatExtensionParameters.
func (e *ElasticsearchChatExtensionParameters) UnmarshalJSON(data []byte) error {
	var rawMsg map[string]json.RawMessage
	if err := json.Unmarshal(data, &rawMsg); err != nil {
		return fmt.Errorf("unmarshalling type %T: %v", e, err)
	}
	for key, val := range rawMsg {
		var err error
		switch key {
		case "authentication":
			e.Authentication, err = unmarshalOnYourDataAuthenticationOptionsClassification(val)
			delete(rawMsg, key)
		case "embedding_dependency":
			e.EmbeddingDependency, err = unmarshalOnYourDataVectorizationSourceClassification(val)
			delete(rawMsg, key)
		case "endpoint":
			err = unpopulate(val, "Endpoint", &e.Endpoint)
			delete(rawMsg, key)
		case "fields_mapping":
			err = unpopulate(val, "FieldsMapping", &e.FieldsMapping)
			delete(rawMsg, key)
		case "in_scope":
			err = unpopulate(val, "InScope", &e.InScope)
			delete(rawMsg, key)
		case "index_name":
			err = unpopulate(val, "IndexName", &e.IndexName)
			delete(rawMsg, key)
		case "query_type":
			err = unpopulate(val, "QueryType", &e.QueryType)
			delete(rawMsg, key)
		case "role_information":
			err = unpopulate(val, "RoleInformation", &e.RoleInformation)
			delete(rawMsg, key)
		case "strictness":
			err = unpopulate(val, "Strictness", &e.Strictness)
			delete(rawMsg, key)
		case "top_n_documents":
			err = unpopulate(val, "TopNDocuments", &e.TopNDocuments)
			delete(rawMsg, key)
		}
		if err != nil {
			return fmt.Errorf("unmarshalling type %T: %v", e, err)
		}
	}
	return nil
}

// MarshalJSON implements the json.Marshaller interface for type ElasticsearchIndexFieldMappingOptions.
func (e ElasticsearchIndexFieldMappingOptions) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]any)
	populate(objectMap, "content_fields", e.ContentFields)
	populate(objectMap, "content_fields_separator", e.ContentFieldsSeparator)
	populate(objectMap, "filepath_field", e.FilepathField)
	populate(objectMap, "title_field", e.TitleField)
	populate(objectMap, "url_field", e.URLField)
	populate(objectMap, "vector_fields", e.VectorFields)
	return json.Marshal(objectMap)
}

// UnmarshalJSON implements the json.Unmarshaller interface for type ElasticsearchIndexFieldMappingOptions.
func (e *ElasticsearchIndexFieldMappingOptions) UnmarshalJSON(data []byte) error {
	var rawMsg map[string]json.RawMessage
	if err := json.Unmarshal(data, &rawMsg); err != nil {
		return fmt.Errorf("unmarshalling type %T: %v", e, err)
	}
	for key, val := range rawMsg {
		var err error
		switch key {
		case "content_fields":
			err = unpopulate(val, "ContentFields", &e.ContentFields)
			delete(rawMsg, key)
		case "content_fields_separator":
			err = unpopulate(val, "ContentFieldsSeparator", &e.ContentFieldsSeparator)
			delete(rawMsg, key)
		case "filepath_field":
			err = unpopulate(val, "FilepathField", &e.FilepathField)
			delete(rawMsg, key)
		case "title_field":
			err = unpopulate(val, "TitleField", &e.TitleField)
			delete(rawMsg, key)
		case "url_field":
			err = unpopulate(val, "URLField", &e.URLField)
			delete(rawMsg, key)
		case "vector_fields":
			err = unpopulate(val, "VectorFields", &e.VectorFields)
			delete(rawMsg, key)
		}
		if err != nil {
			return fmt.Errorf("unmarshalling type %T: %v", e, err)
		}
	}
	return nil
}

// MarshalJSON implements the json.Marshaller interface for type EmbeddingItem.
func (e EmbeddingItem) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]any)
	populate(objectMap, "embedding", e.Embedding)
	populate(objectMap, "index", e.Index)
	return json.Marshal(objectMap)
}

// UnmarshalJSON implements the json.Unmarshaller interface for type EmbeddingItem.
func (e *EmbeddingItem) UnmarshalJSON(data []byte) error {
	var rawMsg map[string]json.RawMessage
	if err := json.Unmarshal(data, &rawMsg); err != nil {
		return fmt.Errorf("unmarshalling type %T: %v", e, err)
	}
	for key, val := range rawMsg {
		var err error
		switch key {
		case "embedding":
			err = deserializeEmbeddingsArray(val, e)
			delete(rawMsg, key)
		case "index":
			err = unpopulate(val, "Index", &e.Index)
			delete(rawMsg, key)
		}
		if err != nil {
			return fmt.Errorf("unmarshalling type %T: %v", e, err)
		}
	}
	return nil
}

// MarshalJSON implements the json.Marshaller interface for type Embeddings.
func (e Embeddings) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]any)
	populate(objectMap, "data", e.Data)
	populate(objectMap, "usage", e.Usage)
	return json.Marshal(objectMap)
}

// UnmarshalJSON implements the json.Unmarshaller interface for type Embeddings.
func (e *Embeddings) UnmarshalJSON(data []byte) error {
	var rawMsg map[string]json.RawMessage
	if err := json.Unmarshal(data, &rawMsg); err != nil {
		return fmt.Errorf("unmarshalling type %T: %v", e, err)
	}
	for key, val := range rawMsg {
		var err error
		switch key {
		case "data":
			err = unpopulate(val, "Data", &e.Data)
			delete(rawMsg, key)
		case "usage":
			err = unpopulate(val, "Usage", &e.Usage)
			delete(rawMsg, key)
		}
		if err != nil {
			return fmt.Errorf("unmarshalling type %T: %v", e, err)
		}
	}
	return nil
}

// MarshalJSON implements the json.Marshaller interface for type EmbeddingsOptions.
func (e EmbeddingsOptions) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]any)
	populate(objectMap, "dimensions", e.Dimensions)
	populate(objectMap, "encoding_format", e.EncodingFormat)
	populate(objectMap, "input", e.Input)
	populate(objectMap, "input_type", e.InputType)
	populate(objectMap, "model", e.DeploymentName)
	populate(objectMap, "user", e.User)
	return json.Marshal(objectMap)
}

// UnmarshalJSON implements the json.Unmarshaller interface for type EmbeddingsOptions.
func (e *EmbeddingsOptions) UnmarshalJSON(data []byte) error {
	var rawMsg map[string]json.RawMessage
	if err := json.Unmarshal(data, &rawMsg); err != nil {
		return fmt.Errorf("unmarshalling type %T: %v", e, err)
	}
	for key, val := range rawMsg {
		var err error
		switch key {
		case "dimensions":
			err = unpopulate(val, "Dimensions", &e.Dimensions)
			delete(rawMsg, key)
		case "encoding_format":
			err = unpopulate(val, "EncodingFormat", &e.EncodingFormat)
			delete(rawMsg, key)
		case "input":
			err = unpopulate(val, "Input", &e.Input)
			delete(rawMsg, key)
		case "input_type":
			err = unpopulate(val, "InputType", &e.InputType)
			delete(rawMsg, key)
		case "model":
			err = unpopulate(val, "Model", &e.DeploymentName)
			delete(rawMsg, key)
		case "user":
			err = unpopulate(val, "User", &e.User)
			delete(rawMsg, key)
		}
		if err != nil {
			return fmt.Errorf("unmarshalling type %T: %v", e, err)
		}
	}
	return nil
}

// MarshalJSON implements the json.Marshaller interface for type EmbeddingsUsage.
func (e EmbeddingsUsage) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]any)
	populate(objectMap, "prompt_tokens", e.PromptTokens)
	populate(objectMap, "total_tokens", e.TotalTokens)
	return json.Marshal(objectMap)
}

// UnmarshalJSON implements the json.Unmarshaller interface for type EmbeddingsUsage.
func (e *EmbeddingsUsage) UnmarshalJSON(data []byte) error {
	var rawMsg map[string]json.RawMessage
	if err := json.Unmarshal(data, &rawMsg); err != nil {
		return fmt.Errorf("unmarshalling type %T: %v", e, err)
	}
	for key, val := range rawMsg {
		var err error
		switch key {
		case "prompt_tokens":
			err = unpopulate(val, "PromptTokens", &e.PromptTokens)
			delete(rawMsg, key)
		case "total_tokens":
			err = unpopulate(val, "TotalTokens", &e.TotalTokens)
			delete(rawMsg, key)
		}
		if err != nil {
			return fmt.Errorf("unmarshalling type %T: %v", e, err)
		}
	}
	return nil
}

// MarshalJSON implements the json.Marshaller interface for type Error.
func (e Error) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]any)
	populate(objectMap, "code", e.Code)
	populate(objectMap, "message", e.message)
	return json.Marshal(objectMap)
}

// UnmarshalJSON implements the json.Unmarshaller interface for type Error.
func (e *Error) UnmarshalJSON(data []byte) error {
	var rawMsg map[string]json.RawMessage
	if err := json.Unmarshal(data, &rawMsg); err != nil {
		return fmt.Errorf("unmarshalling type %T: %v", e, err)
	}
	for key, val := range rawMsg {
		var err error
		switch key {
		case "code":
			err = unpopulate(val, "Code", &e.Code)
			delete(rawMsg, key)
		case "message":
			err = unpopulate(val, "message", &e.message)
			delete(rawMsg, key)
		}
		if err != nil {
			return fmt.Errorf("unmarshalling type %T: %v", e, err)
		}
	}
	return nil
}

// MarshalJSON implements the json.Marshaller interface for type FunctionCall.
func (f FunctionCall) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]any)
	populate(objectMap, "arguments", f.Arguments)
	populate(objectMap, "name", f.Name)
	return json.Marshal(objectMap)
}

// UnmarshalJSON implements the json.Unmarshaller interface for type FunctionCall.
func (f *FunctionCall) UnmarshalJSON(data []byte) error {
	var rawMsg map[string]json.RawMessage
	if err := json.Unmarshal(data, &rawMsg); err != nil {
		return fmt.Errorf("unmarshalling type %T: %v", f, err)
	}
	for key, val := range rawMsg {
		var err error
		switch key {
		case "arguments":
			err = unpopulate(val, "Arguments", &f.Arguments)
			delete(rawMsg, key)
		case "name":
			err = unpopulate(val, "Name", &f.Name)
			delete(rawMsg, key)
		}
		if err != nil {
			return fmt.Errorf("unmarshalling type %T: %v", f, err)
		}
	}
	return nil
}

// MarshalJSON implements the json.Marshaller interface for type FunctionDefinition.
func (f FunctionDefinition) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]any)
	populate(objectMap, "description", f.Description)
	populate(objectMap, "name", f.Name)
	populateAny(objectMap, "parameters", f.Parameters)
	return json.Marshal(objectMap)
}

// UnmarshalJSON implements the json.Unmarshaller interface for type FunctionDefinition.
func (f *FunctionDefinition) UnmarshalJSON(data []byte) error {
	var rawMsg map[string]json.RawMessage
	if err := json.Unmarshal(data, &rawMsg); err != nil {
		return fmt.Errorf("unmarshalling type %T: %v", f, err)
	}
	for key, val := range rawMsg {
		var err error
		switch key {
		case "description":
			err = unpopulate(val, "Description", &f.Description)
			delete(rawMsg, key)
		case "name":
			err = unpopulate(val, "Name", &f.Name)
			delete(rawMsg, key)
		case "parameters":
			err = unpopulate(val, "Parameters", &f.Parameters)
			delete(rawMsg, key)
		}
		if err != nil {
			return fmt.Errorf("unmarshalling type %T: %v", f, err)
		}
	}
	return nil
}

// MarshalJSON implements the json.Marshaller interface for type FunctionName.
func (f FunctionName) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]any)
	populate(objectMap, "name", f.Name)
	return json.Marshal(objectMap)
}

// UnmarshalJSON implements the json.Unmarshaller interface for type FunctionName.
func (f *FunctionName) UnmarshalJSON(data []byte) error {
	var rawMsg map[string]json.RawMessage
	if err := json.Unmarshal(data, &rawMsg); err != nil {
		return fmt.Errorf("unmarshalling type %T: %v", f, err)
	}
	for key, val := range rawMsg {
		var err error
		switch key {
		case "name":
			err = unpopulate(val, "Name", &f.Name)
			delete(rawMsg, key)
		}
		if err != nil {
			return fmt.Errorf("unmarshalling type %T: %v", f, err)
		}
	}
	return nil
}

// MarshalJSON implements the json.Marshaller interface for type ImageGenerationContentFilterResults.
func (i ImageGenerationContentFilterResults) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]any)
	populate(objectMap, "hate", i.Hate)
	populate(objectMap, "self_harm", i.SelfHarm)
	populate(objectMap, "sexual", i.Sexual)
	populate(objectMap, "violence", i.Violence)
	return json.Marshal(objectMap)
}

// UnmarshalJSON implements the json.Unmarshaller interface for type ImageGenerationContentFilterResults.
func (i *ImageGenerationContentFilterResults) UnmarshalJSON(data []byte) error {
	var rawMsg map[string]json.RawMessage
	if err := json.Unmarshal(data, &rawMsg); err != nil {
		return fmt.Errorf("unmarshalling type %T: %v", i, err)
	}
	for key, val := range rawMsg {
		var err error
		switch key {
		case "hate":
			err = unpopulate(val, "Hate", &i.Hate)
			delete(rawMsg, key)
		case "self_harm":
			err = unpopulate(val, "SelfHarm", &i.SelfHarm)
			delete(rawMsg, key)
		case "sexual":
			err = unpopulate(val, "Sexual", &i.Sexual)
			delete(rawMsg, key)
		case "violence":
			err = unpopulate(val, "Violence", &i.Violence)
			delete(rawMsg, key)
		}
		if err != nil {
			return fmt.Errorf("unmarshalling type %T: %v", i, err)
		}
	}
	return nil
}

// MarshalJSON implements the json.Marshaller interface for type ImageGenerationData.
func (i ImageGenerationData) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]any)
	populate(objectMap, "b64_json", i.Base64Data)
	populate(objectMap, "content_filter_results", i.ContentFilterResults)
	populate(objectMap, "prompt_filter_results", i.PromptFilterResults)
	populate(objectMap, "revised_prompt", i.RevisedPrompt)
	populate(objectMap, "url", i.URL)
	return json.Marshal(objectMap)
}

// UnmarshalJSON implements the json.Unmarshaller interface for type ImageGenerationData.
func (i *ImageGenerationData) UnmarshalJSON(data []byte) error {
	var rawMsg map[string]json.RawMessage
	if err := json.Unmarshal(data, &rawMsg); err != nil {
		return fmt.Errorf("unmarshalling type %T: %v", i, err)
	}
	for key, val := range rawMsg {
		var err error
		switch key {
		case "b64_json":
			err = unpopulate(val, "Base64Data", &i.Base64Data)
			delete(rawMsg, key)
		case "content_filter_results":
			err = unpopulate(val, "ContentFilterResults", &i.ContentFilterResults)
			delete(rawMsg, key)
		case "prompt_annotations":
			fallthrough
		case "prompt_filter_results":
			err = unpopulate(val, "PromptFilterResults", &i.PromptFilterResults)
			delete(rawMsg, key)
		case "revised_prompt":
			err = unpopulate(val, "RevisedPrompt", &i.RevisedPrompt)
			delete(rawMsg, key)
		case "url":
			err = unpopulate(val, "URL", &i.URL)
			delete(rawMsg, key)
		}
		if err != nil {
			return fmt.Errorf("unmarshalling type %T: %v", i, err)
		}
	}
	return nil
}

// MarshalJSON implements the json.Marshaller interface for type ImageGenerationOptions.
func (i ImageGenerationOptions) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]any)
	populate(objectMap, "model", i.DeploymentName)
	populate(objectMap, "n", i.N)
	populate(objectMap, "prompt", i.Prompt)
	populate(objectMap, "quality", i.Quality)
	populate(objectMap, "response_format", i.ResponseFormat)
	populate(objectMap, "size", i.Size)
	populate(objectMap, "style", i.Style)
	populate(objectMap, "user", i.User)
	return json.Marshal(objectMap)
}

// UnmarshalJSON implements the json.Unmarshaller interface for type ImageGenerationOptions.
func (i *ImageGenerationOptions) UnmarshalJSON(data []byte) error {
	var rawMsg map[string]json.RawMessage
	if err := json.Unmarshal(data, &rawMsg); err != nil {
		return fmt.Errorf("unmarshalling type %T: %v", i, err)
	}
	for key, val := range rawMsg {
		var err error
		switch key {
		case "model":
			err = unpopulate(val, "Model", &i.DeploymentName)
			delete(rawMsg, key)
		case "n":
			err = unpopulate(val, "N", &i.N)
			delete(rawMsg, key)
		case "prompt":
			err = unpopulate(val, "Prompt", &i.Prompt)
			delete(rawMsg, key)
		case "quality":
			err = unpopulate(val, "Quality", &i.Quality)
			delete(rawMsg, key)
		case "response_format":
			err = unpopulate(val, "ResponseFormat", &i.ResponseFormat)
			delete(rawMsg, key)
		case "size":
			err = unpopulate(val, "Size", &i.Size)
			delete(rawMsg, key)
		case "style":
			err = unpopulate(val, "Style", &i.Style)
			delete(rawMsg, key)
		case "user":
			err = unpopulate(val, "User", &i.User)
			delete(rawMsg, key)
		}
		if err != nil {
			return fmt.Errorf("unmarshalling type %T: %v", i, err)
		}
	}
	return nil
}

// MarshalJSON implements the json.Marshaller interface for type ImageGenerationPromptFilterResults.
func (i ImageGenerationPromptFilterResults) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]any)
	populate(objectMap, "hate", i.Hate)
	populate(objectMap, "jailbreak", i.Jailbreak)
	populate(objectMap, "profanity", i.Profanity)
	populate(objectMap, "self_harm", i.SelfHarm)
	populate(objectMap, "sexual", i.Sexual)
	populate(objectMap, "violence", i.Violence)
	return json.Marshal(objectMap)
}

// UnmarshalJSON implements the json.Unmarshaller interface for type ImageGenerationPromptFilterResults.
func (i *ImageGenerationPromptFilterResults) UnmarshalJSON(data []byte) error {
	var rawMsg map[string]json.RawMessage
	if err := json.Unmarshal(data, &rawMsg); err != nil {
		return fmt.Errorf("unmarshalling type %T: %v", i, err)
	}
	for key, val := range rawMsg {
		var err error
		switch key {
		case "hate":
			err = unpopulate(val, "Hate", &i.Hate)
			delete(rawMsg, key)
		case "jailbreak":
			err = unpopulate(val, "Jailbreak", &i.Jailbreak)
			delete(rawMsg, key)
		case "profanity":
			err = unpopulate(val, "Profanity", &i.Profanity)
			delete(rawMsg, key)
		case "self_harm":
			err = unpopulate(val, "SelfHarm", &i.SelfHarm)
			delete(rawMsg, key)
		case "sexual":
			err = unpopulate(val, "Sexual", &i.Sexual)
			delete(rawMsg, key)
		case "violence":
			err = unpopulate(val, "Violence", &i.Violence)
			delete(rawMsg, key)
		}
		if err != nil {
			return fmt.Errorf("unmarshalling type %T: %v", i, err)
		}
	}
	return nil
}

// MarshalJSON implements the json.Marshaller interface for type ImageGenerations.
func (i ImageGenerations) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]any)
	populateTimeUnix(objectMap, "created", i.Created)
	populate(objectMap, "data", i.Data)
	return json.Marshal(objectMap)
}

// UnmarshalJSON implements the json.Unmarshaller interface for type ImageGenerations.
func (i *ImageGenerations) UnmarshalJSON(data []byte) error {
	var rawMsg map[string]json.RawMessage
	if err := json.Unmarshal(data, &rawMsg); err != nil {
		return fmt.Errorf("unmarshalling type %T: %v", i, err)
	}
	for key, val := range rawMsg {
		var err error
		switch key {
		case "created":
			err = unpopulateTimeUnix(val, "Created", &i.Created)
			delete(rawMsg, key)
		case "data":
			err = unpopulate(val, "Data", &i.Data)
			delete(rawMsg, key)
		}
		if err != nil {
			return fmt.Errorf("unmarshalling type %T: %v", i, err)
		}
	}
	return nil
}

// MarshalJSON implements the json.Marshaller interface for type MaxTokensFinishDetails.
func (m MaxTokensFinishDetails) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]any)
	objectMap["type"] = "max_tokens"
	return json.Marshal(objectMap)
}

// UnmarshalJSON implements the json.Unmarshaller interface for type MaxTokensFinishDetails.
func (m *MaxTokensFinishDetails) UnmarshalJSON(data []byte) error {
	var rawMsg map[string]json.RawMessage
	if err := json.Unmarshal(data, &rawMsg); err != nil {
		return fmt.Errorf("unmarshalling type %T: %v", m, err)
	}
	for key, val := range rawMsg {
		var err error
		switch key {
		case "type":
			err = unpopulate(val, "Type", &m.Type)
			delete(rawMsg, key)
		}
		if err != nil {
			return fmt.Errorf("unmarshalling type %T: %v", m, err)
		}
	}
	return nil
}

// MarshalJSON implements the json.Marshaller interface for type OnYourDataAPIKeyAuthenticationOptions.
func (o OnYourDataAPIKeyAuthenticationOptions) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]any)
	objectMap["type"] = OnYourDataAuthenticationTypeAPIKey
	populate(objectMap, "key", o.Key)
	return json.Marshal(objectMap)
}

// UnmarshalJSON implements the json.Unmarshaller interface for type OnYourDataAPIKeyAuthenticationOptions.
func (o *OnYourDataAPIKeyAuthenticationOptions) UnmarshalJSON(data []byte) error {
	var rawMsg map[string]json.RawMessage
	if err := json.Unmarshal(data, &rawMsg); err != nil {
		return fmt.Errorf("unmarshalling type %T: %v", o, err)
	}
	for key, val := range rawMsg {
		var err error
		switch key {
		case "type":
			err = unpopulate(val, "configType", &o.configType)
			delete(rawMsg, key)
		case "key":
			err = unpopulate(val, "Key", &o.Key)
			delete(rawMsg, key)
		}
		if err != nil {
			return fmt.Errorf("unmarshalling type %T: %v", o, err)
		}
	}
	return nil
}

// MarshalJSON implements the json.Marshaller interface for type OnYourDataAccessTokenAuthenticationOptions.
func (o OnYourDataAccessTokenAuthenticationOptions) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]any)
	populate(objectMap, "access_token", o.AccessToken)
	objectMap["type"] = OnYourDataAuthenticationTypeAccessToken
	return json.Marshal(objectMap)
}

// UnmarshalJSON implements the json.Unmarshaller interface for type OnYourDataAccessTokenAuthenticationOptions.
func (o *OnYourDataAccessTokenAuthenticationOptions) UnmarshalJSON(data []byte) error {
	var rawMsg map[string]json.RawMessage
	if err := json.Unmarshal(data, &rawMsg); err != nil {
		return fmt.Errorf("unmarshalling type %T: %v", o, err)
	}
	for key, val := range rawMsg {
		var err error
		switch key {
		case "access_token":
			err = unpopulate(val, "AccessToken", &o.AccessToken)
			delete(rawMsg, key)
		case "type":
			err = unpopulate(val, "configType", &o.configType)
			delete(rawMsg, key)
		}
		if err != nil {
			return fmt.Errorf("unmarshalling type %T: %v", o, err)
		}
	}
	return nil
}

// MarshalJSON implements the json.Marshaller interface for type OnYourDataAuthenticationOptions.
func (o OnYourDataAuthenticationOptions) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]any)
	objectMap["type"] = o.configType
	return json.Marshal(objectMap)
}

// UnmarshalJSON implements the json.Unmarshaller interface for type OnYourDataAuthenticationOptions.
func (o *OnYourDataAuthenticationOptions) UnmarshalJSON(data []byte) error {
	var rawMsg map[string]json.RawMessage
	if err := json.Unmarshal(data, &rawMsg); err != nil {
		return fmt.Errorf("unmarshalling type %T: %v", o, err)
	}
	for key, val := range rawMsg {
		var err error
		switch key {
		case "type":
			err = unpopulate(val, "configType", &o.configType)
			delete(rawMsg, key)
		}
		if err != nil {
			return fmt.Errorf("unmarshalling type %T: %v", o, err)
		}
	}
	return nil
}

// MarshalJSON implements the json.Marshaller interface for type OnYourDataConnectionStringAuthenticationOptions.
func (o OnYourDataConnectionStringAuthenticationOptions) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]any)
	populate(objectMap, "connection_string", o.ConnectionString)
	objectMap["type"] = OnYourDataAuthenticationTypeConnectionString
	return json.Marshal(objectMap)
}

// UnmarshalJSON implements the json.Unmarshaller interface for type OnYourDataConnectionStringAuthenticationOptions.
func (o *OnYourDataConnectionStringAuthenticationOptions) UnmarshalJSON(data []byte) error {
	var rawMsg map[string]json.RawMessage
	if err := json.Unmarshal(data, &rawMsg); err != nil {
		return fmt.Errorf("unmarshalling type %T: %v", o, err)
	}
	for key, val := range rawMsg {
		var err error
		switch key {
		case "connection_string":
			err = unpopulate(val, "ConnectionString", &o.ConnectionString)
			delete(rawMsg, key)
		case "type":
			err = unpopulate(val, "configType", &o.configType)
			delete(rawMsg, key)
		}
		if err != nil {
			return fmt.Errorf("unmarshalling type %T: %v", o, err)
		}
	}
	return nil
}

// MarshalJSON implements the json.Marshaller interface for type OnYourDataDeploymentNameVectorizationSource.
func (o OnYourDataDeploymentNameVectorizationSource) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]any)
	populate(objectMap, "deployment_name", o.DeploymentName)
	objectMap["type"] = OnYourDataVectorizationSourceTypeDeploymentName
	return json.Marshal(objectMap)
}

// UnmarshalJSON implements the json.Unmarshaller interface for type OnYourDataDeploymentNameVectorizationSource.
func (o *OnYourDataDeploymentNameVectorizationSource) UnmarshalJSON(data []byte) error {
	var rawMsg map[string]json.RawMessage
	if err := json.Unmarshal(data, &rawMsg); err != nil {
		return fmt.Errorf("unmarshalling type %T: %v", o, err)
	}
	for key, val := range rawMsg {
		var err error
		switch key {
		case "deployment_name":
			err = unpopulate(val, "DeploymentName", &o.DeploymentName)
			delete(rawMsg, key)
		case "type":
			err = unpopulate(val, "Type", &o.Type)
			delete(rawMsg, key)
		}
		if err != nil {
			return fmt.Errorf("unmarshalling type %T: %v", o, err)
		}
	}
	return nil
}

// MarshalJSON implements the json.Marshaller interface for type OnYourDataEncodedAPIKeyAuthenticationOptions.
func (o OnYourDataEncodedAPIKeyAuthenticationOptions) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]any)
	populate(objectMap, "encoded_api_key", o.EncodedAPIKey)
	objectMap["type"] = OnYourDataAuthenticationTypeEncodedAPIKey
	return json.Marshal(objectMap)
}

// UnmarshalJSON implements the json.Unmarshaller interface for type OnYourDataEncodedAPIKeyAuthenticationOptions.
func (o *OnYourDataEncodedAPIKeyAuthenticationOptions) UnmarshalJSON(data []byte) error {
	var rawMsg map[string]json.RawMessage
	if err := json.Unmarshal(data, &rawMsg); err != nil {
		return fmt.Errorf("unmarshalling type %T: %v", o, err)
	}
	for key, val := range rawMsg {
		var err error
		switch key {
		case "encoded_api_key":
			err = unpopulate(val, "EncodedAPIKey", &o.EncodedAPIKey)
			delete(rawMsg, key)
		case "type":
			err = unpopulate(val, "configType", &o.configType)
			delete(rawMsg, key)
		}
		if err != nil {
			return fmt.Errorf("unmarshalling type %T: %v", o, err)
		}
	}
	return nil
}

// MarshalJSON implements the json.Marshaller interface for type OnYourDataEndpointVectorizationSource.
func (o OnYourDataEndpointVectorizationSource) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]any)
	populate(objectMap, "authentication", o.Authentication)
	populate(objectMap, "endpoint", o.Endpoint)
	objectMap["type"] = OnYourDataVectorizationSourceTypeEndpoint
	return json.Marshal(objectMap)
}

// UnmarshalJSON implements the json.Unmarshaller interface for type OnYourDataEndpointVectorizationSource.
func (o *OnYourDataEndpointVectorizationSource) UnmarshalJSON(data []byte) error {
	var rawMsg map[string]json.RawMessage
	if err := json.Unmarshal(data, &rawMsg); err != nil {
		return fmt.Errorf("unmarshalling type %T: %v", o, err)
	}
	for key, val := range rawMsg {
		var err error
		switch key {
		case "authentication":
			o.Authentication, err = unmarshalOnYourDataAuthenticationOptionsClassification(val)
			delete(rawMsg, key)
		case "endpoint":
			err = unpopulate(val, "Endpoint", &o.Endpoint)
			delete(rawMsg, key)
		case "type":
			err = unpopulate(val, "Type", &o.Type)
			delete(rawMsg, key)
		}
		if err != nil {
			return fmt.Errorf("unmarshalling type %T: %v", o, err)
		}
	}
	return nil
}

// MarshalJSON implements the json.Marshaller interface for type OnYourDataKeyAndKeyIDAuthenticationOptions.
func (o OnYourDataKeyAndKeyIDAuthenticationOptions) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]any)
	objectMap["type"] = OnYourDataAuthenticationTypeKeyAndKeyID
	populate(objectMap, "key", o.Key)
	populate(objectMap, "key_id", o.KeyID)
	return json.Marshal(objectMap)
}

// UnmarshalJSON implements the json.Unmarshaller interface for type OnYourDataKeyAndKeyIDAuthenticationOptions.
func (o *OnYourDataKeyAndKeyIDAuthenticationOptions) UnmarshalJSON(data []byte) error {
	var rawMsg map[string]json.RawMessage
	if err := json.Unmarshal(data, &rawMsg); err != nil {
		return fmt.Errorf("unmarshalling type %T: %v", o, err)
	}
	for key, val := range rawMsg {
		var err error
		switch key {
		case "type":
			err = unpopulate(val, "configType", &o.configType)
			delete(rawMsg, key)
		case "key":
			err = unpopulate(val, "Key", &o.Key)
			delete(rawMsg, key)
		case "key_id":
			err = unpopulate(val, "KeyID", &o.KeyID)
			delete(rawMsg, key)
		}
		if err != nil {
			return fmt.Errorf("unmarshalling type %T: %v", o, err)
		}
	}
	return nil
}

// MarshalJSON implements the json.Marshaller interface for type OnYourDataModelIDVectorizationSource.
func (o OnYourDataModelIDVectorizationSource) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]any)
	populate(objectMap, "model_id", o.ModelID)
	objectMap["type"] = OnYourDataVectorizationSourceTypeModelID
	return json.Marshal(objectMap)
}

// UnmarshalJSON implements the json.Unmarshaller interface for type OnYourDataModelIDVectorizationSource.
func (o *OnYourDataModelIDVectorizationSource) UnmarshalJSON(data []byte) error {
	var rawMsg map[string]json.RawMessage
	if err := json.Unmarshal(data, &rawMsg); err != nil {
		return fmt.Errorf("unmarshalling type %T: %v", o, err)
	}
	for key, val := range rawMsg {
		var err error
		switch key {
		case "model_id":
			err = unpopulate(val, "ModelID", &o.ModelID)
			delete(rawMsg, key)
		case "type":
			err = unpopulate(val, "Type", &o.Type)
			delete(rawMsg, key)
		}
		if err != nil {
			return fmt.Errorf("unmarshalling type %T: %v", o, err)
		}
	}
	return nil
}

// MarshalJSON implements the json.Marshaller interface for type OnYourDataSystemAssignedManagedIdentityAuthenticationOptions.
func (o OnYourDataSystemAssignedManagedIdentityAuthenticationOptions) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]any)
	objectMap["type"] = OnYourDataAuthenticationTypeSystemAssignedManagedIdentity
	return json.Marshal(objectMap)
}

// UnmarshalJSON implements the json.Unmarshaller interface for type OnYourDataSystemAssignedManagedIdentityAuthenticationOptions.
func (o *OnYourDataSystemAssignedManagedIdentityAuthenticationOptions) UnmarshalJSON(data []byte) error {
	var rawMsg map[string]json.RawMessage
	if err := json.Unmarshal(data, &rawMsg); err != nil {
		return fmt.Errorf("unmarshalling type %T: %v", o, err)
	}
	for key, val := range rawMsg {
		var err error
		switch key {
		case "type":
			err = unpopulate(val, "configType", &o.configType)
			delete(rawMsg, key)
		}
		if err != nil {
			return fmt.Errorf("unmarshalling type %T: %v", o, err)
		}
	}
	return nil
}

// MarshalJSON implements the json.Marshaller interface for type OnYourDataUserAssignedManagedIdentityAuthenticationOptions.
func (o OnYourDataUserAssignedManagedIdentityAuthenticationOptions) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]any)
	objectMap["type"] = OnYourDataAuthenticationTypeUserAssignedManagedIdentity
	populate(objectMap, "managed_identity_resource_id", o.ManagedIdentityResourceID)
	return json.Marshal(objectMap)
}

// UnmarshalJSON implements the json.Unmarshaller interface for type OnYourDataUserAssignedManagedIdentityAuthenticationOptions.
func (o *OnYourDataUserAssignedManagedIdentityAuthenticationOptions) UnmarshalJSON(data []byte) error {
	var rawMsg map[string]json.RawMessage
	if err := json.Unmarshal(data, &rawMsg); err != nil {
		return fmt.Errorf("unmarshalling type %T: %v", o, err)
	}
	for key, val := range rawMsg {
		var err error
		switch key {
		case "type":
			err = unpopulate(val, "configType", &o.configType)
			delete(rawMsg, key)
		case "managed_identity_resource_id":
			err = unpopulate(val, "ManagedIdentityResourceID", &o.ManagedIdentityResourceID)
			delete(rawMsg, key)
		}
		if err != nil {
			return fmt.Errorf("unmarshalling type %T: %v", o, err)
		}
	}
	return nil
}

// MarshalJSON implements the json.Marshaller interface for type OnYourDataVectorizationSource.
func (o OnYourDataVectorizationSource) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]any)
	objectMap["type"] = o.Type
	return json.Marshal(objectMap)
}

// UnmarshalJSON implements the json.Unmarshaller interface for type OnYourDataVectorizationSource.
func (o *OnYourDataVectorizationSource) UnmarshalJSON(data []byte) error {
	var rawMsg map[string]json.RawMessage
	if err := json.Unmarshal(data, &rawMsg); err != nil {
		return fmt.Errorf("unmarshalling type %T: %v", o, err)
	}
	for key, val := range rawMsg {
		var err error
		switch key {
		case "type":
			err = unpopulate(val, "Type", &o.Type)
			delete(rawMsg, key)
		}
		if err != nil {
			return fmt.Errorf("unmarshalling type %T: %v", o, err)
		}
	}
	return nil
}

// MarshalJSON implements the json.Marshaller interface for type PineconeChatExtensionConfiguration.
func (p PineconeChatExtensionConfiguration) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]any)
	objectMap["type"] = AzureChatExtensionTypePinecone
	populate(objectMap, "parameters", p.Parameters)
	return json.Marshal(objectMap)
}

// UnmarshalJSON implements the json.Unmarshaller interface for type PineconeChatExtensionConfiguration.
func (p *PineconeChatExtensionConfiguration) UnmarshalJSON(data []byte) error {
	var rawMsg map[string]json.RawMessage
	if err := json.Unmarshal(data, &rawMsg); err != nil {
		return fmt.Errorf("unmarshalling type %T: %v", p, err)
	}
	for key, val := range rawMsg {
		var err error
		switch key {
		case "type":
			err = unpopulate(val, "configType", &p.configType)
			delete(rawMsg, key)
		case "parameters":
			err = unpopulate(val, "Parameters", &p.Parameters)
			delete(rawMsg, key)
		}
		if err != nil {
			return fmt.Errorf("unmarshalling type %T: %v", p, err)
		}
	}
	return nil
}

// MarshalJSON implements the json.Marshaller interface for type PineconeChatExtensionParameters.
func (p PineconeChatExtensionParameters) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]any)
	populate(objectMap, "authentication", p.Authentication)
	populate(objectMap, "embedding_dependency", p.EmbeddingDependency)
	populate(objectMap, "environment", p.Environment)
	populate(objectMap, "fields_mapping", p.FieldsMapping)
	populate(objectMap, "in_scope", p.InScope)
	populate(objectMap, "index_name", p.IndexName)
	populate(objectMap, "role_information", p.RoleInformation)
	populate(objectMap, "strictness", p.Strictness)
	populate(objectMap, "top_n_documents", p.TopNDocuments)
	return json.Marshal(objectMap)
}

// UnmarshalJSON implements the json.Unmarshaller interface for type PineconeChatExtensionParameters.
func (p *PineconeChatExtensionParameters) UnmarshalJSON(data []byte) error {
	var rawMsg map[string]json.RawMessage
	if err := json.Unmarshal(data, &rawMsg); err != nil {
		return fmt.Errorf("unmarshalling type %T: %v", p, err)
	}
	for key, val := range rawMsg {
		var err error
		switch key {
		case "authentication":
			p.Authentication, err = unmarshalOnYourDataAuthenticationOptionsClassification(val)
			delete(rawMsg, key)
		case "embedding_dependency":
			p.EmbeddingDependency, err = unmarshalOnYourDataVectorizationSourceClassification(val)
			delete(rawMsg, key)
		case "environment":
			err = unpopulate(val, "Environment", &p.Environment)
			delete(rawMsg, key)
		case "fields_mapping":
			err = unpopulate(val, "FieldsMapping", &p.FieldsMapping)
			delete(rawMsg, key)
		case "in_scope":
			err = unpopulate(val, "InScope", &p.InScope)
			delete(rawMsg, key)
		case "index_name":
			err = unpopulate(val, "IndexName", &p.IndexName)
			delete(rawMsg, key)
		case "role_information":
			err = unpopulate(val, "RoleInformation", &p.RoleInformation)
			delete(rawMsg, key)
		case "strictness":
			err = unpopulate(val, "Strictness", &p.Strictness)
			delete(rawMsg, key)
		case "top_n_documents":
			err = unpopulate(val, "TopNDocuments", &p.TopNDocuments)
			delete(rawMsg, key)
		}
		if err != nil {
			return fmt.Errorf("unmarshalling type %T: %v", p, err)
		}
	}
	return nil
}

// MarshalJSON implements the json.Marshaller interface for type PineconeFieldMappingOptions.
func (p PineconeFieldMappingOptions) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]any)
	populate(objectMap, "content_fields", p.ContentFields)
	populate(objectMap, "content_fields_separator", p.ContentFieldsSeparator)
	populate(objectMap, "filepath_field", p.FilepathField)
	populate(objectMap, "title_field", p.TitleField)
	populate(objectMap, "url_field", p.URLField)
	return json.Marshal(objectMap)
}

// UnmarshalJSON implements the json.Unmarshaller interface for type PineconeFieldMappingOptions.
func (p *PineconeFieldMappingOptions) UnmarshalJSON(data []byte) error {
	var rawMsg map[string]json.RawMessage
	if err := json.Unmarshal(data, &rawMsg); err != nil {
		return fmt.Errorf("unmarshalling type %T: %v", p, err)
	}
	for key, val := range rawMsg {
		var err error
		switch key {
		case "content_fields":
			err = unpopulate(val, "ContentFields", &p.ContentFields)
			delete(rawMsg, key)
		case "content_fields_separator":
			err = unpopulate(val, "ContentFieldsSeparator", &p.ContentFieldsSeparator)
			delete(rawMsg, key)
		case "filepath_field":
			err = unpopulate(val, "FilepathField", &p.FilepathField)
			delete(rawMsg, key)
		case "title_field":
			err = unpopulate(val, "TitleField", &p.TitleField)
			delete(rawMsg, key)
		case "url_field":
			err = unpopulate(val, "URLField", &p.URLField)
			delete(rawMsg, key)
		}
		if err != nil {
			return fmt.Errorf("unmarshalling type %T: %v", p, err)
		}
	}
	return nil
}

// MarshalJSON implements the json.Marshaller interface for type SpeechGenerationOptions.
func (s SpeechGenerationOptions) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]any)
	populate(objectMap, "input", s.Input)
	populate(objectMap, "model", s.DeploymentName)
	populate(objectMap, "response_format", s.ResponseFormat)
	populate(objectMap, "speed", s.Speed)
	populate(objectMap, "voice", s.Voice)
	return json.Marshal(objectMap)
}

// UnmarshalJSON implements the json.Unmarshaller interface for type SpeechGenerationOptions.
func (s *SpeechGenerationOptions) UnmarshalJSON(data []byte) error {
	var rawMsg map[string]json.RawMessage
	if err := json.Unmarshal(data, &rawMsg); err != nil {
		return fmt.Errorf("unmarshalling type %T: %v", s, err)
	}
	for key, val := range rawMsg {
		var err error
		switch key {
		case "input":
			err = unpopulate(val, "Input", &s.Input)
			delete(rawMsg, key)
		case "model":
			err = unpopulate(val, "Model", &s.DeploymentName)
			delete(rawMsg, key)
		case "response_format":
			err = unpopulate(val, "ResponseFormat", &s.ResponseFormat)
			delete(rawMsg, key)
		case "speed":
			err = unpopulate(val, "Speed", &s.Speed)
			delete(rawMsg, key)
		case "voice":
			err = unpopulate(val, "Voice", &s.Voice)
			delete(rawMsg, key)
		}
		if err != nil {
			return fmt.Errorf("unmarshalling type %T: %v", s, err)
		}
	}
	return nil
}

// MarshalJSON implements the json.Marshaller interface for type SpeechGenerationResponse.
func (s SpeechGenerationResponse) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]any)
	populateByteArray(objectMap, "audio", s.Audio, func() any {
		return runtime.EncodeByteArray(s.Audio, runtime.Base64StdFormat)
	})
	return json.Marshal(objectMap)
}

// UnmarshalJSON implements the json.Unmarshaller interface for type SpeechGenerationResponse.
func (s *SpeechGenerationResponse) UnmarshalJSON(data []byte) error {
	var rawMsg map[string]json.RawMessage
	if err := json.Unmarshal(data, &rawMsg); err != nil {
		return fmt.Errorf("unmarshalling type %T: %v", s, err)
	}
	for key, val := range rawMsg {
		var err error
		switch key {
		case "audio":
			if val != nil && string(val) != "null" {
				err = runtime.DecodeByteArray(string(val), &s.Audio, runtime.Base64StdFormat)
			}
			delete(rawMsg, key)
		}
		if err != nil {
			return fmt.Errorf("unmarshalling type %T: %v", s, err)
		}
	}
	return nil
}

// MarshalJSON implements the json.Marshaller interface for type StopFinishDetails.
func (s StopFinishDetails) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]any)
	populate(objectMap, "stop", s.Stop)
	objectMap["type"] = "stop"
	return json.Marshal(objectMap)
}

// UnmarshalJSON implements the json.Unmarshaller interface for type StopFinishDetails.
func (s *StopFinishDetails) UnmarshalJSON(data []byte) error {
	var rawMsg map[string]json.RawMessage
	if err := json.Unmarshal(data, &rawMsg); err != nil {
		return fmt.Errorf("unmarshalling type %T: %v", s, err)
	}
	for key, val := range rawMsg {
		var err error
		switch key {
		case "stop":
			err = unpopulate(val, "Stop", &s.Stop)
			delete(rawMsg, key)
		case "type":
			err = unpopulate(val, "Type", &s.Type)
			delete(rawMsg, key)
		}
		if err != nil {
			return fmt.Errorf("unmarshalling type %T: %v", s, err)
		}
	}
	return nil
}

func populate(m map[string]any, k string, v any) {
	if v == nil {
		return
	} else if azcore.IsNullValue(v) {
		m[k] = nil
	} else if !reflect.ValueOf(v).IsNil() {
		m[k] = v
	}
}

func populateAny(m map[string]any, k string, v any) {
	if v == nil {
		return
	} else if azcore.IsNullValue(v) {
		m[k] = nil
	} else {
		m[k] = v
	}
}

func populateByteArray[T any](m map[string]any, k string, b []T, convert func() any) {
	if azcore.IsNullValue(b) {
		m[k] = nil
	} else if len(b) == 0 {
		return
	} else {
		m[k] = convert()
	}
}

func unpopulate(data json.RawMessage, fn string, v any) error {
	if data == nil || string(data) == "null" {
		return nil
	}
	if err := json.Unmarshal(data, v); err != nil {
		return fmt.Errorf("struct field %s: %v", fn, err)
	}
	return nil
}
