//go:build go1.18
// +build go1.18

// Copyright (c) Microsoft Corporation. All rights reserved.
// Licensed under the MIT License. See License.txt in the project root for license information.
// Code generated by Microsoft (R) AutoRest Code Generator. DO NOT EDIT.
// Changes may cause incorrect behavior and will be lost if the code is regenerated.

package azwebpubsub

import (
	"context"
	"errors"
	"io"
	"net/http"
	"net/url"
	"strconv"
	"strings"

	"github.com/Azure/azure-sdk-for-go/sdk/azcore"
	"github.com/Azure/azure-sdk-for-go/sdk/azcore/policy"
	"github.com/Azure/azure-sdk-for-go/sdk/azcore/runtime"
)

// Client contains the methods for the WebPubSub group.
// Don't use this type directly, use a constructor function instead.
type Client struct {
	internal *azcore.Client
	endpoint string
	key      *string
}

// AddConnectionToGroup - Add a connection to the target group.
// If the operation fails it returns an *azcore.ResponseError type.
//
// Generated from API version 2023-07-01
//   - hub - Target hub name, which should start with alphabetic characters and only contain alpha-numeric characters or underscore.
//   - group - Target group name, which length should be greater than 0 and less than 1025.
//   - connectionID - Target connection Id
//   - options - AddConnectionToGroupOptions contains the optional parameters for the Client.AddConnectionToGroup method.
func (client *Client) AddConnectionToGroup(ctx context.Context, hub string, group string, connectionID string, options *AddConnectionToGroupOptions) (AddConnectionToGroupResponse, error) {
	var err error
	req, err := client.addConnectionToGroupCreateRequest(ctx, hub, group, connectionID, options)
	if err != nil {
		return AddConnectionToGroupResponse{}, err
	}
	httpResp, err := client.internal.Pipeline().Do(req)
	if err != nil {
		return AddConnectionToGroupResponse{}, err
	}
	if !runtime.HasStatusCode(httpResp, http.StatusOK) {
		err = runtime.NewResponseError(httpResp)
		return AddConnectionToGroupResponse{}, err
	}
	return AddConnectionToGroupResponse{}, nil
}

// addConnectionToGroupCreateRequest creates the AddConnectionToGroup request.
func (client *Client) addConnectionToGroupCreateRequest(ctx context.Context, hub string, group string, connectionID string, options *AddConnectionToGroupOptions) (*policy.Request, error) {
	urlPath := "/api/hubs/{hub}/groups/{group}/connections/{connectionId}"
	if hub == "" {
		return nil, errors.New("parameter hub cannot be empty")
	}
	urlPath = strings.ReplaceAll(urlPath, "{hub}", url.PathEscape(hub))
	if group == "" {
		return nil, errors.New("parameter group cannot be empty")
	}
	urlPath = strings.ReplaceAll(urlPath, "{group}", url.PathEscape(group))
	if connectionID == "" {
		return nil, errors.New("parameter connectionID cannot be empty")
	}
	urlPath = strings.ReplaceAll(urlPath, "{connectionId}", url.PathEscape(connectionID))
	req, err := runtime.NewRequest(ctx, http.MethodPut, runtime.JoinPaths(client.endpoint, urlPath))
	if err != nil {
		return nil, err
	}
	reqQP := req.Raw().URL.Query()
	reqQP.Set("api-version", "2023-07-01")
	req.Raw().URL.RawQuery = reqQP.Encode()
	req.Raw().Header["Accept"] = []string{"application/json"}
	return req, nil
}

// AddConnectionsToGroups - Add filtered connections to multiple groups.
// If the operation fails it returns an *azcore.ResponseError type.
//
// Generated from API version 2023-07-01
//   - hub - Target hub name, which should start with alphabetic characters and only contain alpha-numeric characters or underscore.
//   - groupsToAdd - Target groups and connection filter.
//   - options - AddConnectionsToGroupsOptions contains the optional parameters for the Client.AddConnectionsToGroups method.
func (client *Client) AddConnectionsToGroups(ctx context.Context, hub string, groupsToAdd AddToGroupsRequest, options *AddConnectionsToGroupsOptions) (AddConnectionsToGroupsResponse, error) {
	var err error
	req, err := client.addConnectionsToGroupsCreateRequest(ctx, hub, groupsToAdd, options)
	if err != nil {
		return AddConnectionsToGroupsResponse{}, err
	}
	httpResp, err := client.internal.Pipeline().Do(req)
	if err != nil {
		return AddConnectionsToGroupsResponse{}, err
	}
	if !runtime.HasStatusCode(httpResp, http.StatusOK) {
		err = runtime.NewResponseError(httpResp)
		return AddConnectionsToGroupsResponse{}, err
	}
	return AddConnectionsToGroupsResponse{}, nil
}

// addConnectionsToGroupsCreateRequest creates the AddConnectionsToGroups request.
func (client *Client) addConnectionsToGroupsCreateRequest(ctx context.Context, hub string, groupsToAdd AddToGroupsRequest, options *AddConnectionsToGroupsOptions) (*policy.Request, error) {
	urlPath := "/api/hubs/{hub}/:addToGroups"
	if hub == "" {
		return nil, errors.New("parameter hub cannot be empty")
	}
	urlPath = strings.ReplaceAll(urlPath, "{hub}", url.PathEscape(hub))
	req, err := runtime.NewRequest(ctx, http.MethodPost, runtime.JoinPaths(client.endpoint, urlPath))
	if err != nil {
		return nil, err
	}
	reqQP := req.Raw().URL.Query()
	reqQP.Set("api-version", "2023-07-01")
	req.Raw().URL.RawQuery = reqQP.Encode()
	req.Raw().Header["Accept"] = []string{"application/json"}
	if err := runtime.MarshalAsJSON(req, groupsToAdd); err != nil {
		return nil, err
	}
	return req, nil
}

// AddUserToGroup - Add a user to the target group.
// If the operation fails it returns an *azcore.ResponseError type.
//
// Generated from API version 2023-07-01
//   - hub - Target hub name, which should start with alphabetic characters and only contain alpha-numeric characters or underscore.
//   - group - Target group name, which length should be greater than 0 and less than 1025.
//   - userID - Target user Id.
//   - options - AddUserToGroupOptions contains the optional parameters for the Client.AddUserToGroup method.
func (client *Client) AddUserToGroup(ctx context.Context, hub string, group string, userID string, options *AddUserToGroupOptions) (AddUserToGroupResponse, error) {
	var err error
	req, err := client.addUserToGroupCreateRequest(ctx, hub, group, userID, options)
	if err != nil {
		return AddUserToGroupResponse{}, err
	}
	httpResp, err := client.internal.Pipeline().Do(req)
	if err != nil {
		return AddUserToGroupResponse{}, err
	}
	if !runtime.HasStatusCode(httpResp, http.StatusOK) {
		err = runtime.NewResponseError(httpResp)
		return AddUserToGroupResponse{}, err
	}
	return AddUserToGroupResponse{}, nil
}

// addUserToGroupCreateRequest creates the AddUserToGroup request.
func (client *Client) addUserToGroupCreateRequest(ctx context.Context, hub string, group string, userID string, options *AddUserToGroupOptions) (*policy.Request, error) {
	urlPath := "/api/hubs/{hub}/users/{userId}/groups/{group}"
	if hub == "" {
		return nil, errors.New("parameter hub cannot be empty")
	}
	urlPath = strings.ReplaceAll(urlPath, "{hub}", url.PathEscape(hub))
	if group == "" {
		return nil, errors.New("parameter group cannot be empty")
	}
	urlPath = strings.ReplaceAll(urlPath, "{group}", url.PathEscape(group))
	if userID == "" {
		return nil, errors.New("parameter userID cannot be empty")
	}
	urlPath = strings.ReplaceAll(urlPath, "{userId}", url.PathEscape(userID))
	req, err := runtime.NewRequest(ctx, http.MethodPut, runtime.JoinPaths(client.endpoint, urlPath))
	if err != nil {
		return nil, err
	}
	reqQP := req.Raw().URL.Query()
	reqQP.Set("api-version", "2023-07-01")
	req.Raw().URL.RawQuery = reqQP.Encode()
	req.Raw().Header["Accept"] = []string{"application/json"}
	return req, nil
}

// checkPermission - Check if a connection has permission to the specified action.
// If the operation fails it returns an *azcore.ResponseError type.
//
// Generated from API version 2023-07-01
//   - hub - Target hub name, which should start with alphabetic characters and only contain alpha-numeric characters or underscore.
//   - permission - The permission: current supported actions are joinLeaveGroup and sendToGroup.
//   - connectionID - Target connection Id.
//   - options - CheckPermissionOptions contains the optional parameters for the Client.checkPermission method.
func (client *Client) checkPermission(ctx context.Context, hub string, permission Permission, connectionID string, options *CheckPermissionOptions) (CheckPermissionResponse, error) {
	var err error
	req, err := client.checkPermissionCreateRequest(ctx, hub, permission, connectionID, options)
	if err != nil {
		return CheckPermissionResponse{}, err
	}
	httpResp, err := client.internal.Pipeline().Do(req)
	if err != nil {
		return CheckPermissionResponse{}, err
	}
	if !runtime.HasStatusCode(httpResp, http.StatusOK, http.StatusNotFound) {
		err = runtime.NewResponseError(httpResp)
		return CheckPermissionResponse{}, err
	}
	return CheckPermissionResponse{}, nil
}

// checkPermissionCreateRequest creates the checkPermission request.
func (client *Client) checkPermissionCreateRequest(ctx context.Context, hub string, permission Permission, connectionID string, options *CheckPermissionOptions) (*policy.Request, error) {
	urlPath := "/api/hubs/{hub}/permissions/{permission}/connections/{connectionId}"
	if hub == "" {
		return nil, errors.New("parameter hub cannot be empty")
	}
	urlPath = strings.ReplaceAll(urlPath, "{hub}", url.PathEscape(hub))
	if permission == "" {
		return nil, errors.New("parameter permission cannot be empty")
	}
	urlPath = strings.ReplaceAll(urlPath, "{permission}", url.PathEscape(string(permission)))
	if connectionID == "" {
		return nil, errors.New("parameter connectionID cannot be empty")
	}
	urlPath = strings.ReplaceAll(urlPath, "{connectionId}", url.PathEscape(connectionID))
	req, err := runtime.NewRequest(ctx, http.MethodHead, runtime.JoinPaths(client.endpoint, urlPath))
	if err != nil {
		return nil, err
	}
	reqQP := req.Raw().URL.Query()
	if options != nil && options.TargetName != nil {
		reqQP.Set("targetName", *options.TargetName)
	}
	reqQP.Set("api-version", "2023-07-01")
	req.Raw().URL.RawQuery = reqQP.Encode()
	return req, nil
}

// CloseAllConnections - Close the connections in the hub.
// If the operation fails it returns an *azcore.ResponseError type.
//
// Generated from API version 2023-07-01
//   - hub - Target hub name, which should start with alphabetic characters and only contain alpha-numeric characters or underscore.
//   - options - CloseAllConnectionsOptions contains the optional parameters for the Client.CloseAllConnections method.
func (client *Client) CloseAllConnections(ctx context.Context, hub string, options *CloseAllConnectionsOptions) (CloseAllConnectionsResponse, error) {
	var err error
	req, err := client.closeAllConnectionsCreateRequest(ctx, hub, options)
	if err != nil {
		return CloseAllConnectionsResponse{}, err
	}
	httpResp, err := client.internal.Pipeline().Do(req)
	if err != nil {
		return CloseAllConnectionsResponse{}, err
	}
	if !runtime.HasStatusCode(httpResp, http.StatusNoContent) {
		err = runtime.NewResponseError(httpResp)
		return CloseAllConnectionsResponse{}, err
	}
	return CloseAllConnectionsResponse{}, nil
}

// closeAllConnectionsCreateRequest creates the CloseAllConnections request.
func (client *Client) closeAllConnectionsCreateRequest(ctx context.Context, hub string, options *CloseAllConnectionsOptions) (*policy.Request, error) {
	urlPath := "/api/hubs/{hub}/:closeConnections"
	if hub == "" {
		return nil, errors.New("parameter hub cannot be empty")
	}
	urlPath = strings.ReplaceAll(urlPath, "{hub}", url.PathEscape(hub))
	req, err := runtime.NewRequest(ctx, http.MethodPost, runtime.JoinPaths(client.endpoint, urlPath))
	if err != nil {
		return nil, err
	}
	reqQP := req.Raw().URL.Query()
	if options != nil && options.Excluded != nil {
		for _, qv := range options.Excluded {
			reqQP.Add("excluded", qv)
		}
	}
	if options != nil && options.Reason != nil {
		reqQP.Set("reason", *options.Reason)
	}
	reqQP.Set("api-version", "2023-07-01")
	req.Raw().URL.RawQuery = reqQP.Encode()
	req.Raw().Header["Accept"] = []string{"application/json"}
	return req, nil
}

// CloseConnection - Close the client connection.
// If the operation fails it returns an *azcore.ResponseError type.
//
// Generated from API version 2023-07-01
//   - hub - Target hub name, which should start with alphabetic characters and only contain alpha-numeric characters or underscore.
//   - connectionID - Target connection Id.
//   - options - CloseConnectionOptions contains the optional parameters for the Client.CloseConnection method.
func (client *Client) CloseConnection(ctx context.Context, hub string, connectionID string, options *CloseConnectionOptions) (CloseConnectionResponse, error) {
	var err error
	req, err := client.closeConnectionCreateRequest(ctx, hub, connectionID, options)
	if err != nil {
		return CloseConnectionResponse{}, err
	}
	httpResp, err := client.internal.Pipeline().Do(req)
	if err != nil {
		return CloseConnectionResponse{}, err
	}
	if !runtime.HasStatusCode(httpResp, http.StatusNoContent) {
		err = runtime.NewResponseError(httpResp)
		return CloseConnectionResponse{}, err
	}
	return CloseConnectionResponse{}, nil
}

// closeConnectionCreateRequest creates the CloseConnection request.
func (client *Client) closeConnectionCreateRequest(ctx context.Context, hub string, connectionID string, options *CloseConnectionOptions) (*policy.Request, error) {
	urlPath := "/api/hubs/{hub}/connections/{connectionId}"
	if hub == "" {
		return nil, errors.New("parameter hub cannot be empty")
	}
	urlPath = strings.ReplaceAll(urlPath, "{hub}", url.PathEscape(hub))
	if connectionID == "" {
		return nil, errors.New("parameter connectionID cannot be empty")
	}
	urlPath = strings.ReplaceAll(urlPath, "{connectionId}", url.PathEscape(connectionID))
	req, err := runtime.NewRequest(ctx, http.MethodDelete, runtime.JoinPaths(client.endpoint, urlPath))
	if err != nil {
		return nil, err
	}
	reqQP := req.Raw().URL.Query()
	if options != nil && options.Reason != nil {
		reqQP.Set("reason", *options.Reason)
	}
	reqQP.Set("api-version", "2023-07-01")
	req.Raw().URL.RawQuery = reqQP.Encode()
	req.Raw().Header["Accept"] = []string{"application/json"}
	return req, nil
}

// CloseGroupConnections - Close connections in the specific group.
// If the operation fails it returns an *azcore.ResponseError type.
//
// Generated from API version 2023-07-01
//   - hub - Target hub name, which should start with alphabetic characters and only contain alpha-numeric characters or underscore.
//   - group - Target group name, which length should be greater than 0 and less than 1025.
//   - options - CloseGroupConnectionsOptions contains the optional parameters for the Client.CloseGroupConnections method.
func (client *Client) CloseGroupConnections(ctx context.Context, hub string, group string, options *CloseGroupConnectionsOptions) (CloseGroupConnectionsResponse, error) {
	var err error
	req, err := client.closeGroupConnectionsCreateRequest(ctx, hub, group, options)
	if err != nil {
		return CloseGroupConnectionsResponse{}, err
	}
	httpResp, err := client.internal.Pipeline().Do(req)
	if err != nil {
		return CloseGroupConnectionsResponse{}, err
	}
	if !runtime.HasStatusCode(httpResp, http.StatusNoContent) {
		err = runtime.NewResponseError(httpResp)
		return CloseGroupConnectionsResponse{}, err
	}
	return CloseGroupConnectionsResponse{}, nil
}

// closeGroupConnectionsCreateRequest creates the CloseGroupConnections request.
func (client *Client) closeGroupConnectionsCreateRequest(ctx context.Context, hub string, group string, options *CloseGroupConnectionsOptions) (*policy.Request, error) {
	urlPath := "/api/hubs/{hub}/groups/{group}/:closeConnections"
	if hub == "" {
		return nil, errors.New("parameter hub cannot be empty")
	}
	urlPath = strings.ReplaceAll(urlPath, "{hub}", url.PathEscape(hub))
	if group == "" {
		return nil, errors.New("parameter group cannot be empty")
	}
	urlPath = strings.ReplaceAll(urlPath, "{group}", url.PathEscape(group))
	req, err := runtime.NewRequest(ctx, http.MethodPost, runtime.JoinPaths(client.endpoint, urlPath))
	if err != nil {
		return nil, err
	}
	reqQP := req.Raw().URL.Query()
	if options != nil && options.Excluded != nil {
		for _, qv := range options.Excluded {
			reqQP.Add("excluded", qv)
		}
	}
	if options != nil && options.Reason != nil {
		reqQP.Set("reason", *options.Reason)
	}
	reqQP.Set("api-version", "2023-07-01")
	req.Raw().URL.RawQuery = reqQP.Encode()
	req.Raw().Header["Accept"] = []string{"application/json"}
	return req, nil
}

// CloseUserConnections - Close connections for the specific user.
// If the operation fails it returns an *azcore.ResponseError type.
//
// Generated from API version 2023-07-01
//   - hub - Target hub name, which should start with alphabetic characters and only contain alpha-numeric characters or underscore.
//   - userID - The user Id.
//   - options - CloseUserConnectionsOptions contains the optional parameters for the Client.CloseUserConnections method.
func (client *Client) CloseUserConnections(ctx context.Context, hub string, userID string, options *CloseUserConnectionsOptions) (CloseUserConnectionsResponse, error) {
	var err error
	req, err := client.closeUserConnectionsCreateRequest(ctx, hub, userID, options)
	if err != nil {
		return CloseUserConnectionsResponse{}, err
	}
	httpResp, err := client.internal.Pipeline().Do(req)
	if err != nil {
		return CloseUserConnectionsResponse{}, err
	}
	if !runtime.HasStatusCode(httpResp, http.StatusNoContent) {
		err = runtime.NewResponseError(httpResp)
		return CloseUserConnectionsResponse{}, err
	}
	return CloseUserConnectionsResponse{}, nil
}

// closeUserConnectionsCreateRequest creates the CloseUserConnections request.
func (client *Client) closeUserConnectionsCreateRequest(ctx context.Context, hub string, userID string, options *CloseUserConnectionsOptions) (*policy.Request, error) {
	urlPath := "/api/hubs/{hub}/users/{userId}/:closeConnections"
	if hub == "" {
		return nil, errors.New("parameter hub cannot be empty")
	}
	urlPath = strings.ReplaceAll(urlPath, "{hub}", url.PathEscape(hub))
	if userID == "" {
		return nil, errors.New("parameter userID cannot be empty")
	}
	urlPath = strings.ReplaceAll(urlPath, "{userId}", url.PathEscape(userID))
	req, err := runtime.NewRequest(ctx, http.MethodPost, runtime.JoinPaths(client.endpoint, urlPath))
	if err != nil {
		return nil, err
	}
	reqQP := req.Raw().URL.Query()
	if options != nil && options.Excluded != nil {
		for _, qv := range options.Excluded {
			reqQP.Add("excluded", qv)
		}
	}
	if options != nil && options.Reason != nil {
		reqQP.Set("reason", *options.Reason)
	}
	reqQP.Set("api-version", "2023-07-01")
	req.Raw().URL.RawQuery = reqQP.Encode()
	req.Raw().Header["Accept"] = []string{"application/json"}
	return req, nil
}

// connectionExists - Check if the connection with the given connectionId exists.
// If the operation fails it returns an *azcore.ResponseError type.
//
// Generated from API version 2023-07-01
//   - hub - Target hub name, which should start with alphabetic characters and only contain alpha-numeric characters or underscore.
//   - connectionID - The connection Id.
//   - options - ConnectionExistsOptions contains the optional parameters for the Client.connectionExists method.
func (client *Client) connectionExists(ctx context.Context, hub string, connectionID string, options *ConnectionExistsOptions) (ConnectionExistsResponse, error) {
	var err error
	req, err := client.connectionExistsCreateRequest(ctx, hub, connectionID, options)
	if err != nil {
		return ConnectionExistsResponse{}, err
	}
	httpResp, err := client.internal.Pipeline().Do(req)
	if err != nil {
		return ConnectionExistsResponse{}, err
	}
	if !runtime.HasStatusCode(httpResp, http.StatusOK, http.StatusNotFound) {
		err = runtime.NewResponseError(httpResp)
		return ConnectionExistsResponse{}, err
	}
	return ConnectionExistsResponse{}, nil
}

// connectionExistsCreateRequest creates the connectionExists request.
func (client *Client) connectionExistsCreateRequest(ctx context.Context, hub string, connectionID string, options *ConnectionExistsOptions) (*policy.Request, error) {
	urlPath := "/api/hubs/{hub}/connections/{connectionId}"
	if hub == "" {
		return nil, errors.New("parameter hub cannot be empty")
	}
	urlPath = strings.ReplaceAll(urlPath, "{hub}", url.PathEscape(hub))
	if connectionID == "" {
		return nil, errors.New("parameter connectionID cannot be empty")
	}
	urlPath = strings.ReplaceAll(urlPath, "{connectionId}", url.PathEscape(connectionID))
	req, err := runtime.NewRequest(ctx, http.MethodHead, runtime.JoinPaths(client.endpoint, urlPath))
	if err != nil {
		return nil, err
	}
	reqQP := req.Raw().URL.Query()
	reqQP.Set("api-version", "2023-07-01")
	req.Raw().URL.RawQuery = reqQP.Encode()
	return req, nil
}

// generateClientToken - Generate token for the client to connect Azure Web PubSub service.
// If the operation fails it returns an *azcore.ResponseError type.
//
// Generated from API version 2023-07-01
//   - hub - Target hub name, which should start with alphabetic characters and only contain alpha-numeric characters or underscore.
//   - options - GenerateClientTokenOptions contains the optional parameters for the Client.generateClientToken method.
func (client *Client) generateClientToken(ctx context.Context, hub string, options *GenerateClientTokenOptions) (GenerateClientTokenResponse, error) {
	var err error
	req, err := client.generateClientTokenCreateRequest(ctx, hub, options)
	if err != nil {
		return GenerateClientTokenResponse{}, err
	}
	httpResp, err := client.internal.Pipeline().Do(req)
	if err != nil {
		return GenerateClientTokenResponse{}, err
	}
	if !runtime.HasStatusCode(httpResp, http.StatusOK) {
		err = runtime.NewResponseError(httpResp)
		return GenerateClientTokenResponse{}, err
	}
	resp, err := client.generateTokenHandleResponse(httpResp)
	return resp, err
}

// generateClientTokenCreateRequest creates the generateClientToken request.
func (client *Client) generateClientTokenCreateRequest(ctx context.Context, hub string, options *GenerateClientTokenOptions) (*policy.Request, error) {
	urlPath := "/api/hubs/{hub}/:generateToken"
	if hub == "" {
		return nil, errors.New("parameter hub cannot be empty")
	}
	urlPath = strings.ReplaceAll(urlPath, "{hub}", url.PathEscape(hub))
	req, err := runtime.NewRequest(ctx, http.MethodPost, runtime.JoinPaths(client.endpoint, urlPath))
	if err != nil {
		return nil, err
	}
	reqQP := req.Raw().URL.Query()
	if options != nil && options.UserID != nil {
		reqQP.Set("userId", *options.UserID)
	}
	if options != nil && options.Role != nil {
		for _, qv := range options.Role {
			reqQP.Add("role", qv)
		}
	}
	if options != nil && options.MinutesToExpire != nil {
		reqQP.Set("minutesToExpire", strconv.FormatInt(int64(*options.MinutesToExpire), 10))
	}
	reqQP.Set("api-version", "2023-07-01")
	if options != nil && options.Group != nil {
		for _, qv := range options.Group {
			reqQP.Add("group", qv)
		}
	}
	req.Raw().URL.RawQuery = reqQP.Encode()
	req.Raw().Header["Accept"] = []string{"application/json, text/json"}
	return req, nil
}

// generateTokenHandleResponse handles the generateClientToken response.
func (client *Client) generateTokenHandleResponse(resp *http.Response) (GenerateClientTokenResponse, error) {
	result := GenerateClientTokenResponse{}
	if err := runtime.UnmarshalAsJSON(resp, &result.TokenResponse); err != nil {
		return GenerateClientTokenResponse{}, err
	}
	return result, nil
}

// GrantPermission - Grant permission to the connection.
// If the operation fails it returns an *azcore.ResponseError type.
//
// Generated from API version 2023-07-01
//   - hub - Target hub name, which should start with alphabetic characters and only contain alpha-numeric characters or underscore.
//   - permission - The permission: current supported actions are joinLeaveGroup and sendToGroup.
//   - connectionID - Target connection Id.
//   - options - GrantPermissionOptions contains the optional parameters for the Client.GrantPermission method.
func (client *Client) GrantPermission(ctx context.Context, hub string, permission Permission, connectionID string, options *GrantPermissionOptions) (GrantPermissionResponse, error) {
	var err error
	req, err := client.grantPermissionCreateRequest(ctx, hub, permission, connectionID, options)
	if err != nil {
		return GrantPermissionResponse{}, err
	}
	httpResp, err := client.internal.Pipeline().Do(req)
	if err != nil {
		return GrantPermissionResponse{}, err
	}
	if !runtime.HasStatusCode(httpResp, http.StatusOK) {
		err = runtime.NewResponseError(httpResp)
		return GrantPermissionResponse{}, err
	}
	return GrantPermissionResponse{}, nil
}

// grantPermissionCreateRequest creates the GrantPermission request.
func (client *Client) grantPermissionCreateRequest(ctx context.Context, hub string, permission Permission, connectionID string, options *GrantPermissionOptions) (*policy.Request, error) {
	urlPath := "/api/hubs/{hub}/permissions/{permission}/connections/{connectionId}"
	if hub == "" {
		return nil, errors.New("parameter hub cannot be empty")
	}
	urlPath = strings.ReplaceAll(urlPath, "{hub}", url.PathEscape(hub))
	if permission == "" {
		return nil, errors.New("parameter permission cannot be empty")
	}
	urlPath = strings.ReplaceAll(urlPath, "{permission}", url.PathEscape(string(permission)))
	if connectionID == "" {
		return nil, errors.New("parameter connectionID cannot be empty")
	}
	urlPath = strings.ReplaceAll(urlPath, "{connectionId}", url.PathEscape(connectionID))
	req, err := runtime.NewRequest(ctx, http.MethodPut, runtime.JoinPaths(client.endpoint, urlPath))
	if err != nil {
		return nil, err
	}
	reqQP := req.Raw().URL.Query()
	if options != nil && options.TargetName != nil {
		reqQP.Set("targetName", *options.TargetName)
	}
	reqQP.Set("api-version", "2023-07-01")
	req.Raw().URL.RawQuery = reqQP.Encode()
	req.Raw().Header["Accept"] = []string{"application/json"}
	return req, nil
}

// groupExists - Check if there are any client connections inside the given group
// If the operation fails it returns an *azcore.ResponseError type.
//
// Generated from API version 2023-07-01
//   - hub - Target hub name, which should start with alphabetic characters and only contain alpha-numeric characters or underscore.
//   - group - Target group name, which length should be greater than 0 and less than 1025.
//   - options - GroupExistsOptions contains the optional parameters for the Client.groupExists method.
func (client *Client) groupExists(ctx context.Context, hub string, group string, options *GroupExistsOptions) (GroupExistsResponse, error) {
	var err error
	req, err := client.groupExistsCreateRequest(ctx, hub, group, options)
	if err != nil {
		return GroupExistsResponse{}, err
	}
	httpResp, err := client.internal.Pipeline().Do(req)
	if err != nil {
		return GroupExistsResponse{}, err
	}
	if !runtime.HasStatusCode(httpResp, http.StatusOK, http.StatusNotFound) {
		err = runtime.NewResponseError(httpResp)
		return GroupExistsResponse{}, err
	}
	return GroupExistsResponse{}, nil
}

// groupExistsCreateRequest creates the groupExists request.
func (client *Client) groupExistsCreateRequest(ctx context.Context, hub string, group string, options *GroupExistsOptions) (*policy.Request, error) {
	urlPath := "/api/hubs/{hub}/groups/{group}"
	if hub == "" {
		return nil, errors.New("parameter hub cannot be empty")
	}
	urlPath = strings.ReplaceAll(urlPath, "{hub}", url.PathEscape(hub))
	if group == "" {
		return nil, errors.New("parameter group cannot be empty")
	}
	urlPath = strings.ReplaceAll(urlPath, "{group}", url.PathEscape(group))
	req, err := runtime.NewRequest(ctx, http.MethodHead, runtime.JoinPaths(client.endpoint, urlPath))
	if err != nil {
		return nil, err
	}
	reqQP := req.Raw().URL.Query()
	reqQP.Set("api-version", "2023-07-01")
	req.Raw().URL.RawQuery = reqQP.Encode()
	return req, nil
}

// RemoveConnectionFromAllGroups - Remove a connection from all groups.
// If the operation fails it returns an *azcore.ResponseError type.
//
// Generated from API version 2023-07-01
//   - hub - Target hub name, which should start with alphabetic characters and only contain alpha-numeric characters or underscore.
//   - connectionID - Target connection Id.
//   - options - RemoveConnectionFromAllGroupsOptions contains the optional parameters for the Client.RemoveConnectionFromAllGroups
//     method.
func (client *Client) RemoveConnectionFromAllGroups(ctx context.Context, hub string, connectionID string, options *RemoveConnectionFromAllGroupsOptions) (RemoveConnectionFromAllGroupsResponse, error) {
	var err error
	req, err := client.removeConnectionFromAllGroupsCreateRequest(ctx, hub, connectionID, options)
	if err != nil {
		return RemoveConnectionFromAllGroupsResponse{}, err
	}
	httpResp, err := client.internal.Pipeline().Do(req)
	if err != nil {
		return RemoveConnectionFromAllGroupsResponse{}, err
	}
	if !runtime.HasStatusCode(httpResp, http.StatusNoContent) {
		err = runtime.NewResponseError(httpResp)
		return RemoveConnectionFromAllGroupsResponse{}, err
	}
	return RemoveConnectionFromAllGroupsResponse{}, nil
}

// removeConnectionFromAllGroupsCreateRequest creates the RemoveConnectionFromAllGroups request.
func (client *Client) removeConnectionFromAllGroupsCreateRequest(ctx context.Context, hub string, connectionID string, options *RemoveConnectionFromAllGroupsOptions) (*policy.Request, error) {
	urlPath := "/api/hubs/{hub}/connections/{connectionId}/groups"
	if hub == "" {
		return nil, errors.New("parameter hub cannot be empty")
	}
	urlPath = strings.ReplaceAll(urlPath, "{hub}", url.PathEscape(hub))
	if connectionID == "" {
		return nil, errors.New("parameter connectionID cannot be empty")
	}
	urlPath = strings.ReplaceAll(urlPath, "{connectionId}", url.PathEscape(connectionID))
	req, err := runtime.NewRequest(ctx, http.MethodDelete, runtime.JoinPaths(client.endpoint, urlPath))
	if err != nil {
		return nil, err
	}
	reqQP := req.Raw().URL.Query()
	reqQP.Set("api-version", "2023-07-01")
	req.Raw().URL.RawQuery = reqQP.Encode()
	req.Raw().Header["Accept"] = []string{"application/json"}
	return req, nil
}

// RemoveConnectionFromGroup - Remove a connection from the target group.
// If the operation fails it returns an *azcore.ResponseError type.
//
// Generated from API version 2023-07-01
//   - hub - Target hub name, which should start with alphabetic characters and only contain alpha-numeric characters or underscore.
//   - group - Target group name, which length should be greater than 0 and less than 1025.
//   - connectionID - Target connection Id.
//   - options - RemoveConnectionFromGroupOptions contains the optional parameters for the Client.RemoveConnectionFromGroup
//     method.
func (client *Client) RemoveConnectionFromGroup(ctx context.Context, hub string, group string, connectionID string, options *RemoveConnectionFromGroupOptions) (RemoveConnectionFromGroupResponse, error) {
	var err error
	req, err := client.removeConnectionFromGroupCreateRequest(ctx, hub, group, connectionID, options)
	if err != nil {
		return RemoveConnectionFromGroupResponse{}, err
	}
	httpResp, err := client.internal.Pipeline().Do(req)
	if err != nil {
		return RemoveConnectionFromGroupResponse{}, err
	}
	if !runtime.HasStatusCode(httpResp, http.StatusNoContent) {
		err = runtime.NewResponseError(httpResp)
		return RemoveConnectionFromGroupResponse{}, err
	}
	return RemoveConnectionFromGroupResponse{}, nil
}

// removeConnectionFromGroupCreateRequest creates the RemoveConnectionFromGroup request.
func (client *Client) removeConnectionFromGroupCreateRequest(ctx context.Context, hub string, group string, connectionID string, options *RemoveConnectionFromGroupOptions) (*policy.Request, error) {
	urlPath := "/api/hubs/{hub}/groups/{group}/connections/{connectionId}"
	if hub == "" {
		return nil, errors.New("parameter hub cannot be empty")
	}
	urlPath = strings.ReplaceAll(urlPath, "{hub}", url.PathEscape(hub))
	if group == "" {
		return nil, errors.New("parameter group cannot be empty")
	}
	urlPath = strings.ReplaceAll(urlPath, "{group}", url.PathEscape(group))
	if connectionID == "" {
		return nil, errors.New("parameter connectionID cannot be empty")
	}
	urlPath = strings.ReplaceAll(urlPath, "{connectionId}", url.PathEscape(connectionID))
	req, err := runtime.NewRequest(ctx, http.MethodDelete, runtime.JoinPaths(client.endpoint, urlPath))
	if err != nil {
		return nil, err
	}
	reqQP := req.Raw().URL.Query()
	reqQP.Set("api-version", "2023-07-01")
	req.Raw().URL.RawQuery = reqQP.Encode()
	req.Raw().Header["Accept"] = []string{"application/json"}
	return req, nil
}

// RemoveConnectionsFromGroups - Remove filtered connections from multiple groups.
// If the operation fails it returns an *azcore.ResponseError type.
//
// Generated from API version 2023-07-01
//   - hub - Target hub name, which should start with alphabetic characters and only contain alpha-numeric characters or underscore.
//   - groupsToRemove - Target groups and connection filter.
//   - options - RemoveConnectionsFromGroupsOptions contains the optional parameters for the Client.RemoveConnectionsFromGroups
//     method.
func (client *Client) RemoveConnectionsFromGroups(ctx context.Context, hub string, groupsToRemove RemoveFromGroupsRequest, options *RemoveConnectionsFromGroupsOptions) (RemoveConnectionsFromGroupsResponse, error) {
	var err error
	req, err := client.removeConnectionsFromGroupsCreateRequest(ctx, hub, groupsToRemove, options)
	if err != nil {
		return RemoveConnectionsFromGroupsResponse{}, err
	}
	httpResp, err := client.internal.Pipeline().Do(req)
	if err != nil {
		return RemoveConnectionsFromGroupsResponse{}, err
	}
	if !runtime.HasStatusCode(httpResp, http.StatusOK) {
		err = runtime.NewResponseError(httpResp)
		return RemoveConnectionsFromGroupsResponse{}, err
	}
	return RemoveConnectionsFromGroupsResponse{}, nil
}

// removeConnectionsFromGroupsCreateRequest creates the RemoveConnectionsFromGroups request.
func (client *Client) removeConnectionsFromGroupsCreateRequest(ctx context.Context, hub string, groupsToRemove RemoveFromGroupsRequest, options *RemoveConnectionsFromGroupsOptions) (*policy.Request, error) {
	urlPath := "/api/hubs/{hub}/:removeFromGroups"
	if hub == "" {
		return nil, errors.New("parameter hub cannot be empty")
	}
	urlPath = strings.ReplaceAll(urlPath, "{hub}", url.PathEscape(hub))
	req, err := runtime.NewRequest(ctx, http.MethodPost, runtime.JoinPaths(client.endpoint, urlPath))
	if err != nil {
		return nil, err
	}
	reqQP := req.Raw().URL.Query()
	reqQP.Set("api-version", "2023-07-01")
	req.Raw().URL.RawQuery = reqQP.Encode()
	req.Raw().Header["Accept"] = []string{"application/json"}
	if err := runtime.MarshalAsJSON(req, groupsToRemove); err != nil {
		return nil, err
	}
	return req, nil
}

// RemoveUserFromAllGroups - Remove a user from all groups.
// If the operation fails it returns an *azcore.ResponseError type.
//
// Generated from API version 2023-07-01
//   - hub - Target hub name, which should start with alphabetic characters and only contain alpha-numeric characters or underscore.
//   - userID - Target user Id.
//   - options - RemoveUserFromAllGroupsOptions contains the optional parameters for the Client.RemoveUserFromAllGroups
//     method.
func (client *Client) RemoveUserFromAllGroups(ctx context.Context, hub string, userID string, options *RemoveUserFromAllGroupsOptions) (RemoveUserFromAllGroupsResponse, error) {
	var err error
	req, err := client.removeUserFromAllGroupsCreateRequest(ctx, hub, userID, options)
	if err != nil {
		return RemoveUserFromAllGroupsResponse{}, err
	}
	httpResp, err := client.internal.Pipeline().Do(req)
	if err != nil {
		return RemoveUserFromAllGroupsResponse{}, err
	}
	if !runtime.HasStatusCode(httpResp, http.StatusNoContent) {
		err = runtime.NewResponseError(httpResp)
		return RemoveUserFromAllGroupsResponse{}, err
	}
	return RemoveUserFromAllGroupsResponse{}, nil
}

// removeUserFromAllGroupsCreateRequest creates the RemoveUserFromAllGroups request.
func (client *Client) removeUserFromAllGroupsCreateRequest(ctx context.Context, hub string, userID string, options *RemoveUserFromAllGroupsOptions) (*policy.Request, error) {
	urlPath := "/api/hubs/{hub}/users/{userId}/groups"
	if hub == "" {
		return nil, errors.New("parameter hub cannot be empty")
	}
	urlPath = strings.ReplaceAll(urlPath, "{hub}", url.PathEscape(hub))
	if userID == "" {
		return nil, errors.New("parameter userID cannot be empty")
	}
	urlPath = strings.ReplaceAll(urlPath, "{userId}", url.PathEscape(userID))
	req, err := runtime.NewRequest(ctx, http.MethodDelete, runtime.JoinPaths(client.endpoint, urlPath))
	if err != nil {
		return nil, err
	}
	reqQP := req.Raw().URL.Query()
	reqQP.Set("api-version", "2023-07-01")
	req.Raw().URL.RawQuery = reqQP.Encode()
	req.Raw().Header["Accept"] = []string{"application/json"}
	return req, nil
}

// RemoveUserFromGroup - Remove a user from the target group.
// If the operation fails it returns an *azcore.ResponseError type.
//
// Generated from API version 2023-07-01
//   - hub - Target hub name, which should start with alphabetic characters and only contain alpha-numeric characters or underscore.
//   - group - Target group name, which length should be greater than 0 and less than 1025.
//   - userID - Target user Id.
//   - options - RemoveUserFromGroupOptions contains the optional parameters for the Client.RemoveUserFromGroup method.
func (client *Client) RemoveUserFromGroup(ctx context.Context, hub string, group string, userID string, options *RemoveUserFromGroupOptions) (RemoveUserFromGroupResponse, error) {
	var err error
	req, err := client.removeUserFromGroupCreateRequest(ctx, hub, group, userID, options)
	if err != nil {
		return RemoveUserFromGroupResponse{}, err
	}
	httpResp, err := client.internal.Pipeline().Do(req)
	if err != nil {
		return RemoveUserFromGroupResponse{}, err
	}
	if !runtime.HasStatusCode(httpResp, http.StatusNoContent) {
		err = runtime.NewResponseError(httpResp)
		return RemoveUserFromGroupResponse{}, err
	}
	return RemoveUserFromGroupResponse{}, nil
}

// removeUserFromGroupCreateRequest creates the RemoveUserFromGroup request.
func (client *Client) removeUserFromGroupCreateRequest(ctx context.Context, hub string, group string, userID string, options *RemoveUserFromGroupOptions) (*policy.Request, error) {
	urlPath := "/api/hubs/{hub}/users/{userId}/groups/{group}"
	if hub == "" {
		return nil, errors.New("parameter hub cannot be empty")
	}
	urlPath = strings.ReplaceAll(urlPath, "{hub}", url.PathEscape(hub))
	if group == "" {
		return nil, errors.New("parameter group cannot be empty")
	}
	urlPath = strings.ReplaceAll(urlPath, "{group}", url.PathEscape(group))
	if userID == "" {
		return nil, errors.New("parameter userID cannot be empty")
	}
	urlPath = strings.ReplaceAll(urlPath, "{userId}", url.PathEscape(userID))
	req, err := runtime.NewRequest(ctx, http.MethodDelete, runtime.JoinPaths(client.endpoint, urlPath))
	if err != nil {
		return nil, err
	}
	reqQP := req.Raw().URL.Query()
	reqQP.Set("api-version", "2023-07-01")
	req.Raw().URL.RawQuery = reqQP.Encode()
	req.Raw().Header["Accept"] = []string{"application/json"}
	return req, nil
}

// RevokePermission - Revoke permission for the connection.
// If the operation fails it returns an *azcore.ResponseError type.
//
// Generated from API version 2023-07-01
//   - hub - Target hub name, which should start with alphabetic characters and only contain alpha-numeric characters or underscore.
//   - permission - The permission: current supported actions are joinLeaveGroup and sendToGroup.
//   - connectionID - Target connection Id.
//   - options - RevokePermissionOptions contains the optional parameters for the Client.RevokePermission method.
func (client *Client) RevokePermission(ctx context.Context, hub string, permission Permission, connectionID string, options *RevokePermissionOptions) (RevokePermissionResponse, error) {
	var err error
	req, err := client.revokePermissionCreateRequest(ctx, hub, permission, connectionID, options)
	if err != nil {
		return RevokePermissionResponse{}, err
	}
	httpResp, err := client.internal.Pipeline().Do(req)
	if err != nil {
		return RevokePermissionResponse{}, err
	}
	if !runtime.HasStatusCode(httpResp, http.StatusNoContent) {
		err = runtime.NewResponseError(httpResp)
		return RevokePermissionResponse{}, err
	}
	return RevokePermissionResponse{}, nil
}

// revokePermissionCreateRequest creates the RevokePermission request.
func (client *Client) revokePermissionCreateRequest(ctx context.Context, hub string, permission Permission, connectionID string, options *RevokePermissionOptions) (*policy.Request, error) {
	urlPath := "/api/hubs/{hub}/permissions/{permission}/connections/{connectionId}"
	if hub == "" {
		return nil, errors.New("parameter hub cannot be empty")
	}
	urlPath = strings.ReplaceAll(urlPath, "{hub}", url.PathEscape(hub))
	if permission == "" {
		return nil, errors.New("parameter permission cannot be empty")
	}
	urlPath = strings.ReplaceAll(urlPath, "{permission}", url.PathEscape(string(permission)))
	if connectionID == "" {
		return nil, errors.New("parameter connectionID cannot be empty")
	}
	urlPath = strings.ReplaceAll(urlPath, "{connectionId}", url.PathEscape(connectionID))
	req, err := runtime.NewRequest(ctx, http.MethodDelete, runtime.JoinPaths(client.endpoint, urlPath))
	if err != nil {
		return nil, err
	}
	reqQP := req.Raw().URL.Query()
	if options != nil && options.TargetName != nil {
		reqQP.Set("targetName", *options.TargetName)
	}
	reqQP.Set("api-version", "2023-07-01")
	req.Raw().URL.RawQuery = reqQP.Encode()
	req.Raw().Header["Accept"] = []string{"application/json"}
	return req, nil
}

// SendToAll - Broadcast content inside request body to all the connected client connections.
// If the operation fails it returns an *azcore.ResponseError type.
//
// Generated from API version 2023-07-01
//   - hub - Target hub name, which should start with alphabetic characters and only contain alpha-numeric characters or underscore.
//   - contentType - Upload file type
//   - message - The payload body.
//   - options - SendToAllOptions contains the optional parameters for the Client.SendToAll method.
func (client *Client) SendToAll(ctx context.Context, hub string, contentType ContentType, message io.ReadSeekCloser, options *SendToAllOptions) (SendToAllResponse, error) {
	var err error
	req, err := client.sendToAllCreateRequest(ctx, hub, contentType, message, options)
	if err != nil {
		return SendToAllResponse{}, err
	}
	httpResp, err := client.internal.Pipeline().Do(req)
	if err != nil {
		return SendToAllResponse{}, err
	}
	if !runtime.HasStatusCode(httpResp, http.StatusAccepted) {
		err = runtime.NewResponseError(httpResp)
		return SendToAllResponse{}, err
	}
	return SendToAllResponse{}, nil
}

// sendToAllCreateRequest creates the SendToAll request.
func (client *Client) sendToAllCreateRequest(ctx context.Context, hub string, contentType ContentType, message io.ReadSeekCloser, options *SendToAllOptions) (*policy.Request, error) {
	urlPath := "/api/hubs/{hub}/:send"
	if hub == "" {
		return nil, errors.New("parameter hub cannot be empty")
	}
	urlPath = strings.ReplaceAll(urlPath, "{hub}", url.PathEscape(hub))
	req, err := runtime.NewRequest(ctx, http.MethodPost, runtime.JoinPaths(client.endpoint, urlPath))
	if err != nil {
		return nil, err
	}
	reqQP := req.Raw().URL.Query()
	if options != nil && options.Excluded != nil {
		for _, qv := range options.Excluded {
			reqQP.Add("excluded", qv)
		}
	}
	reqQP.Set("api-version", "2023-07-01")
	if options != nil && options.Filter != nil {
		reqQP.Set("filter", *options.Filter)
	}
	if options != nil && options.MessageTTLSeconds != nil {
		reqQP.Set("messageTtlSeconds", strconv.FormatInt(int64(*options.MessageTTLSeconds), 10))
	}
	req.Raw().URL.RawQuery = reqQP.Encode()
	req.Raw().Header["Content-Type"] = []string{string(contentType)}
	req.Raw().Header["Accept"] = []string{"application/json"}
	if err := req.SetBody(message, string(contentType)); err != nil {
		return nil, err
	}
	return req, nil
}

// SendToConnection - Send content inside request body to the specific connection.
// If the operation fails it returns an *azcore.ResponseError type.
//
// Generated from API version 2023-07-01
//   - hub - Target hub name, which should start with alphabetic characters and only contain alpha-numeric characters or underscore.
//   - connectionID - The connection Id.
//   - contentType - Upload file type
//   - message - The payload body.
//   - options - SendToConnectionOptions contains the optional parameters for the Client.SendToConnection method.
func (client *Client) SendToConnection(ctx context.Context, hub string, connectionID string, contentType ContentType, message io.ReadSeekCloser, options *SendToConnectionOptions) (SendToConnectionResponse, error) {
	var err error
	req, err := client.sendToConnectionCreateRequest(ctx, hub, connectionID, contentType, message, options)
	if err != nil {
		return SendToConnectionResponse{}, err
	}
	httpResp, err := client.internal.Pipeline().Do(req)
	if err != nil {
		return SendToConnectionResponse{}, err
	}
	if !runtime.HasStatusCode(httpResp, http.StatusAccepted) {
		err = runtime.NewResponseError(httpResp)
		return SendToConnectionResponse{}, err
	}
	return SendToConnectionResponse{}, nil
}

// sendToConnectionCreateRequest creates the SendToConnection request.
func (client *Client) sendToConnectionCreateRequest(ctx context.Context, hub string, connectionID string, contentType ContentType, message io.ReadSeekCloser, options *SendToConnectionOptions) (*policy.Request, error) {
	urlPath := "/api/hubs/{hub}/connections/{connectionId}/:send"
	if hub == "" {
		return nil, errors.New("parameter hub cannot be empty")
	}
	urlPath = strings.ReplaceAll(urlPath, "{hub}", url.PathEscape(hub))
	if connectionID == "" {
		return nil, errors.New("parameter connectionID cannot be empty")
	}
	urlPath = strings.ReplaceAll(urlPath, "{connectionId}", url.PathEscape(connectionID))
	req, err := runtime.NewRequest(ctx, http.MethodPost, runtime.JoinPaths(client.endpoint, urlPath))
	if err != nil {
		return nil, err
	}
	reqQP := req.Raw().URL.Query()
	reqQP.Set("api-version", "2023-07-01")
	if options != nil && options.MessageTTLSeconds != nil {
		reqQP.Set("messageTtlSeconds", strconv.FormatInt(int64(*options.MessageTTLSeconds), 10))
	}
	req.Raw().URL.RawQuery = reqQP.Encode()
	req.Raw().Header["Content-Type"] = []string{string(contentType)}
	req.Raw().Header["Accept"] = []string{"application/json"}
	if err := req.SetBody(message, string(contentType)); err != nil {
		return nil, err
	}
	return req, nil
}

// SendToGroup - Send content inside request body to a group of connections.
// If the operation fails it returns an *azcore.ResponseError type.
//
// Generated from API version 2023-07-01
//   - hub - Target hub name, which should start with alphabetic characters and only contain alpha-numeric characters or underscore.
//   - group - Target group name, which length should be greater than 0 and less than 1025.
//   - contentType - Upload file type
//   - message - The payload body.
//   - options - SendToGroupOptions contains the optional parameters for the Client.SendToGroup method.
func (client *Client) SendToGroup(ctx context.Context, hub string, group string, contentType ContentType, message io.ReadSeekCloser, options *SendToGroupOptions) (SendToGroupResponse, error) {
	var err error
	req, err := client.sendToGroupCreateRequest(ctx, hub, group, contentType, message, options)
	if err != nil {
		return SendToGroupResponse{}, err
	}
	httpResp, err := client.internal.Pipeline().Do(req)
	if err != nil {
		return SendToGroupResponse{}, err
	}
	if !runtime.HasStatusCode(httpResp, http.StatusAccepted) {
		err = runtime.NewResponseError(httpResp)
		return SendToGroupResponse{}, err
	}
	return SendToGroupResponse{}, nil
}

// sendToGroupCreateRequest creates the SendToGroup request.
func (client *Client) sendToGroupCreateRequest(ctx context.Context, hub string, group string, contentType ContentType, message io.ReadSeekCloser, options *SendToGroupOptions) (*policy.Request, error) {
	urlPath := "/api/hubs/{hub}/groups/{group}/:send"
	if hub == "" {
		return nil, errors.New("parameter hub cannot be empty")
	}
	urlPath = strings.ReplaceAll(urlPath, "{hub}", url.PathEscape(hub))
	if group == "" {
		return nil, errors.New("parameter group cannot be empty")
	}
	urlPath = strings.ReplaceAll(urlPath, "{group}", url.PathEscape(group))
	req, err := runtime.NewRequest(ctx, http.MethodPost, runtime.JoinPaths(client.endpoint, urlPath))
	if err != nil {
		return nil, err
	}
	reqQP := req.Raw().URL.Query()
	if options != nil && options.Excluded != nil {
		for _, qv := range options.Excluded {
			reqQP.Add("excluded", qv)
		}
	}
	reqQP.Set("api-version", "2023-07-01")
	if options != nil && options.Filter != nil {
		reqQP.Set("filter", *options.Filter)
	}
	if options != nil && options.MessageTTLSeconds != nil {
		reqQP.Set("messageTtlSeconds", strconv.FormatInt(int64(*options.MessageTTLSeconds), 10))
	}
	req.Raw().URL.RawQuery = reqQP.Encode()
	req.Raw().Header["Content-Type"] = []string{string(contentType)}
	req.Raw().Header["Accept"] = []string{"application/json"}
	if err := req.SetBody(message, string(contentType)); err != nil {
		return nil, err
	}
	return req, nil
}

// SendToUser - Send content inside request body to the specific user.
// If the operation fails it returns an *azcore.ResponseError type.
//
// Generated from API version 2023-07-01
//   - hub - Target hub name, which should start with alphabetic characters and only contain alpha-numeric characters or underscore.
//   - userID - The user Id.
//   - contentType - Upload file type
//   - message - The payload body.
//   - options - SendToUserOptions contains the optional parameters for the Client.SendToUser method.
func (client *Client) SendToUser(ctx context.Context, hub string, userID string, contentType ContentType, message io.ReadSeekCloser, options *SendToUserOptions) (SendToUserResponse, error) {
	var err error
	req, err := client.sendToUserCreateRequest(ctx, hub, userID, contentType, message, options)
	if err != nil {
		return SendToUserResponse{}, err
	}
	httpResp, err := client.internal.Pipeline().Do(req)
	if err != nil {
		return SendToUserResponse{}, err
	}
	if !runtime.HasStatusCode(httpResp, http.StatusAccepted) {
		err = runtime.NewResponseError(httpResp)
		return SendToUserResponse{}, err
	}
	return SendToUserResponse{}, nil
}

// sendToUserCreateRequest creates the SendToUser request.
func (client *Client) sendToUserCreateRequest(ctx context.Context, hub string, userID string, contentType ContentType, message io.ReadSeekCloser, options *SendToUserOptions) (*policy.Request, error) {
	urlPath := "/api/hubs/{hub}/users/{userId}/:send"
	if hub == "" {
		return nil, errors.New("parameter hub cannot be empty")
	}
	urlPath = strings.ReplaceAll(urlPath, "{hub}", url.PathEscape(hub))
	if userID == "" {
		return nil, errors.New("parameter userID cannot be empty")
	}
	urlPath = strings.ReplaceAll(urlPath, "{userId}", url.PathEscape(userID))
	req, err := runtime.NewRequest(ctx, http.MethodPost, runtime.JoinPaths(client.endpoint, urlPath))
	if err != nil {
		return nil, err
	}
	reqQP := req.Raw().URL.Query()
	reqQP.Set("api-version", "2023-07-01")
	if options != nil && options.Filter != nil {
		reqQP.Set("filter", *options.Filter)
	}
	if options != nil && options.MessageTTLSeconds != nil {
		reqQP.Set("messageTtlSeconds", strconv.FormatInt(int64(*options.MessageTTLSeconds), 10))
	}
	req.Raw().URL.RawQuery = reqQP.Encode()
	req.Raw().Header["Content-Type"] = []string{string(contentType)}
	req.Raw().Header["Accept"] = []string{"application/json"}
	if err := req.SetBody(message, string(contentType)); err != nil {
		return nil, err
	}
	return req, nil
}

// userExists - Check if there are any client connections connected for the given user.
// If the operation fails it returns an *azcore.ResponseError type.
//
// Generated from API version 2023-07-01
//   - hub - Target hub name, which should start with alphabetic characters and only contain alpha-numeric characters or underscore.
//   - userID - Target user Id.
//   - options - UserExistsOptions contains the optional parameters for the Client.userExists method.
func (client *Client) userExists(ctx context.Context, hub string, userID string, options *UserExistsOptions) (UserExistsResponse, error) {
	var err error
	req, err := client.userExistsCreateRequest(ctx, hub, userID, options)
	if err != nil {
		return UserExistsResponse{}, err
	}
	httpResp, err := client.internal.Pipeline().Do(req)
	if err != nil {
		return UserExistsResponse{}, err
	}
	if !runtime.HasStatusCode(httpResp, http.StatusOK, http.StatusNotFound) {
		err = runtime.NewResponseError(httpResp)
		return UserExistsResponse{}, err
	}
	return UserExistsResponse{}, nil
}

// userExistsCreateRequest creates the userExists request.
func (client *Client) userExistsCreateRequest(ctx context.Context, hub string, userID string, options *UserExistsOptions) (*policy.Request, error) {
	urlPath := "/api/hubs/{hub}/users/{userId}"
	if hub == "" {
		return nil, errors.New("parameter hub cannot be empty")
	}
	urlPath = strings.ReplaceAll(urlPath, "{hub}", url.PathEscape(hub))
	if userID == "" {
		return nil, errors.New("parameter userID cannot be empty")
	}
	urlPath = strings.ReplaceAll(urlPath, "{userId}", url.PathEscape(userID))
	req, err := runtime.NewRequest(ctx, http.MethodHead, runtime.JoinPaths(client.endpoint, urlPath))
	if err != nil {
		return nil, err
	}
	reqQP := req.Raw().URL.Query()
	reqQP.Set("api-version", "2023-07-01")
	req.Raw().URL.RawQuery = reqQP.Encode()
	return req, nil
}
