//go:build go1.18
// +build go1.18

// Copyright (c) Microsoft Corporation. All rights reserved.
// Licensed under the MIT License. See License.txt in the project root for license information.
// Code generated by Microsoft (R) AutoRest Code Generator.
// Changes may cause incorrect behavior and will be lost if the code is regenerated.
// DO NOT EDIT.

package armalertsmanagement_test

import (
	"context"
	"log"

	"github.com/Azure/azure-sdk-for-go/sdk/azcore/to"
	"github.com/Azure/azure-sdk-for-go/sdk/azidentity"
	"github.com/Azure/azure-sdk-for-go/sdk/resourcemanager/alertsmanagement/armalertsmanagement"
)

// Generated from example definition: https://github.com/Azure/azure-rest-api-specs/blob/6d2438481021a94793b07b226df06d5f3c61d51d/specification/alertsmanagement/resource-manager/Microsoft.AlertsManagement/preview/2023-04-01-preview/examples/TenantActivityLogAlertRule_CreateOrUpdate.json
func ExampleTenantActivityLogAlertsClient_CreateOrUpdate() {
	cred, err := azidentity.NewDefaultAzureCredential(nil)
	if err != nil {
		log.Fatalf("failed to obtain a credential: %v", err)
	}
	ctx := context.Background()
	clientFactory, err := armalertsmanagement.NewClientFactory("<subscription-id>", cred, nil)
	if err != nil {
		log.Fatalf("failed to create client: %v", err)
	}
	res, err := clientFactory.NewTenantActivityLogAlertsClient().CreateOrUpdate(ctx, "72f988bf-86f1-41af-91ab-2d7cd011db47", "SampleActivityLogAlertSHRuleOnTenantLevel", armalertsmanagement.TenantActivityLogAlertResource{
		Location: to.Ptr("Global"),
		Tags:     map[string]*string{},
		Properties: &armalertsmanagement.AlertRuleProperties{
			Description: to.Ptr("Description of sample Activity Log Alert service health rule on tenant level events."),
			Actions: &armalertsmanagement.ActionList{
				ActionGroups: []*armalertsmanagement.ActionGroup{
					{
						ActionGroupID: to.Ptr("/providers/Microsoft.Management/ManagementGroups/72f988bf-86f1-41af-91ab-2d7cd011db47/providers/Microsoft.Insights/actionGroups/SampleActionGroup"),
						ActionProperties: map[string]*string{
							"Email.Title": to.Ptr("my email title"),
						},
						WebhookProperties: map[string]*string{
							"sampleWebhookProperty": to.Ptr("SamplePropertyValue"),
						},
					}},
			},
			Condition: &armalertsmanagement.AlertRuleAllOfCondition{
				AllOf: []*armalertsmanagement.AlertRuleAnyOfOrLeafCondition{
					{
						Equals: to.Ptr("ServiceHealth"),
						Field:  to.Ptr("category"),
					}},
			},
			Enabled:     to.Ptr(true),
			TenantScope: to.Ptr("72f988bf-86f1-41af-91ab-2d7cd011db47"),
		},
	}, nil)
	if err != nil {
		log.Fatalf("failed to finish the request: %v", err)
	}
	// You could use response here. We use blank identifier for just demo purposes.
	_ = res
	// If the HTTP response code is 200 as defined in example definition, your response structure would look as follows. Please pay attention that all the values in the output are fake values for just demo purposes.
	// res.TenantActivityLogAlertResource = armalertsmanagement.TenantActivityLogAlertResource{
	// 	Name: to.Ptr("SampleActivityLogAlertSHRuleOnTenantLevel"),
	// 	Type: to.Ptr("Microsoft.AlertsManagement/TenantActivityLogAlerts"),
	// 	ID: to.Ptr("/providers/Microsoft.Management/ManagementGroups/72f988bf-86f1-41af-91ab-2d7cd011db47/providers/Microsoft.AlertsManagement/TenantActivityLogAlerts/SampleActivityLogAlertSHRuleOnTenantLevel"),
	// 	Location: to.Ptr("Global"),
	// 	Tags: map[string]*string{
	// 	},
	// 	Properties: &armalertsmanagement.AlertRuleProperties{
	// 		Description: to.Ptr("Description of sample Activity Log Alert service health rule on tenant level events."),
	// 		Actions: &armalertsmanagement.ActionList{
	// 			ActionGroups: []*armalertsmanagement.ActionGroup{
	// 				{
	// 					ActionGroupID: to.Ptr("/providers/Microsoft.Management/ManagementGroups/72f988bf-86f1-41af-91ab-2d7cd011db47/providers/Microsoft.Insights/actionGroups/SampleActionGroup"),
	// 					ActionProperties: map[string]*string{
	// 						"Email.Title": to.Ptr("my email title"),
	// 					},
	// 					WebhookProperties: map[string]*string{
	// 						"sampleWebhookProperty": to.Ptr("SamplePropertyValue"),
	// 					},
	// 			}},
	// 		},
	// 		Condition: &armalertsmanagement.AlertRuleAllOfCondition{
	// 			AllOf: []*armalertsmanagement.AlertRuleAnyOfOrLeafCondition{
	// 				{
	// 					Equals: to.Ptr("ServiceHealth"),
	// 					Field: to.Ptr("category"),
	// 			}},
	// 		},
	// 		Enabled: to.Ptr(true),
	// 		TenantScope: to.Ptr("72f988bf-86f1-41af-91ab-2d7cd011db47"),
	// 	},
	// }
}

// Generated from example definition: https://github.com/Azure/azure-rest-api-specs/blob/6d2438481021a94793b07b226df06d5f3c61d51d/specification/alertsmanagement/resource-manager/Microsoft.AlertsManagement/preview/2023-04-01-preview/examples/TenantActivityLogAlertRule_GetRule.json
func ExampleTenantActivityLogAlertsClient_Get() {
	cred, err := azidentity.NewDefaultAzureCredential(nil)
	if err != nil {
		log.Fatalf("failed to obtain a credential: %v", err)
	}
	ctx := context.Background()
	clientFactory, err := armalertsmanagement.NewClientFactory("<subscription-id>", cred, nil)
	if err != nil {
		log.Fatalf("failed to create client: %v", err)
	}
	res, err := clientFactory.NewTenantActivityLogAlertsClient().Get(ctx, "72f988bf-86f1-41af-91ab-2d7cd011db47", "SampleActivityLogAlertSHRuleOnTenantLevel", nil)
	if err != nil {
		log.Fatalf("failed to finish the request: %v", err)
	}
	// You could use response here. We use blank identifier for just demo purposes.
	_ = res
	// If the HTTP response code is 200 as defined in example definition, your response structure would look as follows. Please pay attention that all the values in the output are fake values for just demo purposes.
	// res.TenantActivityLogAlertResource = armalertsmanagement.TenantActivityLogAlertResource{
	// 	Name: to.Ptr("SampleActivityLogAlertSHRuleOnTenantLevel"),
	// 	Type: to.Ptr("Microsoft.AlertsManagement/TenantActivityLogAlerts"),
	// 	ID: to.Ptr("/providers/Microsoft.Management/ManagementGroups/72f988bf-86f1-41af-91ab-2d7cd011db47/providers/Microsoft.AlertsManagement/TenantActivityLogAlerts/SampleActivityLogAlertSHRuleOnTenantLevel"),
	// 	Location: to.Ptr("Global"),
	// 	Tags: map[string]*string{
	// 	},
	// 	Properties: &armalertsmanagement.AlertRuleProperties{
	// 		Description: to.Ptr("Description of sample Activity Log Alert service health rule on tenant level events."),
	// 		Actions: &armalertsmanagement.ActionList{
	// 			ActionGroups: []*armalertsmanagement.ActionGroup{
	// 				{
	// 					ActionGroupID: to.Ptr("/providers/Microsoft.Management/ManagementGroups/72f988bf-86f1-41af-91ab-2d7cd011db47/providers/Microsoft.Insights/actionGroups/SampleActionGroup"),
	// 					ActionProperties: map[string]*string{
	// 						"Email.Title": to.Ptr("my email title"),
	// 					},
	// 					WebhookProperties: map[string]*string{
	// 						"sampleWebhookProperty": to.Ptr("SamplePropertyValue"),
	// 					},
	// 			}},
	// 		},
	// 		Condition: &armalertsmanagement.AlertRuleAllOfCondition{
	// 			AllOf: []*armalertsmanagement.AlertRuleAnyOfOrLeafCondition{
	// 				{
	// 					Equals: to.Ptr("ServiceHealth"),
	// 					Field: to.Ptr("category"),
	// 			}},
	// 		},
	// 		Enabled: to.Ptr(true),
	// 		TenantScope: to.Ptr("72f988bf-86f1-41af-91ab-2d7cd011db47"),
	// 	},
	// }
}

// Generated from example definition: https://github.com/Azure/azure-rest-api-specs/blob/6d2438481021a94793b07b226df06d5f3c61d51d/specification/alertsmanagement/resource-manager/Microsoft.AlertsManagement/preview/2023-04-01-preview/examples/TenantActivityLogAlertRule_DeleteRule.json
func ExampleTenantActivityLogAlertsClient_Delete() {
	cred, err := azidentity.NewDefaultAzureCredential(nil)
	if err != nil {
		log.Fatalf("failed to obtain a credential: %v", err)
	}
	ctx := context.Background()
	clientFactory, err := armalertsmanagement.NewClientFactory("<subscription-id>", cred, nil)
	if err != nil {
		log.Fatalf("failed to create client: %v", err)
	}
	_, err = clientFactory.NewTenantActivityLogAlertsClient().Delete(ctx, "72f988bf-86f1-41af-91ab-2d7cd011db47", "SampleActivityLogAlertSHRuleOnTenantLevel", nil)
	if err != nil {
		log.Fatalf("failed to finish the request: %v", err)
	}
}

// Generated from example definition: https://github.com/Azure/azure-rest-api-specs/blob/6d2438481021a94793b07b226df06d5f3c61d51d/specification/alertsmanagement/resource-manager/Microsoft.AlertsManagement/preview/2023-04-01-preview/examples/TenantActivityLogAlertRule_UpdateRule.json
func ExampleTenantActivityLogAlertsClient_Update() {
	cred, err := azidentity.NewDefaultAzureCredential(nil)
	if err != nil {
		log.Fatalf("failed to obtain a credential: %v", err)
	}
	ctx := context.Background()
	clientFactory, err := armalertsmanagement.NewClientFactory("<subscription-id>", cred, nil)
	if err != nil {
		log.Fatalf("failed to create client: %v", err)
	}
	res, err := clientFactory.NewTenantActivityLogAlertsClient().Update(ctx, "72f988bf-86f1-41af-91ab-2d7cd011db47", "SampleActivityLogAlertSHRuleOnTenantLevel", armalertsmanagement.TenantAlertRulePatchObject{
		Properties: &armalertsmanagement.TenantAlertRulePatchProperties{
			Enabled: to.Ptr(false),
		},
		Tags: map[string]*string{
			"key1": to.Ptr("value1"),
			"key2": to.Ptr("value2"),
		},
	}, nil)
	if err != nil {
		log.Fatalf("failed to finish the request: %v", err)
	}
	// You could use response here. We use blank identifier for just demo purposes.
	_ = res
	// If the HTTP response code is 200 as defined in example definition, your response structure would look as follows. Please pay attention that all the values in the output are fake values for just demo purposes.
	// res.TenantActivityLogAlertResource = armalertsmanagement.TenantActivityLogAlertResource{
	// 	Name: to.Ptr("SampleActivityLogAlertSHRuleOnTenantLevel"),
	// 	Type: to.Ptr("Microsoft.AlertsManagement/TenantActivityLogAlerts"),
	// 	ID: to.Ptr("/providers/Microsoft.Management/ManagementGroups/72f988bf-86f1-41af-91ab-2d7cd011db47/providers/Microsoft.AlertsManagement/TenantActivityLogAlerts/SampleActivityLogAlertSHRuleOnTenantLevel"),
	// 	Location: to.Ptr("Global"),
	// 	Tags: map[string]*string{
	// 		"key1": to.Ptr("value1"),
	// 		"key2": to.Ptr("value2"),
	// 	},
	// 	Properties: &armalertsmanagement.AlertRuleProperties{
	// 		Description: to.Ptr("Description of sample Activity Log Alert service health rule on tenant level events."),
	// 		Actions: &armalertsmanagement.ActionList{
	// 			ActionGroups: []*armalertsmanagement.ActionGroup{
	// 				{
	// 					ActionGroupID: to.Ptr("/providers/Microsoft.Management/ManagementGroups/72f988bf-86f1-41af-91ab-2d7cd011db47/providers/Microsoft.Insights/actionGroups/SampleActionGroup"),
	// 					ActionProperties: map[string]*string{
	// 						"Email.Title": to.Ptr("my email title"),
	// 					},
	// 					WebhookProperties: map[string]*string{
	// 						"sampleWebhookProperty": to.Ptr("SamplePropertyValue"),
	// 					},
	// 			}},
	// 		},
	// 		Condition: &armalertsmanagement.AlertRuleAllOfCondition{
	// 			AllOf: []*armalertsmanagement.AlertRuleAnyOfOrLeafCondition{
	// 				{
	// 					Equals: to.Ptr("ServiceHealth"),
	// 					Field: to.Ptr("category"),
	// 			}},
	// 		},
	// 		Enabled: to.Ptr(false),
	// 		TenantScope: to.Ptr("72f988bf-86f1-41af-91ab-2d7cd011db47"),
	// 	},
	// }
}

// Generated from example definition: https://github.com/Azure/azure-rest-api-specs/blob/6d2438481021a94793b07b226df06d5f3c61d51d/specification/alertsmanagement/resource-manager/Microsoft.AlertsManagement/preview/2023-04-01-preview/examples/TenantActivityLogAlertRule_ListByTenant.json
func ExampleTenantActivityLogAlertsClient_NewListByTenantPager() {
	cred, err := azidentity.NewDefaultAzureCredential(nil)
	if err != nil {
		log.Fatalf("failed to obtain a credential: %v", err)
	}
	ctx := context.Background()
	clientFactory, err := armalertsmanagement.NewClientFactory("<subscription-id>", cred, nil)
	if err != nil {
		log.Fatalf("failed to create client: %v", err)
	}
	pager := clientFactory.NewTenantActivityLogAlertsClient().NewListByTenantPager(nil)
	for pager.More() {
		page, err := pager.NextPage(ctx)
		if err != nil {
			log.Fatalf("failed to advance page: %v", err)
		}
		for _, v := range page.Value {
			// You could use page here. We use blank identifier for just demo purposes.
			_ = v
		}
		// If the HTTP response code is 200 as defined in example definition, your page structure would look as follows. Please pay attention that all the values in the output are fake values for just demo purposes.
		// page.TenantAlertRuleList = armalertsmanagement.TenantAlertRuleList{
		// 	Value: []*armalertsmanagement.TenantActivityLogAlertResource{
		// 		{
		// 			Name: to.Ptr("SampleActivityLogAlertSHRuleOnTenantLevel"),
		// 			Type: to.Ptr("Microsoft.AlertsManagement/TenantActivityLogAlerts"),
		// 			ID: to.Ptr("/providers/Microsoft.Management/ManagementGroups/72f988bf-86f1-41af-91ab-2d7cd011db47/providers/Microsoft.AlertsManagement/TenantActivityLogAlerts/SampleActivityLogAlertSHRuleOnTenantLevel"),
		// 			Location: to.Ptr("Global"),
		// 			Tags: map[string]*string{
		// 			},
		// 			Properties: &armalertsmanagement.AlertRuleProperties{
		// 				Description: to.Ptr("Description of sample Activity Log Alert service health rule on tenant level events."),
		// 				Actions: &armalertsmanagement.ActionList{
		// 					ActionGroups: []*armalertsmanagement.ActionGroup{
		// 						{
		// 							ActionGroupID: to.Ptr("/providers/Microsoft.Management/ManagementGroups/72f988bf-86f1-41af-91ab-2d7cd011db47/providers/Microsoft.Insights/actionGroups/SampleActionGroup"),
		// 							ActionProperties: map[string]*string{
		// 								"Email.Title": to.Ptr("my email title"),
		// 							},
		// 							WebhookProperties: map[string]*string{
		// 								"sampleWebhookProperty": to.Ptr("SamplePropertyValue"),
		// 							},
		// 					}},
		// 				},
		// 				Condition: &armalertsmanagement.AlertRuleAllOfCondition{
		// 					AllOf: []*armalertsmanagement.AlertRuleAnyOfOrLeafCondition{
		// 						{
		// 							Equals: to.Ptr("ServiceHealth"),
		// 							Field: to.Ptr("category"),
		// 					}},
		// 				},
		// 				Enabled: to.Ptr(true),
		// 				TenantScope: to.Ptr("72f988bf-86f1-41af-91ab-2d7cd011db47"),
		// 			},
		// 		},
		// 		{
		// 			Name: to.Ptr("SampleActivityLogAlertSHRuleOnTenantLevel"),
		// 			Type: to.Ptr("Microsoft.AlertsManagement/TenantActivityLogAlerts"),
		// 			ID: to.Ptr("/providers/Microsoft.Management/ManagementGroups/MyManagementGroup/providers/Microsoft.AlertsManagement/TenantActivityLogAlerts/SampleActivityLogAlertSHRuleOnTenantLevel"),
		// 			Location: to.Ptr("Global"),
		// 			Tags: map[string]*string{
		// 			},
		// 			Properties: &armalertsmanagement.AlertRuleProperties{
		// 				Description: to.Ptr("Description of sample Activity Log Alert service health rule on tenant level events."),
		// 				Actions: &armalertsmanagement.ActionList{
		// 					ActionGroups: []*armalertsmanagement.ActionGroup{
		// 						{
		// 							ActionGroupID: to.Ptr("/providers/Microsoft.Management/ManagementGroups/MyManagementGroup/providers/Microsoft.Insights/actionGroups/SampleActionGroup"),
		// 							ActionProperties: map[string]*string{
		// 								"Email.Title": to.Ptr("my email title"),
		// 							},
		// 							WebhookProperties: map[string]*string{
		// 								"sampleWebhookProperty": to.Ptr("SamplePropertyValue"),
		// 							},
		// 					}},
		// 				},
		// 				Condition: &armalertsmanagement.AlertRuleAllOfCondition{
		// 					AllOf: []*armalertsmanagement.AlertRuleAnyOfOrLeafCondition{
		// 						{
		// 							Equals: to.Ptr("ServiceHealth"),
		// 							Field: to.Ptr("category"),
		// 					}},
		// 				},
		// 				Enabled: to.Ptr(true),
		// 				TenantScope: to.Ptr("72f988bf-86f1-41af-91ab-2d7cd011db47"),
		// 			},
		// 	}},
		// }
	}
}

// Generated from example definition: https://github.com/Azure/azure-rest-api-specs/blob/6d2438481021a94793b07b226df06d5f3c61d51d/specification/alertsmanagement/resource-manager/Microsoft.AlertsManagement/preview/2023-04-01-preview/examples/TenantActivityLogAlertRule_ListByManagementGroup.json
func ExampleTenantActivityLogAlertsClient_NewListByManagementGroupPager() {
	cred, err := azidentity.NewDefaultAzureCredential(nil)
	if err != nil {
		log.Fatalf("failed to obtain a credential: %v", err)
	}
	ctx := context.Background()
	clientFactory, err := armalertsmanagement.NewClientFactory("<subscription-id>", cred, nil)
	if err != nil {
		log.Fatalf("failed to create client: %v", err)
	}
	pager := clientFactory.NewTenantActivityLogAlertsClient().NewListByManagementGroupPager("72f988bf-86f1-41af-91ab-2d7cd011db47", nil)
	for pager.More() {
		page, err := pager.NextPage(ctx)
		if err != nil {
			log.Fatalf("failed to advance page: %v", err)
		}
		for _, v := range page.Value {
			// You could use page here. We use blank identifier for just demo purposes.
			_ = v
		}
		// If the HTTP response code is 200 as defined in example definition, your page structure would look as follows. Please pay attention that all the values in the output are fake values for just demo purposes.
		// page.TenantAlertRuleList = armalertsmanagement.TenantAlertRuleList{
		// 	Value: []*armalertsmanagement.TenantActivityLogAlertResource{
		// 		{
		// 			Name: to.Ptr("SampleActivityLogAlertSHRuleOnTenantLevel"),
		// 			Type: to.Ptr("Microsoft.AlertsManagement/TenantActivityLogAlerts"),
		// 			ID: to.Ptr("/providers/Microsoft.Management/ManagementGroups/72f988bf-86f1-41af-91ab-2d7cd011db47/providers/Microsoft.AlertsManagement/TenantActivityLogAlerts/SampleActivityLogAlertSHRuleOnTenantLevel"),
		// 			Location: to.Ptr("Global"),
		// 			Tags: map[string]*string{
		// 			},
		// 			Properties: &armalertsmanagement.AlertRuleProperties{
		// 				Description: to.Ptr("Description of sample Activity Log Alert service health rule on tenant level events."),
		// 				Actions: &armalertsmanagement.ActionList{
		// 					ActionGroups: []*armalertsmanagement.ActionGroup{
		// 						{
		// 							ActionGroupID: to.Ptr("/providers/Microsoft.Management/ManagementGroups/72f988bf-86f1-41af-91ab-2d7cd011db47/providers/Microsoft.Insights/actionGroups/SampleActionGroup"),
		// 							ActionProperties: map[string]*string{
		// 								"Email.Title": to.Ptr("my email title"),
		// 							},
		// 							WebhookProperties: map[string]*string{
		// 								"sampleWebhookProperty": to.Ptr("SamplePropertyValue"),
		// 							},
		// 					}},
		// 				},
		// 				Condition: &armalertsmanagement.AlertRuleAllOfCondition{
		// 					AllOf: []*armalertsmanagement.AlertRuleAnyOfOrLeafCondition{
		// 						{
		// 							Equals: to.Ptr("ServiceHealth"),
		// 							Field: to.Ptr("category"),
		// 					}},
		// 				},
		// 				Enabled: to.Ptr(true),
		// 				TenantScope: to.Ptr("72f988bf-86f1-41af-91ab-2d7cd011db47"),
		// 			},
		// 	}},
		// }
	}
}
