//go:build go1.18
// +build go1.18

// Copyright (c) Microsoft Corporation. All rights reserved.
// Licensed under the MIT License. See License.txt in the project root for license information.
// Code generated by Microsoft (R) AutoRest Code Generator. DO NOT EDIT.
// Changes may cause incorrect behavior and will be lost if the code is regenerated.

package fake

import (
	"context"
	"errors"
	"fmt"
	azfake "github.com/Azure/azure-sdk-for-go/sdk/azcore/fake"
	"github.com/Azure/azure-sdk-for-go/sdk/azcore/fake/server"
	"github.com/Azure/azure-sdk-for-go/sdk/azcore/runtime"
	"github.com/Azure/azure-sdk-for-go/sdk/azcore/to"
	"github.com/Azure/azure-sdk-for-go/sdk/resourcemanager/appservice/armappservice/v2"
	"net/http"
	"net/url"
	"regexp"
)

// TopLevelDomainsServer is a fake server for instances of the armappservice.TopLevelDomainsClient type.
type TopLevelDomainsServer struct {
	// Get is the fake for method TopLevelDomainsClient.Get
	// HTTP status codes to indicate success: http.StatusOK
	Get func(ctx context.Context, name string, options *armappservice.TopLevelDomainsClientGetOptions) (resp azfake.Responder[armappservice.TopLevelDomainsClientGetResponse], errResp azfake.ErrorResponder)

	// NewListPager is the fake for method TopLevelDomainsClient.NewListPager
	// HTTP status codes to indicate success: http.StatusOK
	NewListPager func(options *armappservice.TopLevelDomainsClientListOptions) (resp azfake.PagerResponder[armappservice.TopLevelDomainsClientListResponse])

	// NewListAgreementsPager is the fake for method TopLevelDomainsClient.NewListAgreementsPager
	// HTTP status codes to indicate success: http.StatusOK
	NewListAgreementsPager func(name string, agreementOption armappservice.TopLevelDomainAgreementOption, options *armappservice.TopLevelDomainsClientListAgreementsOptions) (resp azfake.PagerResponder[armappservice.TopLevelDomainsClientListAgreementsResponse])
}

// NewTopLevelDomainsServerTransport creates a new instance of TopLevelDomainsServerTransport with the provided implementation.
// The returned TopLevelDomainsServerTransport instance is connected to an instance of armappservice.TopLevelDomainsClient via the
// azcore.ClientOptions.Transporter field in the client's constructor parameters.
func NewTopLevelDomainsServerTransport(srv *TopLevelDomainsServer) *TopLevelDomainsServerTransport {
	return &TopLevelDomainsServerTransport{
		srv:                    srv,
		newListPager:           newTracker[azfake.PagerResponder[armappservice.TopLevelDomainsClientListResponse]](),
		newListAgreementsPager: newTracker[azfake.PagerResponder[armappservice.TopLevelDomainsClientListAgreementsResponse]](),
	}
}

// TopLevelDomainsServerTransport connects instances of armappservice.TopLevelDomainsClient to instances of TopLevelDomainsServer.
// Don't use this type directly, use NewTopLevelDomainsServerTransport instead.
type TopLevelDomainsServerTransport struct {
	srv                    *TopLevelDomainsServer
	newListPager           *tracker[azfake.PagerResponder[armappservice.TopLevelDomainsClientListResponse]]
	newListAgreementsPager *tracker[azfake.PagerResponder[armappservice.TopLevelDomainsClientListAgreementsResponse]]
}

// Do implements the policy.Transporter interface for TopLevelDomainsServerTransport.
func (t *TopLevelDomainsServerTransport) Do(req *http.Request) (*http.Response, error) {
	rawMethod := req.Context().Value(runtime.CtxAPINameKey{})
	method, ok := rawMethod.(string)
	if !ok {
		return nil, nonRetriableError{errors.New("unable to dispatch request, missing value for CtxAPINameKey")}
	}

	var resp *http.Response
	var err error

	switch method {
	case "TopLevelDomainsClient.Get":
		resp, err = t.dispatchGet(req)
	case "TopLevelDomainsClient.NewListPager":
		resp, err = t.dispatchNewListPager(req)
	case "TopLevelDomainsClient.NewListAgreementsPager":
		resp, err = t.dispatchNewListAgreementsPager(req)
	default:
		err = fmt.Errorf("unhandled API %s", method)
	}

	if err != nil {
		return nil, err
	}

	return resp, nil
}

func (t *TopLevelDomainsServerTransport) dispatchGet(req *http.Request) (*http.Response, error) {
	if t.srv.Get == nil {
		return nil, &nonRetriableError{errors.New("fake for method Get not implemented")}
	}
	const regexStr = `/subscriptions/(?P<subscriptionId>[!#&$-;=?-\[\]_a-zA-Z0-9~%@]+)/providers/Microsoft\.DomainRegistration/topLevelDomains/(?P<name>[!#&$-;=?-\[\]_a-zA-Z0-9~%@]+)`
	regex := regexp.MustCompile(regexStr)
	matches := regex.FindStringSubmatch(req.URL.EscapedPath())
	if matches == nil || len(matches) < 2 {
		return nil, fmt.Errorf("failed to parse path %s", req.URL.Path)
	}
	nameParam, err := url.PathUnescape(matches[regex.SubexpIndex("name")])
	if err != nil {
		return nil, err
	}
	respr, errRespr := t.srv.Get(req.Context(), nameParam, nil)
	if respErr := server.GetError(errRespr, req); respErr != nil {
		return nil, respErr
	}
	respContent := server.GetResponseContent(respr)
	if !contains([]int{http.StatusOK}, respContent.HTTPStatus) {
		return nil, &nonRetriableError{fmt.Errorf("unexpected status code %d. acceptable values are http.StatusOK", respContent.HTTPStatus)}
	}
	resp, err := server.MarshalResponseAsJSON(respContent, server.GetResponse(respr).TopLevelDomain, req)
	if err != nil {
		return nil, err
	}
	return resp, nil
}

func (t *TopLevelDomainsServerTransport) dispatchNewListPager(req *http.Request) (*http.Response, error) {
	if t.srv.NewListPager == nil {
		return nil, &nonRetriableError{errors.New("fake for method NewListPager not implemented")}
	}
	newListPager := t.newListPager.get(req)
	if newListPager == nil {
		const regexStr = `/subscriptions/(?P<subscriptionId>[!#&$-;=?-\[\]_a-zA-Z0-9~%@]+)/providers/Microsoft\.DomainRegistration/topLevelDomains`
		regex := regexp.MustCompile(regexStr)
		matches := regex.FindStringSubmatch(req.URL.EscapedPath())
		if matches == nil || len(matches) < 1 {
			return nil, fmt.Errorf("failed to parse path %s", req.URL.Path)
		}
		resp := t.srv.NewListPager(nil)
		newListPager = &resp
		t.newListPager.add(req, newListPager)
		server.PagerResponderInjectNextLinks(newListPager, req, func(page *armappservice.TopLevelDomainsClientListResponse, createLink func() string) {
			page.NextLink = to.Ptr(createLink())
		})
	}
	resp, err := server.PagerResponderNext(newListPager, req)
	if err != nil {
		return nil, err
	}
	if !contains([]int{http.StatusOK}, resp.StatusCode) {
		t.newListPager.remove(req)
		return nil, &nonRetriableError{fmt.Errorf("unexpected status code %d. acceptable values are http.StatusOK", resp.StatusCode)}
	}
	if !server.PagerResponderMore(newListPager) {
		t.newListPager.remove(req)
	}
	return resp, nil
}

func (t *TopLevelDomainsServerTransport) dispatchNewListAgreementsPager(req *http.Request) (*http.Response, error) {
	if t.srv.NewListAgreementsPager == nil {
		return nil, &nonRetriableError{errors.New("fake for method NewListAgreementsPager not implemented")}
	}
	newListAgreementsPager := t.newListAgreementsPager.get(req)
	if newListAgreementsPager == nil {
		const regexStr = `/subscriptions/(?P<subscriptionId>[!#&$-;=?-\[\]_a-zA-Z0-9~%@]+)/providers/Microsoft\.DomainRegistration/topLevelDomains/(?P<name>[!#&$-;=?-\[\]_a-zA-Z0-9~%@]+)/listAgreements`
		regex := regexp.MustCompile(regexStr)
		matches := regex.FindStringSubmatch(req.URL.EscapedPath())
		if matches == nil || len(matches) < 2 {
			return nil, fmt.Errorf("failed to parse path %s", req.URL.Path)
		}
		body, err := server.UnmarshalRequestAsJSON[armappservice.TopLevelDomainAgreementOption](req)
		if err != nil {
			return nil, err
		}
		nameParam, err := url.PathUnescape(matches[regex.SubexpIndex("name")])
		if err != nil {
			return nil, err
		}
		resp := t.srv.NewListAgreementsPager(nameParam, body, nil)
		newListAgreementsPager = &resp
		t.newListAgreementsPager.add(req, newListAgreementsPager)
		server.PagerResponderInjectNextLinks(newListAgreementsPager, req, func(page *armappservice.TopLevelDomainsClientListAgreementsResponse, createLink func() string) {
			page.NextLink = to.Ptr(createLink())
		})
	}
	resp, err := server.PagerResponderNext(newListAgreementsPager, req)
	if err != nil {
		return nil, err
	}
	if !contains([]int{http.StatusOK}, resp.StatusCode) {
		t.newListAgreementsPager.remove(req)
		return nil, &nonRetriableError{fmt.Errorf("unexpected status code %d. acceptable values are http.StatusOK", resp.StatusCode)}
	}
	if !server.PagerResponderMore(newListAgreementsPager) {
		t.newListAgreementsPager.remove(req)
	}
	return resp, nil
}
