//go:build go1.18
// +build go1.18

// Copyright (c) Microsoft Corporation. All rights reserved.
// Licensed under the MIT License. See License.txt in the project root for license information.
// Code generated by Microsoft (R) AutoRest Code Generator.
// Changes may cause incorrect behavior and will be lost if the code is regenerated.
// DO NOT EDIT.

package armautomation_test

import (
	"context"
	"log"

	"github.com/Azure/azure-sdk-for-go/sdk/azcore/to"
	"github.com/Azure/azure-sdk-for-go/sdk/azidentity"
	"github.com/Azure/azure-sdk-for-go/sdk/resourcemanager/automation/armautomation"
)

// Generated from example definition: https://github.com/Azure/azure-rest-api-specs/blob/432872fac1d0f8edcae98a0e8504afc0ee302710/specification/automation/resource-manager/Microsoft.Automation/preview/2020-01-13-preview/examples/createOrUpdateWatcher.json
func ExampleWatcherClient_CreateOrUpdate() {
	cred, err := azidentity.NewDefaultAzureCredential(nil)
	if err != nil {
		log.Fatalf("failed to obtain a credential: %v", err)
	}
	ctx := context.Background()
	clientFactory, err := armautomation.NewClientFactory("<subscription-id>", cred, nil)
	if err != nil {
		log.Fatalf("failed to create client: %v", err)
	}
	res, err := clientFactory.NewWatcherClient().CreateOrUpdate(ctx, "rg", "MyTestAutomationAccount", "MyTestWatcher", armautomation.Watcher{
		Properties: &armautomation.WatcherProperties{
			Description:                 to.Ptr("This is a test watcher."),
			ExecutionFrequencyInSeconds: to.Ptr[int64](60),
			ScriptName:                  to.Ptr("MyTestWatcherRunbook"),
			ScriptRunOn:                 to.Ptr("MyTestHybridWorkerGroup"),
		},
		Tags: map[string]*string{},
	}, nil)
	if err != nil {
		log.Fatalf("failed to finish the request: %v", err)
	}
	// You could use response here. We use blank identifier for just demo purposes.
	_ = res
	// If the HTTP response code is 200 as defined in example definition, your response structure would look as follows. Please pay attention that all the values in the output are fake values for just demo purposes.
	// res.Watcher = armautomation.Watcher{
	// 	Name: to.Ptr("MyTestWatcher"),
	// 	ID: to.Ptr("/subscriptions/subId/resourceGroups/rg/providers/Microsoft.Automation/automationAccounts/MyTestAutomationAccount/watchers/MyTestWatcher"),
	// 	Properties: &armautomation.WatcherProperties{
	// 		Description: to.Ptr("This is a test watcher."),
	// 		CreationTime: to.Ptr(func() time.Time { t, _ := time.Parse(time.RFC3339Nano, "2018-05-14T21:14:09.607Z"); return t}()),
	// 		ExecutionFrequencyInSeconds: to.Ptr[int64](60),
	// 		LastModifiedTime: to.Ptr(func() time.Time { t, _ := time.Parse(time.RFC3339Nano, "2018-05-14T21:14:09.607Z"); return t}()),
	// 		ScriptName: to.Ptr("MyTestWatcherRunbook"),
	// 		ScriptRunOn: to.Ptr("MyTestHybridWorkerGroup"),
	// 		Status: to.Ptr("New"),
	// 	},
	// 	Tags: map[string]*string{
	// 	},
	// }
}

// Generated from example definition: https://github.com/Azure/azure-rest-api-specs/blob/432872fac1d0f8edcae98a0e8504afc0ee302710/specification/automation/resource-manager/Microsoft.Automation/preview/2020-01-13-preview/examples/getWatcher.json
func ExampleWatcherClient_Get() {
	cred, err := azidentity.NewDefaultAzureCredential(nil)
	if err != nil {
		log.Fatalf("failed to obtain a credential: %v", err)
	}
	ctx := context.Background()
	clientFactory, err := armautomation.NewClientFactory("<subscription-id>", cred, nil)
	if err != nil {
		log.Fatalf("failed to create client: %v", err)
	}
	res, err := clientFactory.NewWatcherClient().Get(ctx, "rg", "MyTestAutomationAccount", "MyTestWatcher", nil)
	if err != nil {
		log.Fatalf("failed to finish the request: %v", err)
	}
	// You could use response here. We use blank identifier for just demo purposes.
	_ = res
	// If the HTTP response code is 200 as defined in example definition, your response structure would look as follows. Please pay attention that all the values in the output are fake values for just demo purposes.
	// res.Watcher = armautomation.Watcher{
	// 	Name: to.Ptr("MyTestWatcher"),
	// 	ID: to.Ptr("/subscriptions/subId/resourceGroups/rg/providers/Microsoft.Automation/automationAccounts/MyTestAutomationAccount/watchers/MyTestWatcher"),
	// 	Properties: &armautomation.WatcherProperties{
	// 		Description: to.Ptr(""),
	// 		CreationTime: to.Ptr(func() time.Time { t, _ := time.Parse(time.RFC3339Nano, "2017-11-30T18:50:17.163Z"); return t}()),
	// 		ExecutionFrequencyInSeconds: to.Ptr[int64](60),
	// 		LastModifiedTime: to.Ptr(func() time.Time { t, _ := time.Parse(time.RFC3339Nano, "2017-11-30T18:50:17.163Z"); return t}()),
	// 		ScriptName: to.Ptr("MyTestWatcherRunbook"),
	// 		ScriptParameters: map[string]*string{
	// 		},
	// 		ScriptRunOn: to.Ptr("MyTestHybridWorkerGroup"),
	// 		Status: to.Ptr("Running"),
	// 	},
	// 	Tags: map[string]*string{
	// 	},
	// }
}

// Generated from example definition: https://github.com/Azure/azure-rest-api-specs/blob/432872fac1d0f8edcae98a0e8504afc0ee302710/specification/automation/resource-manager/Microsoft.Automation/preview/2020-01-13-preview/examples/updateWatcher.json
func ExampleWatcherClient_Update() {
	cred, err := azidentity.NewDefaultAzureCredential(nil)
	if err != nil {
		log.Fatalf("failed to obtain a credential: %v", err)
	}
	ctx := context.Background()
	clientFactory, err := armautomation.NewClientFactory("<subscription-id>", cred, nil)
	if err != nil {
		log.Fatalf("failed to create client: %v", err)
	}
	res, err := clientFactory.NewWatcherClient().Update(ctx, "rg", "MyTestAutomationAccount", "MyTestWatcher", armautomation.WatcherUpdateParameters{
		Name: to.Ptr("MyTestWatcher"),
		Properties: &armautomation.WatcherUpdateProperties{
			ExecutionFrequencyInSeconds: to.Ptr[int64](600),
		},
	}, nil)
	if err != nil {
		log.Fatalf("failed to finish the request: %v", err)
	}
	// You could use response here. We use blank identifier for just demo purposes.
	_ = res
	// If the HTTP response code is 200 as defined in example definition, your response structure would look as follows. Please pay attention that all the values in the output are fake values for just demo purposes.
	// res.Watcher = armautomation.Watcher{
	// 	Name: to.Ptr("MyTestWatcher"),
	// 	ID: to.Ptr("/subscriptions/subId/resourceGroups/rg/providers/Microsoft.Automation/automationAccounts/MyTestAutomationAccount/watchers/MyTestWatcher"),
	// 	Properties: &armautomation.WatcherProperties{
	// 		Description: to.Ptr("This is a test watcher."),
	// 		CreationTime: to.Ptr(func() time.Time { t, _ := time.Parse(time.RFC3339Nano, "2018-05-14T21:33:02.197Z"); return t}()),
	// 		ExecutionFrequencyInSeconds: to.Ptr[int64](600),
	// 		LastModifiedTime: to.Ptr(func() time.Time { t, _ := time.Parse(time.RFC3339Nano, "2018-05-14T22:29:57.650Z"); return t}()),
	// 		ScriptName: to.Ptr("MyTestWatcherRunbook"),
	// 		ScriptParameters: map[string]*string{
	// 		},
	// 		ScriptRunOn: to.Ptr("MyTestHybridWorkerGroup"),
	// 		Status: to.Ptr("New"),
	// 	},
	// 	Tags: map[string]*string{
	// 	},
	// }
}

// Generated from example definition: https://github.com/Azure/azure-rest-api-specs/blob/432872fac1d0f8edcae98a0e8504afc0ee302710/specification/automation/resource-manager/Microsoft.Automation/preview/2020-01-13-preview/examples/deleteWatcher.json
func ExampleWatcherClient_Delete() {
	cred, err := azidentity.NewDefaultAzureCredential(nil)
	if err != nil {
		log.Fatalf("failed to obtain a credential: %v", err)
	}
	ctx := context.Background()
	clientFactory, err := armautomation.NewClientFactory("<subscription-id>", cred, nil)
	if err != nil {
		log.Fatalf("failed to create client: %v", err)
	}
	_, err = clientFactory.NewWatcherClient().Delete(ctx, "rg", "MyTestAutomationAccount", "MyTestWatcher", nil)
	if err != nil {
		log.Fatalf("failed to finish the request: %v", err)
	}
}

// Generated from example definition: https://github.com/Azure/azure-rest-api-specs/blob/432872fac1d0f8edcae98a0e8504afc0ee302710/specification/automation/resource-manager/Microsoft.Automation/preview/2020-01-13-preview/examples/startWatcher.json
func ExampleWatcherClient_Start() {
	cred, err := azidentity.NewDefaultAzureCredential(nil)
	if err != nil {
		log.Fatalf("failed to obtain a credential: %v", err)
	}
	ctx := context.Background()
	clientFactory, err := armautomation.NewClientFactory("<subscription-id>", cred, nil)
	if err != nil {
		log.Fatalf("failed to create client: %v", err)
	}
	_, err = clientFactory.NewWatcherClient().Start(ctx, "rg", "MyTestAutomationAccount", "MyTestWatcher", nil)
	if err != nil {
		log.Fatalf("failed to finish the request: %v", err)
	}
}

// Generated from example definition: https://github.com/Azure/azure-rest-api-specs/blob/432872fac1d0f8edcae98a0e8504afc0ee302710/specification/automation/resource-manager/Microsoft.Automation/preview/2020-01-13-preview/examples/stopWatcher.json
func ExampleWatcherClient_Stop() {
	cred, err := azidentity.NewDefaultAzureCredential(nil)
	if err != nil {
		log.Fatalf("failed to obtain a credential: %v", err)
	}
	ctx := context.Background()
	clientFactory, err := armautomation.NewClientFactory("<subscription-id>", cred, nil)
	if err != nil {
		log.Fatalf("failed to create client: %v", err)
	}
	_, err = clientFactory.NewWatcherClient().Stop(ctx, "rg", "MyTestAutomationAccount", "MyTestWatcher", nil)
	if err != nil {
		log.Fatalf("failed to finish the request: %v", err)
	}
}

// Generated from example definition: https://github.com/Azure/azure-rest-api-specs/blob/432872fac1d0f8edcae98a0e8504afc0ee302710/specification/automation/resource-manager/Microsoft.Automation/preview/2020-01-13-preview/examples/listWatchersByAutomationAccount.json
func ExampleWatcherClient_NewListByAutomationAccountPager() {
	cred, err := azidentity.NewDefaultAzureCredential(nil)
	if err != nil {
		log.Fatalf("failed to obtain a credential: %v", err)
	}
	ctx := context.Background()
	clientFactory, err := armautomation.NewClientFactory("<subscription-id>", cred, nil)
	if err != nil {
		log.Fatalf("failed to create client: %v", err)
	}
	pager := clientFactory.NewWatcherClient().NewListByAutomationAccountPager("rg", "MyTestAutomationAccount", &armautomation.WatcherClientListByAutomationAccountOptions{Filter: nil})
	for pager.More() {
		page, err := pager.NextPage(ctx)
		if err != nil {
			log.Fatalf("failed to advance page: %v", err)
		}
		for _, v := range page.Value {
			// You could use page here. We use blank identifier for just demo purposes.
			_ = v
		}
		// If the HTTP response code is 200 as defined in example definition, your page structure would look as follows. Please pay attention that all the values in the output are fake values for just demo purposes.
		// page.WatcherListResult = armautomation.WatcherListResult{
		// 	Value: []*armautomation.Watcher{
		// 		{
		// 			Name: to.Ptr("MyTestWatcher"),
		// 			ID: to.Ptr("/subscriptions/subid/resourceGroups/rg/providers/Microsoft.Automation/automationAccounts/MyTestAutomationAccount/watchers/MyTestWatcher"),
		// 			Properties: &armautomation.WatcherProperties{
		// 				Description: to.Ptr("This is a test watcher."),
		// 				CreationTime: to.Ptr(func() time.Time { t, _ := time.Parse(time.RFC3339Nano, "2016-12-20T21:36:48.597Z"); return t}()),
		// 				ExecutionFrequencyInSeconds: to.Ptr[int64](60),
		// 				LastModifiedTime: to.Ptr(func() time.Time { t, _ := time.Parse(time.RFC3339Nano, "2016-12-20T21:36:48.597Z"); return t}()),
		// 				ScriptName: to.Ptr("MyTestWatcher"),
		// 				ScriptRunOn: to.Ptr("MyTestHybridWorkerGroup"),
		// 			},
		// 		},
		// 		{
		// 			Name: to.Ptr("MyTestWatcher01"),
		// 			ID: to.Ptr("/subscriptions/subid/resourceGroups/rg/providers/Microsoft.Automation/automationAccounts/MyTestAutomationAccount/watchers/MyTestWatcher01"),
		// 			Properties: &armautomation.WatcherProperties{
		// 				Description: to.Ptr("This is a test watcher."),
		// 				CreationTime: to.Ptr(func() time.Time { t, _ := time.Parse(time.RFC3339Nano, "2016-12-20T20:47:24.697Z"); return t}()),
		// 				ExecutionFrequencyInSeconds: to.Ptr[int64](60),
		// 				LastModifiedTime: to.Ptr(func() time.Time { t, _ := time.Parse(time.RFC3339Nano, "2016-12-20T20:47:24.697Z"); return t}()),
		// 				ScriptName: to.Ptr("MyTestWatcher"),
		// 				ScriptRunOn: to.Ptr("MyTestHybridWorkerGroup"),
		// 			},
		// 		},
		// 		{
		// 			Name: to.Ptr("MyTestWatcher02"),
		// 			ID: to.Ptr("/subscriptions/subid/resourceGroups/rg/providers/Microsoft.Automation/automationAccounts/MyTestAutomationAccount/watchers/MyTestWatcher02"),
		// 			Properties: &armautomation.WatcherProperties{
		// 				Description: to.Ptr("This is a test watcher."),
		// 				CreationTime: to.Ptr(func() time.Time { t, _ := time.Parse(time.RFC3339Nano, "2016-12-20T21:26:35.647Z"); return t}()),
		// 				ExecutionFrequencyInSeconds: to.Ptr[int64](60),
		// 				LastModifiedTime: to.Ptr(func() time.Time { t, _ := time.Parse(time.RFC3339Nano, "2016-12-20T21:26:35.647Z"); return t}()),
		// 				ScriptName: to.Ptr("MyTestWatcher"),
		// 				ScriptRunOn: to.Ptr("MyTestHybridWorkerGroup"),
		// 			},
		// 	}},
		// }
	}
}
