//go:build go1.18
// +build go1.18

// Copyright (c) Microsoft Corporation. All rights reserved.
// Licensed under the MIT License. See License.txt in the project root for license information.
// Code generated by Microsoft (R) AutoRest Code Generator. DO NOT EDIT.
// Changes may cause incorrect behavior and will be lost if the code is regenerated.

package fake

import (
	"context"
	"errors"
	"fmt"
	azfake "github.com/Azure/azure-sdk-for-go/sdk/azcore/fake"
	"github.com/Azure/azure-sdk-for-go/sdk/azcore/fake/server"
	"github.com/Azure/azure-sdk-for-go/sdk/azcore/runtime"
	"github.com/Azure/azure-sdk-for-go/sdk/azcore/to"
	"github.com/Azure/azure-sdk-for-go/sdk/resourcemanager/avs/armavs"
	"net/http"
	"net/url"
	"regexp"
)

// ScriptCmdletsServer is a fake server for instances of the armavs.ScriptCmdletsClient type.
type ScriptCmdletsServer struct {
	// Get is the fake for method ScriptCmdletsClient.Get
	// HTTP status codes to indicate success: http.StatusOK
	Get func(ctx context.Context, resourceGroupName string, privateCloudName string, scriptPackageName string, scriptCmdletName string, options *armavs.ScriptCmdletsClientGetOptions) (resp azfake.Responder[armavs.ScriptCmdletsClientGetResponse], errResp azfake.ErrorResponder)

	// NewListPager is the fake for method ScriptCmdletsClient.NewListPager
	// HTTP status codes to indicate success: http.StatusOK
	NewListPager func(resourceGroupName string, privateCloudName string, scriptPackageName string, options *armavs.ScriptCmdletsClientListOptions) (resp azfake.PagerResponder[armavs.ScriptCmdletsClientListResponse])
}

// NewScriptCmdletsServerTransport creates a new instance of ScriptCmdletsServerTransport with the provided implementation.
// The returned ScriptCmdletsServerTransport instance is connected to an instance of armavs.ScriptCmdletsClient via the
// azcore.ClientOptions.Transporter field in the client's constructor parameters.
func NewScriptCmdletsServerTransport(srv *ScriptCmdletsServer) *ScriptCmdletsServerTransport {
	return &ScriptCmdletsServerTransport{
		srv:          srv,
		newListPager: newTracker[azfake.PagerResponder[armavs.ScriptCmdletsClientListResponse]](),
	}
}

// ScriptCmdletsServerTransport connects instances of armavs.ScriptCmdletsClient to instances of ScriptCmdletsServer.
// Don't use this type directly, use NewScriptCmdletsServerTransport instead.
type ScriptCmdletsServerTransport struct {
	srv          *ScriptCmdletsServer
	newListPager *tracker[azfake.PagerResponder[armavs.ScriptCmdletsClientListResponse]]
}

// Do implements the policy.Transporter interface for ScriptCmdletsServerTransport.
func (s *ScriptCmdletsServerTransport) Do(req *http.Request) (*http.Response, error) {
	rawMethod := req.Context().Value(runtime.CtxAPINameKey{})
	method, ok := rawMethod.(string)
	if !ok {
		return nil, nonRetriableError{errors.New("unable to dispatch request, missing value for CtxAPINameKey")}
	}

	var resp *http.Response
	var err error

	switch method {
	case "ScriptCmdletsClient.Get":
		resp, err = s.dispatchGet(req)
	case "ScriptCmdletsClient.NewListPager":
		resp, err = s.dispatchNewListPager(req)
	default:
		err = fmt.Errorf("unhandled API %s", method)
	}

	if err != nil {
		return nil, err
	}

	return resp, nil
}

func (s *ScriptCmdletsServerTransport) dispatchGet(req *http.Request) (*http.Response, error) {
	if s.srv.Get == nil {
		return nil, &nonRetriableError{errors.New("fake for method Get not implemented")}
	}
	const regexStr = `/subscriptions/(?P<subscriptionId>[!#&$-;=?-\[\]_a-zA-Z0-9~%@]+)/resourceGroups/(?P<resourceGroupName>[!#&$-;=?-\[\]_a-zA-Z0-9~%@]+)/providers/Microsoft\.AVS/privateClouds/(?P<privateCloudName>[!#&$-;=?-\[\]_a-zA-Z0-9~%@]+)/scriptPackages/(?P<scriptPackageName>[!#&$-;=?-\[\]_a-zA-Z0-9~%@]+)/scriptCmdlets/(?P<scriptCmdletName>[!#&$-;=?-\[\]_a-zA-Z0-9~%@]+)`
	regex := regexp.MustCompile(regexStr)
	matches := regex.FindStringSubmatch(req.URL.EscapedPath())
	if matches == nil || len(matches) < 5 {
		return nil, fmt.Errorf("failed to parse path %s", req.URL.Path)
	}
	resourceGroupNameParam, err := url.PathUnescape(matches[regex.SubexpIndex("resourceGroupName")])
	if err != nil {
		return nil, err
	}
	privateCloudNameParam, err := url.PathUnescape(matches[regex.SubexpIndex("privateCloudName")])
	if err != nil {
		return nil, err
	}
	scriptPackageNameParam, err := url.PathUnescape(matches[regex.SubexpIndex("scriptPackageName")])
	if err != nil {
		return nil, err
	}
	scriptCmdletNameParam, err := url.PathUnescape(matches[regex.SubexpIndex("scriptCmdletName")])
	if err != nil {
		return nil, err
	}
	respr, errRespr := s.srv.Get(req.Context(), resourceGroupNameParam, privateCloudNameParam, scriptPackageNameParam, scriptCmdletNameParam, nil)
	if respErr := server.GetError(errRespr, req); respErr != nil {
		return nil, respErr
	}
	respContent := server.GetResponseContent(respr)
	if !contains([]int{http.StatusOK}, respContent.HTTPStatus) {
		return nil, &nonRetriableError{fmt.Errorf("unexpected status code %d. acceptable values are http.StatusOK", respContent.HTTPStatus)}
	}
	resp, err := server.MarshalResponseAsJSON(respContent, server.GetResponse(respr).ScriptCmdlet, req)
	if err != nil {
		return nil, err
	}
	return resp, nil
}

func (s *ScriptCmdletsServerTransport) dispatchNewListPager(req *http.Request) (*http.Response, error) {
	if s.srv.NewListPager == nil {
		return nil, &nonRetriableError{errors.New("fake for method NewListPager not implemented")}
	}
	newListPager := s.newListPager.get(req)
	if newListPager == nil {
		const regexStr = `/subscriptions/(?P<subscriptionId>[!#&$-;=?-\[\]_a-zA-Z0-9~%@]+)/resourceGroups/(?P<resourceGroupName>[!#&$-;=?-\[\]_a-zA-Z0-9~%@]+)/providers/Microsoft\.AVS/privateClouds/(?P<privateCloudName>[!#&$-;=?-\[\]_a-zA-Z0-9~%@]+)/scriptPackages/(?P<scriptPackageName>[!#&$-;=?-\[\]_a-zA-Z0-9~%@]+)/scriptCmdlets`
		regex := regexp.MustCompile(regexStr)
		matches := regex.FindStringSubmatch(req.URL.EscapedPath())
		if matches == nil || len(matches) < 4 {
			return nil, fmt.Errorf("failed to parse path %s", req.URL.Path)
		}
		resourceGroupNameParam, err := url.PathUnescape(matches[regex.SubexpIndex("resourceGroupName")])
		if err != nil {
			return nil, err
		}
		privateCloudNameParam, err := url.PathUnescape(matches[regex.SubexpIndex("privateCloudName")])
		if err != nil {
			return nil, err
		}
		scriptPackageNameParam, err := url.PathUnescape(matches[regex.SubexpIndex("scriptPackageName")])
		if err != nil {
			return nil, err
		}
		resp := s.srv.NewListPager(resourceGroupNameParam, privateCloudNameParam, scriptPackageNameParam, nil)
		newListPager = &resp
		s.newListPager.add(req, newListPager)
		server.PagerResponderInjectNextLinks(newListPager, req, func(page *armavs.ScriptCmdletsClientListResponse, createLink func() string) {
			page.NextLink = to.Ptr(createLink())
		})
	}
	resp, err := server.PagerResponderNext(newListPager, req)
	if err != nil {
		return nil, err
	}
	if !contains([]int{http.StatusOK}, resp.StatusCode) {
		s.newListPager.remove(req)
		return nil, &nonRetriableError{fmt.Errorf("unexpected status code %d. acceptable values are http.StatusOK", resp.StatusCode)}
	}
	if !server.PagerResponderMore(newListPager) {
		s.newListPager.remove(req)
	}
	return resp, nil
}
