//go:build go1.18
// +build go1.18

// Copyright (c) Microsoft Corporation. All rights reserved.
// Licensed under the MIT License. See License.txt in the project root for license information.
// Code generated by Microsoft (R) AutoRest Code Generator. DO NOT EDIT.
// Changes may cause incorrect behavior and will be lost if the code is regenerated.

package fake

import (
	"context"
	"errors"
	"fmt"
	azfake "github.com/Azure/azure-sdk-for-go/sdk/azcore/fake"
	"github.com/Azure/azure-sdk-for-go/sdk/azcore/fake/server"
	"github.com/Azure/azure-sdk-for-go/sdk/azcore/runtime"
	"github.com/Azure/azure-sdk-for-go/sdk/azcore/to"
	"github.com/Azure/azure-sdk-for-go/sdk/resourcemanager/billing/armbilling"
	"net/http"
	"net/url"
	"regexp"
)

// CustomersServer is a fake server for instances of the armbilling.CustomersClient type.
type CustomersServer struct {
	// Get is the fake for method CustomersClient.Get
	// HTTP status codes to indicate success: http.StatusOK
	Get func(ctx context.Context, billingAccountName string, customerName string, options *armbilling.CustomersClientGetOptions) (resp azfake.Responder[armbilling.CustomersClientGetResponse], errResp azfake.ErrorResponder)

	// NewListByBillingAccountPager is the fake for method CustomersClient.NewListByBillingAccountPager
	// HTTP status codes to indicate success: http.StatusOK
	NewListByBillingAccountPager func(billingAccountName string, options *armbilling.CustomersClientListByBillingAccountOptions) (resp azfake.PagerResponder[armbilling.CustomersClientListByBillingAccountResponse])

	// NewListByBillingProfilePager is the fake for method CustomersClient.NewListByBillingProfilePager
	// HTTP status codes to indicate success: http.StatusOK
	NewListByBillingProfilePager func(billingAccountName string, billingProfileName string, options *armbilling.CustomersClientListByBillingProfileOptions) (resp azfake.PagerResponder[armbilling.CustomersClientListByBillingProfileResponse])
}

// NewCustomersServerTransport creates a new instance of CustomersServerTransport with the provided implementation.
// The returned CustomersServerTransport instance is connected to an instance of armbilling.CustomersClient via the
// azcore.ClientOptions.Transporter field in the client's constructor parameters.
func NewCustomersServerTransport(srv *CustomersServer) *CustomersServerTransport {
	return &CustomersServerTransport{
		srv:                          srv,
		newListByBillingAccountPager: newTracker[azfake.PagerResponder[armbilling.CustomersClientListByBillingAccountResponse]](),
		newListByBillingProfilePager: newTracker[azfake.PagerResponder[armbilling.CustomersClientListByBillingProfileResponse]](),
	}
}

// CustomersServerTransport connects instances of armbilling.CustomersClient to instances of CustomersServer.
// Don't use this type directly, use NewCustomersServerTransport instead.
type CustomersServerTransport struct {
	srv                          *CustomersServer
	newListByBillingAccountPager *tracker[azfake.PagerResponder[armbilling.CustomersClientListByBillingAccountResponse]]
	newListByBillingProfilePager *tracker[azfake.PagerResponder[armbilling.CustomersClientListByBillingProfileResponse]]
}

// Do implements the policy.Transporter interface for CustomersServerTransport.
func (c *CustomersServerTransport) Do(req *http.Request) (*http.Response, error) {
	rawMethod := req.Context().Value(runtime.CtxAPINameKey{})
	method, ok := rawMethod.(string)
	if !ok {
		return nil, nonRetriableError{errors.New("unable to dispatch request, missing value for CtxAPINameKey")}
	}

	var resp *http.Response
	var err error

	switch method {
	case "CustomersClient.Get":
		resp, err = c.dispatchGet(req)
	case "CustomersClient.NewListByBillingAccountPager":
		resp, err = c.dispatchNewListByBillingAccountPager(req)
	case "CustomersClient.NewListByBillingProfilePager":
		resp, err = c.dispatchNewListByBillingProfilePager(req)
	default:
		err = fmt.Errorf("unhandled API %s", method)
	}

	if err != nil {
		return nil, err
	}

	return resp, nil
}

func (c *CustomersServerTransport) dispatchGet(req *http.Request) (*http.Response, error) {
	if c.srv.Get == nil {
		return nil, &nonRetriableError{errors.New("fake for method Get not implemented")}
	}
	const regexStr = `/providers/Microsoft\.Billing/billingAccounts/(?P<billingAccountName>[!#&$-;=?-\[\]_a-zA-Z0-9~%@]+)/customers/(?P<customerName>[!#&$-;=?-\[\]_a-zA-Z0-9~%@]+)`
	regex := regexp.MustCompile(regexStr)
	matches := regex.FindStringSubmatch(req.URL.EscapedPath())
	if matches == nil || len(matches) < 2 {
		return nil, fmt.Errorf("failed to parse path %s", req.URL.Path)
	}
	qp := req.URL.Query()
	billingAccountNameParam, err := url.PathUnescape(matches[regex.SubexpIndex("billingAccountName")])
	if err != nil {
		return nil, err
	}
	customerNameParam, err := url.PathUnescape(matches[regex.SubexpIndex("customerName")])
	if err != nil {
		return nil, err
	}
	expandUnescaped, err := url.QueryUnescape(qp.Get("$expand"))
	if err != nil {
		return nil, err
	}
	expandParam := getOptional(expandUnescaped)
	var options *armbilling.CustomersClientGetOptions
	if expandParam != nil {
		options = &armbilling.CustomersClientGetOptions{
			Expand: expandParam,
		}
	}
	respr, errRespr := c.srv.Get(req.Context(), billingAccountNameParam, customerNameParam, options)
	if respErr := server.GetError(errRespr, req); respErr != nil {
		return nil, respErr
	}
	respContent := server.GetResponseContent(respr)
	if !contains([]int{http.StatusOK}, respContent.HTTPStatus) {
		return nil, &nonRetriableError{fmt.Errorf("unexpected status code %d. acceptable values are http.StatusOK", respContent.HTTPStatus)}
	}
	resp, err := server.MarshalResponseAsJSON(respContent, server.GetResponse(respr).Customer, req)
	if err != nil {
		return nil, err
	}
	return resp, nil
}

func (c *CustomersServerTransport) dispatchNewListByBillingAccountPager(req *http.Request) (*http.Response, error) {
	if c.srv.NewListByBillingAccountPager == nil {
		return nil, &nonRetriableError{errors.New("fake for method NewListByBillingAccountPager not implemented")}
	}
	newListByBillingAccountPager := c.newListByBillingAccountPager.get(req)
	if newListByBillingAccountPager == nil {
		const regexStr = `/providers/Microsoft\.Billing/billingAccounts/(?P<billingAccountName>[!#&$-;=?-\[\]_a-zA-Z0-9~%@]+)/customers`
		regex := regexp.MustCompile(regexStr)
		matches := regex.FindStringSubmatch(req.URL.EscapedPath())
		if matches == nil || len(matches) < 1 {
			return nil, fmt.Errorf("failed to parse path %s", req.URL.Path)
		}
		qp := req.URL.Query()
		billingAccountNameParam, err := url.PathUnescape(matches[regex.SubexpIndex("billingAccountName")])
		if err != nil {
			return nil, err
		}
		searchUnescaped, err := url.QueryUnescape(qp.Get("$search"))
		if err != nil {
			return nil, err
		}
		searchParam := getOptional(searchUnescaped)
		filterUnescaped, err := url.QueryUnescape(qp.Get("$filter"))
		if err != nil {
			return nil, err
		}
		filterParam := getOptional(filterUnescaped)
		var options *armbilling.CustomersClientListByBillingAccountOptions
		if searchParam != nil || filterParam != nil {
			options = &armbilling.CustomersClientListByBillingAccountOptions{
				Search: searchParam,
				Filter: filterParam,
			}
		}
		resp := c.srv.NewListByBillingAccountPager(billingAccountNameParam, options)
		newListByBillingAccountPager = &resp
		c.newListByBillingAccountPager.add(req, newListByBillingAccountPager)
		server.PagerResponderInjectNextLinks(newListByBillingAccountPager, req, func(page *armbilling.CustomersClientListByBillingAccountResponse, createLink func() string) {
			page.NextLink = to.Ptr(createLink())
		})
	}
	resp, err := server.PagerResponderNext(newListByBillingAccountPager, req)
	if err != nil {
		return nil, err
	}
	if !contains([]int{http.StatusOK}, resp.StatusCode) {
		c.newListByBillingAccountPager.remove(req)
		return nil, &nonRetriableError{fmt.Errorf("unexpected status code %d. acceptable values are http.StatusOK", resp.StatusCode)}
	}
	if !server.PagerResponderMore(newListByBillingAccountPager) {
		c.newListByBillingAccountPager.remove(req)
	}
	return resp, nil
}

func (c *CustomersServerTransport) dispatchNewListByBillingProfilePager(req *http.Request) (*http.Response, error) {
	if c.srv.NewListByBillingProfilePager == nil {
		return nil, &nonRetriableError{errors.New("fake for method NewListByBillingProfilePager not implemented")}
	}
	newListByBillingProfilePager := c.newListByBillingProfilePager.get(req)
	if newListByBillingProfilePager == nil {
		const regexStr = `/providers/Microsoft\.Billing/billingAccounts/(?P<billingAccountName>[!#&$-;=?-\[\]_a-zA-Z0-9~%@]+)/billingProfiles/(?P<billingProfileName>[!#&$-;=?-\[\]_a-zA-Z0-9~%@]+)/customers`
		regex := regexp.MustCompile(regexStr)
		matches := regex.FindStringSubmatch(req.URL.EscapedPath())
		if matches == nil || len(matches) < 2 {
			return nil, fmt.Errorf("failed to parse path %s", req.URL.Path)
		}
		qp := req.URL.Query()
		billingAccountNameParam, err := url.PathUnescape(matches[regex.SubexpIndex("billingAccountName")])
		if err != nil {
			return nil, err
		}
		billingProfileNameParam, err := url.PathUnescape(matches[regex.SubexpIndex("billingProfileName")])
		if err != nil {
			return nil, err
		}
		searchUnescaped, err := url.QueryUnescape(qp.Get("$search"))
		if err != nil {
			return nil, err
		}
		searchParam := getOptional(searchUnescaped)
		filterUnescaped, err := url.QueryUnescape(qp.Get("$filter"))
		if err != nil {
			return nil, err
		}
		filterParam := getOptional(filterUnescaped)
		var options *armbilling.CustomersClientListByBillingProfileOptions
		if searchParam != nil || filterParam != nil {
			options = &armbilling.CustomersClientListByBillingProfileOptions{
				Search: searchParam,
				Filter: filterParam,
			}
		}
		resp := c.srv.NewListByBillingProfilePager(billingAccountNameParam, billingProfileNameParam, options)
		newListByBillingProfilePager = &resp
		c.newListByBillingProfilePager.add(req, newListByBillingProfilePager)
		server.PagerResponderInjectNextLinks(newListByBillingProfilePager, req, func(page *armbilling.CustomersClientListByBillingProfileResponse, createLink func() string) {
			page.NextLink = to.Ptr(createLink())
		})
	}
	resp, err := server.PagerResponderNext(newListByBillingProfilePager, req)
	if err != nil {
		return nil, err
	}
	if !contains([]int{http.StatusOK}, resp.StatusCode) {
		c.newListByBillingProfilePager.remove(req)
		return nil, &nonRetriableError{fmt.Errorf("unexpected status code %d. acceptable values are http.StatusOK", resp.StatusCode)}
	}
	if !server.PagerResponderMore(newListByBillingProfilePager) {
		c.newListByBillingProfilePager.remove(req)
	}
	return resp, nil
}
