//go:build go1.18
// +build go1.18

// Copyright (c) Microsoft Corporation. All rights reserved.
// Licensed under the MIT License. See License.txt in the project root for license information.
// Code generated by Microsoft (R) AutoRest Code Generator. DO NOT EDIT.
// Changes may cause incorrect behavior and will be lost if the code is regenerated.

package fake

import (
	"context"
	"errors"
	"fmt"
	azfake "github.com/Azure/azure-sdk-for-go/sdk/azcore/fake"
	"github.com/Azure/azure-sdk-for-go/sdk/azcore/fake/server"
	"github.com/Azure/azure-sdk-for-go/sdk/azcore/runtime"
	"github.com/Azure/azure-sdk-for-go/sdk/azcore/to"
	"github.com/Azure/azure-sdk-for-go/sdk/resourcemanager/billing/armbilling"
	"net/http"
	"net/url"
	"regexp"
)

// InstructionsServer is a fake server for instances of the armbilling.InstructionsClient type.
type InstructionsServer struct {
	// Get is the fake for method InstructionsClient.Get
	// HTTP status codes to indicate success: http.StatusOK
	Get func(ctx context.Context, billingAccountName string, billingProfileName string, instructionName string, options *armbilling.InstructionsClientGetOptions) (resp azfake.Responder[armbilling.InstructionsClientGetResponse], errResp azfake.ErrorResponder)

	// NewListByBillingProfilePager is the fake for method InstructionsClient.NewListByBillingProfilePager
	// HTTP status codes to indicate success: http.StatusOK
	NewListByBillingProfilePager func(billingAccountName string, billingProfileName string, options *armbilling.InstructionsClientListByBillingProfileOptions) (resp azfake.PagerResponder[armbilling.InstructionsClientListByBillingProfileResponse])

	// Put is the fake for method InstructionsClient.Put
	// HTTP status codes to indicate success: http.StatusOK
	Put func(ctx context.Context, billingAccountName string, billingProfileName string, instructionName string, parameters armbilling.Instruction, options *armbilling.InstructionsClientPutOptions) (resp azfake.Responder[armbilling.InstructionsClientPutResponse], errResp azfake.ErrorResponder)
}

// NewInstructionsServerTransport creates a new instance of InstructionsServerTransport with the provided implementation.
// The returned InstructionsServerTransport instance is connected to an instance of armbilling.InstructionsClient via the
// azcore.ClientOptions.Transporter field in the client's constructor parameters.
func NewInstructionsServerTransport(srv *InstructionsServer) *InstructionsServerTransport {
	return &InstructionsServerTransport{
		srv:                          srv,
		newListByBillingProfilePager: newTracker[azfake.PagerResponder[armbilling.InstructionsClientListByBillingProfileResponse]](),
	}
}

// InstructionsServerTransport connects instances of armbilling.InstructionsClient to instances of InstructionsServer.
// Don't use this type directly, use NewInstructionsServerTransport instead.
type InstructionsServerTransport struct {
	srv                          *InstructionsServer
	newListByBillingProfilePager *tracker[azfake.PagerResponder[armbilling.InstructionsClientListByBillingProfileResponse]]
}

// Do implements the policy.Transporter interface for InstructionsServerTransport.
func (i *InstructionsServerTransport) Do(req *http.Request) (*http.Response, error) {
	rawMethod := req.Context().Value(runtime.CtxAPINameKey{})
	method, ok := rawMethod.(string)
	if !ok {
		return nil, nonRetriableError{errors.New("unable to dispatch request, missing value for CtxAPINameKey")}
	}

	var resp *http.Response
	var err error

	switch method {
	case "InstructionsClient.Get":
		resp, err = i.dispatchGet(req)
	case "InstructionsClient.NewListByBillingProfilePager":
		resp, err = i.dispatchNewListByBillingProfilePager(req)
	case "InstructionsClient.Put":
		resp, err = i.dispatchPut(req)
	default:
		err = fmt.Errorf("unhandled API %s", method)
	}

	if err != nil {
		return nil, err
	}

	return resp, nil
}

func (i *InstructionsServerTransport) dispatchGet(req *http.Request) (*http.Response, error) {
	if i.srv.Get == nil {
		return nil, &nonRetriableError{errors.New("fake for method Get not implemented")}
	}
	const regexStr = `/providers/Microsoft\.Billing/billingAccounts/(?P<billingAccountName>[!#&$-;=?-\[\]_a-zA-Z0-9~%@]+)/billingProfiles/(?P<billingProfileName>[!#&$-;=?-\[\]_a-zA-Z0-9~%@]+)/instructions/(?P<instructionName>[!#&$-;=?-\[\]_a-zA-Z0-9~%@]+)`
	regex := regexp.MustCompile(regexStr)
	matches := regex.FindStringSubmatch(req.URL.EscapedPath())
	if matches == nil || len(matches) < 3 {
		return nil, fmt.Errorf("failed to parse path %s", req.URL.Path)
	}
	billingAccountNameParam, err := url.PathUnescape(matches[regex.SubexpIndex("billingAccountName")])
	if err != nil {
		return nil, err
	}
	billingProfileNameParam, err := url.PathUnescape(matches[regex.SubexpIndex("billingProfileName")])
	if err != nil {
		return nil, err
	}
	instructionNameParam, err := url.PathUnescape(matches[regex.SubexpIndex("instructionName")])
	if err != nil {
		return nil, err
	}
	respr, errRespr := i.srv.Get(req.Context(), billingAccountNameParam, billingProfileNameParam, instructionNameParam, nil)
	if respErr := server.GetError(errRespr, req); respErr != nil {
		return nil, respErr
	}
	respContent := server.GetResponseContent(respr)
	if !contains([]int{http.StatusOK}, respContent.HTTPStatus) {
		return nil, &nonRetriableError{fmt.Errorf("unexpected status code %d. acceptable values are http.StatusOK", respContent.HTTPStatus)}
	}
	resp, err := server.MarshalResponseAsJSON(respContent, server.GetResponse(respr).Instruction, req)
	if err != nil {
		return nil, err
	}
	return resp, nil
}

func (i *InstructionsServerTransport) dispatchNewListByBillingProfilePager(req *http.Request) (*http.Response, error) {
	if i.srv.NewListByBillingProfilePager == nil {
		return nil, &nonRetriableError{errors.New("fake for method NewListByBillingProfilePager not implemented")}
	}
	newListByBillingProfilePager := i.newListByBillingProfilePager.get(req)
	if newListByBillingProfilePager == nil {
		const regexStr = `/providers/Microsoft\.Billing/billingAccounts/(?P<billingAccountName>[!#&$-;=?-\[\]_a-zA-Z0-9~%@]+)/billingProfiles/(?P<billingProfileName>[!#&$-;=?-\[\]_a-zA-Z0-9~%@]+)/instructions`
		regex := regexp.MustCompile(regexStr)
		matches := regex.FindStringSubmatch(req.URL.EscapedPath())
		if matches == nil || len(matches) < 2 {
			return nil, fmt.Errorf("failed to parse path %s", req.URL.Path)
		}
		billingAccountNameParam, err := url.PathUnescape(matches[regex.SubexpIndex("billingAccountName")])
		if err != nil {
			return nil, err
		}
		billingProfileNameParam, err := url.PathUnescape(matches[regex.SubexpIndex("billingProfileName")])
		if err != nil {
			return nil, err
		}
		resp := i.srv.NewListByBillingProfilePager(billingAccountNameParam, billingProfileNameParam, nil)
		newListByBillingProfilePager = &resp
		i.newListByBillingProfilePager.add(req, newListByBillingProfilePager)
		server.PagerResponderInjectNextLinks(newListByBillingProfilePager, req, func(page *armbilling.InstructionsClientListByBillingProfileResponse, createLink func() string) {
			page.NextLink = to.Ptr(createLink())
		})
	}
	resp, err := server.PagerResponderNext(newListByBillingProfilePager, req)
	if err != nil {
		return nil, err
	}
	if !contains([]int{http.StatusOK}, resp.StatusCode) {
		i.newListByBillingProfilePager.remove(req)
		return nil, &nonRetriableError{fmt.Errorf("unexpected status code %d. acceptable values are http.StatusOK", resp.StatusCode)}
	}
	if !server.PagerResponderMore(newListByBillingProfilePager) {
		i.newListByBillingProfilePager.remove(req)
	}
	return resp, nil
}

func (i *InstructionsServerTransport) dispatchPut(req *http.Request) (*http.Response, error) {
	if i.srv.Put == nil {
		return nil, &nonRetriableError{errors.New("fake for method Put not implemented")}
	}
	const regexStr = `/providers/Microsoft\.Billing/billingAccounts/(?P<billingAccountName>[!#&$-;=?-\[\]_a-zA-Z0-9~%@]+)/billingProfiles/(?P<billingProfileName>[!#&$-;=?-\[\]_a-zA-Z0-9~%@]+)/instructions/(?P<instructionName>[!#&$-;=?-\[\]_a-zA-Z0-9~%@]+)`
	regex := regexp.MustCompile(regexStr)
	matches := regex.FindStringSubmatch(req.URL.EscapedPath())
	if matches == nil || len(matches) < 3 {
		return nil, fmt.Errorf("failed to parse path %s", req.URL.Path)
	}
	body, err := server.UnmarshalRequestAsJSON[armbilling.Instruction](req)
	if err != nil {
		return nil, err
	}
	billingAccountNameParam, err := url.PathUnescape(matches[regex.SubexpIndex("billingAccountName")])
	if err != nil {
		return nil, err
	}
	billingProfileNameParam, err := url.PathUnescape(matches[regex.SubexpIndex("billingProfileName")])
	if err != nil {
		return nil, err
	}
	instructionNameParam, err := url.PathUnescape(matches[regex.SubexpIndex("instructionName")])
	if err != nil {
		return nil, err
	}
	respr, errRespr := i.srv.Put(req.Context(), billingAccountNameParam, billingProfileNameParam, instructionNameParam, body, nil)
	if respErr := server.GetError(errRespr, req); respErr != nil {
		return nil, respErr
	}
	respContent := server.GetResponseContent(respr)
	if !contains([]int{http.StatusOK}, respContent.HTTPStatus) {
		return nil, &nonRetriableError{fmt.Errorf("unexpected status code %d. acceptable values are http.StatusOK", respContent.HTTPStatus)}
	}
	resp, err := server.MarshalResponseAsJSON(respContent, server.GetResponse(respr).Instruction, req)
	if err != nil {
		return nil, err
	}
	return resp, nil
}
