//go:build go1.18
// +build go1.18

// Copyright (c) Microsoft Corporation. All rights reserved.
// Licensed under the MIT License. See License.txt in the project root for license information.
// Code generated by Microsoft (R) AutoRest Code Generator. DO NOT EDIT.
// Changes may cause incorrect behavior and will be lost if the code is regenerated.

package armbillingbenefits

import (
	"github.com/Azure/azure-sdk-for-go/sdk/azcore"
	"github.com/Azure/azure-sdk-for-go/sdk/azcore/arm"
)

// ClientFactory is a client factory used to create any client in this module.
// Don't use this type directly, use NewClientFactory instead.
type ClientFactory struct {
	credential azcore.TokenCredential
	options    *arm.ClientOptions
}

// NewClientFactory creates a new instance of ClientFactory with the specified values.
// The parameter values will be propagated to any client created from this factory.
//   - credential - used to authorize requests. Usually a credential from azidentity.
//   - options - pass nil to accept the default values.
func NewClientFactory(credential azcore.TokenCredential, options *arm.ClientOptions) (*ClientFactory, error) {
	_, err := arm.NewClient(moduleName, moduleVersion, credential, options)
	if err != nil {
		return nil, err
	}
	return &ClientFactory{
		credential: credential,
		options:    options.Clone(),
	}, nil
}

// NewOperationsClient creates a new instance of OperationsClient.
func (c *ClientFactory) NewOperationsClient() *OperationsClient {
	subClient, _ := NewOperationsClient(c.credential, c.options)
	return subClient
}

// NewRPClient creates a new instance of RPClient.
func (c *ClientFactory) NewRPClient() *RPClient {
	subClient, _ := NewRPClient(c.credential, c.options)
	return subClient
}

// NewReservationOrderAliasClient creates a new instance of ReservationOrderAliasClient.
func (c *ClientFactory) NewReservationOrderAliasClient() *ReservationOrderAliasClient {
	subClient, _ := NewReservationOrderAliasClient(c.credential, c.options)
	return subClient
}

// NewSavingsPlanClient creates a new instance of SavingsPlanClient.
func (c *ClientFactory) NewSavingsPlanClient() *SavingsPlanClient {
	subClient, _ := NewSavingsPlanClient(c.credential, c.options)
	return subClient
}

// NewSavingsPlanOrderAliasClient creates a new instance of SavingsPlanOrderAliasClient.
func (c *ClientFactory) NewSavingsPlanOrderAliasClient() *SavingsPlanOrderAliasClient {
	subClient, _ := NewSavingsPlanOrderAliasClient(c.credential, c.options)
	return subClient
}

// NewSavingsPlanOrderClient creates a new instance of SavingsPlanOrderClient.
func (c *ClientFactory) NewSavingsPlanOrderClient() *SavingsPlanOrderClient {
	subClient, _ := NewSavingsPlanOrderClient(c.credential, c.options)
	return subClient
}
