//go:build go1.18
// +build go1.18

// Copyright (c) Microsoft Corporation. All rights reserved.
// Licensed under the MIT License. See License.txt in the project root for license information.
// Code generated by Microsoft (R) AutoRest Code Generator. DO NOT EDIT.
// Changes may cause incorrect behavior and will be lost if the code is regenerated.

package fake

import (
	"context"
	"errors"
	"fmt"
	azfake "github.com/Azure/azure-sdk-for-go/sdk/azcore/fake"
	"github.com/Azure/azure-sdk-for-go/sdk/azcore/fake/server"
	"github.com/Azure/azure-sdk-for-go/sdk/azcore/runtime"
	"github.com/Azure/azure-sdk-for-go/sdk/azcore/to"
	"github.com/Azure/azure-sdk-for-go/sdk/resourcemanager/blueprint/armblueprint"
	"net/http"
	"net/url"
	"regexp"
)

// BlueprintsServer is a fake server for instances of the armblueprint.BlueprintsClient type.
type BlueprintsServer struct {
	// CreateOrUpdate is the fake for method BlueprintsClient.CreateOrUpdate
	// HTTP status codes to indicate success: http.StatusCreated
	CreateOrUpdate func(ctx context.Context, resourceScope string, blueprintName string, blueprint armblueprint.Blueprint, options *armblueprint.BlueprintsClientCreateOrUpdateOptions) (resp azfake.Responder[armblueprint.BlueprintsClientCreateOrUpdateResponse], errResp azfake.ErrorResponder)

	// Delete is the fake for method BlueprintsClient.Delete
	// HTTP status codes to indicate success: http.StatusOK, http.StatusNoContent
	Delete func(ctx context.Context, resourceScope string, blueprintName string, options *armblueprint.BlueprintsClientDeleteOptions) (resp azfake.Responder[armblueprint.BlueprintsClientDeleteResponse], errResp azfake.ErrorResponder)

	// Get is the fake for method BlueprintsClient.Get
	// HTTP status codes to indicate success: http.StatusOK
	Get func(ctx context.Context, resourceScope string, blueprintName string, options *armblueprint.BlueprintsClientGetOptions) (resp azfake.Responder[armblueprint.BlueprintsClientGetResponse], errResp azfake.ErrorResponder)

	// NewListPager is the fake for method BlueprintsClient.NewListPager
	// HTTP status codes to indicate success: http.StatusOK
	NewListPager func(resourceScope string, options *armblueprint.BlueprintsClientListOptions) (resp azfake.PagerResponder[armblueprint.BlueprintsClientListResponse])
}

// NewBlueprintsServerTransport creates a new instance of BlueprintsServerTransport with the provided implementation.
// The returned BlueprintsServerTransport instance is connected to an instance of armblueprint.BlueprintsClient via the
// azcore.ClientOptions.Transporter field in the client's constructor parameters.
func NewBlueprintsServerTransport(srv *BlueprintsServer) *BlueprintsServerTransport {
	return &BlueprintsServerTransport{
		srv:          srv,
		newListPager: newTracker[azfake.PagerResponder[armblueprint.BlueprintsClientListResponse]](),
	}
}

// BlueprintsServerTransport connects instances of armblueprint.BlueprintsClient to instances of BlueprintsServer.
// Don't use this type directly, use NewBlueprintsServerTransport instead.
type BlueprintsServerTransport struct {
	srv          *BlueprintsServer
	newListPager *tracker[azfake.PagerResponder[armblueprint.BlueprintsClientListResponse]]
}

// Do implements the policy.Transporter interface for BlueprintsServerTransport.
func (b *BlueprintsServerTransport) Do(req *http.Request) (*http.Response, error) {
	rawMethod := req.Context().Value(runtime.CtxAPINameKey{})
	method, ok := rawMethod.(string)
	if !ok {
		return nil, nonRetriableError{errors.New("unable to dispatch request, missing value for CtxAPINameKey")}
	}

	var resp *http.Response
	var err error

	switch method {
	case "BlueprintsClient.CreateOrUpdate":
		resp, err = b.dispatchCreateOrUpdate(req)
	case "BlueprintsClient.Delete":
		resp, err = b.dispatchDelete(req)
	case "BlueprintsClient.Get":
		resp, err = b.dispatchGet(req)
	case "BlueprintsClient.NewListPager":
		resp, err = b.dispatchNewListPager(req)
	default:
		err = fmt.Errorf("unhandled API %s", method)
	}

	if err != nil {
		return nil, err
	}

	return resp, nil
}

func (b *BlueprintsServerTransport) dispatchCreateOrUpdate(req *http.Request) (*http.Response, error) {
	if b.srv.CreateOrUpdate == nil {
		return nil, &nonRetriableError{errors.New("fake for method CreateOrUpdate not implemented")}
	}
	const regexStr = `/(?P<resourceScope>[!#&$-;=?-\[\]_a-zA-Z0-9~%@]+)/providers/Microsoft\.Blueprint/blueprints/(?P<blueprintName>[!#&$-;=?-\[\]_a-zA-Z0-9~%@]+)`
	regex := regexp.MustCompile(regexStr)
	matches := regex.FindStringSubmatch(req.URL.EscapedPath())
	if matches == nil || len(matches) < 2 {
		return nil, fmt.Errorf("failed to parse path %s", req.URL.Path)
	}
	body, err := server.UnmarshalRequestAsJSON[armblueprint.Blueprint](req)
	if err != nil {
		return nil, err
	}
	resourceScopeParam, err := url.PathUnescape(matches[regex.SubexpIndex("resourceScope")])
	if err != nil {
		return nil, err
	}
	blueprintNameParam, err := url.PathUnescape(matches[regex.SubexpIndex("blueprintName")])
	if err != nil {
		return nil, err
	}
	respr, errRespr := b.srv.CreateOrUpdate(req.Context(), resourceScopeParam, blueprintNameParam, body, nil)
	if respErr := server.GetError(errRespr, req); respErr != nil {
		return nil, respErr
	}
	respContent := server.GetResponseContent(respr)
	if !contains([]int{http.StatusCreated}, respContent.HTTPStatus) {
		return nil, &nonRetriableError{fmt.Errorf("unexpected status code %d. acceptable values are http.StatusCreated", respContent.HTTPStatus)}
	}
	resp, err := server.MarshalResponseAsJSON(respContent, server.GetResponse(respr).Blueprint, req)
	if err != nil {
		return nil, err
	}
	return resp, nil
}

func (b *BlueprintsServerTransport) dispatchDelete(req *http.Request) (*http.Response, error) {
	if b.srv.Delete == nil {
		return nil, &nonRetriableError{errors.New("fake for method Delete not implemented")}
	}
	const regexStr = `/(?P<resourceScope>[!#&$-;=?-\[\]_a-zA-Z0-9~%@]+)/providers/Microsoft\.Blueprint/blueprints/(?P<blueprintName>[!#&$-;=?-\[\]_a-zA-Z0-9~%@]+)`
	regex := regexp.MustCompile(regexStr)
	matches := regex.FindStringSubmatch(req.URL.EscapedPath())
	if matches == nil || len(matches) < 2 {
		return nil, fmt.Errorf("failed to parse path %s", req.URL.Path)
	}
	resourceScopeParam, err := url.PathUnescape(matches[regex.SubexpIndex("resourceScope")])
	if err != nil {
		return nil, err
	}
	blueprintNameParam, err := url.PathUnescape(matches[regex.SubexpIndex("blueprintName")])
	if err != nil {
		return nil, err
	}
	respr, errRespr := b.srv.Delete(req.Context(), resourceScopeParam, blueprintNameParam, nil)
	if respErr := server.GetError(errRespr, req); respErr != nil {
		return nil, respErr
	}
	respContent := server.GetResponseContent(respr)
	if !contains([]int{http.StatusOK, http.StatusNoContent}, respContent.HTTPStatus) {
		return nil, &nonRetriableError{fmt.Errorf("unexpected status code %d. acceptable values are http.StatusOK, http.StatusNoContent", respContent.HTTPStatus)}
	}
	resp, err := server.MarshalResponseAsJSON(respContent, server.GetResponse(respr).Blueprint, req)
	if err != nil {
		return nil, err
	}
	return resp, nil
}

func (b *BlueprintsServerTransport) dispatchGet(req *http.Request) (*http.Response, error) {
	if b.srv.Get == nil {
		return nil, &nonRetriableError{errors.New("fake for method Get not implemented")}
	}
	const regexStr = `/(?P<resourceScope>[!#&$-;=?-\[\]_a-zA-Z0-9~%@]+)/providers/Microsoft\.Blueprint/blueprints/(?P<blueprintName>[!#&$-;=?-\[\]_a-zA-Z0-9~%@]+)`
	regex := regexp.MustCompile(regexStr)
	matches := regex.FindStringSubmatch(req.URL.EscapedPath())
	if matches == nil || len(matches) < 2 {
		return nil, fmt.Errorf("failed to parse path %s", req.URL.Path)
	}
	resourceScopeParam, err := url.PathUnescape(matches[regex.SubexpIndex("resourceScope")])
	if err != nil {
		return nil, err
	}
	blueprintNameParam, err := url.PathUnescape(matches[regex.SubexpIndex("blueprintName")])
	if err != nil {
		return nil, err
	}
	respr, errRespr := b.srv.Get(req.Context(), resourceScopeParam, blueprintNameParam, nil)
	if respErr := server.GetError(errRespr, req); respErr != nil {
		return nil, respErr
	}
	respContent := server.GetResponseContent(respr)
	if !contains([]int{http.StatusOK}, respContent.HTTPStatus) {
		return nil, &nonRetriableError{fmt.Errorf("unexpected status code %d. acceptable values are http.StatusOK", respContent.HTTPStatus)}
	}
	resp, err := server.MarshalResponseAsJSON(respContent, server.GetResponse(respr).Blueprint, req)
	if err != nil {
		return nil, err
	}
	return resp, nil
}

func (b *BlueprintsServerTransport) dispatchNewListPager(req *http.Request) (*http.Response, error) {
	if b.srv.NewListPager == nil {
		return nil, &nonRetriableError{errors.New("fake for method NewListPager not implemented")}
	}
	newListPager := b.newListPager.get(req)
	if newListPager == nil {
		const regexStr = `/(?P<resourceScope>[!#&$-;=?-\[\]_a-zA-Z0-9~%@]+)/providers/Microsoft\.Blueprint/blueprints`
		regex := regexp.MustCompile(regexStr)
		matches := regex.FindStringSubmatch(req.URL.EscapedPath())
		if matches == nil || len(matches) < 1 {
			return nil, fmt.Errorf("failed to parse path %s", req.URL.Path)
		}
		resourceScopeParam, err := url.PathUnescape(matches[regex.SubexpIndex("resourceScope")])
		if err != nil {
			return nil, err
		}
		resp := b.srv.NewListPager(resourceScopeParam, nil)
		newListPager = &resp
		b.newListPager.add(req, newListPager)
		server.PagerResponderInjectNextLinks(newListPager, req, func(page *armblueprint.BlueprintsClientListResponse, createLink func() string) {
			page.NextLink = to.Ptr(createLink())
		})
	}
	resp, err := server.PagerResponderNext(newListPager, req)
	if err != nil {
		return nil, err
	}
	if !contains([]int{http.StatusOK}, resp.StatusCode) {
		b.newListPager.remove(req)
		return nil, &nonRetriableError{fmt.Errorf("unexpected status code %d. acceptable values are http.StatusOK", resp.StatusCode)}
	}
	if !server.PagerResponderMore(newListPager) {
		b.newListPager.remove(req)
	}
	return resp, nil
}
