//go:build go1.18
// +build go1.18

// Copyright (c) Microsoft Corporation. All rights reserved.
// Licensed under the MIT License. See License.txt in the project root for license information.
// Code generated by Microsoft (R) AutoRest Code Generator.
// Changes may cause incorrect behavior and will be lost if the code is regenerated.
// DO NOT EDIT.

package armcosmosforpostgresql_test

import (
	"context"
	"log"

	"github.com/Azure/azure-sdk-for-go/sdk/azidentity"
	"github.com/Azure/azure-sdk-for-go/sdk/resourcemanager/cosmosforpostgresql/armcosmosforpostgresql"
)

// Generated from example definition: https://github.com/Azure/azure-rest-api-specs/blob/cf5ad1932d00c7d15497705ad6b71171d3d68b1e/specification/postgresqlhsc/resource-manager/Microsoft.DBforPostgreSQL/preview/2023-03-02-preview/examples/ServerListByCluster.json
func ExampleServersClient_NewListByClusterPager() {
	cred, err := azidentity.NewDefaultAzureCredential(nil)
	if err != nil {
		log.Fatalf("failed to obtain a credential: %v", err)
	}
	ctx := context.Background()
	clientFactory, err := armcosmosforpostgresql.NewClientFactory("<subscription-id>", cred, nil)
	if err != nil {
		log.Fatalf("failed to create client: %v", err)
	}
	pager := clientFactory.NewServersClient().NewListByClusterPager("TestGroup", "testcluster1", nil)
	for pager.More() {
		page, err := pager.NextPage(ctx)
		if err != nil {
			log.Fatalf("failed to advance page: %v", err)
		}
		for _, v := range page.Value {
			// You could use page here. We use blank identifier for just demo purposes.
			_ = v
		}
		// If the HTTP response code is 200 as defined in example definition, your page structure would look as follows. Please pay attention that all the values in the output are fake values for just demo purposes.
		// page.ClusterServerListResult = armcosmosforpostgresql.ClusterServerListResult{
		// 	Value: []*armcosmosforpostgresql.ClusterServer{
		// 		{
		// 			Name: to.Ptr("testcluster1-c"),
		// 			Type: to.Ptr("Microsoft.DBforPostgreSQL/serverGroupsv2/servers"),
		// 			ID: to.Ptr("/subscriptions/ffffffff-ffff-ffff-ffff-ffffffffffff/resourceGroups/TestGroup/providers/Microsoft.DBforPostgreSQL/serverGroupsv2/testcluster1/servers/testcluster1-c"),
		// 			SystemData: &armcosmosforpostgresql.SystemData{
		// 				CreatedAt: to.Ptr(func() time.Time { t, _ := time.Parse(time.RFC3339Nano, "2020-01-01T17:18:19.123Z"); return t}()),
		// 				CreatedBy: to.Ptr("user1"),
		// 				CreatedByType: to.Ptr(armcosmosforpostgresql.CreatedByTypeUser),
		// 				LastModifiedAt: to.Ptr(func() time.Time { t, _ := time.Parse(time.RFC3339Nano, "2020-01-02T17:18:19.123Z"); return t}()),
		// 				LastModifiedBy: to.Ptr("user2"),
		// 				LastModifiedByType: to.Ptr(armcosmosforpostgresql.CreatedByTypeUser),
		// 			},
		// 			Properties: &armcosmosforpostgresql.ClusterServerProperties{
		// 				AdministratorLogin: to.Ptr("citus"),
		// 				EnableHa: to.Ptr(true),
		// 				EnablePublicIPAccess: to.Ptr(true),
		// 				IsReadOnly: to.Ptr(false),
		// 				ServerEdition: to.Ptr("MemoryOptimized"),
		// 				StorageQuotaInMb: to.Ptr[int32](10000),
		// 				VCores: to.Ptr[int32](4),
		// 				AvailabilityZone: to.Ptr("1"),
		// 				CitusVersion: to.Ptr("9.5"),
		// 				FullyQualifiedDomainName: to.Ptr("testcluster1-c.postgres.database.azure.com"),
		// 				HaState: to.Ptr("Healthy"),
		// 				PostgresqlVersion: to.Ptr("12"),
		// 				Role: to.Ptr(armcosmosforpostgresql.ServerRoleCoordinator),
		// 				State: to.Ptr("Ready"),
		// 			},
		// 		},
		// 		{
		// 			Name: to.Ptr("testcluster1-w0"),
		// 			Type: to.Ptr("Microsoft.DBforPostgreSQL/serverGroupsv2/servers"),
		// 			ID: to.Ptr("/subscriptions/ffffffff-ffff-ffff-ffff-ffffffffffff/resourceGroups/TestGroup/providers/Microsoft.DBforPostgreSQL/serverGroupsv2/testcluster1/servers/testcluster1-w0"),
		// 			SystemData: &armcosmosforpostgresql.SystemData{
		// 				CreatedAt: to.Ptr(func() time.Time { t, _ := time.Parse(time.RFC3339Nano, "2020-01-01T17:18:19.123Z"); return t}()),
		// 				CreatedBy: to.Ptr("user1"),
		// 				CreatedByType: to.Ptr(armcosmosforpostgresql.CreatedByTypeUser),
		// 				LastModifiedAt: to.Ptr(func() time.Time { t, _ := time.Parse(time.RFC3339Nano, "2020-01-02T17:18:19.123Z"); return t}()),
		// 				LastModifiedBy: to.Ptr("user2"),
		// 				LastModifiedByType: to.Ptr(armcosmosforpostgresql.CreatedByTypeUser),
		// 			},
		// 			Properties: &armcosmosforpostgresql.ClusterServerProperties{
		// 				AdministratorLogin: to.Ptr("citus"),
		// 				EnableHa: to.Ptr(false),
		// 				EnablePublicIPAccess: to.Ptr(false),
		// 				IsReadOnly: to.Ptr(false),
		// 				ServerEdition: to.Ptr("MemoryOptimized"),
		// 				StorageQuotaInMb: to.Ptr[int32](10000),
		// 				VCores: to.Ptr[int32](4),
		// 				AvailabilityZone: to.Ptr("1"),
		// 				CitusVersion: to.Ptr("9.5"),
		// 				FullyQualifiedDomainName: to.Ptr("testcluster1-w0.postgres.database.azure.com"),
		// 				HaState: to.Ptr("NotEnabled"),
		// 				PostgresqlVersion: to.Ptr("12"),
		// 				Role: to.Ptr(armcosmosforpostgresql.ServerRoleWorker),
		// 				State: to.Ptr("Ready"),
		// 			},
		// 		},
		// 		{
		// 			Name: to.Ptr("testcluster1-w1"),
		// 			Type: to.Ptr("Microsoft.DBforPostgreSQL/serverGroupsv2/servers"),
		// 			ID: to.Ptr("/subscriptions/ffffffff-ffff-ffff-ffff-ffffffffffff/resourceGroups/TestGroup/providers/Microsoft.DBforPostgreSQL/serverGroupsv2/testcluster1/servers/testcluster1-w1"),
		// 			SystemData: &armcosmosforpostgresql.SystemData{
		// 				CreatedAt: to.Ptr(func() time.Time { t, _ := time.Parse(time.RFC3339Nano, "2020-01-01T17:18:19.123Z"); return t}()),
		// 				CreatedBy: to.Ptr("user1"),
		// 				CreatedByType: to.Ptr(armcosmosforpostgresql.CreatedByTypeUser),
		// 				LastModifiedAt: to.Ptr(func() time.Time { t, _ := time.Parse(time.RFC3339Nano, "2020-01-02T17:18:19.123Z"); return t}()),
		// 				LastModifiedBy: to.Ptr("user2"),
		// 				LastModifiedByType: to.Ptr(armcosmosforpostgresql.CreatedByTypeUser),
		// 			},
		// 			Properties: &armcosmosforpostgresql.ClusterServerProperties{
		// 				AdministratorLogin: to.Ptr("citus"),
		// 				EnableHa: to.Ptr(false),
		// 				EnablePublicIPAccess: to.Ptr(false),
		// 				IsReadOnly: to.Ptr(false),
		// 				ServerEdition: to.Ptr("MemoryOptimized"),
		// 				StorageQuotaInMb: to.Ptr[int32](10000),
		// 				VCores: to.Ptr[int32](4),
		// 				AvailabilityZone: to.Ptr("1"),
		// 				CitusVersion: to.Ptr("9.5"),
		// 				FullyQualifiedDomainName: to.Ptr("testcluster1-w1.postgres.database.azure.com"),
		// 				HaState: to.Ptr("NotEnabled"),
		// 				PostgresqlVersion: to.Ptr("12"),
		// 				Role: to.Ptr(armcosmosforpostgresql.ServerRoleWorker),
		// 				State: to.Ptr("Ready"),
		// 			},
		// 	}},
		// }
	}
}

// Generated from example definition: https://github.com/Azure/azure-rest-api-specs/blob/cf5ad1932d00c7d15497705ad6b71171d3d68b1e/specification/postgresqlhsc/resource-manager/Microsoft.DBforPostgreSQL/preview/2023-03-02-preview/examples/ServerGet.json
func ExampleServersClient_Get() {
	cred, err := azidentity.NewDefaultAzureCredential(nil)
	if err != nil {
		log.Fatalf("failed to obtain a credential: %v", err)
	}
	ctx := context.Background()
	clientFactory, err := armcosmosforpostgresql.NewClientFactory("<subscription-id>", cred, nil)
	if err != nil {
		log.Fatalf("failed to create client: %v", err)
	}
	res, err := clientFactory.NewServersClient().Get(ctx, "TestGroup", "testcluster1", "testcluster1-c", nil)
	if err != nil {
		log.Fatalf("failed to finish the request: %v", err)
	}
	// You could use response here. We use blank identifier for just demo purposes.
	_ = res
	// If the HTTP response code is 200 as defined in example definition, your response structure would look as follows. Please pay attention that all the values in the output are fake values for just demo purposes.
	// res.ClusterServer = armcosmosforpostgresql.ClusterServer{
	// 	Name: to.Ptr("testcluster1-c"),
	// 	Type: to.Ptr("Microsoft.DBforPostgreSQL/serverGroupsv2/servers"),
	// 	ID: to.Ptr("/subscriptions/ffffffff-ffff-ffff-ffff-ffffffffffff/resourceGroups/TestGroup/providers/Microsoft.DBforPostgreSQL/serverGroupsv2/testcluster1/servers/testcluster1-c"),
	// 	SystemData: &armcosmosforpostgresql.SystemData{
	// 		CreatedAt: to.Ptr(func() time.Time { t, _ := time.Parse(time.RFC3339Nano, "2020-01-01T17:18:19.123Z"); return t}()),
	// 		CreatedBy: to.Ptr("user1"),
	// 		CreatedByType: to.Ptr(armcosmosforpostgresql.CreatedByTypeUser),
	// 		LastModifiedAt: to.Ptr(func() time.Time { t, _ := time.Parse(time.RFC3339Nano, "2020-01-02T17:18:19.123Z"); return t}()),
	// 		LastModifiedBy: to.Ptr("user2"),
	// 		LastModifiedByType: to.Ptr(armcosmosforpostgresql.CreatedByTypeUser),
	// 	},
	// 	Properties: &armcosmosforpostgresql.ClusterServerProperties{
	// 		AdministratorLogin: to.Ptr("citus"),
	// 		EnableHa: to.Ptr(true),
	// 		EnablePublicIPAccess: to.Ptr(true),
	// 		IsReadOnly: to.Ptr(false),
	// 		ServerEdition: to.Ptr("MemoryOptimized"),
	// 		StorageQuotaInMb: to.Ptr[int32](10000),
	// 		VCores: to.Ptr[int32](4),
	// 		AvailabilityZone: to.Ptr("1"),
	// 		CitusVersion: to.Ptr("9.5"),
	// 		FullyQualifiedDomainName: to.Ptr("testcluster1-c.postgres.database.azure.com"),
	// 		HaState: to.Ptr("Healthy"),
	// 		PostgresqlVersion: to.Ptr("12"),
	// 		Role: to.Ptr(armcosmosforpostgresql.ServerRoleCoordinator),
	// 		State: to.Ptr("Ready"),
	// 	},
	// }
}
