//go:build go1.18
// +build go1.18

// Copyright (c) Microsoft Corporation. All rights reserved.
// Licensed under the MIT License. See License.txt in the project root for license information.
// Code generated by Microsoft (R) AutoRest Code Generator. DO NOT EDIT.
// Changes may cause incorrect behavior and will be lost if the code is regenerated.

package armcostmanagement

import (
	"context"
	"errors"
	"github.com/Azure/azure-sdk-for-go/sdk/azcore"
	"github.com/Azure/azure-sdk-for-go/sdk/azcore/arm"
	"github.com/Azure/azure-sdk-for-go/sdk/azcore/policy"
	"github.com/Azure/azure-sdk-for-go/sdk/azcore/runtime"
	"net/http"
	"net/url"
	"strconv"
	"strings"
)

// DimensionsClient contains the methods for the Dimensions group.
// Don't use this type directly, use NewDimensionsClient() instead.
type DimensionsClient struct {
	internal *arm.Client
}

// NewDimensionsClient creates a new instance of DimensionsClient with the specified values.
//   - credential - used to authorize requests. Usually a credential from azidentity.
//   - options - pass nil to accept the default values.
func NewDimensionsClient(credential azcore.TokenCredential, options *arm.ClientOptions) (*DimensionsClient, error) {
	cl, err := arm.NewClient(moduleName, moduleVersion, credential, options)
	if err != nil {
		return nil, err
	}
	client := &DimensionsClient{
		internal: cl,
	}
	return client, nil
}

// NewByExternalCloudProviderTypePager - Lists the dimensions by the external cloud provider type.
//
// Generated from API version 2022-10-01
//   - externalCloudProviderType - The external cloud provider type associated with dimension/query operations. This includes
//     'externalSubscriptions' for linked account and 'externalBillingAccounts' for consolidated account.
//   - externalCloudProviderID - This can be '{externalSubscriptionId}' for linked account or '{externalBillingAccountId}' for
//     consolidated account used with dimension/query operations.
//   - options - DimensionsClientByExternalCloudProviderTypeOptions contains the optional parameters for the DimensionsClient.NewByExternalCloudProviderTypePager
//     method.
func (client *DimensionsClient) NewByExternalCloudProviderTypePager(externalCloudProviderType ExternalCloudProviderType, externalCloudProviderID string, options *DimensionsClientByExternalCloudProviderTypeOptions) *runtime.Pager[DimensionsClientByExternalCloudProviderTypeResponse] {
	return runtime.NewPager(runtime.PagingHandler[DimensionsClientByExternalCloudProviderTypeResponse]{
		More: func(page DimensionsClientByExternalCloudProviderTypeResponse) bool {
			return false
		},
		Fetcher: func(ctx context.Context, page *DimensionsClientByExternalCloudProviderTypeResponse) (DimensionsClientByExternalCloudProviderTypeResponse, error) {
			ctx = context.WithValue(ctx, runtime.CtxAPINameKey{}, "DimensionsClient.NewByExternalCloudProviderTypePager")
			req, err := client.byExternalCloudProviderTypeCreateRequest(ctx, externalCloudProviderType, externalCloudProviderID, options)
			if err != nil {
				return DimensionsClientByExternalCloudProviderTypeResponse{}, err
			}
			resp, err := client.internal.Pipeline().Do(req)
			if err != nil {
				return DimensionsClientByExternalCloudProviderTypeResponse{}, err
			}
			if !runtime.HasStatusCode(resp, http.StatusOK) {
				return DimensionsClientByExternalCloudProviderTypeResponse{}, runtime.NewResponseError(resp)
			}
			return client.byExternalCloudProviderTypeHandleResponse(resp)
		},
		Tracer: client.internal.Tracer(),
	})
}

// byExternalCloudProviderTypeCreateRequest creates the ByExternalCloudProviderType request.
func (client *DimensionsClient) byExternalCloudProviderTypeCreateRequest(ctx context.Context, externalCloudProviderType ExternalCloudProviderType, externalCloudProviderID string, options *DimensionsClientByExternalCloudProviderTypeOptions) (*policy.Request, error) {
	urlPath := "/providers/Microsoft.CostManagement/{externalCloudProviderType}/{externalCloudProviderId}/dimensions"
	if externalCloudProviderType == "" {
		return nil, errors.New("parameter externalCloudProviderType cannot be empty")
	}
	urlPath = strings.ReplaceAll(urlPath, "{externalCloudProviderType}", url.PathEscape(string(externalCloudProviderType)))
	if externalCloudProviderID == "" {
		return nil, errors.New("parameter externalCloudProviderID cannot be empty")
	}
	urlPath = strings.ReplaceAll(urlPath, "{externalCloudProviderId}", url.PathEscape(externalCloudProviderID))
	req, err := runtime.NewRequest(ctx, http.MethodGet, runtime.JoinPaths(client.internal.Endpoint(), urlPath))
	if err != nil {
		return nil, err
	}
	reqQP := req.Raw().URL.Query()
	reqQP.Set("api-version", "2022-10-01")
	if options != nil && options.Filter != nil {
		reqQP.Set("$filter", *options.Filter)
	}
	if options != nil && options.Expand != nil {
		reqQP.Set("$expand", *options.Expand)
	}
	if options != nil && options.Skiptoken != nil {
		reqQP.Set("$skiptoken", *options.Skiptoken)
	}
	if options != nil && options.Top != nil {
		reqQP.Set("$top", strconv.FormatInt(int64(*options.Top), 10))
	}
	req.Raw().URL.RawQuery = reqQP.Encode()
	req.Raw().Header["Accept"] = []string{"application/json"}
	return req, nil
}

// byExternalCloudProviderTypeHandleResponse handles the ByExternalCloudProviderType response.
func (client *DimensionsClient) byExternalCloudProviderTypeHandleResponse(resp *http.Response) (DimensionsClientByExternalCloudProviderTypeResponse, error) {
	result := DimensionsClientByExternalCloudProviderTypeResponse{}
	if err := runtime.UnmarshalAsJSON(resp, &result.DimensionsListResult); err != nil {
		return DimensionsClientByExternalCloudProviderTypeResponse{}, err
	}
	return result, nil
}

// NewListPager - Lists the dimensions by the defined scope.
//
// Generated from API version 2022-10-01
//   - scope - The scope associated with dimension operations. This includes '/subscriptions/{subscriptionId}/' for subscription
//     scope, '/subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}' for
//     resourceGroup scope, '/providers/Microsoft.Billing/billingAccounts/{billingAccountId}' for Billing Account scope,
//     '/providers/Microsoft.Billing/billingAccounts/{billingAccountId}/departments/{departmentId}' for Department scope,
//     '/providers/Microsoft.Billing/billingAccounts/{billingAccountId}/enrollmentAccounts/{enrollmentAccountId}' for EnrollmentAccount
//     scope,
//     '/providers/Microsoft.Management/managementGroups/{managementGroupId}' for Management Group scope, '/providers/Microsoft.Billing/billingAccounts/{billingAccountId}/billingProfiles/{billingProfileId}'
//     for billingProfile scope, 'providers/Microsoft.Billing/billingAccounts/{billingAccountId}/billingProfiles/{billingProfileId}/invoiceSections/{invoiceSectionId}'
//     for invoiceSection scope, and
//     'providers/Microsoft.Billing/billingAccounts/{billingAccountId}/customers/{customerId}' specific for partners.
//   - options - DimensionsClientListOptions contains the optional parameters for the DimensionsClient.NewListPager method.
func (client *DimensionsClient) NewListPager(scope string, options *DimensionsClientListOptions) *runtime.Pager[DimensionsClientListResponse] {
	return runtime.NewPager(runtime.PagingHandler[DimensionsClientListResponse]{
		More: func(page DimensionsClientListResponse) bool {
			return false
		},
		Fetcher: func(ctx context.Context, page *DimensionsClientListResponse) (DimensionsClientListResponse, error) {
			ctx = context.WithValue(ctx, runtime.CtxAPINameKey{}, "DimensionsClient.NewListPager")
			req, err := client.listCreateRequest(ctx, scope, options)
			if err != nil {
				return DimensionsClientListResponse{}, err
			}
			resp, err := client.internal.Pipeline().Do(req)
			if err != nil {
				return DimensionsClientListResponse{}, err
			}
			if !runtime.HasStatusCode(resp, http.StatusOK) {
				return DimensionsClientListResponse{}, runtime.NewResponseError(resp)
			}
			return client.listHandleResponse(resp)
		},
		Tracer: client.internal.Tracer(),
	})
}

// listCreateRequest creates the List request.
func (client *DimensionsClient) listCreateRequest(ctx context.Context, scope string, options *DimensionsClientListOptions) (*policy.Request, error) {
	urlPath := "/{scope}/providers/Microsoft.CostManagement/dimensions"
	urlPath = strings.ReplaceAll(urlPath, "{scope}", scope)
	req, err := runtime.NewRequest(ctx, http.MethodGet, runtime.JoinPaths(client.internal.Endpoint(), urlPath))
	if err != nil {
		return nil, err
	}
	reqQP := req.Raw().URL.Query()
	reqQP.Set("api-version", "2022-10-01")
	if options != nil && options.Filter != nil {
		reqQP.Set("$filter", *options.Filter)
	}
	if options != nil && options.Expand != nil {
		reqQP.Set("$expand", *options.Expand)
	}
	if options != nil && options.Skiptoken != nil {
		reqQP.Set("$skiptoken", *options.Skiptoken)
	}
	if options != nil && options.Top != nil {
		reqQP.Set("$top", strconv.FormatInt(int64(*options.Top), 10))
	}
	req.Raw().URL.RawQuery = reqQP.Encode()
	req.Raw().Header["Accept"] = []string{"application/json"}
	return req, nil
}

// listHandleResponse handles the List response.
func (client *DimensionsClient) listHandleResponse(resp *http.Response) (DimensionsClientListResponse, error) {
	result := DimensionsClientListResponse{}
	if err := runtime.UnmarshalAsJSON(resp, &result.DimensionsListResult); err != nil {
		return DimensionsClientListResponse{}, err
	}
	return result, nil
}
