//go:build go1.18
// +build go1.18

// Copyright (c) Microsoft Corporation. All rights reserved.
// Licensed under the MIT License. See License.txt in the project root for license information.
// Code generated by Microsoft (R) AutoRest Code Generator. DO NOT EDIT.
// Changes may cause incorrect behavior and will be lost if the code is regenerated.

package armdatabox

import "time"

type APIError struct {
	// REQUIRED
	Error *ErrorDetail
}

// AccountCopyLogDetails - Copy log details for a storage account of a DataBox job
type AccountCopyLogDetails struct {
	// REQUIRED; Indicates the type of job details.
	CopyLogDetailsType *ClassDiscriminator

	// READ-ONLY; Account name.
	AccountName *string

	// READ-ONLY; Link for copy logs.
	CopyLogLink *string

	// READ-ONLY; Link for copy verbose logs. This will be set only when LogCollectionLevel is set to Verbose.
	CopyVerboseLogLink *string
}

// GetCopyLogDetails implements the CopyLogDetailsClassification interface for type AccountCopyLogDetails.
func (a *AccountCopyLogDetails) GetCopyLogDetails() *CopyLogDetails {
	return &CopyLogDetails{
		CopyLogDetailsType: a.CopyLogDetailsType,
	}
}

// AccountCredentialDetails - Credential details of the account.
type AccountCredentialDetails struct {
	// READ-ONLY; Connection string of the account endpoint to use the account as a storage endpoint on the device.
	AccountConnectionString *string

	// READ-ONLY; Name of the account.
	AccountName *string

	// READ-ONLY; Type of the account.
	DataAccountType *DataAccountType

	// READ-ONLY; Per share level unencrypted access credentials.
	ShareCredentialDetails []*ShareCredentialDetails
}

// AdditionalErrorInfo - This class represents additional info which Resource Providers pass when an error occurs.
type AdditionalErrorInfo struct {
	// Additional information of the type of error.
	Info any

	// Type of error (e.g. CustomerIntervention, PolicyViolation, SecurityViolation).
	Type *string
}

// AddressValidationOutput - Output of the address validation api.
type AddressValidationOutput struct {
	// READ-ONLY; The address validation properties.
	Properties *AddressValidationProperties
}

// AddressValidationProperties - The address validation output.
type AddressValidationProperties struct {
	// REQUIRED; Identifies the type of validation response.
	ValidationType *ValidationInputDiscriminator

	// READ-ONLY; List of alternate addresses.
	AlternateAddresses []*ShippingAddress

	// READ-ONLY; Error code and message of validation response.
	Error *CloudError

	// READ-ONLY; The address validation status.
	ValidationStatus *AddressValidationStatus
}

// GetValidationInputResponse implements the ValidationInputResponseClassification interface for type AddressValidationProperties.
func (a *AddressValidationProperties) GetValidationInputResponse() *ValidationInputResponse {
	return &ValidationInputResponse{
		Error:          a.Error,
		ValidationType: a.ValidationType,
	}
}

// ApplianceNetworkConfiguration - The Network Adapter configuration of a DataBox.
type ApplianceNetworkConfiguration struct {
	// READ-ONLY; Mac Address.
	MacAddress *string

	// READ-ONLY; Name of the network.
	Name *string
}

// ArmBaseObject - Base class for all objects under resource.
type ArmBaseObject struct {
	// READ-ONLY; Id of the object.
	ID *string

	// READ-ONLY; Name of the object.
	Name *string

	// READ-ONLY; Type of the object.
	Type *string
}

// AvailableSKURequest - The filters for showing the available skus.
type AvailableSKURequest struct {
	// REQUIRED; ISO country code. Country for hardware shipment. For codes check: https://en.wikipedia.org/wiki/ISO3166-1alpha-2#Officiallyassignedcode_elements
	Country *string

	// REQUIRED; Location for data transfer. For locations check: https://management.azure.com/subscriptions/SUBSCRIPTIONID/locations?api-version=2018-01-01
	Location *string

	// REQUIRED; Type of the transfer.
	TransferType *TransferType

	// Sku Names to filter for available skus
	SKUNames []*SKUName
}

// AvailableSKUsResult - The available skus operation response.
type AvailableSKUsResult struct {
	// Link for the next set of skus.
	NextLink *string

	// READ-ONLY; List of available skus.
	Value []*SKUInformation
}

// AzureFileFilterDetails - Filter details to transfer Azure files
type AzureFileFilterDetails struct {
	// List of full path of the files to be transferred.
	FilePathList []*string

	// Prefix list of the Azure files to be transferred.
	FilePrefixList []*string

	// List of file shares to be transferred.
	FileShareList []*string
}

// BlobFilterDetails - Filter details to transfer Azure Blobs
type BlobFilterDetails struct {
	// List of full path of the blobs to be transferred.
	BlobPathList []*string

	// Prefix list of the Azure blobs to be transferred.
	BlobPrefixList []*string

	// List of blob containers to be transferred.
	ContainerList []*string
}

// CancellationReason - Reason for cancellation.
type CancellationReason struct {
	// REQUIRED; Reason for cancellation.
	Reason *string
}

// CloudError - Provides additional information about an http error response.
type CloudError struct {
	// Error code.
	Code *string

	// The error message parsed from the body of the http error response.
	Message *string

	// Gets or sets the target of the error.
	Target *string

	// READ-ONLY; Gets or sets additional error info.
	AdditionalInfo []*AdditionalErrorInfo

	// READ-ONLY; Gets or sets details for the error.
	Details []*CloudError
}

// CommonJobDetails - Job details.
type CommonJobDetails struct {
	// REQUIRED; Contact details for notification and shipping.
	ContactDetails *ContactDetails

	// REQUIRED; Indicates the type of job details.
	JobDetailsType *ClassDiscriminator

	// Details of the data to be exported from azure.
	DataExportDetails []*DataExportDetails

	// Details of the data to be imported into azure.
	DataImportDetails []*DataImportDetails

	// The expected size of the data, which needs to be transferred in this job, in terabytes.
	ExpectedDataSizeInTeraBytes *int32

	// Details about which key encryption type is being used.
	KeyEncryptionKey *KeyEncryptionKey

	// Preferences for the order.
	Preferences *Preferences

	// Optional Reverse Shipping details for order.
	ReverseShippingDetails *ReverseShippingDetails

	// Shipping address of the customer.
	ShippingAddress *ShippingAddress

	// READ-ONLY; Available actions on the job.
	Actions []*CustomerResolutionCode

	// READ-ONLY; Shared access key to download the chain of custody logs
	ChainOfCustodySasKey *string

	// READ-ONLY; List of copy log details.
	CopyLogDetails []CopyLogDetailsClassification

	// READ-ONLY; DataCenter code.
	DataCenterCode *DataCenterCode

	// READ-ONLY; Datacenter address to ship to, for the given sku and storage location.
	DatacenterAddress DatacenterAddressResponseClassification

	// READ-ONLY; Delivery package shipping details.
	DeliveryPackage *PackageShippingDetails

	// READ-ONLY; Holds device data erasure details
	DeviceErasureDetails *DeviceErasureDetails

	// READ-ONLY; List of stages that run in the job.
	JobStages []*JobStages

	// READ-ONLY; Last mitigation action performed on the job.
	LastMitigationActionOnJob *LastMitigationActionOnJob

	// READ-ONLY; Return package shipping details.
	ReturnPackage *PackageShippingDetails

	// READ-ONLY; Shared access key to download the return shipment label
	ReverseShipmentLabelSasKey *string
}

// GetCommonJobDetails implements the CommonJobDetailsClassification interface for type CommonJobDetails.
func (c *CommonJobDetails) GetCommonJobDetails() *CommonJobDetails { return c }

// CommonJobSecrets - The base class for the secrets
type CommonJobSecrets struct {
	// REQUIRED; Used to indicate what type of job secrets object.
	JobSecretsType *ClassDiscriminator

	// READ-ONLY; Dc Access Security Code for Customer Managed Shipping
	DcAccessSecurityCode *DcAccessSecurityCode

	// READ-ONLY; Error while fetching the secrets.
	Error *CloudError
}

// GetCommonJobSecrets implements the CommonJobSecretsClassification interface for type CommonJobSecrets.
func (c *CommonJobSecrets) GetCommonJobSecrets() *CommonJobSecrets { return c }

// CommonScheduleAvailabilityRequest - Request body to get the availability for scheduling orders.
type CommonScheduleAvailabilityRequest struct {
	// REQUIRED; Sku Name for which the order is to be scheduled.
	SKUName *SKUName

	// REQUIRED; Location for data transfer. For locations check: https://management.azure.com/subscriptions/SUBSCRIPTIONID/locations?api-version=2018-01-01
	StorageLocation *string

	// Country in which storage location should be supported.
	Country *string
}

// GetCommonScheduleAvailabilityRequest implements the CommonScheduleAvailabilityRequestClassification interface for type
// CommonScheduleAvailabilityRequest.
func (c *CommonScheduleAvailabilityRequest) GetCommonScheduleAvailabilityRequest() *CommonScheduleAvailabilityRequest {
	return c
}

// ContactDetails - Contact Details.
type ContactDetails struct {
	// REQUIRED; Contact name of the person.
	ContactName *string

	// REQUIRED; List of Email-ids to be notified about job progress.
	EmailList []*string

	// REQUIRED; Phone number of the contact person.
	Phone *string

	// Mobile number of the contact person.
	Mobile *string

	// Notification preference for a job stage.
	NotificationPreference []*NotificationPreference

	// Phone extension number of the contact person.
	PhoneExtension *string
}

// ContactInfo - Contact Info.
type ContactInfo struct {
	// REQUIRED; Contact name of the person.
	ContactName *string

	// REQUIRED; Phone number of the contact person.
	Phone *string

	// Mobile number of the contact person.
	Mobile *string

	// Phone extension number of the contact person.
	PhoneExtension *string
}

// CopyLogDetails - Details for log generated during copy.
type CopyLogDetails struct {
	// REQUIRED; Indicates the type of job details.
	CopyLogDetailsType *ClassDiscriminator
}

// GetCopyLogDetails implements the CopyLogDetailsClassification interface for type CopyLogDetails.
func (c *CopyLogDetails) GetCopyLogDetails() *CopyLogDetails { return c }

// CopyProgress - Copy progress.
type CopyProgress struct {
	// READ-ONLY; Id of the account where the data needs to be uploaded.
	AccountID *string

	// READ-ONLY; Available actions on the job.
	Actions []*CustomerResolutionCode

	// READ-ONLY; To indicate bytes transferred.
	BytesProcessed *int64

	// READ-ONLY; Data Account Type.
	DataAccountType *DataAccountType

	// READ-ONLY; To indicate directories errored out in the job.
	DirectoriesErroredOut *int64

	// READ-ONLY; Error, if any, in the stage
	Error *CloudError

	// READ-ONLY; Number of files which could not be copied
	FilesErroredOut *int64

	// READ-ONLY; Number of files processed
	FilesProcessed *int64

	// READ-ONLY; To indicate directories renamed
	InvalidDirectoriesProcessed *int64

	// READ-ONLY; Total amount of data not adhering to azure naming conventions which were processed by automatic renaming
	InvalidFileBytesUploaded *int64

	// READ-ONLY; Number of files not adhering to azure naming conventions which were processed by automatic renaming
	InvalidFilesProcessed *int64

	// READ-ONLY; To indicate if enumeration of data is in progress. Until this is true, the TotalBytesToProcess may not be valid.
	IsEnumerationInProgress *bool

	// READ-ONLY; Number of folders not adhering to azure naming conventions which were processed by automatic renaming
	RenamedContainerCount *int64

	// READ-ONLY; Name of the storage account. This will be empty for data account types other than storage account.
	StorageAccountName *string

	// READ-ONLY; Total amount of data to be processed by the job.
	TotalBytesToProcess *int64

	// READ-ONLY; Total files to process
	TotalFilesToProcess *int64

	// READ-ONLY; Transfer type of data
	TransferType *TransferType
}

// CreateJobValidations - It does all pre-job creation validations.
type CreateJobValidations struct {
	// REQUIRED; List of request details contain validationType and its request as key and value respectively.
	IndividualRequestDetails []ValidationInputRequestClassification

	// CONSTANT; Identify the nature of validation.
	// Field has constant value "JobCreationValidation", any specified value is ignored.
	ValidationCategory *string
}

// GetValidationRequest implements the ValidationRequestClassification interface for type CreateJobValidations.
func (c *CreateJobValidations) GetValidationRequest() *ValidationRequest {
	return &ValidationRequest{
		IndividualRequestDetails: c.IndividualRequestDetails,
		ValidationCategory:       c.ValidationCategory,
	}
}

// CreateOrderLimitForSubscriptionValidationRequest - Request to validate create order limit for current subscription.
type CreateOrderLimitForSubscriptionValidationRequest struct {
	// REQUIRED; Device type to be used for the job.
	DeviceType *SKUName

	// REQUIRED; Identifies the type of validation request.
	ValidationType *ValidationInputDiscriminator
}

// GetValidationInputRequest implements the ValidationInputRequestClassification interface for type CreateOrderLimitForSubscriptionValidationRequest.
func (c *CreateOrderLimitForSubscriptionValidationRequest) GetValidationInputRequest() *ValidationInputRequest {
	return &ValidationInputRequest{
		ValidationType: c.ValidationType,
	}
}

// CreateOrderLimitForSubscriptionValidationResponseProperties - Properties of create order limit for subscription validation
// response.
type CreateOrderLimitForSubscriptionValidationResponseProperties struct {
	// REQUIRED; Identifies the type of validation response.
	ValidationType *ValidationInputDiscriminator

	// READ-ONLY; Error code and message of validation response.
	Error *CloudError

	// READ-ONLY; Create order limit validation status.
	Status *ValidationStatus
}

// GetValidationInputResponse implements the ValidationInputResponseClassification interface for type CreateOrderLimitForSubscriptionValidationResponseProperties.
func (c *CreateOrderLimitForSubscriptionValidationResponseProperties) GetValidationInputResponse() *ValidationInputResponse {
	return &ValidationInputResponse{
		Error:          c.Error,
		ValidationType: c.ValidationType,
	}
}

// CustomerDiskCopyLogDetails - Copy Log Details for customer disk
type CustomerDiskCopyLogDetails struct {
	// REQUIRED; Indicates the type of job details.
	CopyLogDetailsType *ClassDiscriminator

	// READ-ONLY; Link for copy error logs.
	ErrorLogLink *string

	// READ-ONLY; Disk Serial Number.
	SerialNumber *string

	// READ-ONLY; Link for copy verbose logs.
	VerboseLogLink *string
}

// GetCopyLogDetails implements the CopyLogDetailsClassification interface for type CustomerDiskCopyLogDetails.
func (c *CustomerDiskCopyLogDetails) GetCopyLogDetails() *CopyLogDetails {
	return &CopyLogDetails{
		CopyLogDetailsType: c.CopyLogDetailsType,
	}
}

// CustomerDiskCopyProgress - DataBox CustomerDisk Copy Progress
type CustomerDiskCopyProgress struct {
	// READ-ONLY; Id of the account where the data needs to be uploaded.
	AccountID *string

	// READ-ONLY; Available actions on the job.
	Actions []*CustomerResolutionCode

	// READ-ONLY; To indicate bytes transferred.
	BytesProcessed *int64

	// READ-ONLY; The Status of the copy
	CopyStatus *CopyStatus

	// READ-ONLY; Data Account Type.
	DataAccountType *DataAccountType

	// READ-ONLY; To indicate directories errored out in the job.
	DirectoriesErroredOut *int64

	// READ-ONLY; Error, if any, in the stage
	Error *CloudError

	// READ-ONLY; Number of files which could not be copied
	FilesErroredOut *int64

	// READ-ONLY; Number of files processed
	FilesProcessed *int64

	// READ-ONLY; To indicate directories renamed
	InvalidDirectoriesProcessed *int64

	// READ-ONLY; Total amount of data not adhering to azure naming conventions which were processed by automatic renaming
	InvalidFileBytesUploaded *int64

	// READ-ONLY; Number of files not adhering to azure naming conventions which were processed by automatic renaming
	InvalidFilesProcessed *int64

	// READ-ONLY; To indicate if enumeration of data is in progress. Until this is true, the TotalBytesToProcess may not be valid.
	IsEnumerationInProgress *bool

	// READ-ONLY; Number of folders not adhering to azure naming conventions which were processed by automatic renaming
	RenamedContainerCount *int64

	// READ-ONLY; Disk Serial Number.
	SerialNumber *string

	// READ-ONLY; Name of the storage account. This will be empty for data account types other than storage account.
	StorageAccountName *string

	// READ-ONLY; Total amount of data to be processed by the job.
	TotalBytesToProcess *int64

	// READ-ONLY; Total files to process
	TotalFilesToProcess *int64

	// READ-ONLY; Transfer type of data
	TransferType *TransferType
}

// CustomerDiskJobDetails - Customer disk job details.
type CustomerDiskJobDetails struct {
	// REQUIRED; Contact details for notification and shipping.
	ContactDetails *ContactDetails

	// REQUIRED; Indicates the type of job details.
	JobDetailsType *ClassDiscriminator

	// REQUIRED; Return package shipping details.
	ReturnToCustomerPackageDetails *PackageCarrierDetails

	// Details of the data to be exported from azure.
	DataExportDetails []*DataExportDetails

	// Details of the data to be imported into azure.
	DataImportDetails []*DataImportDetails

	// Flag to indicate if disk manifest should be backed-up in the Storage Account.
	EnableManifestBackup *bool

	// The expected size of the data, which needs to be transferred in this job, in terabytes.
	ExpectedDataSizeInTeraBytes *int32

	// Contains the map of disk serial number to the disk details for import jobs.
	ImportDiskDetailsCollection map[string]*ImportDiskDetails

	// Details about which key encryption type is being used.
	KeyEncryptionKey *KeyEncryptionKey

	// Preferences for the order.
	Preferences *Preferences

	// Optional Reverse Shipping details for order.
	ReverseShippingDetails *ReverseShippingDetails

	// Shipping address of the customer.
	ShippingAddress *ShippingAddress

	// READ-ONLY; Available actions on the job.
	Actions []*CustomerResolutionCode

	// READ-ONLY; Shared access key to download the chain of custody logs
	ChainOfCustodySasKey *string

	// READ-ONLY; List of copy log details.
	CopyLogDetails []CopyLogDetailsClassification

	// READ-ONLY; Copy progress per disk.
	CopyProgress []*CustomerDiskCopyProgress

	// READ-ONLY; DataCenter code.
	DataCenterCode *DataCenterCode

	// READ-ONLY; Datacenter address to ship to, for the given sku and storage location.
	DatacenterAddress DatacenterAddressResponseClassification

	// READ-ONLY; Delivery package shipping details.
	DeliverToDcPackageDetails *PackageCarrierInfo

	// READ-ONLY; Delivery package shipping details.
	DeliveryPackage *PackageShippingDetails

	// READ-ONLY; Holds device data erasure details
	DeviceErasureDetails *DeviceErasureDetails

	// READ-ONLY; Contains the map of disk serial number to the disk details for export jobs.
	ExportDiskDetailsCollection map[string]*ExportDiskDetails

	// READ-ONLY; List of stages that run in the job.
	JobStages []*JobStages

	// READ-ONLY; Last mitigation action performed on the job.
	LastMitigationActionOnJob *LastMitigationActionOnJob

	// READ-ONLY; Return package shipping details.
	ReturnPackage *PackageShippingDetails

	// READ-ONLY; Shared access key to download the return shipment label
	ReverseShipmentLabelSasKey *string
}

// GetCommonJobDetails implements the CommonJobDetailsClassification interface for type CustomerDiskJobDetails.
func (c *CustomerDiskJobDetails) GetCommonJobDetails() *CommonJobDetails {
	return &CommonJobDetails{
		Actions:                     c.Actions,
		ChainOfCustodySasKey:        c.ChainOfCustodySasKey,
		ContactDetails:              c.ContactDetails,
		CopyLogDetails:              c.CopyLogDetails,
		DataCenterCode:              c.DataCenterCode,
		DataExportDetails:           c.DataExportDetails,
		DataImportDetails:           c.DataImportDetails,
		DatacenterAddress:           c.DatacenterAddress,
		DeliveryPackage:             c.DeliveryPackage,
		DeviceErasureDetails:        c.DeviceErasureDetails,
		ExpectedDataSizeInTeraBytes: c.ExpectedDataSizeInTeraBytes,
		JobDetailsType:              c.JobDetailsType,
		JobStages:                   c.JobStages,
		KeyEncryptionKey:            c.KeyEncryptionKey,
		LastMitigationActionOnJob:   c.LastMitigationActionOnJob,
		Preferences:                 c.Preferences,
		ReturnPackage:               c.ReturnPackage,
		ReverseShipmentLabelSasKey:  c.ReverseShipmentLabelSasKey,
		ReverseShippingDetails:      c.ReverseShippingDetails,
		ShippingAddress:             c.ShippingAddress,
	}
}

// CustomerDiskJobSecrets - The secrets related to customer disk job.
type CustomerDiskJobSecrets struct {
	// REQUIRED; Used to indicate what type of job secrets object.
	JobSecretsType *ClassDiscriminator

	// READ-ONLY; Carrier Account Number of the customer
	CarrierAccountNumber *string

	// READ-ONLY; Dc Access Security Code for Customer Managed Shipping
	DcAccessSecurityCode *DcAccessSecurityCode

	// READ-ONLY; Contains the list of secrets object for that device.
	DiskSecrets []*DiskSecret

	// READ-ONLY; Error while fetching the secrets.
	Error *CloudError
}

// GetCommonJobSecrets implements the CommonJobSecretsClassification interface for type CustomerDiskJobSecrets.
func (c *CustomerDiskJobSecrets) GetCommonJobSecrets() *CommonJobSecrets {
	return &CommonJobSecrets{
		DcAccessSecurityCode: c.DcAccessSecurityCode,
		Error:                c.Error,
		JobSecretsType:       c.JobSecretsType,
	}
}

// DataAccountDetails - Account details of the data to be transferred
type DataAccountDetails struct {
	// REQUIRED; Account Type of the data to be transferred.
	DataAccountType *DataAccountType

	// Password for all the shares to be created on the device. Should not be passed for TransferType:ExportFromAzure jobs. If
	// this is not passed, the service will generate password itself. This will not be
	// returned in Get Call. Password Requirements : Password must be minimum of 12 and maximum of 64 characters. Password must
	// have at least one uppercase alphabet, one number and one special character.
	// Password cannot have the following characters : IilLoO0 Password can have only alphabets, numbers and these characters
	// : @#-$%^!+=;:_()]+
	SharePassword *string
}

// GetDataAccountDetails implements the DataAccountDetailsClassification interface for type DataAccountDetails.
func (d *DataAccountDetails) GetDataAccountDetails() *DataAccountDetails { return d }

// DataExportDetails - Details of the data to be used for exporting data from azure.
type DataExportDetails struct {
	// REQUIRED; Account details of the data to be transferred
	AccountDetails DataAccountDetailsClassification

	// REQUIRED; Configuration for the data transfer.
	TransferConfiguration *TransferConfiguration

	// Level of the logs to be collected.
	LogCollectionLevel *LogCollectionLevel
}

// DataImportDetails - Details of the data to be used for importing data to azure.
type DataImportDetails struct {
	// REQUIRED; Account details of the data to be transferred
	AccountDetails DataAccountDetailsClassification

	// Level of the logs to be collected.
	LogCollectionLevel *LogCollectionLevel
}

// DataLocationToServiceLocationMap - Map of data location to service location
type DataLocationToServiceLocationMap struct {
	// READ-ONLY; Location of the data.
	DataLocation *string

	// READ-ONLY; Location of the service.
	ServiceLocation *string
}

// DataTransferDetailsValidationRequest - Request to validate export and import data details.
type DataTransferDetailsValidationRequest struct {
	// REQUIRED; Device type.
	DeviceType *SKUName

	// REQUIRED; Type of the transfer.
	TransferType *TransferType

	// REQUIRED; Identifies the type of validation request.
	ValidationType *ValidationInputDiscriminator

	// List of DataTransfer details to be used to export data from azure.
	DataExportDetails []*DataExportDetails

	// List of DataTransfer details to be used to import data to azure.
	DataImportDetails []*DataImportDetails
}

// GetValidationInputRequest implements the ValidationInputRequestClassification interface for type DataTransferDetailsValidationRequest.
func (d *DataTransferDetailsValidationRequest) GetValidationInputRequest() *ValidationInputRequest {
	return &ValidationInputRequest{
		ValidationType: d.ValidationType,
	}
}

// DataTransferDetailsValidationResponseProperties - Properties of data transfer details validation response.
type DataTransferDetailsValidationResponseProperties struct {
	// REQUIRED; Identifies the type of validation response.
	ValidationType *ValidationInputDiscriminator

	// READ-ONLY; Error code and message of validation response.
	Error *CloudError

	// READ-ONLY; Data transfer details validation status.
	Status *ValidationStatus
}

// GetValidationInputResponse implements the ValidationInputResponseClassification interface for type DataTransferDetailsValidationResponseProperties.
func (d *DataTransferDetailsValidationResponseProperties) GetValidationInputResponse() *ValidationInputResponse {
	return &ValidationInputResponse{
		Error:          d.Error,
		ValidationType: d.ValidationType,
	}
}

// DatacenterAddressInstructionResponse - Datacenter instruction for given storage location.
type DatacenterAddressInstructionResponse struct {
	// REQUIRED; Data center address type
	DatacenterAddressType *DatacenterAddressType

	// READ-ONLY; Data center communication instruction
	CommunicationInstruction *string

	// READ-ONLY; Azure Location where the Data Center serves primarily.
	DataCenterAzureLocation *string

	// READ-ONLY; List of supported carriers for return shipment.
	SupportedCarriersForReturnShipment []*string
}

// GetDatacenterAddressResponse implements the DatacenterAddressResponseClassification interface for type DatacenterAddressInstructionResponse.
func (d *DatacenterAddressInstructionResponse) GetDatacenterAddressResponse() *DatacenterAddressResponse {
	return &DatacenterAddressResponse{
		DataCenterAzureLocation:            d.DataCenterAzureLocation,
		DatacenterAddressType:              d.DatacenterAddressType,
		SupportedCarriersForReturnShipment: d.SupportedCarriersForReturnShipment,
	}
}

// DatacenterAddressLocationResponse - Datacenter address for given storage location.
type DatacenterAddressLocationResponse struct {
	// REQUIRED; Data center address type
	DatacenterAddressType *DatacenterAddressType

	// READ-ONLY; Special instruction for shipping
	AdditionalShippingInformation *string

	// READ-ONLY; Address type
	AddressType *string

	// READ-ONLY; City name
	City *string

	// READ-ONLY; Company name
	Company *string

	// READ-ONLY; Contact person name
	ContactPersonName *string

	// READ-ONLY; name of the country
	Country *string

	// READ-ONLY; Azure Location where the Data Center serves primarily.
	DataCenterAzureLocation *string

	// READ-ONLY; Phone number
	Phone *string

	// READ-ONLY; Phone extension
	PhoneExtension *string

	// READ-ONLY; name of the state
	State *string

	// READ-ONLY; Street address line 1
	Street1 *string

	// READ-ONLY; Street address line 2
	Street2 *string

	// READ-ONLY; Street address line 3
	Street3 *string

	// READ-ONLY; List of supported carriers for return shipment.
	SupportedCarriersForReturnShipment []*string

	// READ-ONLY; Zip code
	Zip *string
}

// GetDatacenterAddressResponse implements the DatacenterAddressResponseClassification interface for type DatacenterAddressLocationResponse.
func (d *DatacenterAddressLocationResponse) GetDatacenterAddressResponse() *DatacenterAddressResponse {
	return &DatacenterAddressResponse{
		DataCenterAzureLocation:            d.DataCenterAzureLocation,
		DatacenterAddressType:              d.DatacenterAddressType,
		SupportedCarriersForReturnShipment: d.SupportedCarriersForReturnShipment,
	}
}

// DatacenterAddressRequest - Request body to get the datacenter address.
type DatacenterAddressRequest struct {
	// REQUIRED; Sku Name for which the data center address requested.
	SKUName *SKUName

	// REQUIRED; Storage location. For locations check: https://management.azure.com/subscriptions/SUBSCRIPTIONID/locations?api-version=2018-01-01
	StorageLocation *string
}

// DatacenterAddressResponse - Datacenter address for given storage location.
type DatacenterAddressResponse struct {
	// REQUIRED; Data center address type
	DatacenterAddressType *DatacenterAddressType

	// READ-ONLY; Azure Location where the Data Center serves primarily.
	DataCenterAzureLocation *string

	// READ-ONLY; List of supported carriers for return shipment.
	SupportedCarriersForReturnShipment []*string
}

// GetDatacenterAddressResponse implements the DatacenterAddressResponseClassification interface for type DatacenterAddressResponse.
func (d *DatacenterAddressResponse) GetDatacenterAddressResponse() *DatacenterAddressResponse {
	return d
}

// DcAccessSecurityCode - Dc access security code
type DcAccessSecurityCode struct {
	// Forward Dc access security code.
	ForwardDCAccessCode *string

	// Reverse Dc access security code.
	ReverseDCAccessCode *string
}

type Details struct {
	// REQUIRED
	Code *string

	// REQUIRED
	Message *string
}

// DeviceErasureDetails - Device erasure details with erasure completion status and erasureordestructionlog sas key
type DeviceErasureDetails struct {
	// READ-ONLY; Holds the device erasure completion status
	DeviceErasureStatus *StageStatus

	// READ-ONLY; Shared access key to download cleanup or destruction certificate for device
	ErasureOrDestructionCertificateSasKey *string
}

// DiskCopyLogDetails - Copy Log Details for a disk
type DiskCopyLogDetails struct {
	// REQUIRED; Indicates the type of job details.
	CopyLogDetailsType *ClassDiscriminator

	// READ-ONLY; Disk Serial Number.
	DiskSerialNumber *string

	// READ-ONLY; Link for copy error logs.
	ErrorLogLink *string

	// READ-ONLY; Link for copy verbose logs.
	VerboseLogLink *string
}

// GetCopyLogDetails implements the CopyLogDetailsClassification interface for type DiskCopyLogDetails.
func (d *DiskCopyLogDetails) GetCopyLogDetails() *CopyLogDetails {
	return &CopyLogDetails{
		CopyLogDetailsType: d.CopyLogDetailsType,
	}
}

// DiskCopyProgress - DataBox Disk Copy Progress
type DiskCopyProgress struct {
	// READ-ONLY; Available actions on the job.
	Actions []*CustomerResolutionCode

	// READ-ONLY; Bytes copied during the copy of disk.
	BytesCopied *int64

	// READ-ONLY; Error, if any, in the stage
	Error *CloudError

	// READ-ONLY; Indicates the percentage completed for the copy of the disk.
	PercentComplete *int32

	// READ-ONLY; The serial number of the disk
	SerialNumber *string

	// READ-ONLY; The Status of the copy
	Status *CopyStatus
}

// DiskGranularCopyLogDetails - Granular Copy Log Details for customer disk
type DiskGranularCopyLogDetails struct {
	// REQUIRED; Indicates the type of job details.
	CopyLogDetailsType *ClassDiscriminator

	// READ-ONLY; Account id.
	AccountID *string

	// READ-ONLY; Link for copy error logs.
	ErrorLogLink *string

	// READ-ONLY; Disk Serial Number.
	SerialNumber *string

	// READ-ONLY; Link for copy verbose logs.
	VerboseLogLink *string
}

// GetGranularCopyLogDetails implements the GranularCopyLogDetailsClassification interface for type DiskGranularCopyLogDetails.
func (d *DiskGranularCopyLogDetails) GetGranularCopyLogDetails() *GranularCopyLogDetails {
	return &GranularCopyLogDetails{
		CopyLogDetailsType: d.CopyLogDetailsType,
	}
}

// DiskGranularCopyProgress - DataBox Disk Granular Copy Progress
type DiskGranularCopyProgress struct {
	// READ-ONLY; Id of the account where the data needs to be uploaded.
	AccountID *string

	// READ-ONLY; Available actions on the job.
	Actions []*CustomerResolutionCode

	// READ-ONLY; To indicate bytes transferred.
	BytesProcessed *int64

	// READ-ONLY; The Status of the copy
	CopyStatus *CopyStatus

	// READ-ONLY; Data Account Type.
	DataAccountType *DataAccountType

	// READ-ONLY; To indicate directories errored out in the job.
	DirectoriesErroredOut *int64

	// READ-ONLY; Error, if any, in the stage
	Error *CloudError

	// READ-ONLY; Number of files which could not be copied
	FilesErroredOut *int64

	// READ-ONLY; Number of files processed
	FilesProcessed *int64

	// READ-ONLY; To indicate directories renamed
	InvalidDirectoriesProcessed *int64

	// READ-ONLY; Total amount of data not adhering to azure naming conventions which were processed by automatic renaming
	InvalidFileBytesUploaded *int64

	// READ-ONLY; Number of files not adhering to azure naming conventions which were processed by automatic renaming
	InvalidFilesProcessed *int64

	// READ-ONLY; To indicate if enumeration of data is in progress. Until this is true, the TotalBytesToProcess may not be valid.
	IsEnumerationInProgress *bool

	// READ-ONLY; Number of folders not adhering to azure naming conventions which were processed by automatic renaming
	RenamedContainerCount *int64

	// READ-ONLY; Disk Serial Number.
	SerialNumber *string

	// READ-ONLY; Name of the storage account. This will be empty for data account types other than storage account.
	StorageAccountName *string

	// READ-ONLY; Total amount of data to be processed by the job.
	TotalBytesToProcess *int64

	// READ-ONLY; Total files to process
	TotalFilesToProcess *int64

	// READ-ONLY; Transfer type of data
	TransferType *TransferType
}

// DiskJobDetails - DataBox Disk Job Details.
type DiskJobDetails struct {
	// REQUIRED; Contact details for notification and shipping.
	ContactDetails *ContactDetails

	// REQUIRED; Indicates the type of job details.
	JobDetailsType *ClassDiscriminator

	// Details of the data to be exported from azure.
	DataExportDetails []*DataExportDetails

	// Details of the data to be imported into azure.
	DataImportDetails []*DataImportDetails

	// The expected size of the data, which needs to be transferred in this job, in terabytes.
	ExpectedDataSizeInTeraBytes *int32

	// Details about which key encryption type is being used.
	KeyEncryptionKey *KeyEncryptionKey

	// User entered passkey for DataBox Disk job.
	Passkey *string

	// Preferences for the order.
	Preferences *Preferences

	// User preference on what size disks are needed for the job. The map is from the disk size in TB to the count. Eg. {2,5}
	// means 5 disks of 2 TB size. Key is string but will be checked against an int.
	PreferredDisks map[string]*int32

	// Optional Reverse Shipping details for order.
	ReverseShippingDetails *ReverseShippingDetails

	// Shipping address of the customer.
	ShippingAddress *ShippingAddress

	// READ-ONLY; Available actions on the job.
	Actions []*CustomerResolutionCode

	// READ-ONLY; Shared access key to download the chain of custody logs
	ChainOfCustodySasKey *string

	// READ-ONLY; List of copy log details.
	CopyLogDetails []CopyLogDetailsClassification

	// READ-ONLY; Copy progress per disk.
	CopyProgress []*DiskCopyProgress

	// READ-ONLY; DataCenter code.
	DataCenterCode *DataCenterCode

	// READ-ONLY; Datacenter address to ship to, for the given sku and storage location.
	DatacenterAddress DatacenterAddressResponseClassification

	// READ-ONLY; Delivery package shipping details.
	DeliveryPackage *PackageShippingDetails

	// READ-ONLY; Holds device data erasure details
	DeviceErasureDetails *DeviceErasureDetails

	// READ-ONLY; Contains the map of disk serial number to the disk size being used for the job. Is returned only after the disks
	// are shipped to the customer.
	DisksAndSizeDetails map[string]*int32

	// READ-ONLY; Copy progress per disk.
	GranularCopyLogDetails []*DiskGranularCopyLogDetails

	// READ-ONLY; Copy progress per disk.
	GranularCopyProgress []*DiskGranularCopyProgress

	// READ-ONLY; List of stages that run in the job.
	JobStages []*JobStages

	// READ-ONLY; Last mitigation action performed on the job.
	LastMitigationActionOnJob *LastMitigationActionOnJob

	// READ-ONLY; Return package shipping details.
	ReturnPackage *PackageShippingDetails

	// READ-ONLY; Shared access key to download the return shipment label
	ReverseShipmentLabelSasKey *string
}

// GetCommonJobDetails implements the CommonJobDetailsClassification interface for type DiskJobDetails.
func (d *DiskJobDetails) GetCommonJobDetails() *CommonJobDetails {
	return &CommonJobDetails{
		Actions:                     d.Actions,
		ChainOfCustodySasKey:        d.ChainOfCustodySasKey,
		ContactDetails:              d.ContactDetails,
		CopyLogDetails:              d.CopyLogDetails,
		DataCenterCode:              d.DataCenterCode,
		DataExportDetails:           d.DataExportDetails,
		DataImportDetails:           d.DataImportDetails,
		DatacenterAddress:           d.DatacenterAddress,
		DeliveryPackage:             d.DeliveryPackage,
		DeviceErasureDetails:        d.DeviceErasureDetails,
		ExpectedDataSizeInTeraBytes: d.ExpectedDataSizeInTeraBytes,
		JobDetailsType:              d.JobDetailsType,
		JobStages:                   d.JobStages,
		KeyEncryptionKey:            d.KeyEncryptionKey,
		LastMitigationActionOnJob:   d.LastMitigationActionOnJob,
		Preferences:                 d.Preferences,
		ReturnPackage:               d.ReturnPackage,
		ReverseShipmentLabelSasKey:  d.ReverseShipmentLabelSasKey,
		ReverseShippingDetails:      d.ReverseShippingDetails,
		ShippingAddress:             d.ShippingAddress,
	}
}

// DiskJobSecrets - The secrets related to disk job.
type DiskJobSecrets struct {
	// REQUIRED; Used to indicate what type of job secrets object.
	JobSecretsType *ClassDiscriminator

	// READ-ONLY; Dc Access Security Code for Customer Managed Shipping
	DcAccessSecurityCode *DcAccessSecurityCode

	// READ-ONLY; Contains the list of secrets object for that device.
	DiskSecrets []*DiskSecret

	// READ-ONLY; Error while fetching the secrets.
	Error *CloudError

	// READ-ONLY; Whether passkey was provided by user.
	IsPasskeyUserDefined *bool

	// READ-ONLY; PassKey for the disk Job.
	PassKey *string
}

// GetCommonJobSecrets implements the CommonJobSecretsClassification interface for type DiskJobSecrets.
func (d *DiskJobSecrets) GetCommonJobSecrets() *CommonJobSecrets {
	return &CommonJobSecrets{
		DcAccessSecurityCode: d.DcAccessSecurityCode,
		Error:                d.Error,
		JobSecretsType:       d.JobSecretsType,
	}
}

// DiskScheduleAvailabilityRequest - Request body to get the availability for scheduling disk orders.
type DiskScheduleAvailabilityRequest struct {
	// REQUIRED; The expected size of the data, which needs to be transferred in this job, in terabytes.
	ExpectedDataSizeInTeraBytes *int32

	// REQUIRED; Sku Name for which the order is to be scheduled.
	SKUName *SKUName

	// REQUIRED; Location for data transfer. For locations check: https://management.azure.com/subscriptions/SUBSCRIPTIONID/locations?api-version=2018-01-01
	StorageLocation *string

	// Country in which storage location should be supported.
	Country *string
}

// GetCommonScheduleAvailabilityRequest implements the CommonScheduleAvailabilityRequestClassification interface for type
// DiskScheduleAvailabilityRequest.
func (d *DiskScheduleAvailabilityRequest) GetCommonScheduleAvailabilityRequest() *CommonScheduleAvailabilityRequest {
	return &CommonScheduleAvailabilityRequest{
		Country:         d.Country,
		SKUName:         d.SKUName,
		StorageLocation: d.StorageLocation,
	}
}

// DiskSecret - Contains all the secrets of a Disk.
type DiskSecret struct {
	// READ-ONLY; Bit Locker key of the disk which can be used to unlock the disk to copy data.
	BitLockerKey *string

	// READ-ONLY; Serial number of the assigned disk.
	DiskSerialNumber *string
}

// EncryptionPreferences - Preferences related to the Encryption.
type EncryptionPreferences struct {
	// Defines secondary layer of software-based encryption enablement.
	DoubleEncryption *DoubleEncryption

	// Defines Hardware level encryption (Only for disk)
	HardwareEncryption *HardwareEncryption
}

type ErrorDetail struct {
	// REQUIRED
	Code *string

	// REQUIRED
	Message *string
	Details []*Details
	Target  *string
}

// ExportDiskDetails - Export disk details
type ExportDiskDetails struct {
	// READ-ONLY; Path to backed up manifest, only returned if enableManifestBackup is true.
	BackupManifestCloudPath *string

	// READ-ONLY; The relative path of the manifest file on the disk.
	ManifestFile *string

	// READ-ONLY; The Base16-encoded MD5 hash of the manifest file on the disk.
	ManifestHash *string
}

// FilterFileDetails - Details of the filter files to be used for data transfer.
type FilterFileDetails struct {
	// REQUIRED; Path of the file that contains the details of all items to transfer.
	FilterFilePath *string

	// REQUIRED; Type of the filter file.
	FilterFileType *FilterFileType
}

// GranularCopyLogDetails - Granular Details for log generated during copy.
type GranularCopyLogDetails struct {
	// REQUIRED; Indicates the type of job details.
	CopyLogDetailsType *ClassDiscriminator
}

// GetGranularCopyLogDetails implements the GranularCopyLogDetailsClassification interface for type GranularCopyLogDetails.
func (g *GranularCopyLogDetails) GetGranularCopyLogDetails() *GranularCopyLogDetails { return g }

// GranularCopyProgress - Granular Copy progress.
type GranularCopyProgress struct {
	// READ-ONLY; Id of the account where the data needs to be uploaded.
	AccountID *string

	// READ-ONLY; Available actions on the job.
	Actions []*CustomerResolutionCode

	// READ-ONLY; To indicate bytes transferred.
	BytesProcessed *int64

	// READ-ONLY; Data Account Type.
	DataAccountType *DataAccountType

	// READ-ONLY; To indicate directories errored out in the job.
	DirectoriesErroredOut *int64

	// READ-ONLY; Error, if any, in the stage
	Error *CloudError

	// READ-ONLY; Number of files which could not be copied
	FilesErroredOut *int64

	// READ-ONLY; Number of files processed
	FilesProcessed *int64

	// READ-ONLY; To indicate directories renamed
	InvalidDirectoriesProcessed *int64

	// READ-ONLY; Total amount of data not adhering to azure naming conventions which were processed by automatic renaming
	InvalidFileBytesUploaded *int64

	// READ-ONLY; Number of files not adhering to azure naming conventions which were processed by automatic renaming
	InvalidFilesProcessed *int64

	// READ-ONLY; To indicate if enumeration of data is in progress. Until this is true, the TotalBytesToProcess may not be valid.
	IsEnumerationInProgress *bool

	// READ-ONLY; Number of folders not adhering to azure naming conventions which were processed by automatic renaming
	RenamedContainerCount *int64

	// READ-ONLY; Name of the storage account. This will be empty for data account types other than storage account.
	StorageAccountName *string

	// READ-ONLY; Total amount of data to be processed by the job.
	TotalBytesToProcess *int64

	// READ-ONLY; Total files to process
	TotalFilesToProcess *int64

	// READ-ONLY; Transfer type of data
	TransferType *TransferType
}

// HeavyAccountCopyLogDetails - Copy log details for a storage account for Databox heavy
type HeavyAccountCopyLogDetails struct {
	// REQUIRED; Indicates the type of job details.
	CopyLogDetailsType *ClassDiscriminator

	// READ-ONLY; Account name.
	AccountName *string

	// READ-ONLY; Link for copy logs.
	CopyLogLink []*string

	// READ-ONLY; Link for copy verbose logs. This will be set only when the LogCollectionLevel is set to verbose.
	CopyVerboseLogLink []*string
}

// GetCopyLogDetails implements the CopyLogDetailsClassification interface for type HeavyAccountCopyLogDetails.
func (h *HeavyAccountCopyLogDetails) GetCopyLogDetails() *CopyLogDetails {
	return &CopyLogDetails{
		CopyLogDetailsType: h.CopyLogDetailsType,
	}
}

// HeavyJobDetails - Databox Heavy Device Job Details
type HeavyJobDetails struct {
	// REQUIRED; Contact details for notification and shipping.
	ContactDetails *ContactDetails

	// REQUIRED; Indicates the type of job details.
	JobDetailsType *ClassDiscriminator

	// Details of the data to be exported from azure.
	DataExportDetails []*DataExportDetails

	// Details of the data to be imported into azure.
	DataImportDetails []*DataImportDetails

	// Set Device password for unlocking Databox Heavy. Should not be passed for TransferType:ExportFromAzure jobs. If this is
	// not passed, the service will generate password itself. This will not be returned
	// in Get Call. Password Requirements : Password must be minimum of 12 and maximum of 64 characters. Password must have at
	// least one uppercase alphabet, one number and one special character. Password
	// cannot have the following characters : IilLoO0 Password can have only alphabets, numbers and these characters : @#-$%^!+=;:_()]+
	DevicePassword *string

	// The expected size of the data, which needs to be transferred in this job, in terabytes.
	ExpectedDataSizeInTeraBytes *int32

	// Details about which key encryption type is being used.
	KeyEncryptionKey *KeyEncryptionKey

	// Preferences for the order.
	Preferences *Preferences

	// Optional Reverse Shipping details for order.
	ReverseShippingDetails *ReverseShippingDetails

	// Shipping address of the customer.
	ShippingAddress *ShippingAddress

	// READ-ONLY; Available actions on the job.
	Actions []*CustomerResolutionCode

	// READ-ONLY; Shared access key to download the chain of custody logs
	ChainOfCustodySasKey *string

	// READ-ONLY; List of copy log details.
	CopyLogDetails []CopyLogDetailsClassification

	// READ-ONLY; Copy progress per account.
	CopyProgress []*CopyProgress

	// READ-ONLY; DataCenter code.
	DataCenterCode *DataCenterCode

	// READ-ONLY; Datacenter address to ship to, for the given sku and storage location.
	DatacenterAddress DatacenterAddressResponseClassification

	// READ-ONLY; Delivery package shipping details.
	DeliveryPackage *PackageShippingDetails

	// READ-ONLY; Holds device data erasure details
	DeviceErasureDetails *DeviceErasureDetails

	// READ-ONLY; List of stages that run in the job.
	JobStages []*JobStages

	// READ-ONLY; Last mitigation action performed on the job.
	LastMitigationActionOnJob *LastMitigationActionOnJob

	// READ-ONLY; Return package shipping details.
	ReturnPackage *PackageShippingDetails

	// READ-ONLY; Shared access key to download the return shipment label
	ReverseShipmentLabelSasKey *string
}

// GetCommonJobDetails implements the CommonJobDetailsClassification interface for type HeavyJobDetails.
func (h *HeavyJobDetails) GetCommonJobDetails() *CommonJobDetails {
	return &CommonJobDetails{
		Actions:                     h.Actions,
		ChainOfCustodySasKey:        h.ChainOfCustodySasKey,
		ContactDetails:              h.ContactDetails,
		CopyLogDetails:              h.CopyLogDetails,
		DataCenterCode:              h.DataCenterCode,
		DataExportDetails:           h.DataExportDetails,
		DataImportDetails:           h.DataImportDetails,
		DatacenterAddress:           h.DatacenterAddress,
		DeliveryPackage:             h.DeliveryPackage,
		DeviceErasureDetails:        h.DeviceErasureDetails,
		ExpectedDataSizeInTeraBytes: h.ExpectedDataSizeInTeraBytes,
		JobDetailsType:              h.JobDetailsType,
		JobStages:                   h.JobStages,
		KeyEncryptionKey:            h.KeyEncryptionKey,
		LastMitigationActionOnJob:   h.LastMitigationActionOnJob,
		Preferences:                 h.Preferences,
		ReturnPackage:               h.ReturnPackage,
		ReverseShipmentLabelSasKey:  h.ReverseShipmentLabelSasKey,
		ReverseShippingDetails:      h.ReverseShippingDetails,
		ShippingAddress:             h.ShippingAddress,
	}
}

// HeavyJobSecrets - The secrets related to a databox heavy job.
type HeavyJobSecrets struct {
	// REQUIRED; Used to indicate what type of job secrets object.
	JobSecretsType *ClassDiscriminator

	// READ-ONLY; Contains the list of secret objects for a databox heavy job.
	CabinetPodSecrets []*HeavySecret

	// READ-ONLY; Dc Access Security Code for Customer Managed Shipping
	DcAccessSecurityCode *DcAccessSecurityCode

	// READ-ONLY; Error while fetching the secrets.
	Error *CloudError
}

// GetCommonJobSecrets implements the CommonJobSecretsClassification interface for type HeavyJobSecrets.
func (h *HeavyJobSecrets) GetCommonJobSecrets() *CommonJobSecrets {
	return &CommonJobSecrets{
		DcAccessSecurityCode: h.DcAccessSecurityCode,
		Error:                h.Error,
		JobSecretsType:       h.JobSecretsType,
	}
}

// HeavyScheduleAvailabilityRequest - Request body to get the availability for scheduling heavy orders.
type HeavyScheduleAvailabilityRequest struct {
	// REQUIRED; Sku Name for which the order is to be scheduled.
	SKUName *SKUName

	// REQUIRED; Location for data transfer. For locations check: https://management.azure.com/subscriptions/SUBSCRIPTIONID/locations?api-version=2018-01-01
	StorageLocation *string

	// Country in which storage location should be supported.
	Country *string
}

// GetCommonScheduleAvailabilityRequest implements the CommonScheduleAvailabilityRequestClassification interface for type
// HeavyScheduleAvailabilityRequest.
func (h *HeavyScheduleAvailabilityRequest) GetCommonScheduleAvailabilityRequest() *CommonScheduleAvailabilityRequest {
	return &CommonScheduleAvailabilityRequest{
		Country:         h.Country,
		SKUName:         h.SKUName,
		StorageLocation: h.StorageLocation,
	}
}

// HeavySecret - The secrets related to a databox heavy.
type HeavySecret struct {
	// READ-ONLY; Per account level access credentials.
	AccountCredentialDetails []*AccountCredentialDetails

	// READ-ONLY; Password for out of the box experience on device.
	DevicePassword *string

	// READ-ONLY; Serial number of the assigned device.
	DeviceSerialNumber *string

	// READ-ONLY; The base 64 encoded public key to authenticate with the device
	EncodedValidationCertPubKey *string

	// READ-ONLY; Network configuration of the appliance.
	NetworkConfigurations []*ApplianceNetworkConfiguration
}

// IdentityProperties - Managed identity properties.
type IdentityProperties struct {
	// Managed service identity type.
	Type *string

	// User assigned identity properties.
	UserAssigned *UserAssignedProperties
}

// ImportDiskDetails - Import disk details
type ImportDiskDetails struct {
	// REQUIRED; BitLocker key used to encrypt the disk.
	BitLockerKey *string

	// REQUIRED; The relative path of the manifest file on the disk.
	ManifestFile *string

	// REQUIRED; The Base16-encoded MD5 hash of the manifest file on the disk.
	ManifestHash *string

	// READ-ONLY; Path to backed up manifest, only returned if enableManifestBackup is true.
	BackupManifestCloudPath *string
}

// JobDeliveryInfo - Additional delivery info.
type JobDeliveryInfo struct {
	// Scheduled date time.
	ScheduledDateTime *time.Time
}

// JobDetails - Databox Job Details
type JobDetails struct {
	// REQUIRED; Contact details for notification and shipping.
	ContactDetails *ContactDetails

	// REQUIRED; Indicates the type of job details.
	JobDetailsType *ClassDiscriminator

	// Details of the data to be exported from azure.
	DataExportDetails []*DataExportDetails

	// Details of the data to be imported into azure.
	DataImportDetails []*DataImportDetails

	// Set Device password for unlocking Databox. Should not be passed for TransferType:ExportFromAzure jobs. If this is not passed,
	// the service will generate password itself. This will not be returned in
	// Get Call. Password Requirements : Password must be minimum of 12 and maximum of 64 characters. Password must have at least
	// one uppercase alphabet, one number and one special character. Password cannot
	// have the following characters : IilLoO0 Password can have only alphabets, numbers and these characters : @#-$%^!+=;:_()]+
	DevicePassword *string

	// The expected size of the data, which needs to be transferred in this job, in terabytes.
	ExpectedDataSizeInTeraBytes *int32

	// Details about which key encryption type is being used.
	KeyEncryptionKey *KeyEncryptionKey

	// Preferences for the order.
	Preferences *Preferences

	// Optional Reverse Shipping details for order.
	ReverseShippingDetails *ReverseShippingDetails

	// Shipping address of the customer.
	ShippingAddress *ShippingAddress

	// READ-ONLY; Available actions on the job.
	Actions []*CustomerResolutionCode

	// READ-ONLY; Shared access key to download the chain of custody logs
	ChainOfCustodySasKey *string

	// READ-ONLY; List of copy log details.
	CopyLogDetails []CopyLogDetailsClassification

	// READ-ONLY; Copy progress per storage account.
	CopyProgress []*CopyProgress

	// READ-ONLY; DataCenter code.
	DataCenterCode *DataCenterCode

	// READ-ONLY; Datacenter address to ship to, for the given sku and storage location.
	DatacenterAddress DatacenterAddressResponseClassification

	// READ-ONLY; Delivery package shipping details.
	DeliveryPackage *PackageShippingDetails

	// READ-ONLY; Holds device data erasure details
	DeviceErasureDetails *DeviceErasureDetails

	// READ-ONLY; List of stages that run in the job.
	JobStages []*JobStages

	// READ-ONLY; Last mitigation action performed on the job.
	LastMitigationActionOnJob *LastMitigationActionOnJob

	// READ-ONLY; Return package shipping details.
	ReturnPackage *PackageShippingDetails

	// READ-ONLY; Shared access key to download the return shipment label
	ReverseShipmentLabelSasKey *string
}

// GetCommonJobDetails implements the CommonJobDetailsClassification interface for type JobDetails.
func (j *JobDetails) GetCommonJobDetails() *CommonJobDetails {
	return &CommonJobDetails{
		Actions:                     j.Actions,
		ChainOfCustodySasKey:        j.ChainOfCustodySasKey,
		ContactDetails:              j.ContactDetails,
		CopyLogDetails:              j.CopyLogDetails,
		DataCenterCode:              j.DataCenterCode,
		DataExportDetails:           j.DataExportDetails,
		DataImportDetails:           j.DataImportDetails,
		DatacenterAddress:           j.DatacenterAddress,
		DeliveryPackage:             j.DeliveryPackage,
		DeviceErasureDetails:        j.DeviceErasureDetails,
		ExpectedDataSizeInTeraBytes: j.ExpectedDataSizeInTeraBytes,
		JobDetailsType:              j.JobDetailsType,
		JobStages:                   j.JobStages,
		KeyEncryptionKey:            j.KeyEncryptionKey,
		LastMitigationActionOnJob:   j.LastMitigationActionOnJob,
		Preferences:                 j.Preferences,
		ReturnPackage:               j.ReturnPackage,
		ReverseShipmentLabelSasKey:  j.ReverseShipmentLabelSasKey,
		ReverseShippingDetails:      j.ReverseShippingDetails,
		ShippingAddress:             j.ShippingAddress,
	}
}

// JobProperties - Job Properties
type JobProperties struct {
	// REQUIRED; Type of the data transfer.
	TransferType *TransferType

	// Delivery Info of Job.
	DeliveryInfo *JobDeliveryInfo

	// Delivery type of Job.
	DeliveryType *JobDeliveryType

	// Details of a job run. This field will only be sent for expand details filter.
	Details CommonJobDetailsClassification

	// READ-ONLY; Reason for cancellation.
	CancellationReason *string

	// READ-ONLY; Top level error for the job.
	Error *CloudError

	// READ-ONLY; Describes whether the job is cancellable or not.
	IsCancellable *bool

	// READ-ONLY; Flag to indicate cancellation of scheduled job.
	IsCancellableWithoutFee *bool

	// READ-ONLY; Describes whether the job is deletable or not.
	IsDeletable *bool

	// READ-ONLY; Is Prepare To Ship Enabled on this job
	IsPrepareToShipEnabled *bool

	// READ-ONLY; Describes whether the shipping address is editable or not.
	IsShippingAddressEditable *bool

	// READ-ONLY; The Editable status for Reverse Shipping Address and Contact Info
	ReverseShippingDetailsUpdate *ReverseShippingDetailsEditStatus

	// READ-ONLY; The Editable status for Reverse Transport preferences
	ReverseTransportPreferenceUpdate *ReverseTransportPreferenceEditStatus

	// READ-ONLY; Time at which the job was started in UTC ISO 8601 format.
	StartTime *time.Time

	// READ-ONLY; Name of the stage which is in progress.
	Status *StageName
}

// JobResource - Job Resource.
type JobResource struct {
	// REQUIRED; The location of the resource. This will be one of the supported and registered Azure Regions (e.g. West US, East
	// US, Southeast Asia, etc.). The region of a resource cannot be changed once it is
	// created, but if an identical region is specified on update the request will succeed.
	Location *string

	// REQUIRED; Properties of a job.
	Properties *JobProperties

	// REQUIRED; The sku type.
	SKU *SKU

	// Msi identity of the resource
	Identity *ResourceIdentity

	// The list of key value pairs that describe the resource. These tags can be used in viewing and grouping this resource (across
	// resource groups).
	Tags map[string]*string

	// READ-ONLY; Id of the object.
	ID *string

	// READ-ONLY; Name of the object.
	Name *string

	// READ-ONLY; Metadata pertaining to creation and last modification of the resource.
	SystemData *SystemData

	// READ-ONLY; Type of the object.
	Type *string
}

// JobResourceList - Job Resource Collection
type JobResourceList struct {
	// Link for the next set of job resources.
	NextLink *string

	// List of job resources.
	Value []*JobResource
}

// JobResourceUpdateParameter - The JobResourceUpdateParameter.
type JobResourceUpdateParameter struct {
	// Msi identity of the resource
	Identity *ResourceIdentity

	// Properties of a job to be updated.
	Properties *UpdateJobProperties

	// The list of key value pairs that describe the resource. These tags can be used in viewing and grouping this resource (across
	// resource groups).
	Tags map[string]*string
}

// JobSecrets - The secrets related to a databox job.
type JobSecrets struct {
	// REQUIRED; Used to indicate what type of job secrets object.
	JobSecretsType *ClassDiscriminator

	// Contains the list of secret objects for a job.
	PodSecrets []*Secret

	// READ-ONLY; Dc Access Security Code for Customer Managed Shipping
	DcAccessSecurityCode *DcAccessSecurityCode

	// READ-ONLY; Error while fetching the secrets.
	Error *CloudError
}

// GetCommonJobSecrets implements the CommonJobSecretsClassification interface for type JobSecrets.
func (j *JobSecrets) GetCommonJobSecrets() *CommonJobSecrets {
	return &CommonJobSecrets{
		DcAccessSecurityCode: j.DcAccessSecurityCode,
		Error:                j.Error,
		JobSecretsType:       j.JobSecretsType,
	}
}

// JobStages - Job stages.
type JobStages struct {
	// READ-ONLY; Display name of the job stage.
	DisplayName *string

	// READ-ONLY; Job Stage Details
	JobStageDetails any

	// READ-ONLY; Name of the job stage.
	StageName *StageName

	// READ-ONLY; Status of the job stage.
	StageStatus *StageStatus

	// READ-ONLY; Time for the job stage in UTC ISO 8601 format.
	StageTime *time.Time
}

// KeyEncryptionKey - Encryption key containing details about key to encrypt different keys.
type KeyEncryptionKey struct {
	// REQUIRED; Type of encryption key used for key encryption.
	KekType *KekType

	// Managed identity properties used for key encryption.
	IdentityProperties *IdentityProperties

	// Key encryption key. It is required in case of Customer managed KekType.
	KekURL *string

	// Kek vault resource id. It is required in case of Customer managed KekType.
	KekVaultResourceID *string
}

// LastMitigationActionOnJob - Last Mitigation Action Performed On Job
type LastMitigationActionOnJob struct {
	// Action performed date time
	ActionDateTimeInUTC *time.Time

	// Resolution code provided by customer
	CustomerResolution *CustomerResolutionCode

	// Action performed by customer, possibility is that mitigation might happen by customer or service or by ops
	IsPerformedByCustomer *bool
}

// ManagedDiskDetails - Details of the managed disks.
type ManagedDiskDetails struct {
	// REQUIRED; Account Type of the data to be transferred.
	DataAccountType *DataAccountType

	// REQUIRED; Resource Group Id of the compute disks.
	ResourceGroupID *string

	// REQUIRED; Resource Id of the storage account that can be used to copy the vhd for staging.
	StagingStorageAccountID *string

	// Password for all the shares to be created on the device. Should not be passed for TransferType:ExportFromAzure jobs. If
	// this is not passed, the service will generate password itself. This will not be
	// returned in Get Call. Password Requirements : Password must be minimum of 12 and maximum of 64 characters. Password must
	// have at least one uppercase alphabet, one number and one special character.
	// Password cannot have the following characters : IilLoO0 Password can have only alphabets, numbers and these characters
	// : @#-$%^!+=;:_()]+
	SharePassword *string
}

// GetDataAccountDetails implements the DataAccountDetailsClassification interface for type ManagedDiskDetails.
func (m *ManagedDiskDetails) GetDataAccountDetails() *DataAccountDetails {
	return &DataAccountDetails{
		DataAccountType: m.DataAccountType,
		SharePassword:   m.SharePassword,
	}
}

// MarkDevicesShippedRequest - The request body to provide the delivery package details of job
type MarkDevicesShippedRequest struct {
	// REQUIRED; Delivery package details
	DeliverToDcPackageDetails *PackageCarrierInfo
}

// MitigateJobRequest - The Mitigate Job captured from request body for Mitigate API
type MitigateJobRequest struct {
	// Resolution code for the job
	CustomerResolutionCode *CustomerResolutionCode

	// Serial number and the customer resolution code corresponding to each serial number
	SerialNumberCustomerResolutionMap map[string]*CustomerResolutionCode
}

// NotificationPreference - Notification preference for a job stage.
type NotificationPreference struct {
	// REQUIRED; Notification is required or not.
	SendNotification *bool

	// REQUIRED; Name of the stage.
	StageName *NotificationStageName
}

// Operation entity.
type Operation struct {
	// Indicates whether the operation is a data action
	IsDataAction *bool

	// READ-ONLY; Operation display values.
	Display *OperationDisplay

	// READ-ONLY; Name of the operation. Format: {resourceProviderNamespace}/{resourceType}/{read|write|delete|action}
	Name *string

	// READ-ONLY; Origin of the operation. Can be : user|system|user,system
	Origin *string

	// READ-ONLY; Operation properties.
	Properties any
}

// OperationDisplay - Operation display
type OperationDisplay struct {
	// Localized description of the operation for display purpose.
	Description *string

	// Localized name of the operation for display purpose.
	Operation *string

	// Provider name.
	Provider *string

	// Resource name.
	Resource *string
}

// OperationList - Operation Collection.
type OperationList struct {
	// Link for the next set of operations.
	NextLink *string

	// READ-ONLY; List of operations.
	Value []*Operation
}

// PackageCarrierDetails - Package carrier details.
type PackageCarrierDetails struct {
	// Carrier Account Number of customer for customer disk.
	CarrierAccountNumber *string

	// Name of the carrier.
	CarrierName *string

	// Tracking Id of shipment.
	TrackingID *string
}

// PackageCarrierInfo - package carrier info
type PackageCarrierInfo struct {
	// Name of the carrier.
	CarrierName *string

	// Tracking Id of shipment.
	TrackingID *string
}

// PackageShippingDetails - package shipping details
type PackageShippingDetails struct {
	// READ-ONLY; Name of the carrier.
	CarrierName *string

	// READ-ONLY; Tracking Id of shipment.
	TrackingID *string

	// READ-ONLY; Url where shipment can be tracked.
	TrackingURL *string
}

// Preferences related to the order
type Preferences struct {
	// Preferences related to the Encryption.
	EncryptionPreferences *EncryptionPreferences

	// Preferred data center region.
	PreferredDataCenterRegion []*string

	// Optional Preferences related to the reverse shipment logistics of the sku.
	ReverseTransportPreferences *TransportPreferences

	// Preferences related to the Access Tier of storage accounts.
	StorageAccountAccessTierPreferences []*string

	// Preferences related to the shipment logistics of the sku.
	TransportPreferences *TransportPreferences
}

// PreferencesValidationRequest - Request to validate preference of transport and data center.
type PreferencesValidationRequest struct {
	// REQUIRED; Device type to be used for the job.
	DeviceType *SKUName

	// REQUIRED; Identifies the type of validation request.
	ValidationType *ValidationInputDiscriminator

	// Preference of transport and data center.
	Preference *Preferences
}

// GetValidationInputRequest implements the ValidationInputRequestClassification interface for type PreferencesValidationRequest.
func (p *PreferencesValidationRequest) GetValidationInputRequest() *ValidationInputRequest {
	return &ValidationInputRequest{
		ValidationType: p.ValidationType,
	}
}

// PreferencesValidationResponseProperties - Properties of data center and transport preference validation response.
type PreferencesValidationResponseProperties struct {
	// REQUIRED; Identifies the type of validation response.
	ValidationType *ValidationInputDiscriminator

	// READ-ONLY; Error code and message of validation response.
	Error *CloudError

	// READ-ONLY; Validation status of requested data center and transport.
	Status *ValidationStatus
}

// GetValidationInputResponse implements the ValidationInputResponseClassification interface for type PreferencesValidationResponseProperties.
func (p *PreferencesValidationResponseProperties) GetValidationInputResponse() *ValidationInputResponse {
	return &ValidationInputResponse{
		Error:          p.Error,
		ValidationType: p.ValidationType,
	}
}

// RegionConfigurationRequest - Request body to get the configuration for the region.
type RegionConfigurationRequest struct {
	// Request body to get the datacenter address for given sku.
	DatacenterAddressRequest *DatacenterAddressRequest

	// Request body to get the availability for scheduling orders.
	ScheduleAvailabilityRequest CommonScheduleAvailabilityRequestClassification

	// Request body to get the transport availability for given sku.
	TransportAvailabilityRequest *TransportAvailabilityRequest
}

// RegionConfigurationResponse - Configuration response specific to a region.
type RegionConfigurationResponse struct {
	// READ-ONLY; Datacenter address for given sku in a region.
	DatacenterAddressResponse DatacenterAddressResponseClassification

	// READ-ONLY; Schedule availability for given sku in a region.
	ScheduleAvailabilityResponse *ScheduleAvailabilityResponse

	// READ-ONLY; Transport options available for given sku in a region.
	TransportAvailabilityResponse *TransportAvailabilityResponse
}

// Resource - Model of the Resource.
type Resource struct {
	// REQUIRED; The location of the resource. This will be one of the supported and registered Azure Regions (e.g. West US, East
	// US, Southeast Asia, etc.). The region of a resource cannot be changed once it is
	// created, but if an identical region is specified on update the request will succeed.
	Location *string

	// REQUIRED; The sku type.
	SKU *SKU

	// Msi identity of the resource
	Identity *ResourceIdentity

	// The list of key value pairs that describe the resource. These tags can be used in viewing and grouping this resource (across
	// resource groups).
	Tags map[string]*string
}

// ResourceIdentity - Msi identity details of the resource
type ResourceIdentity struct {
	// Identity type
	Type *string

	// User Assigned Identities
	UserAssignedIdentities map[string]*UserAssignedIdentity

	// READ-ONLY; Service Principal Id backing the Msi
	PrincipalID *string

	// READ-ONLY; Home Tenant Id
	TenantID *string
}

// ReverseShippingDetails - Reverse Shipping Address and contact details for a job.
type ReverseShippingDetails struct {
	// Contact Info.
	ContactDetails *ContactInfo

	// Shipping address where customer wishes to receive the device.
	ShippingAddress *ShippingAddress

	// READ-ONLY; A flag to indicate whether Reverse Shipping details are updated or not after device has been prepared. Read
	// only field
	IsUpdated *bool
}

// SKU - The Sku.
type SKU struct {
	// REQUIRED; The sku name.
	Name *SKUName

	// The display name of the sku.
	DisplayName *string

	// The sku family.
	Family *string
}

// SKUAvailabilityValidationRequest - Request to validate sku availability.
type SKUAvailabilityValidationRequest struct {
	// REQUIRED; ISO country code. Country for hardware shipment. For codes check: https://en.wikipedia.org/wiki/ISO3166-1alpha-2#Officiallyassignedcode_elements
	Country *string

	// REQUIRED; Device type to be used for the job.
	DeviceType *SKUName

	// REQUIRED; Location for data transfer. For locations check: https://management.azure.com/subscriptions/SUBSCRIPTIONID/locations?api-version=2018-01-01
	Location *string

	// REQUIRED; Type of the transfer.
	TransferType *TransferType

	// REQUIRED; Identifies the type of validation request.
	ValidationType *ValidationInputDiscriminator
}

// GetValidationInputRequest implements the ValidationInputRequestClassification interface for type SKUAvailabilityValidationRequest.
func (s *SKUAvailabilityValidationRequest) GetValidationInputRequest() *ValidationInputRequest {
	return &ValidationInputRequest{
		ValidationType: s.ValidationType,
	}
}

// SKUAvailabilityValidationResponseProperties - Properties of sku availability validation response.
type SKUAvailabilityValidationResponseProperties struct {
	// REQUIRED; Identifies the type of validation response.
	ValidationType *ValidationInputDiscriminator

	// READ-ONLY; Error code and message of validation response.
	Error *CloudError

	// READ-ONLY; Sku availability validation status.
	Status *ValidationStatus
}

// GetValidationInputResponse implements the ValidationInputResponseClassification interface for type SKUAvailabilityValidationResponseProperties.
func (s *SKUAvailabilityValidationResponseProperties) GetValidationInputResponse() *ValidationInputResponse {
	return &ValidationInputResponse{
		Error:          s.Error,
		ValidationType: s.ValidationType,
	}
}

// SKUCapacity - Capacity of the sku.
type SKUCapacity struct {
	// READ-ONLY; Maximum capacity in TB.
	Maximum *string

	// READ-ONLY; Usable capacity in TB.
	Usable *string
}

// SKUCost - Describes metadata for retrieving price info.
type SKUCost struct {
	// READ-ONLY; Meter id of the Sku.
	MeterID *string

	// READ-ONLY; The type of the meter.
	MeterType *string

	// READ-ONLY; Multiplier specifies the region specific value to be multiplied with 1$ guid. Eg: Our new regions will be using
	// 1$ shipping guid with appropriate multiplier specific to region.
	Multiplier *float64
}

// SKUInformation - Information of the sku.
type SKUInformation struct {
	// READ-ONLY; The sku is enabled or not.
	Enabled *bool

	// READ-ONLY; Properties of the sku.
	Properties *SKUProperties

	// READ-ONLY; The Sku.
	SKU *SKU
}

// SKUProperties - Properties of the sku.
type SKUProperties struct {
	// READ-ONLY; Api versions that support this Sku.
	APIVersions []*string

	// READ-ONLY; Capacity of the Sku.
	Capacity *SKUCapacity

	// READ-ONLY; Cost of the Sku.
	Costs []*SKUCost

	// READ-ONLY; List of all the Countries in the SKU specific commerce boundary
	CountriesWithinCommerceBoundary []*string

	// READ-ONLY; The map of data location to service location.
	DataLocationToServiceLocationMap []*DataLocationToServiceLocationMap

	// READ-ONLY; Reason why the Sku is disabled.
	DisabledReason *SKUDisabledReason

	// READ-ONLY; Message for why the Sku is disabled.
	DisabledReasonMessage *string

	// READ-ONLY; Required feature to access the sku.
	RequiredFeature *string
}

// ScheduleAvailabilityRequest - Request body to get the availability for scheduling data box orders orders.
type ScheduleAvailabilityRequest struct {
	// REQUIRED; Sku Name for which the order is to be scheduled.
	SKUName *SKUName

	// REQUIRED; Location for data transfer. For locations check: https://management.azure.com/subscriptions/SUBSCRIPTIONID/locations?api-version=2018-01-01
	StorageLocation *string

	// Country in which storage location should be supported.
	Country *string
}

// GetCommonScheduleAvailabilityRequest implements the CommonScheduleAvailabilityRequestClassification interface for type
// ScheduleAvailabilityRequest.
func (s *ScheduleAvailabilityRequest) GetCommonScheduleAvailabilityRequest() *CommonScheduleAvailabilityRequest {
	return &CommonScheduleAvailabilityRequest{
		Country:         s.Country,
		SKUName:         s.SKUName,
		StorageLocation: s.StorageLocation,
	}
}

// ScheduleAvailabilityResponse - Schedule availability for given sku in a region.
type ScheduleAvailabilityResponse struct {
	// READ-ONLY; List of dates available to schedule
	AvailableDates []*time.Time
}

// Secret - The secrets related to a DataBox.
type Secret struct {
	// READ-ONLY; Per account level access credentials.
	AccountCredentialDetails []*AccountCredentialDetails

	// READ-ONLY; Password for out of the box experience on device.
	DevicePassword *string

	// READ-ONLY; Serial number of the assigned device.
	DeviceSerialNumber *string

	// READ-ONLY; The base 64 encoded public key to authenticate with the device
	EncodedValidationCertPubKey *string

	// READ-ONLY; Network configuration of the appliance.
	NetworkConfigurations []*ApplianceNetworkConfiguration
}

// ShareCredentialDetails - Credential details of the shares in account.
type ShareCredentialDetails struct {
	// READ-ONLY; Password for the share.
	Password *string

	// READ-ONLY; Name of the share.
	ShareName *string

	// READ-ONLY; Type of the share.
	ShareType *ShareDestinationFormatType

	// READ-ONLY; Access protocols supported on the device.
	SupportedAccessProtocols []*AccessProtocol

	// READ-ONLY; User name for the share.
	UserName *string
}

// ShipmentPickUpRequest - Shipment pick up request details.
type ShipmentPickUpRequest struct {
	// REQUIRED; Maximum date before which the pick up should commence, this must be in local time of pick up area.
	EndTime *time.Time

	// REQUIRED; Shipment Location in the pickup place. Eg.front desk
	ShipmentLocation *string

	// REQUIRED; Minimum date after which the pick up should commence, this must be in local time of pick up area.
	StartTime *time.Time
}

// ShipmentPickUpResponse - Shipment pick up response.
type ShipmentPickUpResponse struct {
	// READ-ONLY; Confirmation number for the pick up request.
	ConfirmationNumber *string

	// READ-ONLY; Time by which shipment should be ready for pick up, this is in local time of pick up area.
	ReadyByTime *time.Time
}

// ShippingAddress - Shipping address where customer wishes to receive the device.
type ShippingAddress struct {
	// REQUIRED; Name of the Country.
	Country *string

	// REQUIRED; Street Address line 1.
	StreetAddress1 *string

	// Type of address.
	AddressType *AddressType

	// Name of the City.
	City *string

	// Name of the company.
	CompanyName *string

	// Postal code.
	PostalCode *string

	// Flag to indicate if customer has chosen to skip default address validation
	SkipAddressValidation *bool

	// Name of the State or Province.
	StateOrProvince *string

	// Street Address line 2.
	StreetAddress2 *string

	// Street Address line 3.
	StreetAddress3 *string

	// Tax Identification Number
	TaxIdentificationNumber *string

	// Extended Zip Code.
	ZipExtendedCode *string
}

// StorageAccountDetails - Details for the storage account.
type StorageAccountDetails struct {
	// REQUIRED; Account Type of the data to be transferred.
	DataAccountType *DataAccountType

	// REQUIRED; Storage Account Resource Id.
	StorageAccountID *string

	// Password for all the shares to be created on the device. Should not be passed for TransferType:ExportFromAzure jobs. If
	// this is not passed, the service will generate password itself. This will not be
	// returned in Get Call. Password Requirements : Password must be minimum of 12 and maximum of 64 characters. Password must
	// have at least one uppercase alphabet, one number and one special character.
	// Password cannot have the following characters : IilLoO0 Password can have only alphabets, numbers and these characters
	// : @#-$%^!+=;:_()]+
	SharePassword *string
}

// GetDataAccountDetails implements the DataAccountDetailsClassification interface for type StorageAccountDetails.
func (s *StorageAccountDetails) GetDataAccountDetails() *DataAccountDetails {
	return &DataAccountDetails{
		DataAccountType: s.DataAccountType,
		SharePassword:   s.SharePassword,
	}
}

// SubscriptionIsAllowedToCreateJobValidationRequest - Request to validate subscription permission to create jobs.
type SubscriptionIsAllowedToCreateJobValidationRequest struct {
	// REQUIRED; Identifies the type of validation request.
	ValidationType *ValidationInputDiscriminator
}

// GetValidationInputRequest implements the ValidationInputRequestClassification interface for type SubscriptionIsAllowedToCreateJobValidationRequest.
func (s *SubscriptionIsAllowedToCreateJobValidationRequest) GetValidationInputRequest() *ValidationInputRequest {
	return &ValidationInputRequest{
		ValidationType: s.ValidationType,
	}
}

// SubscriptionIsAllowedToCreateJobValidationResponseProperties - Properties of subscription permission to create job validation
// response.
type SubscriptionIsAllowedToCreateJobValidationResponseProperties struct {
	// REQUIRED; Identifies the type of validation response.
	ValidationType *ValidationInputDiscriminator

	// READ-ONLY; Error code and message of validation response.
	Error *CloudError

	// READ-ONLY; Validation status of subscription permission to create job.
	Status *ValidationStatus
}

// GetValidationInputResponse implements the ValidationInputResponseClassification interface for type SubscriptionIsAllowedToCreateJobValidationResponseProperties.
func (s *SubscriptionIsAllowedToCreateJobValidationResponseProperties) GetValidationInputResponse() *ValidationInputResponse {
	return &ValidationInputResponse{
		Error:          s.Error,
		ValidationType: s.ValidationType,
	}
}

// SystemData - Provides details about resource creation and update time
type SystemData struct {
	// READ-ONLY; The timestamp of resource creation (UTC)
	CreatedAt *time.Time

	// READ-ONLY; A string identifier for the identity that created the resource
	CreatedBy *string

	// READ-ONLY; The type of identity that created the resource: user, application, managedIdentity
	CreatedByType *string

	// READ-ONLY; The timestamp of resource last modification (UTC)
	LastModifiedAt *time.Time

	// READ-ONLY; A string identifier for the identity that last modified the resource
	LastModifiedBy *string

	// READ-ONLY; The type of identity that last modified the resource: user, application, managedIdentity
	LastModifiedByType *string
}

// TransferAllDetails - Details to transfer all data.
type TransferAllDetails struct {
	// REQUIRED; Type of the account of data
	DataAccountType *DataAccountType

	// To indicate if all Azure blobs have to be transferred
	TransferAllBlobs *bool

	// To indicate if all Azure Files have to be transferred
	TransferAllFiles *bool
}

// TransferConfiguration - Configuration for defining the transfer of data.
type TransferConfiguration struct {
	// REQUIRED; Type of the configuration for transfer.
	TransferConfigurationType *TransferConfigurationType

	// Map of filter type and the details to transfer all data. This field is required only if the TransferConfigurationType is
	// given as TransferAll
	TransferAllDetails *TransferConfigurationTransferAllDetails

	// Map of filter type and the details to filter. This field is required only if the TransferConfigurationType is given as
	// TransferUsingFilter.
	TransferFilterDetails *TransferConfigurationTransferFilterDetails
}

// TransferConfigurationTransferAllDetails - Map of filter type and the details to transfer all data. This field is required
// only if the TransferConfigurationType is given as TransferAll
type TransferConfigurationTransferAllDetails struct {
	// Details to transfer all data.
	Include *TransferAllDetails
}

// TransferConfigurationTransferFilterDetails - Map of filter type and the details to filter. This field is required only
// if the TransferConfigurationType is given as TransferUsingFilter.
type TransferConfigurationTransferFilterDetails struct {
	// Details of the filtering the transfer of data.
	Include *TransferFilterDetails
}

// TransferFilterDetails - Details of the filtering the transfer of data.
type TransferFilterDetails struct {
	// REQUIRED; Type of the account of data.
	DataAccountType *DataAccountType

	// Filter details to transfer Azure files.
	AzureFileFilterDetails *AzureFileFilterDetails

	// Filter details to transfer blobs.
	BlobFilterDetails *BlobFilterDetails

	// Details of the filter files to be used for data transfer.
	FilterFileDetails []*FilterFileDetails
}

// TransportAvailabilityDetails - Transport options availability details for given region.
type TransportAvailabilityDetails struct {
	// READ-ONLY; Transport Shipment Type supported for given region.
	ShipmentType *TransportShipmentTypes
}

// TransportAvailabilityRequest - Request body to get the transport availability for given sku.
type TransportAvailabilityRequest struct {
	// Type of the device.
	SKUName *SKUName
}

// TransportAvailabilityResponse - Transport options available for given sku in a region.
type TransportAvailabilityResponse struct {
	// READ-ONLY; List of transport availability details for given region
	TransportAvailabilityDetails []*TransportAvailabilityDetails
}

// TransportPreferences - Preferences related to the shipment logistics of the sku
type TransportPreferences struct {
	// REQUIRED; Indicates Shipment Logistics type that the customer preferred.
	PreferredShipmentType *TransportShipmentTypes

	// READ-ONLY; Read only property which indicates whether transport preferences has been updated or not after device is prepared.
	IsUpdated *bool
}

// UnencryptedCredentials - Unencrypted credentials for accessing device.
type UnencryptedCredentials struct {
	// READ-ONLY; Name of the job.
	JobName *string

	// READ-ONLY; Secrets related to this job.
	JobSecrets CommonJobSecretsClassification
}

// UnencryptedCredentialsList - List of unencrypted credentials for accessing device.
type UnencryptedCredentialsList struct {
	// Link for the next set of unencrypted credentials.
	NextLink *string

	// List of unencrypted credentials.
	Value []*UnencryptedCredentials
}

// UpdateJobDetails - Job details for update.
type UpdateJobDetails struct {
	// Contact details for notification and shipping.
	ContactDetails *ContactDetails

	// Key encryption key for the job.
	KeyEncryptionKey *KeyEncryptionKey

	// Preferences related to the order
	Preferences *Preferences

	// Return package details of job.
	ReturnToCustomerPackageDetails *PackageCarrierDetails

	// Reverse Shipping Address and contact details for a job.
	ReverseShippingDetails *ReverseShippingDetails

	// Shipping address of the customer.
	ShippingAddress *ShippingAddress
}

// UpdateJobProperties - Job Properties for update
type UpdateJobProperties struct {
	// Details of a job to be updated.
	Details *UpdateJobDetails
}

// UserAssignedIdentity - Class defining User assigned identity details.
type UserAssignedIdentity struct {
	// READ-ONLY; The client id of user assigned identity.
	ClientID *string

	// READ-ONLY; The principal id of user assigned identity.
	PrincipalID *string
}

// UserAssignedProperties - User assigned identity properties.
type UserAssignedProperties struct {
	// Arm resource id for user assigned identity to be used to fetch MSI token.
	ResourceID *string
}

// ValidateAddress - The requirements to validate customer address where the device needs to be shipped.
type ValidateAddress struct {
	// REQUIRED; Device type to be used for the job.
	DeviceType *SKUName

	// REQUIRED; Shipping address of the customer.
	ShippingAddress *ShippingAddress

	// REQUIRED; Identifies the type of validation request.
	ValidationType *ValidationInputDiscriminator

	// Preferences related to the shipment logistics of the sku.
	TransportPreferences *TransportPreferences
}

// GetValidationInputRequest implements the ValidationInputRequestClassification interface for type ValidateAddress.
func (v *ValidateAddress) GetValidationInputRequest() *ValidationInputRequest {
	return &ValidationInputRequest{
		ValidationType: v.ValidationType,
	}
}

// ValidationInputRequest - Minimum fields that must be present in any type of validation request.
type ValidationInputRequest struct {
	// REQUIRED; Identifies the type of validation request.
	ValidationType *ValidationInputDiscriminator
}

// GetValidationInputRequest implements the ValidationInputRequestClassification interface for type ValidationInputRequest.
func (v *ValidationInputRequest) GetValidationInputRequest() *ValidationInputRequest { return v }

// ValidationInputResponse - Minimum properties that should be present in each individual validation response.
type ValidationInputResponse struct {
	// REQUIRED; Identifies the type of validation response.
	ValidationType *ValidationInputDiscriminator

	// READ-ONLY; Error code and message of validation response.
	Error *CloudError
}

// GetValidationInputResponse implements the ValidationInputResponseClassification interface for type ValidationInputResponse.
func (v *ValidationInputResponse) GetValidationInputResponse() *ValidationInputResponse { return v }

// ValidationRequest - Minimum request requirement of any validation category.
type ValidationRequest struct {
	// REQUIRED; List of request details contain validationType and its request as key and value respectively.
	IndividualRequestDetails []ValidationInputRequestClassification

	// CONSTANT; Identify the nature of validation.
	// Field has constant value "JobCreationValidation", any specified value is ignored.
	ValidationCategory *string
}

// GetValidationRequest implements the ValidationRequestClassification interface for type ValidationRequest.
func (v *ValidationRequest) GetValidationRequest() *ValidationRequest { return v }

// ValidationResponse - Response of pre job creation validations.
type ValidationResponse struct {
	// READ-ONLY; Properties of pre job creation validation response.
	Properties *ValidationResponseProperties
}

// ValidationResponseProperties - Properties of pre job creation validation response.
type ValidationResponseProperties struct {
	// READ-ONLY; List of response details contain validationType and its response as key and value respectively.
	IndividualResponseDetails []ValidationInputResponseClassification

	// READ-ONLY; Overall validation status.
	Status *OverallValidationStatus
}
