//go:build go1.18
// +build go1.18

// Copyright (c) Microsoft Corporation. All rights reserved.
// Licensed under the MIT License. See License.txt in the project root for license information.
// Code generated by Microsoft (R) AutoRest Code Generator. DO NOT EDIT.
// Changes may cause incorrect behavior and will be lost if the code is regenerated.

package armdeploymentmanager

import (
	"github.com/Azure/azure-sdk-for-go/sdk/azcore"
	"github.com/Azure/azure-sdk-for-go/sdk/azcore/arm"
)

// ClientFactory is a client factory used to create any client in this module.
// Don't use this type directly, use NewClientFactory instead.
type ClientFactory struct {
	subscriptionID string
	credential     azcore.TokenCredential
	options        *arm.ClientOptions
}

// NewClientFactory creates a new instance of ClientFactory with the specified values.
// The parameter values will be propagated to any client created from this factory.
//   - subscriptionID - Subscription credentials which uniquely identify Microsoft Azure subscription. The subscription ID forms
//     part of the URI for every service call.
//   - credential - used to authorize requests. Usually a credential from azidentity.
//   - options - pass nil to accept the default values.
func NewClientFactory(subscriptionID string, credential azcore.TokenCredential, options *arm.ClientOptions) (*ClientFactory, error) {
	_, err := arm.NewClient(moduleName, moduleVersion, credential, options)
	if err != nil {
		return nil, err
	}
	return &ClientFactory{
		subscriptionID: subscriptionID, credential: credential,
		options: options.Clone(),
	}, nil
}

// NewArtifactSourcesClient creates a new instance of ArtifactSourcesClient.
func (c *ClientFactory) NewArtifactSourcesClient() *ArtifactSourcesClient {
	subClient, _ := NewArtifactSourcesClient(c.subscriptionID, c.credential, c.options)
	return subClient
}

// NewOperationsClient creates a new instance of OperationsClient.
func (c *ClientFactory) NewOperationsClient() *OperationsClient {
	subClient, _ := NewOperationsClient(c.credential, c.options)
	return subClient
}

// NewRolloutsClient creates a new instance of RolloutsClient.
func (c *ClientFactory) NewRolloutsClient() *RolloutsClient {
	subClient, _ := NewRolloutsClient(c.subscriptionID, c.credential, c.options)
	return subClient
}

// NewServiceTopologiesClient creates a new instance of ServiceTopologiesClient.
func (c *ClientFactory) NewServiceTopologiesClient() *ServiceTopologiesClient {
	subClient, _ := NewServiceTopologiesClient(c.subscriptionID, c.credential, c.options)
	return subClient
}

// NewServiceUnitsClient creates a new instance of ServiceUnitsClient.
func (c *ClientFactory) NewServiceUnitsClient() *ServiceUnitsClient {
	subClient, _ := NewServiceUnitsClient(c.subscriptionID, c.credential, c.options)
	return subClient
}

// NewServicesClient creates a new instance of ServicesClient.
func (c *ClientFactory) NewServicesClient() *ServicesClient {
	subClient, _ := NewServicesClient(c.subscriptionID, c.credential, c.options)
	return subClient
}

// NewStepsClient creates a new instance of StepsClient.
func (c *ClientFactory) NewStepsClient() *StepsClient {
	subClient, _ := NewStepsClient(c.subscriptionID, c.credential, c.options)
	return subClient
}
