//go:build go1.18
// +build go1.18

// Copyright (c) Microsoft Corporation. All rights reserved.
// Licensed under the MIT License. See License.txt in the project root for license information.
// Code generated by Microsoft (R) AutoRest Code Generator. DO NOT EDIT.
// Changes may cause incorrect behavior and will be lost if the code is regenerated.

package fake

import (
	"context"
	"errors"
	"fmt"
	azfake "github.com/Azure/azure-sdk-for-go/sdk/azcore/fake"
	"github.com/Azure/azure-sdk-for-go/sdk/azcore/fake/server"
	"github.com/Azure/azure-sdk-for-go/sdk/azcore/runtime"
	"github.com/Azure/azure-sdk-for-go/sdk/resourcemanager/devcenter/armdevcenter/v2"
	"net/http"
	"regexp"
)

// CheckScopedNameAvailabilityServer is a fake server for instances of the armdevcenter.CheckScopedNameAvailabilityClient type.
type CheckScopedNameAvailabilityServer struct {
	// Execute is the fake for method CheckScopedNameAvailabilityClient.Execute
	// HTTP status codes to indicate success: http.StatusOK
	Execute func(ctx context.Context, nameAvailabilityRequest armdevcenter.CheckScopedNameAvailabilityRequest, options *armdevcenter.CheckScopedNameAvailabilityClientExecuteOptions) (resp azfake.Responder[armdevcenter.CheckScopedNameAvailabilityClientExecuteResponse], errResp azfake.ErrorResponder)
}

// NewCheckScopedNameAvailabilityServerTransport creates a new instance of CheckScopedNameAvailabilityServerTransport with the provided implementation.
// The returned CheckScopedNameAvailabilityServerTransport instance is connected to an instance of armdevcenter.CheckScopedNameAvailabilityClient via the
// azcore.ClientOptions.Transporter field in the client's constructor parameters.
func NewCheckScopedNameAvailabilityServerTransport(srv *CheckScopedNameAvailabilityServer) *CheckScopedNameAvailabilityServerTransport {
	return &CheckScopedNameAvailabilityServerTransport{srv: srv}
}

// CheckScopedNameAvailabilityServerTransport connects instances of armdevcenter.CheckScopedNameAvailabilityClient to instances of CheckScopedNameAvailabilityServer.
// Don't use this type directly, use NewCheckScopedNameAvailabilityServerTransport instead.
type CheckScopedNameAvailabilityServerTransport struct {
	srv *CheckScopedNameAvailabilityServer
}

// Do implements the policy.Transporter interface for CheckScopedNameAvailabilityServerTransport.
func (c *CheckScopedNameAvailabilityServerTransport) Do(req *http.Request) (*http.Response, error) {
	rawMethod := req.Context().Value(runtime.CtxAPINameKey{})
	method, ok := rawMethod.(string)
	if !ok {
		return nil, nonRetriableError{errors.New("unable to dispatch request, missing value for CtxAPINameKey")}
	}

	var resp *http.Response
	var err error

	switch method {
	case "CheckScopedNameAvailabilityClient.Execute":
		resp, err = c.dispatchExecute(req)
	default:
		err = fmt.Errorf("unhandled API %s", method)
	}

	if err != nil {
		return nil, err
	}

	return resp, nil
}

func (c *CheckScopedNameAvailabilityServerTransport) dispatchExecute(req *http.Request) (*http.Response, error) {
	if c.srv.Execute == nil {
		return nil, &nonRetriableError{errors.New("fake for method Execute not implemented")}
	}
	const regexStr = `/subscriptions/(?P<subscriptionId>[!#&$-;=?-\[\]_a-zA-Z0-9~%@]+)/providers/Microsoft\.DevCenter/checkScopedNameAvailability`
	regex := regexp.MustCompile(regexStr)
	matches := regex.FindStringSubmatch(req.URL.EscapedPath())
	if matches == nil || len(matches) < 1 {
		return nil, fmt.Errorf("failed to parse path %s", req.URL.Path)
	}
	body, err := server.UnmarshalRequestAsJSON[armdevcenter.CheckScopedNameAvailabilityRequest](req)
	if err != nil {
		return nil, err
	}
	respr, errRespr := c.srv.Execute(req.Context(), body, nil)
	if respErr := server.GetError(errRespr, req); respErr != nil {
		return nil, respErr
	}
	respContent := server.GetResponseContent(respr)
	if !contains([]int{http.StatusOK}, respContent.HTTPStatus) {
		return nil, &nonRetriableError{fmt.Errorf("unexpected status code %d. acceptable values are http.StatusOK", respContent.HTTPStatus)}
	}
	resp, err := server.MarshalResponseAsJSON(respContent, server.GetResponse(respr).CheckNameAvailabilityResponse, req)
	if err != nil {
		return nil, err
	}
	return resp, nil
}
