//go:build go1.18
// +build go1.18

// Copyright (c) Microsoft Corporation. All rights reserved.
// Licensed under the MIT License. See License.txt in the project root for license information.
// Code generated by Microsoft (R) AutoRest Code Generator. DO NOT EDIT.
// Changes may cause incorrect behavior and will be lost if the code is regenerated.

package fake

import (
	"context"
	"errors"
	"fmt"
	azfake "github.com/Azure/azure-sdk-for-go/sdk/azcore/fake"
	"github.com/Azure/azure-sdk-for-go/sdk/azcore/fake/server"
	"github.com/Azure/azure-sdk-for-go/sdk/azcore/runtime"
	"github.com/Azure/azure-sdk-for-go/sdk/azcore/to"
	"github.com/Azure/azure-sdk-for-go/sdk/resourcemanager/dynatrace/armdynatrace/v2"
	"net/http"
	"net/url"
	"reflect"
	"regexp"
)

// MonitorsServer is a fake server for instances of the armdynatrace.MonitorsClient type.
type MonitorsServer struct {
	// BeginCreateOrUpdate is the fake for method MonitorsClient.BeginCreateOrUpdate
	// HTTP status codes to indicate success: http.StatusOK, http.StatusCreated
	BeginCreateOrUpdate func(ctx context.Context, resourceGroupName string, monitorName string, resource armdynatrace.MonitorResource, options *armdynatrace.MonitorsClientBeginCreateOrUpdateOptions) (resp azfake.PollerResponder[armdynatrace.MonitorsClientCreateOrUpdateResponse], errResp azfake.ErrorResponder)

	// BeginDelete is the fake for method MonitorsClient.BeginDelete
	// HTTP status codes to indicate success: http.StatusOK, http.StatusAccepted, http.StatusNoContent
	BeginDelete func(ctx context.Context, resourceGroupName string, monitorName string, options *armdynatrace.MonitorsClientBeginDeleteOptions) (resp azfake.PollerResponder[armdynatrace.MonitorsClientDeleteResponse], errResp azfake.ErrorResponder)

	// Get is the fake for method MonitorsClient.Get
	// HTTP status codes to indicate success: http.StatusOK
	Get func(ctx context.Context, resourceGroupName string, monitorName string, options *armdynatrace.MonitorsClientGetOptions) (resp azfake.Responder[armdynatrace.MonitorsClientGetResponse], errResp azfake.ErrorResponder)

	// GetMarketplaceSaaSResourceDetails is the fake for method MonitorsClient.GetMarketplaceSaaSResourceDetails
	// HTTP status codes to indicate success: http.StatusOK
	GetMarketplaceSaaSResourceDetails func(ctx context.Context, request armdynatrace.MarketplaceSaaSResourceDetailsRequest, options *armdynatrace.MonitorsClientGetMarketplaceSaaSResourceDetailsOptions) (resp azfake.Responder[armdynatrace.MonitorsClientGetMarketplaceSaaSResourceDetailsResponse], errResp azfake.ErrorResponder)

	// GetMetricStatus is the fake for method MonitorsClient.GetMetricStatus
	// HTTP status codes to indicate success: http.StatusOK
	GetMetricStatus func(ctx context.Context, resourceGroupName string, monitorName string, options *armdynatrace.MonitorsClientGetMetricStatusOptions) (resp azfake.Responder[armdynatrace.MonitorsClientGetMetricStatusResponse], errResp azfake.ErrorResponder)

	// GetSSODetails is the fake for method MonitorsClient.GetSSODetails
	// HTTP status codes to indicate success: http.StatusOK
	GetSSODetails func(ctx context.Context, resourceGroupName string, monitorName string, options *armdynatrace.MonitorsClientGetSSODetailsOptions) (resp azfake.Responder[armdynatrace.MonitorsClientGetSSODetailsResponse], errResp azfake.ErrorResponder)

	// GetVMHostPayload is the fake for method MonitorsClient.GetVMHostPayload
	// HTTP status codes to indicate success: http.StatusOK
	GetVMHostPayload func(ctx context.Context, resourceGroupName string, monitorName string, options *armdynatrace.MonitorsClientGetVMHostPayloadOptions) (resp azfake.Responder[armdynatrace.MonitorsClientGetVMHostPayloadResponse], errResp azfake.ErrorResponder)

	// NewListAppServicesPager is the fake for method MonitorsClient.NewListAppServicesPager
	// HTTP status codes to indicate success: http.StatusOK
	NewListAppServicesPager func(resourceGroupName string, monitorName string, options *armdynatrace.MonitorsClientListAppServicesOptions) (resp azfake.PagerResponder[armdynatrace.MonitorsClientListAppServicesResponse])

	// NewListByResourceGroupPager is the fake for method MonitorsClient.NewListByResourceGroupPager
	// HTTP status codes to indicate success: http.StatusOK
	NewListByResourceGroupPager func(resourceGroupName string, options *armdynatrace.MonitorsClientListByResourceGroupOptions) (resp azfake.PagerResponder[armdynatrace.MonitorsClientListByResourceGroupResponse])

	// NewListBySubscriptionIDPager is the fake for method MonitorsClient.NewListBySubscriptionIDPager
	// HTTP status codes to indicate success: http.StatusOK
	NewListBySubscriptionIDPager func(options *armdynatrace.MonitorsClientListBySubscriptionIDOptions) (resp azfake.PagerResponder[armdynatrace.MonitorsClientListBySubscriptionIDResponse])

	// NewListHostsPager is the fake for method MonitorsClient.NewListHostsPager
	// HTTP status codes to indicate success: http.StatusOK
	NewListHostsPager func(resourceGroupName string, monitorName string, options *armdynatrace.MonitorsClientListHostsOptions) (resp azfake.PagerResponder[armdynatrace.MonitorsClientListHostsResponse])

	// NewListLinkableEnvironmentsPager is the fake for method MonitorsClient.NewListLinkableEnvironmentsPager
	// HTTP status codes to indicate success: http.StatusOK
	NewListLinkableEnvironmentsPager func(resourceGroupName string, monitorName string, request armdynatrace.LinkableEnvironmentRequest, options *armdynatrace.MonitorsClientListLinkableEnvironmentsOptions) (resp azfake.PagerResponder[armdynatrace.MonitorsClientListLinkableEnvironmentsResponse])

	// NewListMonitoredResourcesPager is the fake for method MonitorsClient.NewListMonitoredResourcesPager
	// HTTP status codes to indicate success: http.StatusOK
	NewListMonitoredResourcesPager func(resourceGroupName string, monitorName string, options *armdynatrace.MonitorsClientListMonitoredResourcesOptions) (resp azfake.PagerResponder[armdynatrace.MonitorsClientListMonitoredResourcesResponse])

	// Update is the fake for method MonitorsClient.Update
	// HTTP status codes to indicate success: http.StatusOK
	Update func(ctx context.Context, resourceGroupName string, monitorName string, resource armdynatrace.MonitorResourceUpdate, options *armdynatrace.MonitorsClientUpdateOptions) (resp azfake.Responder[armdynatrace.MonitorsClientUpdateResponse], errResp azfake.ErrorResponder)
}

// NewMonitorsServerTransport creates a new instance of MonitorsServerTransport with the provided implementation.
// The returned MonitorsServerTransport instance is connected to an instance of armdynatrace.MonitorsClient via the
// azcore.ClientOptions.Transporter field in the client's constructor parameters.
func NewMonitorsServerTransport(srv *MonitorsServer) *MonitorsServerTransport {
	return &MonitorsServerTransport{
		srv:                              srv,
		beginCreateOrUpdate:              newTracker[azfake.PollerResponder[armdynatrace.MonitorsClientCreateOrUpdateResponse]](),
		beginDelete:                      newTracker[azfake.PollerResponder[armdynatrace.MonitorsClientDeleteResponse]](),
		newListAppServicesPager:          newTracker[azfake.PagerResponder[armdynatrace.MonitorsClientListAppServicesResponse]](),
		newListByResourceGroupPager:      newTracker[azfake.PagerResponder[armdynatrace.MonitorsClientListByResourceGroupResponse]](),
		newListBySubscriptionIDPager:     newTracker[azfake.PagerResponder[armdynatrace.MonitorsClientListBySubscriptionIDResponse]](),
		newListHostsPager:                newTracker[azfake.PagerResponder[armdynatrace.MonitorsClientListHostsResponse]](),
		newListLinkableEnvironmentsPager: newTracker[azfake.PagerResponder[armdynatrace.MonitorsClientListLinkableEnvironmentsResponse]](),
		newListMonitoredResourcesPager:   newTracker[azfake.PagerResponder[armdynatrace.MonitorsClientListMonitoredResourcesResponse]](),
	}
}

// MonitorsServerTransport connects instances of armdynatrace.MonitorsClient to instances of MonitorsServer.
// Don't use this type directly, use NewMonitorsServerTransport instead.
type MonitorsServerTransport struct {
	srv                              *MonitorsServer
	beginCreateOrUpdate              *tracker[azfake.PollerResponder[armdynatrace.MonitorsClientCreateOrUpdateResponse]]
	beginDelete                      *tracker[azfake.PollerResponder[armdynatrace.MonitorsClientDeleteResponse]]
	newListAppServicesPager          *tracker[azfake.PagerResponder[armdynatrace.MonitorsClientListAppServicesResponse]]
	newListByResourceGroupPager      *tracker[azfake.PagerResponder[armdynatrace.MonitorsClientListByResourceGroupResponse]]
	newListBySubscriptionIDPager     *tracker[azfake.PagerResponder[armdynatrace.MonitorsClientListBySubscriptionIDResponse]]
	newListHostsPager                *tracker[azfake.PagerResponder[armdynatrace.MonitorsClientListHostsResponse]]
	newListLinkableEnvironmentsPager *tracker[azfake.PagerResponder[armdynatrace.MonitorsClientListLinkableEnvironmentsResponse]]
	newListMonitoredResourcesPager   *tracker[azfake.PagerResponder[armdynatrace.MonitorsClientListMonitoredResourcesResponse]]
}

// Do implements the policy.Transporter interface for MonitorsServerTransport.
func (m *MonitorsServerTransport) Do(req *http.Request) (*http.Response, error) {
	rawMethod := req.Context().Value(runtime.CtxAPINameKey{})
	method, ok := rawMethod.(string)
	if !ok {
		return nil, nonRetriableError{errors.New("unable to dispatch request, missing value for CtxAPINameKey")}
	}

	var resp *http.Response
	var err error

	switch method {
	case "MonitorsClient.BeginCreateOrUpdate":
		resp, err = m.dispatchBeginCreateOrUpdate(req)
	case "MonitorsClient.BeginDelete":
		resp, err = m.dispatchBeginDelete(req)
	case "MonitorsClient.Get":
		resp, err = m.dispatchGet(req)
	case "MonitorsClient.GetMarketplaceSaaSResourceDetails":
		resp, err = m.dispatchGetMarketplaceSaaSResourceDetails(req)
	case "MonitorsClient.GetMetricStatus":
		resp, err = m.dispatchGetMetricStatus(req)
	case "MonitorsClient.GetSSODetails":
		resp, err = m.dispatchGetSSODetails(req)
	case "MonitorsClient.GetVMHostPayload":
		resp, err = m.dispatchGetVMHostPayload(req)
	case "MonitorsClient.NewListAppServicesPager":
		resp, err = m.dispatchNewListAppServicesPager(req)
	case "MonitorsClient.NewListByResourceGroupPager":
		resp, err = m.dispatchNewListByResourceGroupPager(req)
	case "MonitorsClient.NewListBySubscriptionIDPager":
		resp, err = m.dispatchNewListBySubscriptionIDPager(req)
	case "MonitorsClient.NewListHostsPager":
		resp, err = m.dispatchNewListHostsPager(req)
	case "MonitorsClient.NewListLinkableEnvironmentsPager":
		resp, err = m.dispatchNewListLinkableEnvironmentsPager(req)
	case "MonitorsClient.NewListMonitoredResourcesPager":
		resp, err = m.dispatchNewListMonitoredResourcesPager(req)
	case "MonitorsClient.Update":
		resp, err = m.dispatchUpdate(req)
	default:
		err = fmt.Errorf("unhandled API %s", method)
	}

	if err != nil {
		return nil, err
	}

	return resp, nil
}

func (m *MonitorsServerTransport) dispatchBeginCreateOrUpdate(req *http.Request) (*http.Response, error) {
	if m.srv.BeginCreateOrUpdate == nil {
		return nil, &nonRetriableError{errors.New("fake for method BeginCreateOrUpdate not implemented")}
	}
	beginCreateOrUpdate := m.beginCreateOrUpdate.get(req)
	if beginCreateOrUpdate == nil {
		const regexStr = `/subscriptions/(?P<subscriptionId>[!#&$-;=?-\[\]_a-zA-Z0-9~%@]+)/resourceGroups/(?P<resourceGroupName>[!#&$-;=?-\[\]_a-zA-Z0-9~%@]+)/providers/Dynatrace\.Observability/monitors/(?P<monitorName>[!#&$-;=?-\[\]_a-zA-Z0-9~%@]+)`
		regex := regexp.MustCompile(regexStr)
		matches := regex.FindStringSubmatch(req.URL.EscapedPath())
		if matches == nil || len(matches) < 3 {
			return nil, fmt.Errorf("failed to parse path %s", req.URL.Path)
		}
		body, err := server.UnmarshalRequestAsJSON[armdynatrace.MonitorResource](req)
		if err != nil {
			return nil, err
		}
		resourceGroupNameParam, err := url.PathUnescape(matches[regex.SubexpIndex("resourceGroupName")])
		if err != nil {
			return nil, err
		}
		monitorNameParam, err := url.PathUnescape(matches[regex.SubexpIndex("monitorName")])
		if err != nil {
			return nil, err
		}
		respr, errRespr := m.srv.BeginCreateOrUpdate(req.Context(), resourceGroupNameParam, monitorNameParam, body, nil)
		if respErr := server.GetError(errRespr, req); respErr != nil {
			return nil, respErr
		}
		beginCreateOrUpdate = &respr
		m.beginCreateOrUpdate.add(req, beginCreateOrUpdate)
	}

	resp, err := server.PollerResponderNext(beginCreateOrUpdate, req)
	if err != nil {
		return nil, err
	}

	if !contains([]int{http.StatusOK, http.StatusCreated}, resp.StatusCode) {
		m.beginCreateOrUpdate.remove(req)
		return nil, &nonRetriableError{fmt.Errorf("unexpected status code %d. acceptable values are http.StatusOK, http.StatusCreated", resp.StatusCode)}
	}
	if !server.PollerResponderMore(beginCreateOrUpdate) {
		m.beginCreateOrUpdate.remove(req)
	}

	return resp, nil
}

func (m *MonitorsServerTransport) dispatchBeginDelete(req *http.Request) (*http.Response, error) {
	if m.srv.BeginDelete == nil {
		return nil, &nonRetriableError{errors.New("fake for method BeginDelete not implemented")}
	}
	beginDelete := m.beginDelete.get(req)
	if beginDelete == nil {
		const regexStr = `/subscriptions/(?P<subscriptionId>[!#&$-;=?-\[\]_a-zA-Z0-9~%@]+)/resourceGroups/(?P<resourceGroupName>[!#&$-;=?-\[\]_a-zA-Z0-9~%@]+)/providers/Dynatrace\.Observability/monitors/(?P<monitorName>[!#&$-;=?-\[\]_a-zA-Z0-9~%@]+)`
		regex := regexp.MustCompile(regexStr)
		matches := regex.FindStringSubmatch(req.URL.EscapedPath())
		if matches == nil || len(matches) < 3 {
			return nil, fmt.Errorf("failed to parse path %s", req.URL.Path)
		}
		resourceGroupNameParam, err := url.PathUnescape(matches[regex.SubexpIndex("resourceGroupName")])
		if err != nil {
			return nil, err
		}
		monitorNameParam, err := url.PathUnescape(matches[regex.SubexpIndex("monitorName")])
		if err != nil {
			return nil, err
		}
		respr, errRespr := m.srv.BeginDelete(req.Context(), resourceGroupNameParam, monitorNameParam, nil)
		if respErr := server.GetError(errRespr, req); respErr != nil {
			return nil, respErr
		}
		beginDelete = &respr
		m.beginDelete.add(req, beginDelete)
	}

	resp, err := server.PollerResponderNext(beginDelete, req)
	if err != nil {
		return nil, err
	}

	if !contains([]int{http.StatusOK, http.StatusAccepted, http.StatusNoContent}, resp.StatusCode) {
		m.beginDelete.remove(req)
		return nil, &nonRetriableError{fmt.Errorf("unexpected status code %d. acceptable values are http.StatusOK, http.StatusAccepted, http.StatusNoContent", resp.StatusCode)}
	}
	if !server.PollerResponderMore(beginDelete) {
		m.beginDelete.remove(req)
	}

	return resp, nil
}

func (m *MonitorsServerTransport) dispatchGet(req *http.Request) (*http.Response, error) {
	if m.srv.Get == nil {
		return nil, &nonRetriableError{errors.New("fake for method Get not implemented")}
	}
	const regexStr = `/subscriptions/(?P<subscriptionId>[!#&$-;=?-\[\]_a-zA-Z0-9~%@]+)/resourceGroups/(?P<resourceGroupName>[!#&$-;=?-\[\]_a-zA-Z0-9~%@]+)/providers/Dynatrace\.Observability/monitors/(?P<monitorName>[!#&$-;=?-\[\]_a-zA-Z0-9~%@]+)`
	regex := regexp.MustCompile(regexStr)
	matches := regex.FindStringSubmatch(req.URL.EscapedPath())
	if matches == nil || len(matches) < 3 {
		return nil, fmt.Errorf("failed to parse path %s", req.URL.Path)
	}
	resourceGroupNameParam, err := url.PathUnescape(matches[regex.SubexpIndex("resourceGroupName")])
	if err != nil {
		return nil, err
	}
	monitorNameParam, err := url.PathUnescape(matches[regex.SubexpIndex("monitorName")])
	if err != nil {
		return nil, err
	}
	respr, errRespr := m.srv.Get(req.Context(), resourceGroupNameParam, monitorNameParam, nil)
	if respErr := server.GetError(errRespr, req); respErr != nil {
		return nil, respErr
	}
	respContent := server.GetResponseContent(respr)
	if !contains([]int{http.StatusOK}, respContent.HTTPStatus) {
		return nil, &nonRetriableError{fmt.Errorf("unexpected status code %d. acceptable values are http.StatusOK", respContent.HTTPStatus)}
	}
	resp, err := server.MarshalResponseAsJSON(respContent, server.GetResponse(respr).MonitorResource, req)
	if err != nil {
		return nil, err
	}
	return resp, nil
}

func (m *MonitorsServerTransport) dispatchGetMarketplaceSaaSResourceDetails(req *http.Request) (*http.Response, error) {
	if m.srv.GetMarketplaceSaaSResourceDetails == nil {
		return nil, &nonRetriableError{errors.New("fake for method GetMarketplaceSaaSResourceDetails not implemented")}
	}
	const regexStr = `/subscriptions/(?P<subscriptionId>[!#&$-;=?-\[\]_a-zA-Z0-9~%@]+)/providers/Dynatrace\.Observability/getMarketplaceSaaSResourceDetails`
	regex := regexp.MustCompile(regexStr)
	matches := regex.FindStringSubmatch(req.URL.EscapedPath())
	if matches == nil || len(matches) < 1 {
		return nil, fmt.Errorf("failed to parse path %s", req.URL.Path)
	}
	body, err := server.UnmarshalRequestAsJSON[armdynatrace.MarketplaceSaaSResourceDetailsRequest](req)
	if err != nil {
		return nil, err
	}
	respr, errRespr := m.srv.GetMarketplaceSaaSResourceDetails(req.Context(), body, nil)
	if respErr := server.GetError(errRespr, req); respErr != nil {
		return nil, respErr
	}
	respContent := server.GetResponseContent(respr)
	if !contains([]int{http.StatusOK}, respContent.HTTPStatus) {
		return nil, &nonRetriableError{fmt.Errorf("unexpected status code %d. acceptable values are http.StatusOK", respContent.HTTPStatus)}
	}
	resp, err := server.MarshalResponseAsJSON(respContent, server.GetResponse(respr).MarketplaceSaaSResourceDetailsResponse, req)
	if err != nil {
		return nil, err
	}
	return resp, nil
}

func (m *MonitorsServerTransport) dispatchGetMetricStatus(req *http.Request) (*http.Response, error) {
	if m.srv.GetMetricStatus == nil {
		return nil, &nonRetriableError{errors.New("fake for method GetMetricStatus not implemented")}
	}
	const regexStr = `/subscriptions/(?P<subscriptionId>[!#&$-;=?-\[\]_a-zA-Z0-9~%@]+)/resourceGroups/(?P<resourceGroupName>[!#&$-;=?-\[\]_a-zA-Z0-9~%@]+)/providers/Dynatrace\.Observability/monitors/(?P<monitorName>[!#&$-;=?-\[\]_a-zA-Z0-9~%@]+)/getMetricStatus`
	regex := regexp.MustCompile(regexStr)
	matches := regex.FindStringSubmatch(req.URL.EscapedPath())
	if matches == nil || len(matches) < 3 {
		return nil, fmt.Errorf("failed to parse path %s", req.URL.Path)
	}
	resourceGroupNameParam, err := url.PathUnescape(matches[regex.SubexpIndex("resourceGroupName")])
	if err != nil {
		return nil, err
	}
	monitorNameParam, err := url.PathUnescape(matches[regex.SubexpIndex("monitorName")])
	if err != nil {
		return nil, err
	}
	respr, errRespr := m.srv.GetMetricStatus(req.Context(), resourceGroupNameParam, monitorNameParam, nil)
	if respErr := server.GetError(errRespr, req); respErr != nil {
		return nil, respErr
	}
	respContent := server.GetResponseContent(respr)
	if !contains([]int{http.StatusOK}, respContent.HTTPStatus) {
		return nil, &nonRetriableError{fmt.Errorf("unexpected status code %d. acceptable values are http.StatusOK", respContent.HTTPStatus)}
	}
	resp, err := server.MarshalResponseAsJSON(respContent, server.GetResponse(respr).MetricsStatusResponse, req)
	if err != nil {
		return nil, err
	}
	return resp, nil
}

func (m *MonitorsServerTransport) dispatchGetSSODetails(req *http.Request) (*http.Response, error) {
	if m.srv.GetSSODetails == nil {
		return nil, &nonRetriableError{errors.New("fake for method GetSSODetails not implemented")}
	}
	const regexStr = `/subscriptions/(?P<subscriptionId>[!#&$-;=?-\[\]_a-zA-Z0-9~%@]+)/resourceGroups/(?P<resourceGroupName>[!#&$-;=?-\[\]_a-zA-Z0-9~%@]+)/providers/Dynatrace\.Observability/monitors/(?P<monitorName>[!#&$-;=?-\[\]_a-zA-Z0-9~%@]+)/getSSODetails`
	regex := regexp.MustCompile(regexStr)
	matches := regex.FindStringSubmatch(req.URL.EscapedPath())
	if matches == nil || len(matches) < 3 {
		return nil, fmt.Errorf("failed to parse path %s", req.URL.Path)
	}
	body, err := server.UnmarshalRequestAsJSON[armdynatrace.SSODetailsRequest](req)
	if err != nil {
		return nil, err
	}
	resourceGroupNameParam, err := url.PathUnescape(matches[regex.SubexpIndex("resourceGroupName")])
	if err != nil {
		return nil, err
	}
	monitorNameParam, err := url.PathUnescape(matches[regex.SubexpIndex("monitorName")])
	if err != nil {
		return nil, err
	}
	var options *armdynatrace.MonitorsClientGetSSODetailsOptions
	if !reflect.ValueOf(body).IsZero() {
		options = &armdynatrace.MonitorsClientGetSSODetailsOptions{
			Request: &body,
		}
	}
	respr, errRespr := m.srv.GetSSODetails(req.Context(), resourceGroupNameParam, monitorNameParam, options)
	if respErr := server.GetError(errRespr, req); respErr != nil {
		return nil, respErr
	}
	respContent := server.GetResponseContent(respr)
	if !contains([]int{http.StatusOK}, respContent.HTTPStatus) {
		return nil, &nonRetriableError{fmt.Errorf("unexpected status code %d. acceptable values are http.StatusOK", respContent.HTTPStatus)}
	}
	resp, err := server.MarshalResponseAsJSON(respContent, server.GetResponse(respr).SSODetailsResponse, req)
	if err != nil {
		return nil, err
	}
	return resp, nil
}

func (m *MonitorsServerTransport) dispatchGetVMHostPayload(req *http.Request) (*http.Response, error) {
	if m.srv.GetVMHostPayload == nil {
		return nil, &nonRetriableError{errors.New("fake for method GetVMHostPayload not implemented")}
	}
	const regexStr = `/subscriptions/(?P<subscriptionId>[!#&$-;=?-\[\]_a-zA-Z0-9~%@]+)/resourceGroups/(?P<resourceGroupName>[!#&$-;=?-\[\]_a-zA-Z0-9~%@]+)/providers/Dynatrace\.Observability/monitors/(?P<monitorName>[!#&$-;=?-\[\]_a-zA-Z0-9~%@]+)/getVMHostPayload`
	regex := regexp.MustCompile(regexStr)
	matches := regex.FindStringSubmatch(req.URL.EscapedPath())
	if matches == nil || len(matches) < 3 {
		return nil, fmt.Errorf("failed to parse path %s", req.URL.Path)
	}
	resourceGroupNameParam, err := url.PathUnescape(matches[regex.SubexpIndex("resourceGroupName")])
	if err != nil {
		return nil, err
	}
	monitorNameParam, err := url.PathUnescape(matches[regex.SubexpIndex("monitorName")])
	if err != nil {
		return nil, err
	}
	respr, errRespr := m.srv.GetVMHostPayload(req.Context(), resourceGroupNameParam, monitorNameParam, nil)
	if respErr := server.GetError(errRespr, req); respErr != nil {
		return nil, respErr
	}
	respContent := server.GetResponseContent(respr)
	if !contains([]int{http.StatusOK}, respContent.HTTPStatus) {
		return nil, &nonRetriableError{fmt.Errorf("unexpected status code %d. acceptable values are http.StatusOK", respContent.HTTPStatus)}
	}
	resp, err := server.MarshalResponseAsJSON(respContent, server.GetResponse(respr).VMExtensionPayload, req)
	if err != nil {
		return nil, err
	}
	return resp, nil
}

func (m *MonitorsServerTransport) dispatchNewListAppServicesPager(req *http.Request) (*http.Response, error) {
	if m.srv.NewListAppServicesPager == nil {
		return nil, &nonRetriableError{errors.New("fake for method NewListAppServicesPager not implemented")}
	}
	newListAppServicesPager := m.newListAppServicesPager.get(req)
	if newListAppServicesPager == nil {
		const regexStr = `/subscriptions/(?P<subscriptionId>[!#&$-;=?-\[\]_a-zA-Z0-9~%@]+)/resourceGroups/(?P<resourceGroupName>[!#&$-;=?-\[\]_a-zA-Z0-9~%@]+)/providers/Dynatrace\.Observability/monitors/(?P<monitorName>[!#&$-;=?-\[\]_a-zA-Z0-9~%@]+)/listAppServices`
		regex := regexp.MustCompile(regexStr)
		matches := regex.FindStringSubmatch(req.URL.EscapedPath())
		if matches == nil || len(matches) < 3 {
			return nil, fmt.Errorf("failed to parse path %s", req.URL.Path)
		}
		resourceGroupNameParam, err := url.PathUnescape(matches[regex.SubexpIndex("resourceGroupName")])
		if err != nil {
			return nil, err
		}
		monitorNameParam, err := url.PathUnescape(matches[regex.SubexpIndex("monitorName")])
		if err != nil {
			return nil, err
		}
		resp := m.srv.NewListAppServicesPager(resourceGroupNameParam, monitorNameParam, nil)
		newListAppServicesPager = &resp
		m.newListAppServicesPager.add(req, newListAppServicesPager)
		server.PagerResponderInjectNextLinks(newListAppServicesPager, req, func(page *armdynatrace.MonitorsClientListAppServicesResponse, createLink func() string) {
			page.NextLink = to.Ptr(createLink())
		})
	}
	resp, err := server.PagerResponderNext(newListAppServicesPager, req)
	if err != nil {
		return nil, err
	}
	if !contains([]int{http.StatusOK}, resp.StatusCode) {
		m.newListAppServicesPager.remove(req)
		return nil, &nonRetriableError{fmt.Errorf("unexpected status code %d. acceptable values are http.StatusOK", resp.StatusCode)}
	}
	if !server.PagerResponderMore(newListAppServicesPager) {
		m.newListAppServicesPager.remove(req)
	}
	return resp, nil
}

func (m *MonitorsServerTransport) dispatchNewListByResourceGroupPager(req *http.Request) (*http.Response, error) {
	if m.srv.NewListByResourceGroupPager == nil {
		return nil, &nonRetriableError{errors.New("fake for method NewListByResourceGroupPager not implemented")}
	}
	newListByResourceGroupPager := m.newListByResourceGroupPager.get(req)
	if newListByResourceGroupPager == nil {
		const regexStr = `/subscriptions/(?P<subscriptionId>[!#&$-;=?-\[\]_a-zA-Z0-9~%@]+)/resourceGroups/(?P<resourceGroupName>[!#&$-;=?-\[\]_a-zA-Z0-9~%@]+)/providers/Dynatrace\.Observability/monitors`
		regex := regexp.MustCompile(regexStr)
		matches := regex.FindStringSubmatch(req.URL.EscapedPath())
		if matches == nil || len(matches) < 2 {
			return nil, fmt.Errorf("failed to parse path %s", req.URL.Path)
		}
		resourceGroupNameParam, err := url.PathUnescape(matches[regex.SubexpIndex("resourceGroupName")])
		if err != nil {
			return nil, err
		}
		resp := m.srv.NewListByResourceGroupPager(resourceGroupNameParam, nil)
		newListByResourceGroupPager = &resp
		m.newListByResourceGroupPager.add(req, newListByResourceGroupPager)
		server.PagerResponderInjectNextLinks(newListByResourceGroupPager, req, func(page *armdynatrace.MonitorsClientListByResourceGroupResponse, createLink func() string) {
			page.NextLink = to.Ptr(createLink())
		})
	}
	resp, err := server.PagerResponderNext(newListByResourceGroupPager, req)
	if err != nil {
		return nil, err
	}
	if !contains([]int{http.StatusOK}, resp.StatusCode) {
		m.newListByResourceGroupPager.remove(req)
		return nil, &nonRetriableError{fmt.Errorf("unexpected status code %d. acceptable values are http.StatusOK", resp.StatusCode)}
	}
	if !server.PagerResponderMore(newListByResourceGroupPager) {
		m.newListByResourceGroupPager.remove(req)
	}
	return resp, nil
}

func (m *MonitorsServerTransport) dispatchNewListBySubscriptionIDPager(req *http.Request) (*http.Response, error) {
	if m.srv.NewListBySubscriptionIDPager == nil {
		return nil, &nonRetriableError{errors.New("fake for method NewListBySubscriptionIDPager not implemented")}
	}
	newListBySubscriptionIDPager := m.newListBySubscriptionIDPager.get(req)
	if newListBySubscriptionIDPager == nil {
		const regexStr = `/subscriptions/(?P<subscriptionId>[!#&$-;=?-\[\]_a-zA-Z0-9~%@]+)/providers/Dynatrace\.Observability/monitors`
		regex := regexp.MustCompile(regexStr)
		matches := regex.FindStringSubmatch(req.URL.EscapedPath())
		if matches == nil || len(matches) < 1 {
			return nil, fmt.Errorf("failed to parse path %s", req.URL.Path)
		}
		resp := m.srv.NewListBySubscriptionIDPager(nil)
		newListBySubscriptionIDPager = &resp
		m.newListBySubscriptionIDPager.add(req, newListBySubscriptionIDPager)
		server.PagerResponderInjectNextLinks(newListBySubscriptionIDPager, req, func(page *armdynatrace.MonitorsClientListBySubscriptionIDResponse, createLink func() string) {
			page.NextLink = to.Ptr(createLink())
		})
	}
	resp, err := server.PagerResponderNext(newListBySubscriptionIDPager, req)
	if err != nil {
		return nil, err
	}
	if !contains([]int{http.StatusOK}, resp.StatusCode) {
		m.newListBySubscriptionIDPager.remove(req)
		return nil, &nonRetriableError{fmt.Errorf("unexpected status code %d. acceptable values are http.StatusOK", resp.StatusCode)}
	}
	if !server.PagerResponderMore(newListBySubscriptionIDPager) {
		m.newListBySubscriptionIDPager.remove(req)
	}
	return resp, nil
}

func (m *MonitorsServerTransport) dispatchNewListHostsPager(req *http.Request) (*http.Response, error) {
	if m.srv.NewListHostsPager == nil {
		return nil, &nonRetriableError{errors.New("fake for method NewListHostsPager not implemented")}
	}
	newListHostsPager := m.newListHostsPager.get(req)
	if newListHostsPager == nil {
		const regexStr = `/subscriptions/(?P<subscriptionId>[!#&$-;=?-\[\]_a-zA-Z0-9~%@]+)/resourceGroups/(?P<resourceGroupName>[!#&$-;=?-\[\]_a-zA-Z0-9~%@]+)/providers/Dynatrace\.Observability/monitors/(?P<monitorName>[!#&$-;=?-\[\]_a-zA-Z0-9~%@]+)/listHosts`
		regex := regexp.MustCompile(regexStr)
		matches := regex.FindStringSubmatch(req.URL.EscapedPath())
		if matches == nil || len(matches) < 3 {
			return nil, fmt.Errorf("failed to parse path %s", req.URL.Path)
		}
		resourceGroupNameParam, err := url.PathUnescape(matches[regex.SubexpIndex("resourceGroupName")])
		if err != nil {
			return nil, err
		}
		monitorNameParam, err := url.PathUnescape(matches[regex.SubexpIndex("monitorName")])
		if err != nil {
			return nil, err
		}
		resp := m.srv.NewListHostsPager(resourceGroupNameParam, monitorNameParam, nil)
		newListHostsPager = &resp
		m.newListHostsPager.add(req, newListHostsPager)
		server.PagerResponderInjectNextLinks(newListHostsPager, req, func(page *armdynatrace.MonitorsClientListHostsResponse, createLink func() string) {
			page.NextLink = to.Ptr(createLink())
		})
	}
	resp, err := server.PagerResponderNext(newListHostsPager, req)
	if err != nil {
		return nil, err
	}
	if !contains([]int{http.StatusOK}, resp.StatusCode) {
		m.newListHostsPager.remove(req)
		return nil, &nonRetriableError{fmt.Errorf("unexpected status code %d. acceptable values are http.StatusOK", resp.StatusCode)}
	}
	if !server.PagerResponderMore(newListHostsPager) {
		m.newListHostsPager.remove(req)
	}
	return resp, nil
}

func (m *MonitorsServerTransport) dispatchNewListLinkableEnvironmentsPager(req *http.Request) (*http.Response, error) {
	if m.srv.NewListLinkableEnvironmentsPager == nil {
		return nil, &nonRetriableError{errors.New("fake for method NewListLinkableEnvironmentsPager not implemented")}
	}
	newListLinkableEnvironmentsPager := m.newListLinkableEnvironmentsPager.get(req)
	if newListLinkableEnvironmentsPager == nil {
		const regexStr = `/subscriptions/(?P<subscriptionId>[!#&$-;=?-\[\]_a-zA-Z0-9~%@]+)/resourceGroups/(?P<resourceGroupName>[!#&$-;=?-\[\]_a-zA-Z0-9~%@]+)/providers/Dynatrace\.Observability/monitors/(?P<monitorName>[!#&$-;=?-\[\]_a-zA-Z0-9~%@]+)/listLinkableEnvironments`
		regex := regexp.MustCompile(regexStr)
		matches := regex.FindStringSubmatch(req.URL.EscapedPath())
		if matches == nil || len(matches) < 3 {
			return nil, fmt.Errorf("failed to parse path %s", req.URL.Path)
		}
		body, err := server.UnmarshalRequestAsJSON[armdynatrace.LinkableEnvironmentRequest](req)
		if err != nil {
			return nil, err
		}
		resourceGroupNameParam, err := url.PathUnescape(matches[regex.SubexpIndex("resourceGroupName")])
		if err != nil {
			return nil, err
		}
		monitorNameParam, err := url.PathUnescape(matches[regex.SubexpIndex("monitorName")])
		if err != nil {
			return nil, err
		}
		resp := m.srv.NewListLinkableEnvironmentsPager(resourceGroupNameParam, monitorNameParam, body, nil)
		newListLinkableEnvironmentsPager = &resp
		m.newListLinkableEnvironmentsPager.add(req, newListLinkableEnvironmentsPager)
		server.PagerResponderInjectNextLinks(newListLinkableEnvironmentsPager, req, func(page *armdynatrace.MonitorsClientListLinkableEnvironmentsResponse, createLink func() string) {
			page.NextLink = to.Ptr(createLink())
		})
	}
	resp, err := server.PagerResponderNext(newListLinkableEnvironmentsPager, req)
	if err != nil {
		return nil, err
	}
	if !contains([]int{http.StatusOK}, resp.StatusCode) {
		m.newListLinkableEnvironmentsPager.remove(req)
		return nil, &nonRetriableError{fmt.Errorf("unexpected status code %d. acceptable values are http.StatusOK", resp.StatusCode)}
	}
	if !server.PagerResponderMore(newListLinkableEnvironmentsPager) {
		m.newListLinkableEnvironmentsPager.remove(req)
	}
	return resp, nil
}

func (m *MonitorsServerTransport) dispatchNewListMonitoredResourcesPager(req *http.Request) (*http.Response, error) {
	if m.srv.NewListMonitoredResourcesPager == nil {
		return nil, &nonRetriableError{errors.New("fake for method NewListMonitoredResourcesPager not implemented")}
	}
	newListMonitoredResourcesPager := m.newListMonitoredResourcesPager.get(req)
	if newListMonitoredResourcesPager == nil {
		const regexStr = `/subscriptions/(?P<subscriptionId>[!#&$-;=?-\[\]_a-zA-Z0-9~%@]+)/resourceGroups/(?P<resourceGroupName>[!#&$-;=?-\[\]_a-zA-Z0-9~%@]+)/providers/Dynatrace\.Observability/monitors/(?P<monitorName>[!#&$-;=?-\[\]_a-zA-Z0-9~%@]+)/listMonitoredResources`
		regex := regexp.MustCompile(regexStr)
		matches := regex.FindStringSubmatch(req.URL.EscapedPath())
		if matches == nil || len(matches) < 3 {
			return nil, fmt.Errorf("failed to parse path %s", req.URL.Path)
		}
		resourceGroupNameParam, err := url.PathUnescape(matches[regex.SubexpIndex("resourceGroupName")])
		if err != nil {
			return nil, err
		}
		monitorNameParam, err := url.PathUnescape(matches[regex.SubexpIndex("monitorName")])
		if err != nil {
			return nil, err
		}
		resp := m.srv.NewListMonitoredResourcesPager(resourceGroupNameParam, monitorNameParam, nil)
		newListMonitoredResourcesPager = &resp
		m.newListMonitoredResourcesPager.add(req, newListMonitoredResourcesPager)
		server.PagerResponderInjectNextLinks(newListMonitoredResourcesPager, req, func(page *armdynatrace.MonitorsClientListMonitoredResourcesResponse, createLink func() string) {
			page.NextLink = to.Ptr(createLink())
		})
	}
	resp, err := server.PagerResponderNext(newListMonitoredResourcesPager, req)
	if err != nil {
		return nil, err
	}
	if !contains([]int{http.StatusOK}, resp.StatusCode) {
		m.newListMonitoredResourcesPager.remove(req)
		return nil, &nonRetriableError{fmt.Errorf("unexpected status code %d. acceptable values are http.StatusOK", resp.StatusCode)}
	}
	if !server.PagerResponderMore(newListMonitoredResourcesPager) {
		m.newListMonitoredResourcesPager.remove(req)
	}
	return resp, nil
}

func (m *MonitorsServerTransport) dispatchUpdate(req *http.Request) (*http.Response, error) {
	if m.srv.Update == nil {
		return nil, &nonRetriableError{errors.New("fake for method Update not implemented")}
	}
	const regexStr = `/subscriptions/(?P<subscriptionId>[!#&$-;=?-\[\]_a-zA-Z0-9~%@]+)/resourceGroups/(?P<resourceGroupName>[!#&$-;=?-\[\]_a-zA-Z0-9~%@]+)/providers/Dynatrace\.Observability/monitors/(?P<monitorName>[!#&$-;=?-\[\]_a-zA-Z0-9~%@]+)`
	regex := regexp.MustCompile(regexStr)
	matches := regex.FindStringSubmatch(req.URL.EscapedPath())
	if matches == nil || len(matches) < 3 {
		return nil, fmt.Errorf("failed to parse path %s", req.URL.Path)
	}
	body, err := server.UnmarshalRequestAsJSON[armdynatrace.MonitorResourceUpdate](req)
	if err != nil {
		return nil, err
	}
	resourceGroupNameParam, err := url.PathUnescape(matches[regex.SubexpIndex("resourceGroupName")])
	if err != nil {
		return nil, err
	}
	monitorNameParam, err := url.PathUnescape(matches[regex.SubexpIndex("monitorName")])
	if err != nil {
		return nil, err
	}
	respr, errRespr := m.srv.Update(req.Context(), resourceGroupNameParam, monitorNameParam, body, nil)
	if respErr := server.GetError(errRespr, req); respErr != nil {
		return nil, respErr
	}
	respContent := server.GetResponseContent(respr)
	if !contains([]int{http.StatusOK}, respContent.HTTPStatus) {
		return nil, &nonRetriableError{fmt.Errorf("unexpected status code %d. acceptable values are http.StatusOK", respContent.HTTPStatus)}
	}
	resp, err := server.MarshalResponseAsJSON(respContent, server.GetResponse(respr).MonitorResource, req)
	if err != nil {
		return nil, err
	}
	return resp, nil
}
