//go:build go1.18
// +build go1.18

// Copyright (c) Microsoft Corporation. All rights reserved.
// Licensed under the MIT License. See License.txt in the project root for license information.
// Code generated by Microsoft (R) AutoRest Code Generator. DO NOT EDIT.
// Changes may cause incorrect behavior and will be lost if the code is regenerated.

package armeducation

import (
	"github.com/Azure/azure-sdk-for-go/sdk/azcore"
	"github.com/Azure/azure-sdk-for-go/sdk/azcore/arm"
)

// ClientFactory is a client factory used to create any client in this module.
// Don't use this type directly, use NewClientFactory instead.
type ClientFactory struct {
	credential azcore.TokenCredential
	options    *arm.ClientOptions
}

// NewClientFactory creates a new instance of ClientFactory with the specified values.
// The parameter values will be propagated to any client created from this factory.
//   - credential - used to authorize requests. Usually a credential from azidentity.
//   - options - pass nil to accept the default values.
func NewClientFactory(credential azcore.TokenCredential, options *arm.ClientOptions) (*ClientFactory, error) {
	_, err := arm.NewClient(moduleName, moduleVersion, credential, options)
	if err != nil {
		return nil, err
	}
	return &ClientFactory{
		credential: credential,
		options:    options.Clone(),
	}, nil
}

// NewGrantsClient creates a new instance of GrantsClient.
func (c *ClientFactory) NewGrantsClient() *GrantsClient {
	subClient, _ := NewGrantsClient(c.credential, c.options)
	return subClient
}

// NewJoinRequestsClient creates a new instance of JoinRequestsClient.
func (c *ClientFactory) NewJoinRequestsClient() *JoinRequestsClient {
	subClient, _ := NewJoinRequestsClient(c.credential, c.options)
	return subClient
}

// NewLabsClient creates a new instance of LabsClient.
func (c *ClientFactory) NewLabsClient() *LabsClient {
	subClient, _ := NewLabsClient(c.credential, c.options)
	return subClient
}

// NewManagementClient creates a new instance of ManagementClient.
func (c *ClientFactory) NewManagementClient() *ManagementClient {
	subClient, _ := NewManagementClient(c.credential, c.options)
	return subClient
}

// NewOperationsClient creates a new instance of OperationsClient.
func (c *ClientFactory) NewOperationsClient() *OperationsClient {
	subClient, _ := NewOperationsClient(c.credential, c.options)
	return subClient
}

// NewStudentLabsClient creates a new instance of StudentLabsClient.
func (c *ClientFactory) NewStudentLabsClient() *StudentLabsClient {
	subClient, _ := NewStudentLabsClient(c.credential, c.options)
	return subClient
}

// NewStudentsClient creates a new instance of StudentsClient.
func (c *ClientFactory) NewStudentsClient() *StudentsClient {
	subClient, _ := NewStudentsClient(c.credential, c.options)
	return subClient
}
