//go:build go1.18
// +build go1.18

// Copyright (c) Microsoft Corporation. All rights reserved.
// Licensed under the MIT License. See License.txt in the project root for license information.
// Code generated by Microsoft (R) AutoRest Code Generator. DO NOT EDIT.
// Changes may cause incorrect behavior and will be lost if the code is regenerated.

package fake

import (
	"context"
	"errors"
	"fmt"
	azfake "github.com/Azure/azure-sdk-for-go/sdk/azcore/fake"
	"github.com/Azure/azure-sdk-for-go/sdk/azcore/fake/server"
	"github.com/Azure/azure-sdk-for-go/sdk/azcore/runtime"
	"github.com/Azure/azure-sdk-for-go/sdk/resourcemanager/hybridcompute/armhybridcompute/v2"
	"net/http"
	"net/url"
	"regexp"
)

// ExtensionMetadataServer is a fake server for instances of the armhybridcompute.ExtensionMetadataClient type.
type ExtensionMetadataServer struct {
	// Get is the fake for method ExtensionMetadataClient.Get
	// HTTP status codes to indicate success: http.StatusOK
	Get func(ctx context.Context, location string, publisher string, extensionType string, version string, options *armhybridcompute.ExtensionMetadataClientGetOptions) (resp azfake.Responder[armhybridcompute.ExtensionMetadataClientGetResponse], errResp azfake.ErrorResponder)

	// NewListPager is the fake for method ExtensionMetadataClient.NewListPager
	// HTTP status codes to indicate success: http.StatusOK
	NewListPager func(location string, publisher string, extensionType string, options *armhybridcompute.ExtensionMetadataClientListOptions) (resp azfake.PagerResponder[armhybridcompute.ExtensionMetadataClientListResponse])
}

// NewExtensionMetadataServerTransport creates a new instance of ExtensionMetadataServerTransport with the provided implementation.
// The returned ExtensionMetadataServerTransport instance is connected to an instance of armhybridcompute.ExtensionMetadataClient via the
// azcore.ClientOptions.Transporter field in the client's constructor parameters.
func NewExtensionMetadataServerTransport(srv *ExtensionMetadataServer) *ExtensionMetadataServerTransport {
	return &ExtensionMetadataServerTransport{
		srv:          srv,
		newListPager: newTracker[azfake.PagerResponder[armhybridcompute.ExtensionMetadataClientListResponse]](),
	}
}

// ExtensionMetadataServerTransport connects instances of armhybridcompute.ExtensionMetadataClient to instances of ExtensionMetadataServer.
// Don't use this type directly, use NewExtensionMetadataServerTransport instead.
type ExtensionMetadataServerTransport struct {
	srv          *ExtensionMetadataServer
	newListPager *tracker[azfake.PagerResponder[armhybridcompute.ExtensionMetadataClientListResponse]]
}

// Do implements the policy.Transporter interface for ExtensionMetadataServerTransport.
func (e *ExtensionMetadataServerTransport) Do(req *http.Request) (*http.Response, error) {
	rawMethod := req.Context().Value(runtime.CtxAPINameKey{})
	method, ok := rawMethod.(string)
	if !ok {
		return nil, nonRetriableError{errors.New("unable to dispatch request, missing value for CtxAPINameKey")}
	}

	var resp *http.Response
	var err error

	switch method {
	case "ExtensionMetadataClient.Get":
		resp, err = e.dispatchGet(req)
	case "ExtensionMetadataClient.NewListPager":
		resp, err = e.dispatchNewListPager(req)
	default:
		err = fmt.Errorf("unhandled API %s", method)
	}

	if err != nil {
		return nil, err
	}

	return resp, nil
}

func (e *ExtensionMetadataServerTransport) dispatchGet(req *http.Request) (*http.Response, error) {
	if e.srv.Get == nil {
		return nil, &nonRetriableError{errors.New("fake for method Get not implemented")}
	}
	const regexStr = `/subscriptions/(?P<subscriptionId>[!#&$-;=?-\[\]_a-zA-Z0-9~%@]+)/providers/Microsoft\.HybridCompute/locations/(?P<location>[!#&$-;=?-\[\]_a-zA-Z0-9~%@]+)/publishers/(?P<publisher>[!#&$-;=?-\[\]_a-zA-Z0-9~%@]+)/extensionTypes/(?P<extensionType>[!#&$-;=?-\[\]_a-zA-Z0-9~%@]+)/versions/(?P<version>[!#&$-;=?-\[\]_a-zA-Z0-9~%@]+)`
	regex := regexp.MustCompile(regexStr)
	matches := regex.FindStringSubmatch(req.URL.EscapedPath())
	if matches == nil || len(matches) < 5 {
		return nil, fmt.Errorf("failed to parse path %s", req.URL.Path)
	}
	locationParam, err := url.PathUnescape(matches[regex.SubexpIndex("location")])
	if err != nil {
		return nil, err
	}
	publisherParam, err := url.PathUnescape(matches[regex.SubexpIndex("publisher")])
	if err != nil {
		return nil, err
	}
	extensionTypeParam, err := url.PathUnescape(matches[regex.SubexpIndex("extensionType")])
	if err != nil {
		return nil, err
	}
	versionParam, err := url.PathUnescape(matches[regex.SubexpIndex("version")])
	if err != nil {
		return nil, err
	}
	respr, errRespr := e.srv.Get(req.Context(), locationParam, publisherParam, extensionTypeParam, versionParam, nil)
	if respErr := server.GetError(errRespr, req); respErr != nil {
		return nil, respErr
	}
	respContent := server.GetResponseContent(respr)
	if !contains([]int{http.StatusOK}, respContent.HTTPStatus) {
		return nil, &nonRetriableError{fmt.Errorf("unexpected status code %d. acceptable values are http.StatusOK", respContent.HTTPStatus)}
	}
	resp, err := server.MarshalResponseAsJSON(respContent, server.GetResponse(respr).ExtensionValue, req)
	if err != nil {
		return nil, err
	}
	return resp, nil
}

func (e *ExtensionMetadataServerTransport) dispatchNewListPager(req *http.Request) (*http.Response, error) {
	if e.srv.NewListPager == nil {
		return nil, &nonRetriableError{errors.New("fake for method NewListPager not implemented")}
	}
	newListPager := e.newListPager.get(req)
	if newListPager == nil {
		const regexStr = `/subscriptions/(?P<subscriptionId>[!#&$-;=?-\[\]_a-zA-Z0-9~%@]+)/providers/Microsoft\.HybridCompute/locations/(?P<location>[!#&$-;=?-\[\]_a-zA-Z0-9~%@]+)/publishers/(?P<publisher>[!#&$-;=?-\[\]_a-zA-Z0-9~%@]+)/extensionTypes/(?P<extensionType>[!#&$-;=?-\[\]_a-zA-Z0-9~%@]+)/versions`
		regex := regexp.MustCompile(regexStr)
		matches := regex.FindStringSubmatch(req.URL.EscapedPath())
		if matches == nil || len(matches) < 4 {
			return nil, fmt.Errorf("failed to parse path %s", req.URL.Path)
		}
		locationParam, err := url.PathUnescape(matches[regex.SubexpIndex("location")])
		if err != nil {
			return nil, err
		}
		publisherParam, err := url.PathUnescape(matches[regex.SubexpIndex("publisher")])
		if err != nil {
			return nil, err
		}
		extensionTypeParam, err := url.PathUnescape(matches[regex.SubexpIndex("extensionType")])
		if err != nil {
			return nil, err
		}
		resp := e.srv.NewListPager(locationParam, publisherParam, extensionTypeParam, nil)
		newListPager = &resp
		e.newListPager.add(req, newListPager)
	}
	resp, err := server.PagerResponderNext(newListPager, req)
	if err != nil {
		return nil, err
	}
	if !contains([]int{http.StatusOK}, resp.StatusCode) {
		e.newListPager.remove(req)
		return nil, &nonRetriableError{fmt.Errorf("unexpected status code %d. acceptable values are http.StatusOK", resp.StatusCode)}
	}
	if !server.PagerResponderMore(newListPager) {
		e.newListPager.remove(req)
	}
	return resp, nil
}
